function g = anticonv_call(ninte,precr,x,y,upbd)

% /********************************************************************
% *  Antitonic and convex regression                                  *
% *                                                                   *
% *   Input                                                           *
% *        ninte - number maximum of interations                      *
% *        precr - precision required in second and first derivatives *
% *        x , y - independent and dependent variables                *
% *        upbd  - discount factor                                    *
% *   Return                                                          *
% *        g - antitonic and convex regression                        *
% *                                                                   *
% *  Modification                       by                    date    *
% *   Implementation             Jefferson Duarte           07/17/96  *
% *   Minor adaptation             Simon Kwok              01/05/2021 *
% ********************************************************************/

% local g, dI , beta, i,j,k,h,flag1, block, n, temp, ag, ax, startp, der1, der2;
% local flag, d1, d2, tempx, tempg, dif, equal;
% local t1,t2,t3,t4,t5,t6,t7,t8,t9,t10,b;
% local u, dyc, d2y, dy, der10, der11, temp1,mgt0,a;

n = length(x);
u = [zeros(n,1) ; 1];
dx = x(2:n) - x(1:n-1);
dy = y(2:n) - y(1:n-1);
d2y = y(1:n-2)./dx(1:n-2) - (1./dx(1:n-2) + 1./dx(2:n-1)).*y(2:n-1) + y(3:n)./dx(2:n-1);
k = 1;
%tempx = 0;
%equal = 0;
dI = zeros(n+1,n+2);
flag = 1;
a = zeros(n,n+1);

i = 1;
while i <= n-2

   % project u - di in the ith cone + n - 1 */

   a(i,i) = -1/dx(i);
   a(i,i+1) = 1/dx(i) + 1/dx(i+1);
   a(i,i+2) = -1/dx(i+1);
   a(i,n+1) = -d2y(i);
   i = i + 1;
end

a(n-1,n) = 1;
a(n-1,n-1) = -1;
a(n-1,n+1) = dy(n-1);
a(n,1) = 1;
a(n,2) = -1;
a(n,n+1) = -dy(1) - upbd*dx(1);

% while vector is increasing and concave stay in looping with limit the
%    number maximum of interations */

%format /rd 1,0;

while ((k <= ninte) && (flag == 1))

    % if flag does not change of value in looping so it finishes interations */

    flag = 0;
    %temp1 = u;

    % START with the 2nd derivative constrained */

    i = 1;
    while i <= n-2
        u = u - dI(:,i);

        % project u - di in the ith cone + n - 1 */

        if  ( a(i,:) * u  > 0)
               temp = u;
               u = temp - (a(i,:) * temp) .* a(i,:)' / sum(a(i,:)' .^2);
               dI(:,i) = u - temp;
        else
               dI(:,i) = zeros(n+1,1);
        end
        i = i + 1;
    end

    % project u - di in the ith cone + n - 1 */

    i = n-1;
    u = u - dI(:,i);
    if  ( a(i,:) * u  > 0)
          temp = u;
          u = temp - (a(i,:) * temp) .* a(i,:)' / sum(a(i,:)' .^2);
          dI(:,i) = u - temp;
    else
          dI(:,i) = zeros(n+1,1);          
    end

    % project u - di in the ith cone */

    i = n;
    u = u - dI(:,i);
    if  ( a(i,:) * u  > 0)
          temp = u;
          u = temp - (a(i,:) * temp) .* a(i,:)' / sum(a(i,:)' .^2);
          dI(:,i) = u - temp;
    else
          dI(:,i) = zeros(n+1,1);  
    end


    u = u - dI(:,n+1);
    temp = u;
    if -u(n+1) > precr
        u(n+1) = 0;
        dI(:,n+1) = u - temp;
    else
        dI(:,n+1) = zeros(n+1,1);  
    end

    der10 = (u(n) - u(n-1) + u(n+1) * dy(n-1));
    der11 = (-u(2) + u(1) + u(n+1) * (-dy(1) - upbd*dx(1)));
    der2  = ( - 1./dx(1:(n-2)).*u(1:(n-2)) + (1./dx(1:(n-2))+1./dx(2:(n-1))).*u(2:(n-1)) ...
            - 1./dx(2:(n-1)).*u(3:n) ) - u(n+1) * d2y;

    % if it did not converge, try again   */

    if  ( (sum(der10 > precr) > 0) || (sum(der2 > precr) > 0) ...
         || (sum(der11 > precr) > 0) || (-u(n+1) > precr) )
        flag = 1;
    end
    k = k + 1;
end

u = u/u(n+1);
g = y + u(1:n);
der1  = (-g(1:n-1) + g(2:n))/ (x(2) - x(1));
der11 = der1 + upbd ;                                                 % larger than zero if converges */
der2 = (-2 * g(2:n-1) + g(1:(n-2)) + g(3:n) ) / ((x(2) - x(1)) ^2);   % larger than zero if converges */

end
