	local loop=1
	forvalues tot=1/$PLL_CLUSTERS {
	di `tot'
	if ($pll_instance==`tot') {
	local loop_min=`loop'
	local loop_max=`loop'+$loopspercluster-1
	}
	local loop=`loop'+$loopspercluster
	}
	di "loopmin " `loop_min'
	di "loopmax " `loop_max'	
	
	
forvalues draw=`loop_min'/`loop_max' {

//Load sample used in estimation
use "Output/startpred_clean",clear 

*load draw nr X
gen drawnumber=`draw'
merge m:1 drawnumber using "Output/paramdraws",keep(3)


*according to this model, what are treatment effects? (expect similar but not identical results)
gen zb=x_cons+x_z*z+x_drel_someASO*drel_someASO

gen inter0=inter0_cons+inter0_drel_someASO*drel_someASO				
gen inter1=inter1_cons+inter1_drel_someASO*drel_someASO

gen xb0_nointer=y0_nointer_cons
gen xb1_nointer=y1_nointer_cons

gen xb0_inter=y0_inter_cons	
gen xb1_inter=y1_inter_cons


qui foreach var of varlist $controls2  { //other vars
replace zb=zb+x_`var'*`var'

replace inter0=inter0+inter0_`var'*`var'
replace inter1=inter1+inter1_`var'*`var'

replace xb0_nointer=xb0_nointer+y0_nointer_`var'*`var'
replace xb1_nointer=xb1_nointer+y1_nointer_`var'*`var'

replace xb0_inter=xb0_inter+y0_inter_`var'*`var'
replace xb1_inter=xb1_inter+y1_inter_`var'*`var'
}

gen prob1= 		normal(inter1) * /// 
				(normal(xb1_inter) ) /// 
			+	(1-normal(inter1)) * ///
				( normal(xb1_nointer)) //

gen prob0= 		normal(inter0) * /// 
				(normal(xb0_inter) ) /// 
			+	(1-normal(inter0)) * ///
				( normal(xb0_nointer)) //

gen te=prob1-prob0
sum te


*te and distributional effects using simulated ability
		qui {
		gen psel_sim=0
		
		gen treat_sim=0
		gen prob0_sim=0
		gen prob1_sim=0
		
		gen gain_sim=0
		gen loose_sim=0
		gen gain_tt_sim=0
		gen loose_tt_sim=0 
		gen gain_ut_sim=0
		gen loose_ut_sim=0
				
		gen prob0_sim3=0
		gen prob1_sim3=0
		
		gen gain_sim3=0
		gen loose_sim3=0
		gen gain_tt_sim3=0
		gen loose_tt_sim3=0 
		gen gain_ut_sim3=0
		gen loose_ut_sim3=0
		
		gen prob0_sim4=0
		gen prob1_sim4=0
		
		gen gain_sim4=0
		gen loose_sim4=0
		gen gain_tt_sim4=0
		gen loose_tt_sim4=0 
		gen gain_ut_sim4=0
		gen loose_ut_sim4=0
		
		
		gen aso_psel_sim=0
		
		gen aso_treat_sim=0
		gen aso_prob0_sim=0
		gen aso_prob1_sim=0
		
		gen aso_gain_sim=0
		gen aso_loose_sim=0
		gen aso_gain_tt_sim=0
		gen aso_loose_tt_sim=0 
		gen aso_gain_ut_sim=0
		gen aso_loose_ut_sim=0

		
		gen track_gain_sim=0
		gen track_loose_sim=0
		gen track_gain_tt_sim=0
		gen track_loose_tt_sim=0
		gen track_gain_ut_sim=0
		gen track_loose_ut_sim=0
			
		
		}

		
foreach var of varlist zb   inter0 inter1	  xb0_nointer xb1_nointer xb0_inter xb1_inter {
clonevar `var'_base=`var'
}

	gen inter0_sim=.
	gen inter1_sim=.
	gen inter_sim=.
	

	
	qui forvalues s=1/$maxsim {
	drawnorm ability_sim
	
	drawnorm edinter0_sim
	drawnorm edinter1_sim
	
	drawnorm enointer0_sim
	drawnorm enointer1_sim
	drawnorm einter0_sim
	drawnorm einter1_sim
	
	drawnorm ed_sim



	*simulation of stage 1: elite school
	replace treat_sim=(zb_base+x_ability*ability_sim+ed_sim>0)
	
	*simulation of stage 2: inter
	replace inter0_sim=(inter0_base+inter0_ability*ability_sim+edinter0_sim>0)
	replace inter1_sim=(inter1_base+inter1_ability*ability_sim+edinter1_sim>0)

	*simulation of stage 3: outcome
	replace prob0_sim=xb0_nointer_base	+	y0_nointer_ability*ability_sim	+enointer0_sim>0	if inter0_sim==0 
	replace prob0_sim=xb0_inter_base	+	y0_inter_ability*ability_sim	+einter0_sim>0		if inter0_sim==1 
	
	replace prob1_sim=xb1_nointer_base	+	y1_nointer_ability*ability_sim	+enointer1_sim>0	if inter1_sim==0 
	replace prob1_sim=xb1_inter_base	+	y1_inter_ability*ability_sim	+einter1_sim>0		if inter1_sim==1 
	
		
		*simulation of stage 3: outcome, with everyone doing inter 
		replace prob0_sim3=xb0_inter_base	+	y0_inter_ability*ability_sim	+einter0_sim>0		
		replace prob1_sim3=xb1_inter_base	+	y1_inter_ability*ability_sim	+einter1_sim>0	
		
		*simulation of stage 3: outcome, with everyone not doing inter 
		replace prob0_sim4=xb0_nointer_base	+	y0_nointer_ability*ability_sim	+enointer0_sim>0	
		replace prob1_sim4=xb1_nointer_base	+	y1_nointer_ability*ability_sim	+enointer1_sim>0	
	
		*simulation of stage 3 conditional on track
		*no aso
		replace aso_prob0_sim=xb0_nointer_base	+	y0_nointer_ability*ability_sim	+enointer0_sim>0	if treat_sim==0
		replace aso_prob0_sim=xb1_nointer_base	+	y1_nointer_ability*ability_sim	+enointer1_sim>0	if treat_sim==1
		
		*aso
		replace aso_prob1_sim=xb0_inter_base	+	y0_inter_ability*ability_sim	+einter0_sim>0		if treat_sim==0 
		replace aso_prob1_sim=xb1_inter_base	+	y1_inter_ability*ability_sim	+einter1_sim>0		if treat_sim==1 
	
	*individual treatment effects
	replace gain_sim=(gain_sim+prob1_sim*(1-prob0_sim))
	replace loose_sim=(loose_sim+(1-prob1_sim)*prob0_sim)
	replace gain_tt_sim=(gain_tt_sim+prob1_sim*(1-prob0_sim)*treat_sim)
	replace loose_tt_sim=(loose_tt_sim+(1-prob1_sim)*prob0_sim*treat_sim)
	replace gain_ut_sim=(gain_ut_sim+prob1_sim*(1-prob0_sim)*(1-treat_sim))
	replace loose_ut_sim=(loose_ut_sim+(1-prob1_sim)*prob0_sim*(1-treat_sim)) 

	*individual treatment effects on track choice
	replace track_gain_sim=(track_gain_sim+inter1_sim*(1-inter0_sim))
	replace track_loose_sim=(track_loose_sim+(1-inter1_sim)*inter0_sim)
	replace track_gain_tt_sim=(track_gain_tt_sim+inter1_sim*(1-inter0_sim)*treat_sim)
	replace track_loose_tt_sim=(track_loose_tt_sim+(1-inter1_sim)*inter0_sim*treat_sim)
	replace track_gain_ut_sim=(track_gain_ut_sim+inter1_sim*(1-inter0_sim)*(1-treat_sim))
	replace track_loose_ut_sim=(track_loose_ut_sim+(1-inter1_sim)*inter0_sim*(1-treat_sim)) 
	
	
	 
	 	*individual treatment effects, with everyone doing inter
		replace gain_sim3=(gain_sim3+prob1_sim3*(1-prob0_sim3))
		replace loose_sim3=(loose_sim3+(1-prob1_sim3)*prob0_sim3)
		replace gain_tt_sim3=(gain_tt_sim3+prob1_sim3*(1-prob0_sim3)*treat_sim)
		replace loose_tt_sim3=(loose_tt_sim3+(1-prob1_sim3)*prob0_sim3*treat_sim)
		replace gain_ut_sim3=(gain_ut_sim3+prob1_sim3*(1-prob0_sim3)*(1-treat_sim))
		replace loose_ut_sim3=(loose_ut_sim3+(1-prob1_sim3)*prob0_sim3*(1-treat_sim)) 

		*individual treatment effects, with everyone not doing inter
		replace gain_sim4=(gain_sim4+prob1_sim4*(1-prob0_sim4))
		replace loose_sim4=(loose_sim4+(1-prob1_sim4)*prob0_sim4)
		replace gain_tt_sim4=(gain_tt_sim4+prob1_sim4*(1-prob0_sim4)*treat_sim)
		replace loose_tt_sim4=(loose_tt_sim4+(1-prob1_sim4)*prob0_sim4*treat_sim)
		replace gain_ut_sim4=(gain_ut_sim4+prob1_sim4*(1-prob0_sim4)*(1-treat_sim))
		replace loose_ut_sim4=(loose_ut_sim4+(1-prob1_sim4)*prob0_sim4*(1-treat_sim)) 
		
	*number of times treated (needed for denominator after loop)
	replace psel_sim=psel_sim+treat_sim	

		*individual treatment effects OF INTER
		replace aso_gain_sim=(aso_gain_sim+aso_prob1_sim*(1-aso_prob0_sim))
		
		replace inter_sim=inter1_sim if x==1
		replace inter_sim=inter0_sim if x==0
		
		replace aso_loose_sim=(aso_loose_sim+(1-aso_prob1_sim)*aso_prob0_sim)
		replace aso_gain_tt_sim=(aso_gain_tt_sim+aso_prob1_sim*(1-aso_prob0_sim)*inter_sim)
		replace aso_loose_tt_sim=(aso_loose_tt_sim+(1-aso_prob1_sim)*aso_prob0_sim*inter_sim)
		replace aso_gain_ut_sim=(aso_gain_ut_sim+aso_prob1_sim*(1-aso_prob0_sim)*(1-inter_sim))
		replace aso_loose_ut_sim=(aso_loose_ut_sim+(1-aso_prob1_sim)*aso_prob0_sim*(1-inter_sim)) 

		
		*number of times treated (needed for denominator after loop)
		replace aso_psel_sim=aso_psel_sim+inter_sim
		
		drop ability_sim e*0_sim e*1_sim ed_sim 
	}

	*average treatment effects
	qui {
	replace psel_sim=psel_sim/$maxsim

	replace gain_sim=(gain_sim/$maxsim)
	replace loose_sim=(loose_sim/$maxsim)
	replace gain_tt_sim=(gain_tt_sim/$maxsim)/psel_sim
	replace loose_tt_sim=(loose_tt_sim/$maxsim)/psel_sim
	replace gain_ut_sim=(gain_ut_sim/$maxsim)/(1-psel_sim)
	replace loose_ut_sim=(loose_ut_sim/$maxsim)/(1-psel_sim)

	replace gain_tt_sim=. if x==0 //such that expectation over X is okay
	replace loose_tt_sim=. if x==0
	replace gain_ut_sim=. if x==1 
	replace loose_ut_sim=. if x==1

	gen ate=gain_sim-loose_sim
	gen att=gain_tt_sim-loose_tt_sim
	gen atnt=gain_ut_sim-loose_ut_sim
	}

	

	*average treatment effects on track choice
	replace track_gain_sim=(track_gain_sim/$maxsim)
	replace track_loose_sim=(track_loose_sim/$maxsim)
	replace track_gain_tt_sim=(track_gain_tt_sim/$maxsim)/psel_sim
	replace track_loose_tt_sim=(track_loose_tt_sim/$maxsim)/psel_sim
	replace track_gain_ut_sim=(track_gain_ut_sim/$maxsim)/(1-psel_sim)
	replace track_loose_ut_sim=(track_loose_ut_sim/$maxsim)/(1-psel_sim)

	replace track_gain_tt_sim=. if x==0 //such that expectation over X is okay
	replace track_loose_tt_sim=. if x==0
	replace track_gain_ut_sim=. if x==1 
	replace track_loose_ut_sim=. if x==1

	gen track_ate=track_gain_sim-track_loose_sim
	gen track_att=track_gain_tt_sim-track_loose_tt_sim
	gen track_atnt=track_gain_ut_sim-track_loose_ut_sim
	

	*average treatment effects, cond on everyone doing inter
	replace gain_sim3=(gain_sim3/$maxsim)
	replace loose_sim3=(loose_sim3/$maxsim)
	replace gain_tt_sim3=(gain_tt_sim3/$maxsim)/psel_sim
	replace loose_tt_sim3=(loose_tt_sim3/$maxsim)/psel_sim
	replace gain_ut_sim3=(gain_ut_sim3/$maxsim)/(1-psel_sim)
	replace loose_ut_sim3=(loose_ut_sim3/$maxsim)/(1-psel_sim)

	replace gain_tt_sim3=. if x==0 //such that expectation over X is okay
	replace loose_tt_sim3=. if x==0
	replace gain_ut_sim3=. if x==1 
	replace loose_ut_sim3=. if x==1

	gen ate3=gain_sim3-loose_sim3
	gen att3=gain_tt_sim3-loose_tt_sim3
	gen atnt3=gain_ut_sim3-loose_ut_sim3
	
	*average treatment effects, cond on everyone not doing inter
	replace gain_sim4=(gain_sim4/$maxsim)
	replace loose_sim4=(loose_sim4/$maxsim)
	replace gain_tt_sim4=(gain_tt_sim4/$maxsim)/psel_sim
	replace loose_tt_sim4=(loose_tt_sim4/$maxsim)/psel_sim
	replace gain_ut_sim4=(gain_ut_sim4/$maxsim)/(1-psel_sim)
	replace loose_ut_sim4=(loose_ut_sim4/$maxsim)/(1-psel_sim)

	replace gain_tt_sim4=. if x==0 //such that expectation over X is okay
	replace loose_tt_sim4=. if x==0
	replace gain_ut_sim4=. if x==1 
	replace loose_ut_sim4=. if x==1

	gen ate4=gain_sim4-loose_sim4
	gen att4=gain_tt_sim4-loose_tt_sim4
	gen atnt4=gain_ut_sim4-loose_ut_sim4
	
	*average treatment effects for aso
	replace aso_psel_sim=aso_psel_sim/$maxsim

	replace aso_gain_sim=(aso_gain_sim/$maxsim)
	replace aso_loose_sim=(aso_loose_sim/$maxsim)
	replace aso_gain_tt_sim=(aso_gain_tt_sim/$maxsim)/aso_psel_sim
	replace aso_loose_tt_sim=(aso_loose_tt_sim/$maxsim)/aso_psel_sim
	replace aso_gain_ut_sim=(aso_gain_ut_sim/$maxsim)/(1-aso_psel_sim)
	replace aso_loose_ut_sim=(aso_loose_ut_sim/$maxsim)/(1-aso_psel_sim)

	replace aso_gain_tt_sim=. if inter==0 //such that expectation over X is okay
	replace aso_loose_tt_sim=. if inter==0
	replace aso_gain_ut_sim=. if inter==1 
	replace aso_loose_ut_sim=. if inter==1

	gen aso_ate=aso_gain_sim-aso_loose_sim
	gen aso_att=aso_gain_tt_sim-aso_loose_tt_sim
	gen aso_atnt=aso_gain_ut_sim-aso_loose_ut_sim
	
	
	
*collect all interesting statistics

	*no weights needed
	foreach var of varlist ate gain_sim loose_sim  att gain_tt_sim loose_tt_sim atnt gain_ut_sim loose_ut_sim ///
	 track_ate track_gain_sim track_loose_sim  track_att track_gain_tt_sim track_loose_tt_sim track_atnt track_gain_ut_sim track_loose_ut_sim ///
		  ate3 gain_sim3 loose_sim3  att3 gain_tt_sim3 loose_tt_sim3 atnt3 gain_ut_sim3 loose_ut_sim3 ///
		   ate4 gain_sim4 loose_sim4  att4 gain_tt_sim4 loose_tt_sim4 atnt4 gain_ut_sim4 loose_ut_sim4 ///
			aso_ate aso_gain_sim aso_loose_sim aso_att aso_gain_tt_sim aso_loose_tt_sim aso_atnt aso_gain_ut_sim aso_loose_ut_sim ///
				{
	qui sum `var'
	scalar scal_`var'_`draw'=r(mean)
	}
		 		
	
	clear
	set obs 150 //at least number of statistics we're interested in
	
	gen var=""
	gen draw`draw'=.

	
	local i=0
	foreach var in  					ate gain_sim loose_sim  att gain_tt_sim loose_tt_sim atnt gain_ut_sim loose_ut_sim ///
										track_ate track_gain_sim track_loose_sim  track_att track_gain_tt_sim track_loose_tt_sim track_atnt track_gain_ut_sim track_loose_ut_sim ///
										ate3 gain_sim3 loose_sim3  att3 gain_tt_sim3 loose_tt_sim3 atnt3 gain_ut_sim3 loose_ut_sim3 ///
										ate4 gain_sim4 loose_sim4  att4 gain_tt_sim4 loose_tt_sim4 atnt4 gain_ut_sim4 loose_ut_sim4 ///
										aso_ate aso_gain_sim aso_loose_sim aso_att aso_gain_tt_sim aso_loose_tt_sim aso_atnt aso_gain_ut_sim aso_loose_ut_sim ///
										{
	local i=`i'+1
	replace var="`var'" in `i'
	replace draw`draw'=scal_`var'_`draw' if var=="`var'"					
	}
	
	*also calculate difference of treatment effects
	foreach var in ate3 ate4  {
	local i=`i'+1
	replace var="`var'_d" in `i'
	replace draw`draw'=scal_`var'_`draw'-scal_ate_`draw' if var=="`var'_d"				
	}
	foreach var in att3 att4 {
	local i=`i'+1
	replace var="`var'_d" in `i'
	replace draw`draw'=scal_`var'_`draw'-scal_att_`draw' if var=="`var'_d"					
	}
	foreach var in	atnt3 atnt4  {
	local i=`i'+1
	replace var="`var'_d" in `i'
	replace draw`draw'=scal_`var'_`draw'-scal_atnt_`draw' if var=="`var'_d"					
	}
	
	drop if missing(var)
	save "Output/threestage_draw_`draw'",replace
	}
	