cd "C:\Users\degroote\Sync\Research\Analysis\Elite\"

clear all
version 15
set seed 3010
set sortseed 5

/*
Do file that run estimation
*/

* Use %of sample (1= full sample)
global sample=1

* Treatment
global x scho_ASO

* Control set
global controls1 opl_moe1 opl_moe2 no_ned_thuis toelage_SO male 
global controlsdemo stad_2 stad_3 stad_4 prov_2 prov_3 prov_4 prov_5  ///
				mediaaninkomen bev totaalbelgrel hogeronderwijsrel sechogerrel ///
				mediaaninkomen_nis bev_nis totaalbelgrel_nis hogeronderwijsrel_nis sechogerrel_nis 
global controls2 $controls1 repeated $controlsdemo

* Loops in bootstrap
global bootloop 250

* Allow parallel computing for bootstraps
global parallel_allow=1

* Simulation for gain and loss of treatment
global maxsim=100

* Outcome
	* main outcome 	
		global y nodropout_strict
	* graduating without study delay: 	
		*global y degreeontime
	* downgrading
		*global y downgrade
	* students still in school after 3 years of study delay classified as graduated 	
		*global y nodropout_soft
		
* Sample 
	* 1 = all
		global subsample=1
	* 2 = at least 4 schools within 5 km distance
	* 3 = students with elite school among 4 closest options
	* 4 = students choosing the academic track
	* 5 = schools that offer the academic track
	* 6 = drop students with uncertainty about the main outcome
	
		
*  Main analysis (semiparametric + parametric)		
	do "Do files/main_analysis"

*  Direct estimation of factor model (cfr. footnote 21)
	do "Do files/gsem_aakvik"

* Analysis of extended model (ASO2 is used in paper, ASO3 in robustness)
	global inter ASO2
	do "Do files/gsem_inter"
	global inter ASO3
	do "Do files/gsem_inter"

* Alternative outcomes (see definitions above)
	global subsample=1
	
	global y degreeontime
	do "Do files/main_analysis"
	
	global y downgrade
	do "Do files/main_analysis"

	global y nodropout_soft
	do "Do files/main_analysis"		

* Alternative samples (see definitions above)
	global y nodropout_strict
	
	global subsample=2
	do "Do files/main_analysis"

set seed 09112
set sortseed 6
global y nodropout_strict

	global subsample=4
	do "Do files/main_analysis"
	
	global subsample=5
	do "Do files/main_analysis"
	
	global subsample=6
	do "Do files/main_analysis"
		
	global subsample=3
	do "Do files/main_analysis"	
