%% Read in the Data
%==========================================================================

opts = detectImportOptions('bk_data.csv');

opts.VariableDescriptionsLine = 2;

RAW =readtable('bk_data.csv',opts);

Data = table2timetable(RAW(:,2:end),'RowTimes',datetime(RAW{:,1},'Format','MM.dd.yyyy'));

t_code = Data.Properties.VariableDescriptions;

varlist = Data.Properties.VariableNames;

% Construct stationary series
%==========================================================================
DataTrans = Data;

for ii = 1:length(varlist)
    
    switch t_code{ii}
        case 'lv' 
            % Keep level
        case 'fl'
           if (sum(Data{:,varlist{ii}}<=0))>0 % in case of negative values in fl classified series
                DataTrans{:,varlist{ii}}=[NaN;100*(Data{2:end,varlist{ii}}./Data{1:end-1,varlist{ii}}-1)];
            else
                DataTrans{:,varlist{ii}}=[NaN;100*(log(Data{2:end,varlist{ii}})-log(Data{1:end-1,varlist{ii}}))];
            end
        case 'fd'
            DataTrans{:,varlist{ii}}=[NaN;Data{2:end,varlist{ii}}-Data{1:end-1,varlist{ii}}];
    end
    
end

% Choose final sample and reomve series with missings
%==========================================================================
estStart = datetime('1965-01-01');  % start of estimation sample
estEnd = datetime('2019-12-01');    % end of estimation sample

t_range = DataTrans.Time;

t_range = t_range(t_range>=estStart & t_range<=estEnd);


DataIn = DataTrans(t_range,:);

% Remove series with Missings
DataIn = DataIn(:,sum(isnan(DataIn{:,:})==1,1)==0);

y = DataIn{:,1:end};

[T,N] = size(y);

% Standardise the Input data
%==========================================================================
my=mean(y,1);
ystd=std(y,1);

y=(y-my(ones(T,1),:))./ystd(ones(T,1),:); 

