clear;clc;close all;

%-------------------------------------------------------------------
% call getdata.m to fetch the data, adjust the getdata.m function if
% different / more variables shall be used
%-------------------------------------------------------------------
[years,y,g,t,r,ex,p,infl,ly,lg,lt,ls,ld,lex,lp,countries,ifs,year,crisis,lrate,mgov,mpers,Dmgov,wardummy,mgov2]=getdata_jst_panel;

%Specify time period
Myear=reshape(year,[years,countries]);
t1=find(Myear(:,1)==1917);              %Start date
t2=find(Myear(:,1)==2016);              %End date

y=cutsample(t1,t2,y);
g=cutsample(t1,t2,g);
t=cutsample(t1,t2,t);
r=cutsample(t1,t2,r);
ex=cutsample(t1,t2,ex);
p=cutsample(t1,t2,p);
infl=cutsample(t1,t2,infl);
ly=cutsample(t1,t2,ly);
lg=cutsample(t1,t2,lg);
mgov2=cutsample(t1,t2,mgov2);
lmg=log(mgov2);
Dmgov=cutsample(t1,t2,Dmgov.*100);
lt=cutsample(t1,t2,lt);
ls=cutsample(t1,t2,ls);
ld=cutsample(t1,t2,ld);
lex=cutsample(t1,t2,lex);
lp=cutsample(t1,t2,lp);
year=cutsample(t1,t2,year);
crisis=cutsample(t1,t2,crisis);
lrate=cutsample(t1,t2,lrate);
ifs=cutsample(t1,t2,ifs);
wardummy=cutsample(t1,t2,wardummy);

years=size(y,1)./countries;


Mr=reshape(r,[years,countries]);
My=reshape(ly,[years,countries]);
Mg=reshape(lg,[years,countries]);
Mmg=reshape(lmg,[years,countries]);


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%Calculate Indicator Variable
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

MIr=zeros(size(Mr));


for i=1:countries
   for j=1:size(MIr,1)-1
       if Mr(j,i)<=1
        MIr(j+1,i)=1;
        elseif Mr(j,i)>1
       MIr(j+1,i)=0;
        end
   end   
end


Ir=reshape(MIr,[countries*years,1]);
I=Ir;

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%Calculate Growth Rate
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

MDy=zeros(size(My));
MDg=zeros(size(Mg));
MDmg=zeros(size(Mmg));

for i=1:countries
    for j=2:size(MDy,1)
    MDy(j,i)=(My(j,i)-My(j-1,i));
    MDg(j,i)=(Mg(j,i)-Mg(j-1,i));
    MDmg(j,i)=(Mmg(j,i)-Mmg(j-1,i));
    end   
end
Dy=reshape(MDy,[countries*years,1]);
Dg=reshape(MDg,[countries*years,1]);
Dmg=reshape(MDmg,[countries*years,1]);

MDmg=MDmg;
MDg=MDg;

figure(1);
plot(Myear(t1+1:t2,1), MDmg(2:end,1),'-d');
hold on
plot(Myear(t1+1:t2,2), MDmg(2:end,2),'-o');
hold on
plot(Myear(t1+1:t2,3), MDmg(2:end,3),'-+');
hold on
plot(Myear(t1+1:t2,4), MDmg(2:end,4), '-x');
hold on
plot(Myear(t1+3:t2,5), MDmg(4:end,5), '->');
hold on
plot(Myear(t1+1:t2,6), MDmg(2:end,6), '-<');
hold on
plot(Myear(t1+1:t2,7), MDmg(2:end,7), '-v');
hold on
plot(Myear(t1+1:t2,8), MDmg(2:end,8), '-h');
hold on
plot(Myear(t1+1:t2,9), MDmg(2:end,9), '-p');
hold on
plot(Myear(t1+1:t2,10), MDmg(2:end,10), '-*');
hold on
plot(Myear(t1+1:t2,11), MDmg(2:end,11), '-s');
hold on
plot(Myear(t1+1:t2,12), MDmg(2:end,12), '-x');
hold on
plot(Myear(t1+1:t2,13), MDmg(2:end,13),'-^');
hold on
axis([1917 2016 -2.5 2.5])
legend({'BEL','CHE','DNK','ESP','FIN','FRA','GBR','ITA','NLD','NOR','PRT','SWE','USA'},'Orientation','vertical', 'Location','northeast', 'NumColumns',2);

figure(2);
plot(Myear(t1+1:t2,1), MDg(2:end,1),'-d');
hold on
plot(Myear(t1+1:t2,2), MDg(2:end,2),'-o');
hold on
plot(Myear(t1+1:t2,3), MDg(2:end,3),'-+');
hold on
plot(Myear(t1+1:t2,4), MDg(2:end,4), '-x');
hold on
plot(Myear(t1+1:t2,5), MDg(2:end,5), '->');
hold on
plot(Myear(t1+1:t2,6), MDg(2:end,6), '-<');
hold on
plot(Myear(t1+1:t2,7), MDg(2:end,7), '-v');
hold on
plot(Myear(t1+1:t2,8), MDg(2:end,8), '-h');
hold on
plot(Myear(t1+1:t2,9), MDg(2:end,9), '-p');
hold on
plot(Myear(t1+1:t2,10), MDg(2:end,10), '-*');
hold on
plot(Myear(t1+1:t2,11), MDg(2:end,11), '-s');
hold on
plot(Myear(t1+1:t2,12), MDg(2:end,12), '-x');
hold on
plot(Myear(t1+1:t2,13), MDg(2:end,13),'-^');
hold on
axis([1917 2016 -1 1])
legend({'BEL','CHE','DNK','ESP','FIN','FRA','GBR','ITA','NLD','NOR','PRT','SWE','USA'},'Orientation','vertical', 'Location','northeast', 'NumColumns',2);

figure(3);
plot(Myear(t1+1:t2,1), MDy(2:end,1),'-d');
hold on
plot(Myear(t1+1:t2,2), MDy(2:end,2),'-o');
hold on
plot(Myear(t1+1:t2,3), MDy(2:end,3),'-+');
hold on
plot(Myear(t1+1:t2,4), MDy(2:end,4), '-x');
hold on
plot(Myear(t1+1:t2,5), MDy(2:end,5), '->');
hold on
plot(Myear(t1+1:t2,6), MDy(2:end,6), '-<');
hold on
plot(Myear(t1+1:t2,7), MDy(2:end,7), '-v');
hold on
plot(Myear(t1+1:t2,8), MDy(2:end,8), '-h');
hold on
plot(Myear(t1+1:t2,9), MDy(2:end,9), '-p');
hold on
plot(Myear(t1+1:t2,10), MDy(2:end,10), '-*');
hold on
plot(Myear(t1+1:t2,11), MDy(2:end,11), '-s');
hold on
plot(Myear(t1+1:t2,12), MDy(2:end,12), '-x');
hold on
plot(Myear(t1+1:t2,13), MDy(2:end,13),'-^');
hold on
axis([1917 2016 -0.5 0.55])
legend({'BEL','CHE','DNK','ESP','FIN','FRA','GBR','ITA','NLD','NOR','PRT','SWE','USA'},'Orientation','vertical', 'Location','northeast', 'NumColumns',2);
