clear;clc;close all;

Irfs_G_MilitarySpending
Irfs_G_BP
Irfs_GDP_MilitarySpending
Irfs_GDP_BP
Irfs_Consumption_MilitarySpending
Irfs_Consumption_BP
Irfs_RealRate_MilitarySpending
Irfs_RealRate_BP
Irfs_LongRate_MilitarySpending
Irfs_LongRate_BP

g_zlb = dlmread('G_Mil_ZLB.txt');
g = dlmread('G_Mil_NoZLB.txt');
g_bp_zlb = dlmread('G_BP_ZLB.txt');
g_bp = dlmread('G_BP_NoZLB.txt');
y_zlb = dlmread('Y_Mil_ZLB.txt');
y = dlmread('Y_Mil_NoZLB.txt');
y_bp_zlb = dlmread('Y_BP_ZLB.txt');
y_bp = dlmread('Y_BP_NoZLB.txt');
c_zlb = dlmread('C_Mil_ZLB.txt');
c = dlmread('C_Mil_NoZLB.txt');
c_bp_zlb = dlmread('C_BP_ZLB.txt');
c_bp = dlmread('C_BP_NoZLB.txt');
rr_zlb = dlmread('RR_Mil_ZLB.txt');
rr = dlmread('RR_Mil_NoZLB.txt');
rr_bp_zlb = dlmread('RR_BP_ZLB.txt');
rr_bp = dlmread('RR_BP_NoZLB.txt');
rc_zlb = dlmread('RC_Mil_ZLB.txt');
rc = dlmread('RC_Mil_NoZLB.txt');
rc_bp_zlb = dlmread('RC_BP_ZLB.txt');
rc_bp = dlmread('RC_BP_NoZLB.txt');

hor=4;
zz=zeros(1,hor+1);


set(0,'DefaultAxesFontName','Times');
set(0,'DefaultAxesFontSize',10);

figure(1)
subplot(5,2,1)
x1 = [(0:1:hor), fliplr((0:1:hor))];
x2 = [g_zlb(:,2)', fliplr(g_zlb(:,3)')];
h=fill(x1, x2, [0.8 0.8 0.8]);
set(h,'EdgeColor','none');
hold on
plot(0:1:hor, g_zlb(:,1),'k--', 'LineWidth', 1.5)
hold on
plot(0:1:hor, g_bp_zlb(:,1),'r-o', 'LineWidth', 1.5)
hold on
plot(0:1:hor, g_bp_zlb(:,2), 'r--')
hold on
plot(0:1:hor, g_bp_zlb(:,3), 'r--')
hold on
plot(0:1:hor, zz, 'k-','LineWidth', 0.5);
axis([0 hor -0.5 8]);
title('ZLB')
ylabel('G-Spending','FontSize',10,...
       'FontWeight','bold','Color','k')
subplot(5,2,2)
x1 = [(0:1:hor), fliplr((0:1:hor))];
x2 = [g(:,2)', fliplr(g(:,3)')];
h=fill(x1, x2, [0.8 0.8 0.8]);
set(h,'EdgeColor','none');
hold on
plot(0:1:hor, g(:,1),'k--', 'LineWidth', 1.5)
hold on
plot(0:1:hor, g_bp(:,1),'r-o', 'LineWidth', 1.5)
hold on
plot(0:1:hor, g_bp(:,2), 'r--')
hold on
plot(0:1:hor, g_bp(:,3), 'r--')
hold on
hold on
plot(0:1:hor, zz, 'k-','LineWidth', 0.5);
axis([0 hor -0.5 8]);
title('Outside ZLB')
subplot(5,2,3)
x1 = [(0:1:hor), fliplr((0:1:hor))];
x2 = [y_zlb(:,2)', fliplr(y_zlb(:,3)')];
h=fill(x1, x2, [0.8 0.8 0.8]);
set(h,'EdgeColor','none');
hold on
plot(0:1:hor, y_zlb(:,1),'k--', 'LineWidth', 1.5)
hold on
plot(0:1:hor, y_bp_zlb(:,1),'r-o', 'LineWidth', 1.5)
hold on
plot(0:1:hor, y_bp_zlb(:,2), 'r--')
hold on
plot(0:1:hor, y_bp_zlb(:,3), 'r--')
hold on
plot(0:1:hor, zz, 'k-','LineWidth', 0.5);
hold on
axis([0 hor -2 12]);
ylabel('GDP','FontSize',10,...
       'FontWeight','bold','Color','k')
subplot(5,2,4)
x1 = [(0:1:hor), fliplr((0:1:hor))];
x2 = [y(:,2)', fliplr(y(:,3)')];
h=fill(x1, x2, [0.8 0.8 0.8]);
set(h,'EdgeColor','none');
hold on
plot(0:1:hor, y(:,1),'k--', 'LineWidth', 1.5)
hold on
plot(0:1:hor, zz, 'k-','LineWidth', 0.5);
hold on
plot(0:1:hor, y_bp(:,1),'r-o', 'LineWidth', 1.5)
hold on
plot(0:1:hor, y_bp(:,2), 'r--')
hold on
plot(0:1:hor, y_bp(:,3), 'r--')
axis([0 hor -2 12]);
subplot(5,2,5)
x1 = [(0:1:hor), fliplr((0:1:hor))];
x2 = [c_zlb(:,2)', fliplr(c_zlb(:,3)')];
h=fill(x1, x2, [0.8 0.8 0.8]);
set(h,'EdgeColor','none');
hold on
plot(0:1:hor, c_zlb(:,1),'k--', 'LineWidth', 1.5)
hold on
plot(0:1:hor, c_bp_zlb(:,1),'r-o', 'LineWidth', 1.5)
hold on
plot(0:1:hor, c_bp_zlb(:,2), 'r--')
hold on
plot(0:1:hor, c_bp_zlb(:,3), 'r--')
hold on
plot(0:1:hor, zz, 'k-','LineWidth', 0.5);
hold on
axis([0 hor -1 10]);
ylabel('Consumption','FontSize',10,...
       'FontWeight','bold','Color','k')
subplot(5,2,6)
x1 = [(0:1:hor), fliplr((0:1:hor))];
x2 = [c(:,2)', fliplr(c(:,3)')];
h=fill(x1, x2, [0.8 0.8 0.8]);
set(h,'EdgeColor','none');
hold on
plot(0:1:hor, c(:,1),'k--', 'LineWidth', 1.5)
hold on
plot(0:1:hor, c_bp(:,1),'r-o', 'LineWidth', 1.5)
hold on
plot(0:1:hor, c_bp(:,2), 'r--')
hold on
plot(0:1:hor, c_bp(:,3), 'r--')
hold on
plot(0:1:hor, zz, 'k-','LineWidth', 0.5);
hold on
axis([0 hor -1 10]);
subplot(5,2,7)
x1 = [(0:1:hor), fliplr((0:1:hor))];
x2 = [rr_zlb(:,2)', fliplr(rr_zlb(:,3)')];
h=fill(x1, x2, [0.8 0.8 0.8]);
set(h,'EdgeColor','none');
hold on
plot(0:1:hor, rr_zlb(:,1),'k--', 'LineWidth', 1.5)
hold on
plot(0:1:hor, rr_bp_zlb(:,1),'r-o', 'LineWidth', 1.5)
hold on
plot(0:1:hor, rr_bp_zlb(:,2), 'r--')
hold on
plot(0:1:hor, rr_bp_zlb(:,3), 'r--')
hold on
plot(0:1:hor, zz, 'k-','LineWidth', 0.5);
hold on
axis([0 hor -0.8 0.3]);
ylabel('Real Interest Rate','FontSize',10,...
       'FontWeight','bold','Color','k')
subplot(5,2,8)
x1 = [(0:1:hor), fliplr((0:1:hor))];
x2 = [rr(:,2)', fliplr(rr(:,3)')];
h=fill(x1, x2, [0.8 0.8 0.8]);
set(h,'EdgeColor','none');
hold on
plot(0:1:hor, rr(:,1),'k--', 'LineWidth', 1.5)
hold on
plot(0:1:hor, rr_bp(:,1),'r-o', 'LineWidth', 1.5)
hold on
plot(0:1:hor, rr_bp(:,2), 'r--')
hold on
plot(0:1:hor, rr_bp(:,3), 'r--')
hold on
plot(0:1:hor, zz, 'k-','LineWidth', 0.5);
hold on
axis([0 hor -0.8 0.3]);
subplot(5,2,9)
x1 = [(0:1:hor), fliplr((0:1:hor))];
x2 = [rc_zlb(:,2)', fliplr(rc_zlb(:,3)')];
h=fill(x1, x2, [0.8 0.8 0.8]);
set(h,'EdgeColor','none');
hold on
plot(0:1:hor, rc_zlb(:,1),'k--', 'LineWidth', 1.5)
hold on
plot(0:1:hor, rc_bp_zlb(:,1),'r-o', 'LineWidth', 1.5)
hold on
plot(0:1:hor, rc_bp_zlb(:,2), 'r--')
hold on
plot(0:1:hor, rc_bp_zlb(:,3), 'r--')
hold on
plot(0:1:hor, zz, 'k-','LineWidth', 0.5);
hold on
axis([0 hor -1.7 1.7]);
ylabel('Long-term Yields','FontSize',10,...
       'FontWeight','bold','Color','k')
subplot(5,2,10)
x1 = [(0:1:hor), fliplr((0:1:hor))];
x2 = [rc(:,2)', fliplr(rc(:,3)')];
h=fill(x1, x2, [0.8 0.8 0.8]);
set(h,'EdgeColor','none');
hold on
l1=plot(0:1:hor, rc(:,1),'k--', 'LineWidth', 1.5);
hold on
l2=plot(0:1:hor, rc_bp(:,1),'r-o', 'LineWidth', 1.5);
hold on
plot(0:1:hor, rc_bp(:,2), 'r--')
hold on
plot(0:1:hor, rc_bp(:,3), 'r--')
hold on
plot(0:1:hor, zz, 'k-','LineWidth', 0.5);
hold on
axis([0 hor -1.7 1.7]);
legend([l2 l1],'BP','Military Spending','location','southeast')
legend boxoff     