/*******************************************************************************
This file reproduces Tables 2 and 3 from Everett Grant and Julieta Yung 
"The Double-Edge Sword of Global Integration: Robustness, Fragility & Contagion 
in the International Firm Network," Journal of Applied Econometrics, forthcoming
Data files are stored in the data folder. All output will be stored in the 
output folder. 
*******************************************************************************/

use ".\data\RegressionDataMonthly.dta", clear

* Table 2 RyF Global Network (1996-2016)
* Panel A: Dependent Variable: Firm Equity Return Distress Indicator 
	estimates clear

		version 10 : probit Crisis10RetM WeightSum, cluster(FirmID)
		mfx
			capture estimates store BaseCriWgtS
		version 10 : probit Crisis10RetM CrisisSum, cluster(FirmID)
		mfx
			capture estimates store BaseCriCrisS
		version 10 : probit Crisis10RetM WeightSum	CrisisSum, cluster(FirmID)
		mfx
			capture estimates store BaseCriWgtSCrisS
		version 10 : probit Crisis10RetM WeightSum	CrisisSum Crisis10TedSprdAvgM, cluster(FirmID)
		mfx
			capture estimates store NCSCriWgtSCrisS
		version 10 : probit Crisis10RetM WeightSum	CrisisSum Crisis10TedSprdAvgM NetwCrisIntWeightSum NetwCrisIntCrisisSum, cluster(FirmID)
		mfx
			capture estimates store NCSWSCSCriWgtSCrisS
		outreg2 [*] using ".\output\table2a.xml", excel mfx  e(r2_p)  nocons replace
		
* Panel C: Dependent Variable: Firm Monthly Equity Returns 
	estimates clear

		regress RetM WeightSum, noheader cluster(FirmID)
			capture estimates store BaseRetWgtS
		regress RetM CrisisSum, noheader cluster(FirmID)
			capture estimates store BaseRetCrisS
		regress RetM WeightSum	CrisisSum, noheader cluster(FirmID)
			capture estimates store BaseRetWgtSCrisS
		regress RetM WeightSum	CrisisSum Crisis10TedSprdAvgM, noheader cluster(FirmID)
			capture estimates store NCSRetWgtSCrisS
		regress RetM WeightSum	CrisisSum Crisis10TedSprdAvgM NetwCrisIntWeightSum NetwCrisIntCrisisSum, noheader cluster(FirmID)
			capture estimates store NCSWSCSRetWgtSCrisS
		outreg2 [*] using ".\output\table2c.xml", excel  nocons replace
		
* Table 3: RyF Global Network (1996-2016): Different Firm Health Measures
* Panel A: Regression Estimates
	estimates clear
		regress RetM WeightSum	CrisisSum Crisis10TedSprdAvgM, noheader cluster(FirmID)
			capture estimates store NCSRetWgtSCrisS
		sort FirmID Month
		regress D.CDS5yrAvgM  D.WeightSum	D.CrisisSumCDS, noheader cluster(FirmID) noconst
			capture estimates store NCSChngCDSWgtSCrisS
		regress CDS5yrAvgM WeightSum	CrisisSumCDS , noheader cluster(FirmID)
			capture estimates store NCSCDSWgtSCrisS
		outreg2 [*] using ".\output\table3aMonthly.xml", excel  nocons replace

use ".\data\RegressionDataQuarterly.dta", clear
	estimates clear
		regress  ChngEBITDAQ WeightSumQ	CrisisSumEBITDA Crisis10TedSprdAvgQ , noheader cluster(FirmID)
			capture estimates store NCSEBITDAWgtSCrisS
		regress  ChngRevenueQ WeightSumQ	CrisisSumRev Crisis10TedSprdAvgQ , noheader cluster(FirmID)
			capture estimates store NCSRevWgtSCrisS
		outreg2 [*] using ".\output\table3aQuarterly.xml", excel  nocons replace

use ".\data\RegressionDataAnnual.dta", clear
	estimates clear
		regress  ChngRoEY WeightSumY	CrisisSumChngROE Crisis10TedSprdAvgY , noheader cluster(FirmID)
			capture estimates store NCSChngROEWgtSCrisS
		regress  RoEY WeightSumY	CrisisSumROE Crisis10TedSprdAvgY , noheader cluster(FirmID)
			capture estimates store NCSROEWgtSCrisS
		outreg2 [*] using ".\output\table3aAnnual.xml", excel  nocons replace
