
clear

cd /*Add Replication Folder Location Here/replication_cls/data_files*/

********************************************************************************
*Burkina Faso
use input\BurkinaFaso\2003_Fort_HIV\bfar41fl.dta,clear
rename hivclust dhs_clust
rename hivnumb dhs_hh
rename hivline dhs_line

keep dhs_clust dhs_hh dhs_line hiv03 hiv05
sort dhs_clust dhs_hh dhs_line

tempfile hold
save `hold',replace

use input\BurkinaFaso\2003_Fort_HIV\BFPR44FL.DTA,clear
rename hv001 dhs_clust
rename hv002 dhs_hh
rename hvidx dhs_line

keep hv000 dhs_clust dhs_hh dhs_line hv005 hv007 hv024 hv025 hv102 ///
	hv104 hv105 hv108 hv109 hv111 hv113

sort dhs_clust dhs_hh dhs_line
merge 1:1 dhs_clust dhs_hh dhs_line using `hold'
drop _m*

gen country=1
save output\Original_Replication,replace

********************************************************************************
*Cameroon
use input\Cameroon\2004_Fort_HIV\CMar42fl.dta,clear

replace hiv03=. if hiv03==7 /*indeterminant*/

rename hivclust dhs_clust
rename hivnumb dhs_hh
rename hivline dhs_line

keep dhs_clust dhs_hh dhs_line hiv03 hiv05
sort dhs_clust dhs_hh dhs_line

tempfile hold
save `hold',replace

use input\Cameroon\2004_Fort_HIV\CMPR45FL.DTA,clear
rename hv001 dhs_clust
rename hv002 dhs_hh
rename hvidx dhs_line

keep hv000 dhs_clust dhs_hh dhs_line hv005 hv007 hv024 hv025 hv102 ///
	hv104 hv105 hv108 hv109 hv111 hv113

sort dhs_clust dhs_hh dhs_line
merge 1:1 dhs_clust dhs_hh dhs_line using `hold'
drop _m*

append using output\Original_Replication
replace country=2 if country==.
save output\Original_Replication,replace

********************************************************************************
*Cote d'Ivoire
use input\CotedIvoire\2005_Fort_HIV\CIar50fl.dta,clear

replace hiv03=. if hiv03==7 /*indeterminant*/

rename hivclust dhs_clust
rename hivstruct dhs_struct
rename hivnumb dhs_hh
rename hivline dhs_line

keep dhs_clust dhs_struct dhs_hh dhs_line hiv03 hiv05
sort dhs_clust dhs_struct dhs_hh dhs_line

tempfile hold
save `hold',replace

use input\CotedIvoire\2005_Fort_HIV\CIPR50FL.DTA,clear
rename hv001 dhs_clust
rename shstruct dhs_struct
rename hv002 dhs_hh
rename hvidx dhs_line

keep hv000 dhs_clust dhs_struct dhs_hh dhs_line hv005 hv007 hv024 hv025 hv102 ///
	hv104 hv105 hv108 hv109 hv111 hv113

sort dhs_clust dhs_struct dhs_hh dhs_line
merge 1:1 dhs_clust dhs_struct dhs_hh dhs_line using `hold'
drop _m*

append using output\Original_Replication
replace country=3 if country==.
save output\Original_Replication,replace

********************************************************************************
*Ethiopia
use input\Ethiopia\2005_Fort_HIV\ETAR51FL.DTA,clear

replace hiv03=. if hiv03==8 /*indeterminant*/

rename hivclust dhs_clust
rename hivnumb dhs_hh
rename hivline dhs_line

keep dhs_clust dhs_hh dhs_line hiv03 hiv05
sort dhs_clust dhs_hh dhs_line

tempfile hold
save `hold',replace

use input\Ethiopia\2005_Fort_HIV\ETPR51FL.DTA,clear
rename hv001 dhs_clust
rename hv002 dhs_hh
rename hvidx dhs_line

keep hv000 dhs_clust dhs_hh dhs_line hv005 hv007 hv024 hv025 hv102 ///
	hv104 hv105 hv108 hv109 hv111 hv113

sort dhs_clust dhs_hh dhs_line
merge 1:1 dhs_clust dhs_hh dhs_line using `hold'
drop _m*

append using output\Original_Replication
replace country=4 if country==.
save output\Original_Replication,replace

********************************************************************************
*Ghana
use input\Ghana\2003_Fort_HIV\GHar4Afl.dta,clear

replace hiv03=. if (hiv03==8 | hiv03==9) /*indeterminant*/

rename hivclust dhs_clust
rename hivnumb dhs_hh
rename hivline dhs_line

keep dhs_clust dhs_hh dhs_line hiv03 hiv05
sort dhs_clust dhs_hh dhs_line

tempfile hold
save `hold',replace

use input\Ghana\2003_Fort_HIV\GHPR4BFL.DTA,clear
rename hv001 dhs_clust
rename hv002 dhs_hh
rename hvidx dhs_line

keep hv000 dhs_clust dhs_hh dhs_line hv005 hv007 hv024 hv025 hv102 ///
	hv104 hv105 hv108 hv109 hv111 hv113

sort dhs_clust dhs_hh dhs_line
merge 1:1 dhs_clust dhs_hh dhs_line using `hold'
drop _m*

append using output\Original_Replication
replace country=5 if country==.
save output\Original_Replication,replace

********************************************************************************
*Guinea
use input\Guinea\2005_Fort_HIV\gnar51fl.dta,clear

replace hiv03=. if (hiv03==7) /*indeterminant*/

rename hivclust dhs_clust
rename hivnumb dhs_hh
rename hivline dhs_line

keep dhs_clust dhs_hh dhs_line hiv03 hiv05
sort dhs_clust dhs_hh dhs_line

tempfile hold
save `hold',replace

use input\Guinea\2005_Fort_HIV\GNPR53FL.DTA,clear
rename hv001 dhs_clust
rename hv002 dhs_hh
rename hvidx dhs_line

keep hv000 dhs_clust dhs_hh dhs_line hv005 hv007 hv024 hv025 hv102 ///
	hv104 hv105 hv108 hv109 hv111 hv113

sort dhs_clust dhs_hh dhs_line
merge 1:1 dhs_clust dhs_hh dhs_line using `hold'
drop _m*

append using output\Original_Replication
replace country=6 if country==.
save output\Original_Replication,replace

********************************************************************************
*Kenya
use input\Kenya\2003_Fort_HIV\KEar42fl.dta,clear

replace hiv03=. if (hiv03==7) /*indeterminant*/

rename hivclust dhs_clust
rename hivnumb dhs_hh
rename hivline dhs_line

keep dhs_clust dhs_hh dhs_line hiv03 hiv05
sort dhs_clust dhs_hh dhs_line

tempfile hold
save `hold',replace

use input\Kenya\2003_Fort_HIV\KEPR42FL.DTA,clear
rename hv001 dhs_clust
rename hv002 dhs_hh
rename hvidx dhs_line

keep hv000 dhs_clust dhs_hh dhs_line hv005 hv007 hv024 hv025 hv102 ///
	hv104 hv105 hv108 hv109 hv111 hv113

sort dhs_clust dhs_hh dhs_line
merge 1:1 dhs_clust dhs_hh dhs_line using `hold'
drop _m*

append using output\Original_Replication
replace country=7 if country==.
save output\Original_Replication,replace

********************************************************************************
*Lesotho
use input\Lesotho\2004_Fort_HIV\lsar41fl.dta,clear

replace hiv03=. if (hiv03==7) /*indeterminant*/

rename hivclust dhs_clust
rename hivnumb dhs_hh
rename hivline dhs_line

keep dhs_clust dhs_hh dhs_line hiv03 hiv05
sort dhs_clust dhs_hh dhs_line

tempfile hold
save `hold',replace

use input\Lesotho\2004_Fort_HIV\LSPR41FL.dta,clear
rename hv001 dhs_clust
rename hv002 dhs_hh
rename hvidx dhs_line

keep hv000 dhs_clust dhs_hh dhs_line hv005 hv007 hv024 hv025 hv102 ///
	hv104 hv105 hv108 hv109 hv111 hv113

sort dhs_clust dhs_hh dhs_line
merge 1:1 dhs_clust dhs_hh dhs_line using `hold'
drop _m*

append using output\Original_Replication
replace country=8 if country==.
save output\Original_Replication,replace

********************************************************************************
*Malawi
use input\Malawi\2004_Fort_HIV\MWar4Afl.dta,clear
rename hivclust dhs_clust
rename hivnumb dhs_hh
rename hivline dhs_line

keep dhs_clust dhs_hh dhs_line hiv03 hiv05
sort dhs_clust dhs_hh dhs_line

tempfile hold
save `hold',replace

use input\Malawi\2004_Fort_HIV\MWPR4EFL.DTA,clear
rename hv001 dhs_clust
rename hv002 dhs_hh
rename hvidx dhs_line

keep hv000 dhs_clust dhs_hh dhs_line hv005 hv007 hv024 hv025 hv102 ///
	hv104 hv105 hv108 hv109 hv111 hv113

sort dhs_clust dhs_hh dhs_line
merge 1:1 dhs_clust dhs_hh dhs_line using `hold'
drop _m*

append using output\Original_Replication
replace country=9 if country==.
save output\Original_Replication,replace

********************************************************************************
********************************************************************************
*Mali - Region Link Only
use input\Mali\2001_Fort_HIV\MLHT41FL.DTA,clear
rename hiv_res hiv03
rename hivpoids hiv05
rename region hv024
rename age hv105

keep hiv03 hiv05 hv024 hv105
sort hv024

tempfile hold
save `hold',replace

use input\Mali\2001_Fort_HIV\MLPR41FL.DTA,clear
rename hv001 dhs_clust
rename hv002 dhs_hh
rename hvidx dhs_line

keep hv000 dhs_clust dhs_hh dhs_line hv005 hv007 hv024 hv025 hv102 ///
	hv104 hv105 hv108 hv109 hv111 hv113

sort dhs_clust dhs_hh dhs_line
append using `hold'

append using output\Original_Replication
replace country=10 if country==.
save output\Original_Replication,replace

********************************************************************************
*Niger
use input\Niger\2006_Fort_HIV\NIAR51FL.DTA,clear
rename hivclust dhs_clust
rename hivnumb dhs_hh
rename hivline dhs_line

keep dhs_clust dhs_hh dhs_line hiv03 hiv05
sort dhs_clust dhs_hh dhs_line

tempfile hold
save `hold',replace

use input\Niger\2006_Fort_HIV\NIPR51FL.DTA,clear
rename hv001 dhs_clust
rename hv002 dhs_hh
rename hvidx dhs_line

keep hv000 dhs_clust dhs_hh dhs_line hv005 hv007 hv024 hv025 hv102 ///
	hv104 hv105 hv108 hv109 hv111 hv113

sort dhs_clust dhs_hh dhs_line
merge 1:1 dhs_clust dhs_hh dhs_line using `hold'
drop _m*

append using output\Original_Replication
replace country=11 if country==.
save output\Original_Replication,replace

********************************************************************************
*Rwanda
use input\Rwanda\2005_Fort_HIV\rwar51fl.dta,clear
rename hivclust dhs_clust
rename hivnumb dhs_hh
rename hivline dhs_line

keep dhs_clust dhs_hh dhs_line hiv03 hiv05
sort dhs_clust dhs_hh dhs_line

tempfile hold
save `hold',replace

use input\Rwanda\2005_Fort_HIV\RWPR53FL.DTA,clear
rename hv001 dhs_clust
rename hv002 dhs_hh
rename hvidx dhs_line
*drop hv024
*rename shregnat hv024

keep hv000 dhs_clust dhs_hh dhs_line hv005 hv007 hv024 hv025 hv102 ///
	hv104 hv105 hv108 hv109 hv111 hv113

sort dhs_clust dhs_hh dhs_line
merge 1:1 dhs_clust dhs_hh dhs_line using `hold'
drop _m*

append using output\Original_Replication
replace country=12 if country==.
save output\Original_Replication,replace

********************************************************************************
*Senegal
use input\Senegal\2005_Fort_HIV\SNar4Afl.dta,clear
rename hivclust dhs_clust
rename hivstruct dhs_struct
rename hivnumb dhs_hh
rename hivline dhs_line

keep dhs_clust dhs_struct dhs_hh dhs_line hiv03 hiv05
sort dhs_clust dhs_struct dhs_hh dhs_line

tempfile hold
save `hold',replace

use input\Senegal\2005_Fort_HIV\SNPR4HFL.DTA,clear
rename hv001 dhs_clust
rename shconces dhs_struct
rename hv002 dhs_hh
rename hvidx dhs_line

keep hv000 dhs_clust dhs_struct dhs_hh dhs_line hv005 hv007 hv024 hv025 hv102 ///
	hv104 hv105 hv108 hv109 hv111 hv113

sort dhs_clust dhs_struct dhs_hh dhs_line
merge 1:1 dhs_clust dhs_struct dhs_hh dhs_line using `hold'
drop _m*

append using output\Original_Replication
replace country=13 if country==.
save output\Original_Replication,replace

********************************************************************************
*Tanzania
use input\Tanzania\2003_Fort_HIV\TZar4Afl.dta,clear
rename hivclust dhs_clust
rename hivnumb dhs_hh
rename hivline dhs_line

keep dhs_clust dhs_hh dhs_line hiv03 hiv05
sort dhs_clust dhs_hh dhs_line

tempfile hold
save `hold',replace

use input\Tanzania\2003_Fort_HIV\tzpr4afl.dta,clear
rename hv001 dhs_clust
rename hv002 dhs_hh
rename hvidx dhs_line

keep hv000 dhs_clust dhs_hh dhs_line hv005 hv007 hv024 hv025 hv102 ///
	hv104 hv105 hv108 hv109 hv111 hv113

sort dhs_clust dhs_hh dhs_line
merge 1:1 dhs_clust dhs_hh dhs_line using `hold'
drop _m*

append using output\Original_Replication
replace country=14 if country==.
save output\Original_Replication,replace

********************************************************************************
*Zambia - Region Link Only
use input\Zambia\2001_Fort_HIV\ZMHT41FL.DTA,clear
gen hiv03=hivfinal==1 if hivfinal!=.
rename hiv_wgt hiv05
rename hivprov hv024
rename hivage hv105

keep hiv03 hiv05 hv024 hv105
sort hv024

tempfile hold
save `hold',replace

use input\Zambia\2001_Fort_HIV\ZMPR43FL.DTA,clear
rename hv001 dhs_clust
rename hv002 dhs_hh
rename hvidx dhs_line

keep hv000 dhs_clust dhs_hh dhs_line hv005 hv007 hv024 hv025 hv102 ///
	hv104 hv105 hv108 hv109 hv111 hv113

sort dhs_clust dhs_hh dhs_line
append using `hold'

append using output\Original_Replication

replace country=15 if country==.
lab define country_l 1 "Burkina Faso"
lab define country_l 2 "Cameroon",add
lab define country_l 3 "Cote d'Ivoire",add
lab define country_l 4 "Ethiopia",add
lab define country_l 5 "Ghana",add
lab define country_l 6 "Guinea",add
lab define country_l 7 "Kenya",add
lab define country_l 8 "Lesotho",add
lab define country_l 9 "Malawi",add
lab define country_l 10 "Mali",add
lab define country_l 11 "Niger",add
lab define country_l 12 "Rwanda",add
lab define country_l 13 "Senegal",add
lab define country_l 14 "Tanzania",add
lab define country_l 15 "Zambia",add
lab val country country_l

order dhs_struct,after(dhs_clust)
order dhs_line,after(dhs_hh)
order country,before(hv000)
lab var country "Name of Country"

*Combine All Test Results to 0/1
recode hiv03 (2=1) (3=1)
lab var hiv03 "HIV Test Result; 0=Negative"

save output\Original_Replication,replace
