clear

cd /*Add Replication Folder Location Here/replication_cls/data_files*/

********************************************************************************
*Burkina Faso 1993
use input\BurkinaFaso\1993_DHS\BFPR21FL.DTA,clear

rename hv001 dhs_clust
rename hv002 dhs_hh
rename hvidx dhs_line
drop hv024
rename shprov hv024

keep hv000 dhs_clust dhs_hh dhs_line hv005 hv007 hv024 hv025 hv102 ///
	hv104 hv105 hv108 hv109 hv111 hv113

sort dhs_clust dhs_hh dhs_line
gen country=1
save output/Original_AllYears,replace

*Burkina Faso 1998
use input\BurkinaFaso\1998_DHS\BFPR31FL.DTA, clear

rename hv001 dhs_clust
rename hv002 dhs_hh
rename hvidx dhs_line
drop hv024
rename shprov hv024

keep hv000 dhs_clust dhs_hh dhs_line hv005 hv007 hv024 hv025 hv102 ///
	hv104 hv105 hv108 hv109 hv111 hv113

sort dhs_clust dhs_hh dhs_line
append using output/Original_AllYears
replace country=1 if country==.
save output/Original_AllYears,replace

*Burkina Faso 2003
use input\BurkinaFaso\2003_Fort_HIV\bfar41fl.dta,clear
rename hivclust dhs_clust
rename hivnumb dhs_hh
rename hivline dhs_line

keep dhs_clust dhs_hh dhs_line hiv03 hiv05
sort dhs_clust dhs_hh dhs_line

tempfile hold
save `hold',replace

use input\BurkinaFaso\2003_Fort_HIV\BFPR44FL.DTA,clear
rename hv001 dhs_clust
rename hv002 dhs_hh
rename hvidx dhs_line

keep hv000 dhs_clust dhs_hh dhs_line hv005 hv007 hv024 hv025 hv102 ///
	hv104 hv105 hv108 hv109 hv111 hv113

sort dhs_clust dhs_hh dhs_line
merge 1:1 dhs_clust dhs_hh dhs_line using `hold'
drop _m*

append using output/Original_AllYears
gen fortson=1 if hv007==2003
replace country=1 if country==.
save output/Original_AllYears,replace

*Burkina Faso 2010

use input\BurkinaFaso\2010_HIV_DHS\BFAR61FL.DTA,clear

replace hiv03=. if hiv03==7 /*indeterminant*/

rename hivclust dhs_clust
rename hivnumb dhs_hh
rename hivline dhs_line

keep dhs_clust dhs_hh dhs_line hiv03 hiv05
sort dhs_clust dhs_hh dhs_line

tempfile hold
save `hold',replace

use input\BurkinaFaso\2010_HIV_DHS\BFPR62FL.DTA,clear
rename hv001 dhs_clust
rename hv002 dhs_hh
rename hvidx dhs_line

	*Child Labor
	gen nfam_work=sh20d if hv105>=5 & hv105<=15 & sh20d!=9
	recode nfam_work (3=0) (1=2) (2=1)

	gen fam_work=sh20h if hv105>=5 & hv105<=15 & sh20h!=9

keep hv000 dhs_clust dhs_hh dhs_line hv005 hv007 hv024 hv025 hv102 ///
	hv104 hv105 hv108 hv109 hv111 hv113 nfam_work fam_work

sort dhs_clust dhs_hh dhs_line
merge 1:1 dhs_clust dhs_hh dhs_line using `hold'
drop _m*

append using output/Original_AllYears
replace country=1 if country==.
save output/Original_AllYears,replace

********************************************************************************
*Cameroon 1991
use input\Cameroon\1991_DHS\CMPR22FL.DTA,clear
rename hv001 dhs_clust
rename hv002 dhs_hh
rename hvidx dhs_line
drop hv024
rename shprov hv024

keep hv000 dhs_clust dhs_hh dhs_line hv005 hv007 hv024 hv025 hv102 ///
	hv104 hv105 hv108 hv109 hv111 hv113

sort dhs_clust dhs_hh dhs_line
append using output/Original_AllYears
replace country=2 if country==.
save output/Original_AllYears,replace

*Cameroon 1998 
use input\Cameroon\1998_DHS\CMPR31FL.DTA,clear

rename hv001 dhs_clust
rename hv002 dhs_hh
rename hvidx dhs_line
drop hv024
rename shprov hv024

keep hv000 dhs_clust dhs_hh dhs_line hv005 hv007 hv024 hv025 hv102 ///
	hv104 hv105 hv108 hv109 hv111 hv113

sort dhs_clust dhs_hh dhs_line
append using output/Original_AllYears
replace country=2 if country==.
save output/Original_AllYears,replace

*Cameroon 2004
use input\Cameroon\2004_Fort_HIV\CMar42fl.dta,clear

replace hiv03=. if hiv03==7 /*indeterminant*/

rename hivclust dhs_clust
rename hivnumb dhs_hh
rename hivline dhs_line

keep dhs_clust dhs_hh dhs_line hiv03 hiv05 
sort dhs_clust dhs_hh dhs_line

tempfile hold
save `hold',replace

use input\Cameroon\2004_Fort_HIV\CMPR45FL.DTA,clear
rename hv001 dhs_clust
rename hv002 dhs_hh
rename hvidx dhs_line

keep hv000 dhs_clust dhs_hh dhs_line hv005 hv007 hv024 hv025 hv102 ///
	hv104 hv105 hv108 hv109 hv111 hv113

sort dhs_clust dhs_hh dhs_line
merge 1:1 dhs_clust dhs_hh dhs_line using `hold'
drop _m*

append using output/Original_AllYears
replace country=2 if country==.
replace fortson=1 if country==2 & hv007==2004
save output/Original_AllYears,replace

*Cameroon 2011
use input\Cameroon\2011_HIV_DHS\CMAR61FL.DTA,clear

replace hiv03=. if hiv03==7 /*indeterminant*/

rename hivclust dhs_clust
rename hivnumb dhs_hh
rename hivline dhs_line

keep dhs_clust dhs_hh dhs_line hiv03 hiv05 
sort dhs_clust dhs_hh dhs_line

tempfile hold
save `hold',replace

use input\Cameroon\2011_HIV_DHS\CMPR61FL.DTA,clear
rename hv001 dhs_clust
rename hv002 dhs_hh
rename hvidx dhs_line

	*Child Labor
	gen nfam_work=sh304 if hv105>=5 & hv105<=15 & sh304!=9
	recode nfam_work (3=0) (2=1) (1=2)

	gen fam_work=sh309 if hv105>=5 & hv105<=15 & sh309!=9

keep hv000 dhs_clust dhs_hh dhs_line hv005 hv007 hv024 hv025 hv102 ///
	hv104 hv105 hv108 hv109 hv111 hv113 nfam_work fam_work

sort dhs_clust dhs_hh dhs_line
merge 1:1 dhs_clust dhs_hh dhs_line using `hold'
drop _m*

append using output/Original_AllYears
replace country=2 if country==.
save output/Original_AllYears,replace

********************************************************************************
*Cote d'Ivoire 1994
use input\CotedIvoire\1994_DHS\CIPR35FL.DTA,clear
rename hv001 dhs_clust
rename hv002 dhs_hh
rename hvidx dhs_line

keep hv000 dhs_clust dhs_hh dhs_line hv005 hv007 hv024 hv025 hv102 ///
	hv104 hv105 hv108 hv109 hv111 hv113

sort dhs_clust dhs_hh dhs_line
append using output/Original_AllYears
replace country=3 if country==.
save output/Original_AllYears,replace

*Cote d'Ivoire 2005
use input\CotedIvoire\2005_Fort_HIV\CIar50fl.dta,clear

replace hiv03=. if hiv03==7 /*indeterminant*/

rename hivclust dhs_clust
rename hivstruct dhs_struct
rename hivnumb dhs_hh
rename hivline dhs_line

keep dhs_clust dhs_struct dhs_hh dhs_line hiv03 hiv05
sort dhs_clust dhs_struct dhs_hh dhs_line

tempfile hold
save `hold',replace

use input\CotedIvoire\2005_Fort_HIV\CIPR50FL.DTA,clear
rename hv001 dhs_clust
rename shstruct dhs_struct
rename hv002 dhs_hh
rename hvidx dhs_line

keep hv000 dhs_clust dhs_struct dhs_hh dhs_line hv005 hv007 hv024 hv025 hv102 ///
	hv104 hv105 hv108 hv109 

sort dhs_clust dhs_struct dhs_hh dhs_line
merge 1:1 dhs_clust dhs_struct dhs_hh dhs_line using `hold'
drop _m*

append using output/Original_AllYears
replace country=3 if country==.
replace fortson=1 if country==3 & hv007==2005
save output/Original_AllYears,replace

*Cote d'Ivoire 2011
use input\CotedIvoire\2011_HIV_DHS\CIAR61FL.DTA,clear

replace hiv03=. if hiv03==7 /*indeterminant*/

rename hivclust dhs_clust
rename hivnumb dhs_hh
rename hivline dhs_line

keep dhs_clust dhs_hh dhs_line hiv03 hiv05
sort dhs_clust dhs_hh dhs_line

tempfile hold
save `hold',replace

use input\CotedIvoire\2011_HIV_DHS\CIPR62FL.DTA,clear
rename hv001 dhs_clust
rename hv002 dhs_hh
rename hvidx dhs_line

	*Child Labor
	gen nfam_work=chl1 if hv105>=5 & hv105<=15 & chl1!=9
	recode nfam_work (2=1) (1=2)

	gen fam_work=chl5 if hv105>=5 & hv105<=15 & chl5!=9

keep hv000 dhs_clust dhs_hh dhs_line hv005 hv007 hv024 hv025 hv102 ///
	hv104 hv105 hv108 hv109 hv111 hv113 nfam_work fam_work

sort dhs_clust dhs_hh dhs_line
merge 1:1 dhs_clust dhs_hh dhs_line using `hold'
drop _m*

append using output/Original_AllYears
replace country=3 if country==.
save output/Original_AllYears,replace

********************************************************************************
*Ethiopia 2000
use input\Ethiopia\2000_DHS\ETPR41FL.DTA,clear
rename hv001 dhs_clust
rename hv002 dhs_hh
rename hvidx dhs_line

keep hv000 dhs_clust dhs_hh dhs_line hv005 hv007 hv024 hv025 hv102 ///
	hv104 hv105 hv108 hv109 hv111 hv113

sort dhs_clust dhs_hh dhs_line
append using output/Original_AllYears
replace country=4 if country==.
save output/Original_AllYears,replace

*Ethiopia 2005
use input\Ethiopia\2005_Fort_HIV\ETAR51FL.DTA,clear

replace hiv03=. if hiv03==8 /*indeterminant*/

rename hivclust dhs_clust
rename hivnumb dhs_hh
rename hivline dhs_line

keep dhs_clust dhs_hh dhs_line hiv03 hiv05
sort dhs_clust dhs_hh dhs_line

tempfile hold
save `hold',replace

use input\Ethiopia\2005_Fort_HIV\ETPR51FL.DTA,clear
rename hv001 dhs_clust
rename hv002 dhs_hh
rename hvidx dhs_line

keep hv000 dhs_clust dhs_hh dhs_line hv005 hv007 hv024 hv025 hv102 ///
	hv104 hv105 hv108 hv109 hv111 hv113

sort dhs_clust dhs_hh dhs_line
merge 1:1 dhs_clust dhs_hh dhs_line using `hold'
drop _m*

append using output/Original_AllYears
replace country=4 if country==.
replace fortson=1 if country==4 & hv007==1997
save output/Original_AllYears,replace

*Ethiopia 2011
use input\Ethiopia\2011_HIV_DHS\ETar61fl,clear

replace hiv03=. if hiv03==8 | hiv03==7 /*indeterminant*/

rename hivclust dhs_clust
rename hivnumb dhs_hh
rename hivline dhs_line

keep dhs_clust dhs_hh dhs_line hiv03 hiv05
sort dhs_clust dhs_hh dhs_line

tempfile hold
save `hold',replace

use input\Ethiopia\2011_HIV_DHS\ETPR61FL.DTA,clear
rename hv001 dhs_clust
rename hv002 dhs_hh
rename hvidx dhs_line

	*Child Labor
	gen nfam_work=sh22 if hv105>=5 & hv105<=15 & sh22!=9
	recode nfam_work (2=1) (1=2)

	gen fam_work=sh27 if hv105>=5 & hv105<=15 & sh27!=9

keep hv000 dhs_clust dhs_hh dhs_line hv005 hv007 hv024 hv025 hv102 ///
	hv104 hv105 hv108 hv109 hv111 hv113 nfam_work fam_work

sort dhs_clust dhs_hh dhs_line
merge 1:1 dhs_clust dhs_hh dhs_line using `hold'
drop _m*

append using output/Original_AllYears
replace country=4 if country==.
save output/Original_AllYears,replace

*Ethiopia 2016
use input\Ethiopia\2016_HIV_DHS\ETAR71FL.DTA,clear

replace hiv03=. if hiv03==9 /*inconclusive*/

rename hivclust dhs_clust
rename hivnumb dhs_hh
rename hivline dhs_line

keep dhs_clust dhs_hh dhs_line hiv03 hiv05
sort dhs_clust dhs_hh dhs_line

tempfile hold
save `hold',replace

use input\Ethiopia\2016_HIV_DHS\ETPR70FL.DTA,clear
rename hv001 dhs_clust
rename hv002 dhs_hh
rename hvidx dhs_line

keep hv000 dhs_clust dhs_hh dhs_line hv005 hv007 hv024 hv025 hv102 ///
	hv104 hv105 hv108 hv109 hv111 hv113

sort dhs_clust dhs_hh dhs_line
merge 1:1 dhs_clust dhs_hh dhs_line using `hold'
drop _m*

append using output/Original_AllYears
replace country=4 if country==.
save output/Original_AllYears,replace

********************************************************************************
*Ghana 1993
use input\Ghana\1993_DHS\GHPR31FL.DTA,clear

rename hv001 dhs_clust
rename hv002 dhs_hh
rename hvidx dhs_line

keep hv000 dhs_clust dhs_hh dhs_line hv005 hv007 hv024 hv025 hv102 ///
	hv104 hv105 hv108 hv109 hv111 hv113

sort dhs_clust dhs_hh dhs_line
append using output/Original_AllYears
replace country=5 if country==.
save output/Original_AllYears,replace

*Ghana 1998
use input\Ghana\1998_DHS\GHPR41FL.DTA,clear 
rename hv001 dhs_clust
rename hv002 dhs_hh
rename hvidx dhs_line

keep hv000 dhs_clust dhs_hh dhs_line hv005 hv007 hv024 hv025 hv102 ///
	hv104 hv105 hv108 hv109 hv111 hv113

sort dhs_clust dhs_hh dhs_line
append using output/Original_AllYears
replace country=5 if country==.
save output/Original_AllYears,replace

*Ghana 2003
use input\Ghana\2003_Fort_HIV\GHar4Afl.dta,clear

replace hiv03=. if (hiv03==8 | hiv03==9) /*indeterminant*/

rename hivclust dhs_clust
rename hivnumb dhs_hh
rename hivline dhs_line

keep dhs_clust dhs_hh dhs_line hiv03 hiv05
sort dhs_clust dhs_hh dhs_line

tempfile hold
save `hold',replace

use input\Ghana\2003_Fort_HIV\GHPR4BFL.DTA,clear
rename hv001 dhs_clust
rename hv002 dhs_hh
rename hvidx dhs_line

keep hv000 dhs_clust dhs_hh dhs_line hv005 hv007 hv024 hv025 hv102 ///
	hv104 hv105 hv108 hv109 hv111 hv113

sort dhs_clust dhs_hh dhs_line
merge 1:1 dhs_clust dhs_hh dhs_line using `hold'
drop _m*

append using output/Original_AllYears
replace country=5 if country==.
replace fortson=1 if country==5 & hv007==2003
save output/Original_AllYears,replace

*Ghana 2008 (DHS Only)
use input\Ghana\2008_DHS\GHPR5AFL.DTA,clear 
rename hv001 dhs_clust
rename hv002 dhs_hh
rename hvidx dhs_line

keep hv000 dhs_clust dhs_hh dhs_line hv005 hv007 hv024 hv025 hv102 ///
	hv104 hv105 hv108 hv109 hv111 hv113

sort dhs_clust dhs_hh dhs_line
append using output/Original_AllYears
replace country=5 if country==.
save output/Original_AllYears,replace

*Ghana 2014
use input\Ghana\2014_HIV_DHS\GHAR71FL.DTA,clear

rename hivclust dhs_clust
rename hivnumb dhs_hh
rename hivline dhs_line

keep dhs_clust dhs_hh dhs_line hiv03 hiv05
sort dhs_clust dhs_hh dhs_line

tempfile hold
save `hold',replace

use input\Ghana\2014_HIV_DHS\GHPR72FL.DTA,clear
rename hv001 dhs_clust
rename hv002 dhs_hh
rename hvidx dhs_line

keep hv000 dhs_clust dhs_hh dhs_line hv005 hv007 hv024 hv025 hv102 ///
	hv104 hv105 hv108 hv109 hv111 hv113

sort dhs_clust dhs_hh dhs_line
merge 1:1 dhs_clust dhs_hh dhs_line using `hold'
drop _m*

append using output/Original_AllYears
replace country=5 if country==.
save output/Original_AllYears,replace

********************************************************************************
*Guinea 1999
use input\Guinea\1999_DHS\GNPR41FL.DTA,clear
rename hv001 dhs_clust
rename hv002 dhs_hh
rename hvidx dhs_line

keep hv000 dhs_clust dhs_hh dhs_line hv005 hv007 hv024 hv025 hv102 ///
	hv104 hv105 hv108 hv109 hv111 hv113

sort dhs_clust dhs_hh dhs_line
append using output/Original_AllYears
replace country=6 if country==.
save output/Original_AllYears,replace

*Guinea 2005
use input\Guinea\2005_Fort_HIV\gnar51fl.dta,clear

replace hiv03=. if (hiv03==7) /*indeterminant*/

rename hivclust dhs_clust
rename hivnumb dhs_hh
rename hivline dhs_line

keep dhs_clust dhs_hh dhs_line hiv03 hiv05
sort dhs_clust dhs_hh dhs_line

tempfile hold
save `hold',replace

use input\Guinea\2005_Fort_HIV\GNPR53FL.DTA,clear
rename hv001 dhs_clust
rename hv002 dhs_hh
rename hvidx dhs_line

drop hv024
rename shregnat hv024

keep hv000 dhs_clust dhs_hh dhs_line hv005 hv007 hv024 hv025 hv102 ///
	hv104 hv105 hv108 hv109 hv111 hv113

sort dhs_clust dhs_hh dhs_line
merge 1:1 dhs_clust dhs_hh dhs_line using `hold'
drop _m*

append using output/Original_AllYears
replace country=6 if country==.
replace fortson=1 if country==6 & hv007==2005
save output/Original_AllYears,replace

*Guinea 2012
use input\Guinea\2012_HIV_DHS\gnAR61FL.DTA,clear

replace hiv03=. if (hiv03==7) /*indeterminant*/

rename hivclust dhs_clust
rename hivnumb dhs_hh
rename hivline dhs_line

keep dhs_clust dhs_hh dhs_line hiv03 hiv05
sort dhs_clust dhs_hh dhs_line

tempfile hold
save `hold',replace

use input\Guinea\2012_HIV_DHS\GNPR62FL.DTA,clear
rename hv001 dhs_clust
rename hv002 dhs_hh
rename hvidx dhs_line

	*Child Labor
	gen nfam_work=chl1 if hv105>=5 & hv105<=15 & chl1!=9
	recode nfam_work (2=1) (1=2)
	
	gen fam_work=chl5 if hv105>=5 & hv105<=15 & chl5!=9

drop hv024
rename shregnew hv024
keep hv000 dhs_clust dhs_hh dhs_line hv005 hv007 hv024 hv025 hv102 ///
	hv104 hv105 hv108 hv109 hv111 hv113 nfam_work fam_work

sort dhs_clust dhs_hh dhs_line
merge 1:1 dhs_clust dhs_hh dhs_line using `hold'
drop _m*

append using output/Original_AllYears
replace country=6 if country==.
save output/Original_AllYears,replace

********************************************************************************
*Kenya 1993
use input\Kenya\1993_DHS\KEPR33FL.DTA,clear

rename hv001 dhs_clust
rename hv002 dhs_hh
rename hvidx dhs_line

keep hv000 dhs_clust dhs_hh dhs_line hv005 hv007 hv024 hv025 hv102 ///
	hv104 hv105 hv108 hv109 hv111 hv113

sort dhs_clust dhs_hh dhs_line
append using output/Original_AllYears
replace country=7 if country==.
save output/Original_AllYears,replace

*Kenya 1998
use input\Kenya\1998_DHS\KEPR3AFL.DTA,clear

rename hv001 dhs_clust
rename hv002 dhs_hh
rename hvidx dhs_line

keep hv000 dhs_clust dhs_hh dhs_line hv005 hv007 hv024 hv025 hv102 ///
	hv104 hv105 hv108 hv109 hv111 hv113

sort dhs_clust dhs_hh dhs_line
append using output/Original_AllYears
replace country=7 if country==.
save output/Original_AllYears,replace

*Kenya 2003
use input\Kenya\2003_Fort_HIV\KEar42fl.dta,clear

replace hiv03=. if (hiv03==7) /*indeterminant*/

rename hivclust dhs_clust
rename hivnumb dhs_hh
rename hivline dhs_line

keep dhs_clust dhs_hh dhs_line hiv03 hiv05
sort dhs_clust dhs_hh dhs_line

tempfile hold
save `hold',replace

use input\Kenya\2003_Fort_HIV\KEPR42FL.DTA,clear
rename hv001 dhs_clust
rename hv002 dhs_hh
rename hvidx dhs_line

keep hv000 dhs_clust dhs_hh dhs_line hv005 hv007 hv024 hv025 hv102 ///
	hv104 hv105 hv108 hv109 hv111 hv113

sort dhs_clust dhs_hh dhs_line
merge 1:1 dhs_clust dhs_hh dhs_line using `hold'
drop _m*

append using output/Original_AllYears
replace country=7 if country==.
replace fortson=1 if country==7 & hv007==2003
save output/Original_AllYears,replace

*Kenya 2008
use input\Kenya\2008_HIV_DHS\KEar51fl,clear

rename hivclust dhs_clust
rename hivnumb dhs_hh
rename hivline dhs_line

keep dhs_clust dhs_hh dhs_line hiv03 hiv05
sort dhs_clust dhs_hh dhs_line

tempfile hold
save `hold',replace

use input\Kenya\2008_HIV_DHS\KEPR52FL.DTA,clear
rename hv001 dhs_clust
rename hv002 dhs_hh
rename hvidx dhs_line

keep hv000 dhs_clust dhs_hh dhs_line hv005 hv007 hv024 hv025 hv102 ///
	hv104 hv105 hv108 hv109 hv111 hv113

sort dhs_clust dhs_hh dhs_line
merge 1:1 dhs_clust dhs_hh dhs_line using `hold'
drop _m*

append using output/Original_AllYears
replace country=7 if country==.
save output/Original_AllYears,replace

*Kenya 2015 - DHS Only
use input\Kenya\2015_DHS\KEPR7HFL.DTA,clear

rename hv001 dhs_clust
rename hv002 dhs_hh
rename hvidx dhs_line

keep hv000 dhs_clust dhs_hh dhs_line hv005 hv007 hv024 hv025 hv102 ///
	hv104 hv105 hv108 hv109 hv111 hv113

sort dhs_clust dhs_hh dhs_line
append using output/Original_AllYears
replace country=7 if country==.
save output/Original_AllYears,replace

********************************************************************************
*Lesotho 2004
use input\Lesotho\2004_Fort_HIV\lsar41fl.dta,clear

replace hiv03=. if (hiv03==7) /*indeterminant*/

rename hivclust dhs_clust
rename hivnumb dhs_hh
rename hivline dhs_line

keep dhs_clust dhs_hh dhs_line hiv03 hiv05
sort dhs_clust dhs_hh dhs_line

tempfile hold
save `hold',replace

use input\Lesotho\2004_Fort_HIV\LSPR41FL.dta,clear
rename hv001 dhs_clust
rename hv002 dhs_hh
rename hvidx dhs_line

keep hv000 dhs_clust dhs_hh dhs_line hv005 hv007 hv024 hv025 hv102 ///
	hv104 hv105 hv108 hv109 hv111 hv113

sort dhs_clust dhs_hh dhs_line
merge 1:1 dhs_clust dhs_hh dhs_line using `hold'
drop _m*

append using output/Original_AllYears
replace country=8 if country==.
replace fortson=1 if country==8 & hv007==2004
gen nokids=1
save output/Original_AllYears,replace

*Lesotho 2009
use input\Lesotho\2009_HIV_DHS\LSAR61FL.DTA,clear

rename hivclust dhs_clust
rename hivnumb dhs_hh
rename hivline dhs_line

keep dhs_clust dhs_hh dhs_line hiv03 hiv05
sort dhs_clust dhs_hh dhs_line

tempfile hold
save `hold',replace

use input\Lesotho\2009_HIV_DHS\LSPR61FL.DTA,clear
rename hv001 dhs_clust
rename hv002 dhs_hh
rename hvidx dhs_line

keep hv000 dhs_clust dhs_hh dhs_line hv005 hv007 hv024 hv025 hv102 ///
	hv104 hv105 hv108 hv109 hv111 hv113

sort dhs_clust dhs_hh dhs_line
merge 1:1 dhs_clust dhs_hh dhs_line using `hold'
drop _m*

append using output/Original_AllYears
replace country=8 if country==.
replace nokids=1 if nokids==.
save output/Original_AllYears,replace

*Lesotho 2014
use input\Lesotho\2014_HIV_DHS\LSAR72FL.DTA,clear

replace hiv03=. if (hiv03==7) /*indeterminant*/

rename hivclust dhs_clust
rename hivnumb dhs_hh
rename hivline dhs_line

keep dhs_clust dhs_hh dhs_line hiv03 hiv05
sort dhs_clust dhs_hh dhs_line

tempfile hold
save `hold',replace

use input\Lesotho\2014_HIV_DHS\LSPR71FL.DTA,clear
rename hv001 dhs_clust
rename hv002 dhs_hh
rename hvidx dhs_line

keep hv000 dhs_clust dhs_hh dhs_line hv005 hv007 hv024 hv025 hv102 ///
	hv104 hv105 hv108 hv109 hv111 hv113

sort dhs_clust dhs_hh dhs_line
merge 1:1 dhs_clust dhs_hh dhs_line using `hold'
drop _m*

append using output/Original_AllYears
replace country=8 if country==.
replace nokids=1 if nokids==.
save output/Original_AllYears,replace

********************************************************************************
*Malawi 1992
use input\Malawi\1992_DHS\MWPR22FL.DTA,clear

rename hv001 dhs_clust
rename hv002 dhs_hh
rename hvidx dhs_line

keep hv000 dhs_clust dhs_hh dhs_line hv005 hv007 hv024 hv025 hv102 ///
	hv104 hv105 hv108 hv109 hv111 hv113

sort dhs_clust dhs_hh dhs_line
append using output/Original_AllYears
replace country=9 if country==.
save output/Original_AllYears,replace

*Malawi 2000
use input\Malawi\2000_DHS\MWPR41FL.DTA,clear

rename hv001 dhs_clust
rename hv002 dhs_hh
rename hvidx dhs_line

keep hv000 dhs_clust dhs_hh dhs_line hv005 hv007 hv024 hv025 hv102 ///
	hv104 hv105 hv108 hv109 hv111 hv113

sort dhs_clust dhs_hh dhs_line
append using output/Original_AllYears
replace country=9 if country==.
save output/Original_AllYears,replace

*Malawi 2004
use input\Malawi\2004_Fort_HIV\MWar4Afl.dta,clear
rename hivclust dhs_clust
rename hivnumb dhs_hh
rename hivline dhs_line

keep dhs_clust dhs_hh dhs_line hiv03 hiv05
sort dhs_clust dhs_hh dhs_line

tempfile hold
save `hold',replace

use input\Malawi\2004_Fort_HIV\MWPR4EFL.DTA,clear
rename hv001 dhs_clust
rename hv002 dhs_hh
rename hvidx dhs_line

	*Child Labor
	gen nfam_work=sl41 if hv105>=5 & hv105<=15 & sl41!=9
	recode nfam_work (2=1) (1=2)

	gen fam_work=sl46!=0 if hv105>=5 & hv105<=15 & (sl41!=.)

keep hv000 dhs_clust dhs_hh dhs_line hv005 hv007 hv024 hv025 hv102 ///
	hv104 hv105 hv108 hv109 hv111 hv113 nfam_work fam_work

sort dhs_clust dhs_hh dhs_line
merge 1:1 dhs_clust dhs_hh dhs_line using `hold'
drop _m*

append using output/Original_AllYears
replace country=9 if country==.
replace fortson=1 if country==9 & hv007==2004
save output/Original_AllYears,replace

*Malawi 2010
use input\Malawi\2010_HIV_DHS\MWAR61FL.DTA,clear

replace hiv03=. if (hiv03==7) /*indeterminant*/

rename hivclust dhs_clust
rename hivnumb dhs_hh
rename hivline dhs_line

keep dhs_clust dhs_hh dhs_line hiv03 hiv05
sort dhs_clust dhs_hh dhs_line

tempfile hold
save `hold',replace

use input\Malawi\2010_HIV_DHS\MWPR61FL.DTA,clear
rename hv001 dhs_clust
rename hv002 dhs_hh
rename hvidx dhs_line

keep hv000 dhs_clust dhs_hh dhs_line hv005 hv007 hv024 hv025 hv102 ///
	hv104 hv105 hv108 hv109 hv111 hv113

sort dhs_clust dhs_hh dhs_line
merge 1:1 dhs_clust dhs_hh dhs_line using `hold'
drop _m*

append using output/Original_AllYears
replace country=9 if country==.
save output/Original_AllYears,replace

*Malawi 2014
use input\Malawi\2015_HIV_DHS\MWAR7AFL.DTA,clear

replace hiv03=. if (hiv03==7 | hiv03==9) /*indeterminant*/

rename hivclust dhs_clust
rename hivnumb dhs_hh
rename hivline dhs_line

keep dhs_clust dhs_hh dhs_line hiv03 hiv05
sort dhs_clust dhs_hh dhs_line

tempfile hold
save `hold',replace

use input\Malawi\2015_HIV_DHS\MWPR7HFL.DTA,clear
rename hv001 dhs_clust
rename hv002 dhs_hh
rename hvidx dhs_line

keep hv000 dhs_clust dhs_hh dhs_line hv005 hv007 hv024 hv025 hv102 ///
	hv104 hv105 hv108 hv109 hv111 hv113

sort dhs_clust dhs_hh dhs_line
merge 1:1 dhs_clust dhs_hh dhs_line using `hold'
drop _m*

append using output/Original_AllYears
replace country=9 if country==.
save output/Original_AllYears,replace

********************************************************************************
********************************************************************************
*Mali 1995
use input\Mali\1995_DHS\MLPR32FL.DTA

rename hv001 dhs_clust
rename hv002 dhs_hh
rename hvidx dhs_line

keep hv000 dhs_clust dhs_hh dhs_line hv005 hv007 hv024 hv025 hv102 ///
	hv104 hv105 hv108 hv109 hv111 hv113

sort dhs_clust dhs_hh dhs_line
append using output/Original_AllYears
replace country=10 if country==.
save output/Original_AllYears,replace

*Mali - Region Link Only 2001
use input\Mali\2001_Fort_HIV\MLHT41FL.DTA,clear
rename hiv_res hiv03
rename hivpoids hiv05
rename region hv024
rename age hv105
gen hv007=2001

keep hiv03 hiv05 hv024 hv105 hv007
sort hv024

tempfile hold
save `hold',replace

use input\Mali\2001_Fort_HIV\MLPR41FL.DTA,clear
rename hv001 dhs_clust
rename hv002 dhs_hh
rename hvidx dhs_line

	*Child Labor
	gen nfam_work=sh20e if hv105>=5 & hv105<=15 & sh20e!=9
	recode nfam_work (3=0) (1=2) (2=1)

	gen fam_work=sh20j if hv105>=5 & hv105<=15 & sh20j!=9

keep hv000 dhs_clust dhs_hh dhs_line hv005 hv007 hv024 hv025 hv102 ///
	hv104 hv105 hv108 hv109 hv111 hv113 nfam_work fam_work

sort dhs_clust dhs_hh dhs_line
append using `hold'

append using output/Original_AllYears
replace country=10 if country==.
replace fortson=1 if country==10 & hv007==2001
save output/Original_AllYears,replace

*Mali 2006
use input\Mali\2006_HIV_DHS\MLar51fl,clear
rename hivclust dhs_clust
rename hivnumb dhs_hh
rename hivline dhs_line

keep dhs_clust dhs_hh dhs_line hiv03 hiv05
sort dhs_clust dhs_hh dhs_line

tempfile hold
save `hold',replace

use input\Mali\2006_HIV_DHS\MLPR53FL.DTA,clear
rename hv001 dhs_clust
rename hv002 dhs_hh
rename hvidx dhs_line

	*Child Labor
	gen nfam_work=sh20e if hv105>=5 & hv105<=15 & sh20e!=9
	recode nfam_work (3=0) (1=2) (2=1)

	gen fam_work=sh20i if hv105>=5 & hv105<=15 & sh20i!=9

keep hv000 dhs_clust dhs_hh dhs_line hv005 hv007 hv024 hv025 hv102 ///
	hv104 hv105 hv108 hv109 hv111 hv113 nfam_work fam_work

sort dhs_clust dhs_hh dhs_line
merge 1:1 dhs_clust dhs_hh dhs_line using `hold'
drop _m*

append using output/Original_AllYears
replace country=10 if country==.
save output/Original_AllYears,replace

*Mali 2012
use input\Mali\2012_HIV_DHS\mlar6afl,clear
rename hivclust dhs_clust
rename hivnumb dhs_hh
rename hivline dhs_line

keep dhs_clust dhs_hh dhs_line hiv03 hiv05
sort dhs_clust dhs_hh dhs_line

tempfile hold
save `hold',replace

use input\Mali\2012_HIV_DHS\MLPR6HFL.DTA,clear
rename hv001 dhs_clust
rename hv002 dhs_hh
rename hvidx dhs_line

	*Child Labor
	gen nfam_work=chl1 if hv105>=5 & hv105<=15 & chl1!=9
	recode nfam_work (1=2) (2=1)

	gen fam_work=chl5 if hv105>=5 & hv105<=15 & chl5!=9

keep hv000 dhs_clust dhs_hh dhs_line hv005 hv007 hv024 hv025 hv102 ///
	hv104 hv105 hv108 hv109 hv111 hv113 nfam_work fam_work

sort dhs_clust dhs_hh dhs_line
merge 1:1 dhs_clust dhs_hh dhs_line using `hold'
drop _m*

append using output/Original_AllYears
replace country=10 if country==.
save output/Original_AllYears,replace

********************************************************************************
*Niger 1992
use input\Niger\1992_DHS\NIPR22FL.DTA,clear

rename hv001 dhs_clust
rename hv002 dhs_hh
rename hvidx dhs_line

keep hv000 dhs_clust dhs_hh dhs_line hv005 hv007 hv024 hv025 hv102 ///
	hv104 hv105 hv108 hv109 hv111 hv113

sort dhs_clust dhs_hh dhs_line
append using output/Original_AllYears
replace country=11 if country==.
save output/Original_AllYears,replace

*Niger 1998
use input\Niger\1998_DHS\NIPR31FL.DTA,clear

rename hv001 dhs_clust
rename hv002 dhs_hh
rename hvidx dhs_line

keep hv000 dhs_clust dhs_hh dhs_line hv005 hv007 hv024 hv025 hv102 ///
	hv104 hv105 hv108 hv109 hv111 hv113

sort dhs_clust dhs_hh dhs_line
append using output/Original_AllYears
replace country=11 if country==.
save output/Original_AllYears,replace

*Niger 2006
use input\Niger\2006_Fort_HIV\NIAR51FL.DTA,clear
rename hivclust dhs_clust
rename hivnumb dhs_hh
rename hivline dhs_line

keep dhs_clust dhs_hh dhs_line hiv03 hiv05
sort dhs_clust dhs_hh dhs_line

tempfile hold
save `hold',replace

use input\Niger\2006_Fort_HIV\NIPR51FL.DTA,clear
rename hv001 dhs_clust
rename hv002 dhs_hh
rename hvidx dhs_line

	*Child Labor
	gen nfam_work=sh20ad if hv105>=5 & hv105<=15 & sh20ad!=9
	recode nfam_work (3=0) (1=2) (2=1)
	
	gen fam_work=sh20ah if hv105>=5 & hv105<=15 & sh20ah!=9

keep hv000 dhs_clust dhs_hh dhs_line hv005 hv007 hv024 hv025 hv102 ///
	hv104 hv105 hv108 hv109 hv111 hv113 nfam_work fam_work

sort dhs_clust dhs_hh dhs_line
merge 1:1 dhs_clust dhs_hh dhs_line using `hold'
drop _m*

append using output/Original_AllYears
replace country=11 if country==.
replace fortson=1 if country==11 & hv007==2006
save output/Original_AllYears,replace

*Niger 2012
use input\Niger\2012_HIV_DHS\niar61fl,clear

replace hiv03=. if (hiv03==7) /*indeterminant*/

rename hivclust dhs_clust
rename hivnumb dhs_hh
rename hivline dhs_line

keep dhs_clust dhs_hh dhs_line hiv03 hiv05
sort dhs_clust dhs_hh dhs_line

tempfile hold
save `hold',replace

use input\Niger\2012_HIV_DHS\NIPR61FL.DTA,clear
rename hv001 dhs_clust
rename hv002 dhs_hh
rename hvidx dhs_line

	*Child Labor
	gen nfam_work=chl1 if hv105>=5 & hv105<=15 & chl1!=9
	recode nfam_work (1=2) (2=1)

	gen fam_work=chl5 if hv105>=5 & hv105<=15 & chl5!=9

keep hv000 dhs_clust dhs_hh dhs_line hv005 hv007 hv024 hv025 hv102 ///
	hv104 hv105 hv108 hv109 hv111 hv113 nfam_work fam_work

sort dhs_clust dhs_hh dhs_line
merge 1:1 dhs_clust dhs_hh dhs_line using `hold'
drop _m*

append using output/Original_AllYears
replace country=11 if country==.
save output/Original_AllYears,replace

********************************************************************************
*Rwanda 2005
use input\Rwanda\2005_Fort_HIV\rwar51fl.dta,clear
rename hivclust dhs_clust
rename hivnumb dhs_hh
rename hivline dhs_line

keep dhs_clust dhs_hh dhs_line hiv03 hiv05
sort dhs_clust dhs_hh dhs_line

tempfile hold
save `hold',replace

use input\Rwanda\2005_Fort_HIV\RWPR53FL.DTA,clear
rename hv001 dhs_clust
rename hv002 dhs_hh
rename hvidx dhs_line
drop hv024
rename shregnat hv024

keep hv000 dhs_clust dhs_hh dhs_line hv005 hv007 hv024 hv025 hv102 ///
	hv104 hv105 hv108 hv109 hv111 hv113

sort dhs_clust dhs_hh dhs_line
merge 1:1 dhs_clust dhs_hh dhs_line using `hold'
drop _m*

append using output/Original_AllYears
replace country=12 if country==.
replace fortson=1 if country==12 & hv007==2005
save output/Original_AllYears,replace

*Rwanda 2010
use input\Rwanda\2010_HIV_DHS\RWAR61FL.DTA,clear
rename hivclust dhs_clust
rename hivnumb dhs_hh
rename hivline dhs_line

keep dhs_clust dhs_hh dhs_line hiv03 hiv05
sort dhs_clust dhs_hh dhs_line

tempfile hold
save `hold',replace

use input\Rwanda\2010_HIV_DHS\RWPR61FL.DTA,clear
rename hv001 dhs_clust
rename hv002 dhs_hh
rename hvidx dhs_line

	*Child Labor
	gen nfam_work=sh29 if hv105>=5 & hv105<=15 & sh29!=9
	recode nfam_work (1=2) (2=1)

	gen fam_work=sh33 if hv105>=5 & hv105<=15 & sh33!=9

keep hv000 dhs_clust dhs_hh dhs_line hv005 hv007 hv024 hv025 hv102 ///
	hv104 hv105 hv108 hv109 hv111 hv113 nfam_work fam_work

sort dhs_clust dhs_hh dhs_line
merge 1:1 dhs_clust dhs_hh dhs_line using `hold'
drop _m*

append using output/Original_AllYears
replace country=12 if country==.
save output/Original_AllYears,replace

*Rwanda 2014
use input\Rwanda\2014_HIV_DHS\RWAR71FL.DTA,clear
rename hivclust dhs_clust
rename hivnumb dhs_hh
rename hivline dhs_line

keep dhs_clust dhs_hh dhs_line hiv03 hiv05
sort dhs_clust dhs_hh dhs_line

tempfile hold
save `hold',replace

use input\Rwanda\2014_HIV_DHS\RWPR70FL.DTA,clear
rename hv001 dhs_clust
rename hv002 dhs_hh
rename hvidx dhs_line

keep hv000 dhs_clust dhs_hh dhs_line hv005 hv007 hv024 hv025 hv102 ///
	hv104 hv105 hv108 hv109 hv111 hv113

sort dhs_clust dhs_hh dhs_line
merge 1:1 dhs_clust dhs_hh dhs_line using `hold'
drop _m*

append using output/Original_AllYears
replace country=12 if country==.
save output/Original_AllYears,replace

********************************************************************************
*Senegal 1992
use input\Senegal\1992_DHS\SNPR21FL.DTA,clear

rename hv001 dhs_clust
rename hv002 dhs_hh
rename hvidx dhs_line

keep hv000 dhs_clust dhs_hh dhs_line hv005 hv007 hv024 hv025 hv102 ///
	hv104 hv105 hv108 hv109 hv111 hv113

sort dhs_clust dhs_hh dhs_line
append using output/Original_AllYears
replace country=13 if country==.
save output/Original_AllYears,replace

*Senegal 1997/9
use input\Senegal\1997_DHS\SNPR32FL.DTA,clear

rename hv001 dhs_clust
rename hv002 dhs_hh
rename hvidx dhs_line

keep hv000 dhs_clust dhs_hh dhs_line hv005 hv007 hv024 hv025 hv102 ///
	hv104 hv105 hv108 hv109 hv111 hv113

sort dhs_clust dhs_hh dhs_line
append using output/Original_AllYears
replace country=13 if country==.
save output/Original_AllYears,replace

*Senegal 2005
use input\Senegal\2005_Fort_HIV\SNar4Afl.dta,clear
rename hivclust dhs_clust
rename hivstruct dhs_struct
rename hivnumb dhs_hh
rename hivline dhs_line

keep dhs_clust dhs_struct dhs_hh dhs_line hiv03 hiv05
sort dhs_clust dhs_struct dhs_hh dhs_line

tempfile hold
save `hold',replace

use input\Senegal\2005_Fort_HIV\SNPR4HFL.DTA,clear
rename hv001 dhs_clust
rename shconces dhs_struct
rename hv002 dhs_hh
rename hvidx dhs_line

	*Child Labor
	gen nfam_work=sh20g if hv105>=5 & hv105<=15 & sh20g!=9
	recode nfam_work (1=2) (2=1)

	gen fam_work=sh20k if hv105>=5 & hv105<=15 & sh20k!=9

keep hv000 dhs_clust dhs_struct dhs_hh dhs_line hv005 hv007 hv024 hv025 hv102 ///
	hv104 hv105 hv108 hv109 hv111 hv113 nfam_work fam_work

sort dhs_clust dhs_struct dhs_hh dhs_line
merge 1:1 dhs_clust dhs_struct dhs_hh dhs_line using `hold'
drop _m*

append using output/Original_AllYears
replace country=13 if country==.
replace fortson=1 if country==13 & hv007==2005
save output/Original_AllYears,replace

*Senegal 2010
use input\Senegal\2010_HIV_DHS\SNAR61FL.DTA,clear
rename hivclust dhs_clust
rename hivnumb dhs_hh
rename hivline dhs_line

keep dhs_clust dhs_hh dhs_line hiv03 hiv05
sort dhs_clust dhs_hh dhs_line

tempfile hold
save `hold',replace

use input\Senegal\2010_HIV_DHS\SNPR61FL.DTA,clear
rename hv001 dhs_clust
rename hv002 dhs_hh
rename hvidx dhs_line

	*Child Labor
	gen nfam_work=sh20g if hv105>=5 & hv105<=15 & sh20g!=9
	recode nfam_work (3=0) (1=2) (2=1)

	gen fam_work=sh20k if hv105>=5 & hv105<=15 & sh20k!=9

keep hv000 dhs_clust dhs_hh dhs_line hv005 hv007 hv024 hv025 hv102 ///
	hv104 hv105 hv108 hv109 hv111 hv113 nfam_work fam_work

sort dhs_clust dhs_hh dhs_line
merge 1:1 dhs_clust dhs_hh dhs_line using `hold'
drop _m*

append using output/Original_AllYears
replace country=13 if country==.
save output/Original_AllYears,replace

*Senegal 2017
use input\Senegal\2017_HIV_cDHS\SNAR7RFL.DTA,clear

replace hiv03=. if (hiv03==9) /*indeterminant*/

rename hivclust dhs_clust
rename hivnumb dhs_hh
rename hivline dhs_line

keep dhs_clust dhs_hh dhs_line hiv03 hiv05
sort dhs_clust dhs_hh dhs_line

tempfile hold
save `hold',replace

use input\Senegal\2017_HIV_cDHS\SNPR7ZFL.DTA,clear
rename hv001 dhs_clust
rename hv002 dhs_hh
rename hvidx dhs_line

keep hv000 dhs_clust dhs_hh dhs_line hv005 hv007 hv024 hv025 hv102 ///
	hv104 hv105 hv108 hv109 hv111 hv113

sort dhs_clust dhs_hh dhs_line
merge 1:1 dhs_clust dhs_hh dhs_line using `hold'
drop _m*

append using output/Original_AllYears
replace country=13 if country==.
save output/Original_AllYears,replace

********************************************************************************
*Tanzania 1991 
use input\Tanzania\1991_DHS\TZPR21FL.DTA,clear

rename hv001 dhs_clust
rename hv002 dhs_hh
rename hvidx dhs_line
drop hv024
rename shreg hv024

keep hv000 dhs_clust dhs_hh dhs_line hv005 hv007 hv024 hv025 hv102 ///
	hv104 hv105 hv108 hv109 hv111 hv113

sort dhs_clust dhs_hh dhs_line
append using output/Original_AllYears
replace country=14 if country==.
save output/Original_AllYears,replace

*Tanzania 1996
use input\Tanzania\1996_DHS\TZPR3AFL.DTA,clear 

rename hv001 dhs_clust
rename hv002 dhs_hh
rename hvidx dhs_line

keep hv000 dhs_clust dhs_hh dhs_line hv005 hv007 hv024 hv025 hv102 ///
	hv104 hv105 hv108 hv109 hv111 hv113

sort dhs_clust dhs_hh dhs_line
append using output/Original_AllYears
replace country=14 if country==.
save output/Original_AllYears,replace

*Tanzania 1999
use input\Tanzania\1999_DHS\TZPR41FL.DTA,clear 

rename hv001 dhs_clust
rename hv002 dhs_hh
rename hvidx dhs_line

keep hv000 dhs_clust dhs_hh dhs_line hv005 hv007 hv024 hv025 hv102 ///
	hv104 hv105 hv108 hv109 hv111 hv113

sort dhs_clust dhs_hh dhs_line
append using output/Original_AllYears
replace country=14 if country==.
save output/Original_AllYears,replace

*Tanzania 2003
use input\Tanzania\2003_Fort_HIV\TZar4Afl.dta,clear
rename hivclust dhs_clust
rename hivnumb dhs_hh
rename hivline dhs_line

keep dhs_clust dhs_hh dhs_line hiv03 hiv05
sort dhs_clust dhs_hh dhs_line

tempfile hold
save `hold',replace

use input\Tanzania\2003_Fort_HIV\tzpr4afl.dta,clear
rename hv001 dhs_clust
rename hv002 dhs_hh
rename hvidx dhs_line

keep hv000 dhs_clust dhs_hh dhs_line hv005 hv007 hv024 hv025 hv102 ///
	hv104 hv105 hv108 hv109 hv111 hv113

sort dhs_clust dhs_hh dhs_line
merge 1:1 dhs_clust dhs_hh dhs_line using `hold'
drop _m*

append using output/Original_AllYears
replace country=14 if country==.
replace fortson=1 if country==14 & hv007==2003
save output/Original_AllYears,replace

*Tanzania 2007
use input\Tanzania\2007_HIV\TZAR51FL.DTA,clear
rename hivclust dhs_clust
rename hivnumb dhs_hh
rename hivline dhs_line

keep dhs_clust dhs_hh dhs_line hiv03 hiv05
sort dhs_clust dhs_hh dhs_line

tempfile hold
save `hold',replace

use input\Tanzania\2007_HIV\TZPR51FL.DTA,clear
rename hv001 dhs_clust
rename hv002 dhs_hh
rename hvidx dhs_line

keep hv000 dhs_clust dhs_hh dhs_line hv005 hv007 hv024 hv025 hv102 ///
	hv104 hv105 hv108 hv109 hv111 hv113

sort dhs_clust dhs_hh dhs_line
merge 1:1 dhs_clust dhs_hh dhs_line using `hold'
drop _m*

append using output/Original_AllYears
replace country=14 if country==.
save output/Original_AllYears,replace

*Tanzania 2011
use input\Tanzania\2011_HIV\TZAR6AFL.DTA,clear
rename hivclust dhs_clust
rename hivnumb dhs_hh
rename hivline dhs_line

keep dhs_clust dhs_hh dhs_line hiv03 hiv05
sort dhs_clust dhs_hh dhs_line

tempfile hold
save `hold',replace

use input\Tanzania\2011_HIV\TZPR6AFL.DTA,clear
rename hv001 dhs_clust
rename hv002 dhs_hh
rename hvidx dhs_line

keep hv000 dhs_clust dhs_hh dhs_line hv005 hv007 hv024 hv025 hv102 ///
	hv104 hv105 hv108 hv109 hv111 hv113

sort dhs_clust dhs_hh dhs_line
merge 1:1 dhs_clust dhs_hh dhs_line using `hold'
drop _m*

append using output/Original_AllYears
replace country=14 if country==.
save output/Original_AllYears,replace

********************************************************************************
*Zambia 1992
use input\Zambia\1992\ZMPR21FL.DTA,clear

rename hv001 dhs_clust
rename hv002 dhs_hh
rename hvidx dhs_line

keep hv000 dhs_clust dhs_hh dhs_line hv005 hv007 hv024 hv025 hv102 ///
	hv104 hv105 hv108 hv109 hv111 hv113

sort dhs_clust dhs_hh dhs_line
append using output/Original_AllYears
replace country=15 if country==.
save output/Original_AllYears,replace


*Zambia 1996
use input\Zambia\1996\ZMPR31FL.DTA,clear
rename hv001 dhs_clust
rename hv002 dhs_hh
rename hvidx dhs_line

keep hv000 dhs_clust dhs_hh dhs_line hv005 hv007 hv024 hv025 hv102 ///
	hv104 hv105 hv108 hv109 hv111 hv113

sort dhs_clust dhs_hh dhs_line
append using output/Original_AllYears
replace country=15 if country==.
save output/Original_AllYears,replace

*Zambia 2001
use input\Zambia\2001_Fort_HIV\ZMPR43FL.DTA,clear

rename hv001 dhs_clust
rename hv002 dhs_hh
rename hvidx dhs_line

keep hv000 dhs_clust dhs_hh dhs_line hv005 hv007 hv024 hv025 hv102 ///
	hv104 hv105 hv108 hv109 hv111 hv113

sort dhs_clust dhs_hh dhs_line
append using output/Original_AllYears
replace country=15 if country==.
save output/Original_AllYears,replace

*Zambia - Region Link Only 2001
use input\Zambia\2001_Fort_HIV\ZMHT41FL.DTA,clear
gen hiv03=hivfinal==1 if hivfinal!=.
rename hiv_wgt hiv05
rename hivprov hv024
rename hivage hv105
gen hv007=2001

keep hiv03 hiv05 hv024 hv105 hv007
sort hv024

tempfile hold
save `hold',replace

use input\Zambia\2001_Fort_HIV\ZMPR43FL.DTA,clear
rename hv001 dhs_clust
rename hv002 dhs_hh
rename hvidx dhs_line

keep hv000 dhs_clust dhs_hh dhs_line hv005 hv007 hv024 hv025 hv102 ///
	hv104 hv105 hv108 hv109 hv111 hv113

sort dhs_clust dhs_hh dhs_line
append using `hold'

append using output/Original_AllYears
replace country=15 if country==.
replace fortson=1 if country==15 & hv007==2001
save output/Original_AllYears,replace

*Zambia 2007
use input\Zambia\2007_HIV_DHS\ZMAR51FL.DTA,clear

replace hiv03=. if (hiv03==7) /*indeterminant*/

rename hivclust dhs_clust
rename hivnumb dhs_hh
rename hivline dhs_line

keep dhs_clust dhs_hh dhs_line hiv03 hiv05
sort dhs_clust dhs_hh dhs_line

tempfile hold
save `hold',replace

use input\Zambia\2007_HIV_DHS\ZMPR51FL.DTA,clear
rename hv001 dhs_clust
rename hv002 dhs_hh
rename hvidx dhs_line

keep hv000 dhs_clust dhs_hh dhs_line hv005 hv007 hv024 hv025 hv102 ///
	hv104 hv105 hv108 hv109 hv111 hv113

sort dhs_clust dhs_hh dhs_line
merge 1:1 dhs_clust dhs_hh dhs_line using `hold'
drop _m*

append using output/Original_AllYears
replace country=15 if country==.
save output/Original_AllYears,replace

*Zambia 2013
use input\Zambia\2013_HIV_DHS\ZMAR63FL.DTA,clear

rename hivclust dhs_clust
rename hivnumb dhs_hh
rename hivline dhs_line

keep dhs_clust dhs_hh dhs_line hiv03 hiv05
sort dhs_clust dhs_hh dhs_line

tempfile hold
save `hold',replace

use input\Zambia\2013_HIV_DHS\ZMPR61FL.DTA,clear
rename hv001 dhs_clust
rename hv002 dhs_hh
rename hvidx dhs_line

keep hv000 dhs_clust dhs_hh dhs_line hv005 hv007 hv024 hv025 hv102 ///
	hv104 hv105 hv108 hv109 hv111 hv113

sort dhs_clust dhs_hh dhs_line
merge 1:1 dhs_clust dhs_hh dhs_line using `hold'
drop _m*

append using output/Original_AllYears
replace country=15 if country==.
save output/Original_AllYears,replace

lab define country_l 1 "Burkina Faso"
lab define country_l 2 "Cameroon",add
lab define country_l 3 "Cote d'Ivoire",add
lab define country_l 4 "Ethiopia",add
lab define country_l 5 "Ghana",add
lab define country_l 6 "Guinea",add
lab define country_l 7 "Kenya",add
lab define country_l 8 "Lesotho",add
lab define country_l 9 "Malawi",add
lab define country_l 10 "Mali",add
lab define country_l 11 "Niger",add
lab define country_l 12 "Rwanda",add
lab define country_l 13 "Senegal",add
lab define country_l 14 "Tanzania",add
lab define country_l 15 "Zambia",add
lab val country country_l

order dhs_struct,after(dhs_clust)
order dhs_line,after(dhs_hh)
order country,before(hv000)
lab var country "Name of Country"

*Combine All Test Results to 0/1
replace hiv03=. if (hiv03==7) /*indeterminant*/
recode hiv03 (2=1) (3=1)
lab var hiv03 "HIV Test Result; 0=Negative"

gen exp_fortson=1 if hv007>=2001
replace exp_fortson=1 if country==4 & hv007==1997
replace exp_fortson=. if country==5 & hv007==2008
replace exp_fortson=. if country==7 & hv007==2015

gen drop_annual=1 if country==12
save output/Original_AllYears,replace
