
clear

cd /*Add Replication Folder Location Here/replication_cls/data_files*/

**** New Countries
*Angola

use input/Angola_2015/AOAR71FL.DTA,clear

replace hiv03=. if (hiv03==7 | hiv03==9)

rename hivclust dhs_clust
rename hivnumb dhs_hh
rename hivline dhs_line

keep dhs_clust dhs_hh dhs_line hiv03 hiv05
sort dhs_clust dhs_hh dhs_line

tempfile hold
save `hold',replace

use input\Angola_2015\AOPR71FL.DTA,clear
rename hv001 dhs_clust
rename hv002 dhs_hh
rename hvidx dhs_line

keep hv000 dhs_clust dhs_hh dhs_line hv005 hv007 hv024 hv025 hv102 ///
	hv104 hv105 hv108 hv109 hv111 hv113

sort dhs_clust dhs_hh dhs_line
merge 1:1 dhs_clust dhs_hh dhs_line using `hold'
drop _m*

gen country=16
replace country=16 if country==.
save output/NewCountries_Post2000,replace

********************************************************************************
*Burundi 2010

use input\Burundi\2010_HIV_DHS\BUAR61FL.DTA,clear

replace hiv03=. if hiv03==7

rename hivclust dhs_clust
rename hivnumb dhs_hh
rename hivline dhs_line

keep dhs_clust dhs_hh dhs_line hiv03 hiv05
sort dhs_clust dhs_hh dhs_line

tempfile hold
save `hold',replace

use input\Burundi\2010_HIV_DHS\BUPR61FL,clear
rename hv001 dhs_clust
rename hv002 dhs_hh
rename hvidx dhs_line

	*Child Labor
	gen nfam_work=sh21 if hv105>=5 & hv105<=15 & sh21!=9
	recode nfam_work (2=1) (1=2)

	gen fam_work=sh25 if hv105>=5 & hv105<=15 & sh25!=9

keep hv000 dhs_clust dhs_hh dhs_line hv005 hv007 hv024 hv025 hv102 ///
	hv104 hv105 hv108 hv109 hv111 hv113 nfam_work fam_work

sort dhs_clust dhs_hh dhs_line
merge 1:1 dhs_clust dhs_hh dhs_line using `hold'
drop _m*

gen country=17
append using output/NewCountries_Post2000
replace country=17 if country==.
save output/NewCountries_Post2000,replace

*Burundi 2016

use input\Burundi\2016_HIV_DHS\BUAR71FL.DTA,clear

replace hiv03=. if hiv03==9

rename hivclust dhs_clust
rename hivnumb dhs_hh
rename hivline dhs_line

keep dhs_clust dhs_hh dhs_line hiv03 hiv05
sort dhs_clust dhs_hh dhs_line

tempfile hold
save `hold',replace

use input\Burundi\2016_HIV_DHS\BUPR70FL.DTA,clear
rename hv001 dhs_clust
rename hv002 dhs_hh
rename hvidx dhs_line

keep hv000 dhs_clust dhs_hh dhs_line hv005 hv007 hv024 hv025 hv102 ///
	hv104 hv105 hv108 hv109 hv111 hv113

sort dhs_clust dhs_hh dhs_line
merge 1:1 dhs_clust dhs_hh dhs_line using `hold'
drop _m*

append using output/NewCountries_Post2000
replace country=17 if country==.
save output/NewCountries_Post2000,replace

**********************************************************************************
*Chad 2014

use input\Chad\2014_HIV_DHS\TDAR71FL.DTA,clear
rename hivclust dhs_clust
rename hivnumb dhs_hh
rename hivline dhs_line

keep dhs_clust dhs_hh dhs_line hiv03 hiv05
sort dhs_clust dhs_hh dhs_line

tempfile hold
save `hold',replace

use input\Chad\2014_HIV_DHS\TDPR71FL.DTA,clear
rename hv001 dhs_clust
rename hv002 dhs_hh
rename hvidx dhs_line

keep hv000 dhs_clust dhs_hh dhs_line hv005 hv007 hv024 hv025 hv102 ///
	hv104 hv105 hv108 hv109 hv111 hv113

sort dhs_clust dhs_hh dhs_line
merge 1:1 dhs_clust dhs_hh dhs_line using `hold'
drop _m*

gen country=18 
append using output/NewCountries_Post2000
replace country=18 if country==.
save output/NewCountries_Post2000,replace

********************************************************************************
*Congo (Rep. of) 2009

use input\Congo\2009_AIS\CGar5Hfl.dta, clear

replace hiv03=. if hiv03==8

rename hivclust dhs_clust
rename hivnumb dhs_hh
rename hivline dhs_line

keep dhs_clust dhs_hh dhs_line hiv03 hiv05
sort dhs_clust dhs_hh dhs_line

tempfile hold
save `hold',replace

use input\Congo\2009_AIS\CGPR5HFL.DTA,clear
rename hv001 dhs_clust
rename hv002 dhs_hh
rename hvidx dhs_line

keep hv000 dhs_clust dhs_hh dhs_line hv005 hv007 hv024 hv025 hv102 ///
	hv104 hv105 hv108 hv109 hv111 hv113

sort dhs_clust dhs_hh dhs_line
merge 1:1 dhs_clust dhs_hh dhs_line using `hold'
drop _m*

gen country=19
append using output/NewCountries_Post2000
replace country=19 if country==.
save output/NewCountries_Post2000,replace

*******************************************************************************
*DRC 2007

use input\DRC\2007_HIV_DHS\CDar50fl.dta,clear

replace hiv03=. if hiv03==8 

rename hivclust dhs_clust
rename hivnumb dhs_hh
rename hivline dhs_line

keep dhs_clust dhs_hh dhs_line hiv03 hiv05
sort dhs_clust dhs_hh dhs_line

tempfile hold
save `hold',replace

use input\DRC\2007_HIV_DHS\CDPR50FL.DTA,clear
rename hv001 dhs_clust
rename hv002 dhs_hh
rename hvidx dhs_line

	*Child Labor
	gen nfam_work=sh204 if hv105>=5 & hv105<=15 & sh204!=9
	recode nfam_work (2=1) (1=2)

	gen fam_work=sh209 if hv105>=5 & hv105<=15 & sh209!=9

keep hv000 dhs_clust dhs_hh dhs_line hv005 hv007 hv024 hv025 hv102 ///
	hv104 hv105 hv108 hv109 hv111 hv113 nfam_work fam_work

sort dhs_clust dhs_hh dhs_line
merge 1:1 dhs_clust dhs_hh dhs_line using `hold'
drop _m*

gen country=20
append using output/NewCountries_Post2000
replace country=20 if country==.
save output/NewCountries_Post2000,replace

*DRC 2013

use input\DRC\2013_HIV_DHS\CDAR61FL.DTA,clear
rename hivclust dhs_clust
rename hivnumb dhs_hh
rename hivline dhs_line

keep dhs_clust dhs_hh dhs_line hiv03 hiv05
sort dhs_clust dhs_hh dhs_line

tempfile hold
save `hold',replace

use input\DRC\2013_HIV_DHS\CDPR61FL.DTA,clear
rename hv001 dhs_clust
rename hv002 dhs_hh
rename hvidx dhs_line

keep hv000 dhs_clust dhs_hh dhs_line hv005 hv007 hv024 hv025 hv102 ///
	hv104 hv105 hv108 hv109 hv111 hv113

sort dhs_clust dhs_hh dhs_line
merge 1:1 dhs_clust dhs_hh dhs_line using `hold'
drop _m*

append using output/NewCountries_Post2000
replace country=20 if country==.
save output/NewCountries_Post2000,replace

********************************************************************************
*Gabon 2012

use input\Gabon\2012_HIV_DHS\gaAR60FL.DTA, clear

replace hiv03=. if hiv03==7

rename hivclust dhs_clust
rename hivnumb dhs_hh
rename hivline dhs_line

keep dhs_clust dhs_hh dhs_line hiv03 hiv05
sort dhs_clust dhs_hh dhs_line

tempfile hold
save `hold',replace

use input\Gabon\2012_HIV_DHS\GAPR60FL.DTA,clear
rename hv001 dhs_clust
rename hv002 dhs_hh
rename hvidx dhs_line

	*Child Labor
	gen nfam_work=sh144 if hv105>=5 & hv105<=15 & sh144!=9
	recode nfam_work (3=0) (2=1) (1=2)

	gen fam_work=sh149 if hv105>=5 & hv105<=15 & sh149!=9

keep hv000 dhs_clust dhs_hh dhs_line hv005 hv007 hv024 hv025 hv102 ///
	hv104 hv105 hv108 hv109 hv111 hv113 nfam_work fam_work

sort dhs_clust dhs_hh dhs_line
merge 1:1 dhs_clust dhs_hh dhs_line using `hold'
drop _m*

gen country=21
append using output/NewCountries_Post2000
replace country=21 if country==.
save output/NewCountries_Post2000,replace

********************************************************************************
*Gambia 2013

use input\Gambia_2013\GMAR60FL.DTA, clear
rename hivclust dhs_clust
rename hivnumb dhs_hh
rename hivline dhs_line

keep dhs_clust dhs_hh dhs_line hiv03 hiv05
sort dhs_clust dhs_hh dhs_line

tempfile hold
save `hold',replace

use input\Gambia_2013\GMPR60FL.DTA,clear
rename hv001 dhs_clust
rename hv002 dhs_hh
rename hvidx dhs_line

keep hv000 dhs_clust dhs_hh dhs_line hv005 hv007 hv024 hv025 hv102 ///
	hv104 hv105 hv108 hv109 hv111 hv113

sort dhs_clust dhs_hh dhs_line
merge 1:1 dhs_clust dhs_hh dhs_line using `hold'
drop _m*

gen country=22
append using output/NewCountries_Post2000
replace country=22 if country==.
save output/NewCountries_Post2000,replace

********************************************************************************
*Liberia 2007

use input\Liberia\2007_HIV_DHS\lbar51fl.dta, clear

replace hiv03=. if hiv03==7

rename hivclust dhs_clust
rename hivnumb dhs_hh
rename hivline dhs_line

keep dhs_clust dhs_hh dhs_line hiv03 hiv05
sort dhs_clust dhs_hh dhs_line

tempfile hold
save `hold',replace

use input\Liberia\2007_HIV_DHS\LBPR51FL.dta,clear
rename hv001 dhs_clust
rename hv002 dhs_hh
rename hvidx dhs_line

	*Child Labor
	gen nfam_work=sh206 if hv105>=5 & hv105<=15 & sh206!=9
	recode nfam_work (3=0) (2=1) (1=2)

	gen fam_work=sh211 if hv105>=5 & hv105<=15 & sh211!=9

keep hv000 dhs_clust dhs_hh dhs_line hv005 hv007 hv024 hv025 hv102 ///
	hv104 hv105 hv108 hv109 hv111 hv113 nfam_work fam_work

sort dhs_clust dhs_hh dhs_line
merge 1:1 dhs_clust dhs_hh dhs_line using `hold'
drop _m*

gen country=23
append using output/NewCountries_Post2000
replace country=23 if country==.
save output/NewCountries_Post2000,replace

*Liberia 2013

use input\Liberia\2013_HIV_DHS\LBAR6AFL.DTA, clear

replace hiv03=. if hiv03==7

rename hivclust dhs_clust
rename hivnumb dhs_hh
rename hivline dhs_line

keep dhs_clust dhs_hh dhs_line hiv03 hiv05
sort dhs_clust dhs_hh dhs_line

tempfile hold
save `hold',replace

use input\Liberia\2013_HIV_DHS\LBPR6AFL.DTA,clear
rename hv001 dhs_clust
rename hv002 dhs_hh
rename hvidx dhs_line

keep hv000 dhs_clust dhs_hh dhs_line hv005 hv007 hv024 hv025 hv102 ///
	hv104 hv105 hv108 hv109 hv111 hv113

sort dhs_clust dhs_hh dhs_line
merge 1:1 dhs_clust dhs_hh dhs_line using `hold'
drop _m*

append using output/NewCountries_Post2000
replace country=23 if country==.
save output/NewCountries_Post2000,replace

********************************************************************************
*Mozambique 2009

use input\Mozambique\2009_HIV\MZar51fl.dta, clear
rename hivclust dhs_clust
rename hivnumb dhs_hh
rename hivline dhs_line

keep dhs_clust dhs_hh dhs_line hiv03 hiv05
sort dhs_clust dhs_hh dhs_line

tempfile hold
save `hold',replace

use input\Mozambique\2009_HIV\MZPR51FL.DTA,clear
rename hv001 dhs_clust
rename hv002 dhs_hh
rename hvidx dhs_line

keep hv000 dhs_clust dhs_hh dhs_line hv005 hv007 hv024 hv025 hv102 ///
	hv104 hv105 hv108 hv109 hv111 hv113

sort dhs_clust dhs_hh dhs_line
merge 1:1 dhs_clust dhs_hh dhs_line using `hold'
drop _m*

gen country=24
append using output/NewCountries_Post2000
replace country=24 if country==.
save output/NewCountries_Post2000,replace

*Mozambique 2015

use input\Mozambique\2015_HIV\MZAR72FL.DTA, clear

replace hiv03=. if (hiv03==7 | hiv03==9)

rename hivclust dhs_clust
rename hivnumb dhs_hh
rename hivline dhs_line

keep dhs_clust dhs_hh dhs_line hiv03 hiv05
sort dhs_clust dhs_hh dhs_line

tempfile hold
save `hold',replace

use input\Mozambique\2015_HIV\MZPR71FL.DTA,clear
rename hv001 dhs_clust
rename hv002 dhs_hh
rename hvidx dhs_line

keep hv000 dhs_clust dhs_hh dhs_line hv005 hv007 hv024 hv025 hv102 ///
	hv104 hv105 hv108 hv109 hv111 hv113

sort dhs_clust dhs_hh dhs_line
merge 1:1 dhs_clust dhs_hh dhs_line using `hold'
drop _m*

gen country=24
append using output/NewCountries_Post2000
replace country=24 if country==.
save output/NewCountries_Post2000,replace

********************************************************************************
*Namibia 2013

use input\Namibia\2013_HIV_DHS\NMAR61FL.dta, clear
rename hivclust dhs_clust
rename hivnumb dhs_hh
rename hivline dhs_line

keep dhs_clust dhs_hh dhs_line hiv03 hiv05
sort dhs_clust dhs_hh dhs_line

tempfile hold
save `hold',replace

use input\Namibia\2013_HIV_DHS\NMPR61FL.DTA,clear
rename hv001 dhs_clust
rename hv002 dhs_hh
rename hvidx dhs_line

keep hv000 dhs_clust dhs_hh dhs_line hv005 hv007 hv024 hv025 hv102 ///
	hv104 hv105 hv108 hv109 hv111 hv113

sort dhs_clust dhs_hh dhs_line
merge 1:1 dhs_clust dhs_hh dhs_line using `hold'
drop _m*

gen country=25
append using output/NewCountries_Post2000
replace country=25 if country==.
save output/NewCountries_Post2000,replace

********************************************************************************
*Sierra Leone 2008

use input\Sierra_Leone\2008_HIV_DHS\SLAR51FL.DTA, clear
rename hivclust dhs_clust
rename hivnumb dhs_hh
rename hivline dhs_line

keep dhs_clust dhs_hh dhs_line hiv03 hiv05
sort dhs_clust dhs_hh dhs_line

tempfile hold
save `hold',replace

use input\Sierra_Leone\2008_HIV_DHS\SLPR51FL.DTA,clear
rename hv001 dhs_clust
rename hv002 dhs_hh
rename hvidx dhs_line

	*Child Labor
	gen nfam_work=sh203 if hv105>=5 & hv105<=15 & sh203!=9
	recode nfam_work (3=0) (1=2) (2=1)

	gen fam_work=sh208 if hv105>=5 & hv105<=15 & sh208!=9

keep hv000 dhs_clust dhs_hh dhs_line hv005 hv007 hv024 hv025 hv102 ///
	hv104 hv105 hv108 hv109 hv111 hv113 nfam_work fam_work

sort dhs_clust dhs_hh dhs_line
merge 1:1 dhs_clust dhs_hh dhs_line using `hold'
drop _m*

gen country=26
append using output/NewCountries_Post2000
replace country=26 if country==.
save output/NewCountries_Post2000,replace

*Sierra Leone 2013

use input\Sierra_Leone\2013_HIV_DHS\SLAR61FL.dta, clear
rename hivclust dhs_clust
rename hivnumb dhs_hh
rename hivline dhs_line

keep dhs_clust dhs_hh dhs_line hiv03 hiv05
sort dhs_clust dhs_hh dhs_line

tempfile hold
save `hold',replace

use input\Sierra_Leone\2013_HIV_DHS\SLPR61FL.DTA,clear
rename hv001 dhs_clust
rename hv002 dhs_hh
rename hvidx dhs_line

	*Child Labor
	gen nfam_work=chl1 if hv105>=5 & hv105<=15 & chl1!=9
	recode nfam_work (1=2) (2=1)

	gen fam_work=chl5 if hv105>=5 & hv105<=15 & chl5!=9

keep hv000 dhs_clust dhs_hh dhs_line hv005 hv007 hv024 hv025 hv102 ///
	hv104 hv105 hv108 hv109 hv111 hv113 nfam_work fam_work

sort dhs_clust dhs_hh dhs_line
merge 1:1 dhs_clust dhs_hh dhs_line using `hold'
drop _m*

append using output/NewCountries_Post2000
replace country=26 if country==.
save output/NewCountries_Post2000,replace 

********************************************************************************
*South Africa 2016

use input\South_Africa\2016_HIV_DHS\ZAAR71FL.DTA, clear

replace hiv03=. if hiv03==9

rename hivclust dhs_clust
rename hivnumb dhs_hh
rename hivline dhs_line

keep dhs_clust dhs_hh dhs_line hiv03 hiv05
sort dhs_clust dhs_hh dhs_line

tempfile hold
save `hold',replace

use input\South_Africa\2016_HIV_DHS\ZAPR71FL.DTA,clear
rename hv001 dhs_clust
rename hv002 dhs_hh
rename hvidx dhs_line

keep hv000 dhs_clust dhs_hh dhs_line hv005 hv007 hv024 hv025 hv102 ///
	hv104 hv105 hv108 hv109 hv111 hv113

sort dhs_clust dhs_hh dhs_line
merge 1:1 dhs_clust dhs_hh dhs_line using `hold'
drop _m*

gen country=27
append using output/NewCountries_Post2000
replace country=27 if country==.
save output/NewCountries_Post2000,replace

********************************************************************************
*Togo 2013

use input\Togo\2013_HIV_DHS\TGAR61FL.DTA, clear
rename hivclust dhs_clust
rename hivnumb dhs_hh
rename hivline dhs_line

keep dhs_clust dhs_hh dhs_line hiv03 hiv05
sort dhs_clust dhs_hh dhs_line

tempfile hold
save `hold',replace

use input\Togo\2013_HIV_DHS\TGPR61FL.DTA,clear
rename hv001 dhs_clust
rename hv002 dhs_hh
rename hvidx dhs_line

keep hv000 dhs_clust dhs_hh dhs_line hv005 hv007 hv024 hv025 hv102 ///
	hv104 hv105 hv108 hv109 hv111 hv113

sort dhs_clust dhs_hh dhs_line
merge 1:1 dhs_clust dhs_hh dhs_line using `hold'
drop _m*

gen country=28
append using output/NewCountries_Post2000
replace country=28 if country==.
save output/NewCountries_Post2000,replace

********************************************************************************
*Uganda 2011

use input\Uganda\2011_HIV\UGAR6AFL.DTA, clear

replace hiv03=. if hiv03==7

rename hivclust dhs_clust
rename hivnumb dhs_hh
rename hivline dhs_line

keep dhs_clust dhs_hh dhs_line hiv03 hiv05
sort dhs_clust dhs_hh dhs_line

tempfile hold
save `hold',replace

use input\Uganda\2011_HIV\UGPR6AFL.DTA,clear
rename hv001 dhs_clust
rename hv002 dhs_hh
rename hvidx dhs_line

keep hv000 dhs_clust dhs_hh dhs_line hv005 hv007 hv024 hv025 hv102 ///
	hv104 hv105 hv108 hv109 hv111 hv113

sort dhs_clust dhs_hh dhs_line
merge 1:1 dhs_clust dhs_hh dhs_line using `hold'
drop _m*

gen country=29
append using output/NewCountries_Post2000
replace country=29 if country==.
save output/NewCountries_Post2000,replace

********************************************************************************
*Zimbabwe 2005

use input\Zimbabwe\2005_HIV_DHS\ZWar51fl.dta, clear
rename hivclust dhs_clust
rename hivnumb dhs_hh
rename hivline dhs_line

keep dhs_clust dhs_hh dhs_line hiv03 hiv05
sort dhs_clust dhs_hh dhs_line

tempfile hold
save `hold',replace

use input\Zimbabwe\2005_HIV_DHS\ZWPR52FL.DTA,clear
rename hv001 dhs_clust
rename hv002 dhs_hh
rename hvidx dhs_line

keep hv000 dhs_clust dhs_hh dhs_line hv005 hv007 hv024 hv025 hv102 ///
	hv104 hv105 hv108 hv109 hv111 hv113

sort dhs_clust dhs_hh dhs_line
merge 1:1 dhs_clust dhs_hh dhs_line using `hold'
drop _m*

gen country=30
append using output/NewCountries_Post2000
replace country=30 if country==.
save output/NewCountries_Post2000,replace

*Zimbabwe 2010

use input\Zimbabwe\2010_HIV_DHS\ZWAR61FL.DTA, clear
rename hivclust dhs_clust
rename hivnumb dhs_hh
rename hivline dhs_line

keep dhs_clust dhs_hh dhs_line hiv03 hiv05
sort dhs_clust dhs_hh dhs_line

tempfile hold
save `hold',replace

use input\Zimbabwe\2010_HIV_DHS\ZWPR62FL.DTA,clear
rename hv001 dhs_clust
rename hv002 dhs_hh
rename hvidx dhs_line

keep hv000 dhs_clust dhs_hh dhs_line hv005 hv007 hv024 hv025 hv102 ///
	hv104 hv105 hv108 hv109 hv111 hv113

sort dhs_clust dhs_hh dhs_line
merge 1:1 dhs_clust dhs_hh dhs_line using `hold'
drop _m*

append using output/NewCountries_Post2000
replace country=30 if country==.
save output/NewCountries_Post2000,replace 

*Zimbabwe 2015

use input\Zimbabwe\2015_HIV_DHS\ZWAR71FL.DTA, clear

replace hiv03=. if hiv03==7
replace hiv03=. if hiv03==8
replace hiv03=. if hiv03==9

rename hivclust dhs_clust
rename hivnumb dhs_hh
rename hivline dhs_line

keep dhs_clust dhs_hh dhs_line hiv03 hiv05
sort dhs_clust dhs_hh dhs_line

tempfile hold
save `hold',replace

use input\Zimbabwe\2015_HIV_DHS\ZWPR71FL.DTA,clear
rename hv001 dhs_clust
rename hv002 dhs_hh
rename hvidx dhs_line

keep hv000 dhs_clust dhs_hh dhs_line hv005 hv007 hv024 hv025 hv102 ///
	hv104 hv105 hv108 hv109 hv111 hv113

sort dhs_clust dhs_hh dhs_line
merge 1:1 dhs_clust dhs_hh dhs_line using `hold'
drop _m*

append using output/NewCountries_Post2000
replace country=30 if country==.
save output/NewCountries_Post2000,replace 

lab define country_l 16 "Angola"
lab define country_l 17 "Burundi",add
lab define country_l 18 "Chad",add
lab define country_l 19 "Congo",add
lab define country_1 20 "DRC",add
lab define country_1 21 "Gabon",add
lab define country_1 22 "Gambia",add
lab define country_1 23 "Liberia",add
lab define country_1 24 "Mozambique",add
lab define country_1 25 "Namibia",add
lab define country_1 26 "Sierra_Leone",add
lab define country_1 27 "South_Africa",add
lab define country_1 28 "Togo",add
lab define country_1 29 "Uganda",add
lab define country_1 30 "Zimbabwe",add
lab val country country_l

*order dhs_struct,after(dhs_clust)*
order dhs_line,after(dhs_hh)
order country,before(hv000)
lab var country "Name of Country"

*Combine All Test Results to 0/1
replace hiv03=. if (hiv03==7) /*indeterminant*/
recode hiv03 (2=1) (3=1)
lab var hiv03 "HIV Test Result; 0=Negative"

save output/NewCountries_Post2000,replace

lab def country 16 "Angola"
lab def country 1 "BurkinaFaso", add
lab def country 17 "Burundi", add
lab def country 2 "Cameroon", add
lab def country 18 "Chad", add
lab def country 19 "Congo", add
lab def country 20 "DRC", add
lab def country 3 "CotedIvoire", add
lab def country 4 "Ethiopia", add
lab def country 21 "Gabon", add
lab def country 22 "Gambia", add
lab def country 5 "Ghana", add
lab def country 6 "Guinea", add
lab def country 7 "Kenya", add
lab def country 8 "Lesotho", add
lab def country 23 "Liberia", add
lab def country 9 "Malawi", add
lab def country 10 "Mali", add
lab def country 24 "Mozambique", add
lab def country 25 "Namibia", add
lab def country 11 "Niger", add
lab def country 12 "Rwanda", add
lab def country 13 "Senegal", add
lab def country 26 "Sierra Leone", add
lab def country 27 "South Africa", add
lab def country 14 "Tanzania", add
lab def country 28 "Togo", add
lab def country 29 "Uganda", add
lab def country 15 "Zambia", add
lab def country 30 "Zimbabwe", add

lab val country country

gen exp_fortson=1
append using output/Original_AllYears

keep if exp_fortson==1
save output/AllCountries_Post2000_Main,replace 
