
clear
set more off

cd "$file"

use data_files/output/Original_Replication,clear
*Remove Missing Region Variables
drop if hv024==.

*Scale Weights
replace hiv05=hiv05/1000000 if hiv05!=.
replace hv005=hv005/1000000 if hv005!=.

***Create Regional Measures
gen hiv_prime=hiv03 if hv105>=15 & hv105<=49
egen hiv_region=wtmean(hiv_prime), weight(hiv05) by(country hv024)
*Scale Variable to be Measured in Percentage Points
gen hiv_scaled=hiv_region*100

*Generate Variables for Analysis
*Birth Year
replace hv007=hv007+8 if country==4
replace hv105=. if hv105>97
gen by=hv007-hv105

*Region Code
gen region=country*100+hv024

*Adjust Sex
replace hv104=. if hv104==9

*Schooling
gen yrschl=hv108 if hv108<30
gen anyschool=yrschl>=1 if yrschl!=.
gen primary=hv109>=2 if hv109<=5

*Grades Behind
gen ybehind=.
replace ybehind=hv105-6-yrschl
replace ybehind=0 if ybehind==(-1)
replace ybehind=. if ybehind<(-1)

********************************************************************************
*Weight Adjustment with WDI population estimates
sum hv005 if country==1
gen double adj_wgt2=hv005*(12654621/r(sum)) if country==1

sum hv005 if country==2
replace adj_wgt2=hv005*(16959081/r(sum)) if country==2

sum hv005 if country==3
replace adj_wgt2=hv005*(18336303/r(sum)) if country==3

sum hv005 if country==4
replace adj_wgt2=hv005*(76727083/r(sum)) if country==4

sum hv005 if country==5
replace adj_wgt2=hv005*(20446782/r(sum)) if country==5

sum hv005 if country==6
replace adj_wgt2=hv005*(9679745/r(sum)) if country==6

sum hv005 if country==7
replace adj_wgt2=hv005*(34130852/r(sum)) if country==7

sum hv005 if country==8
replace adj_wgt2=hv005*(1933728/r(sum)) if country==8

sum hv005 if country==9
replace adj_wgt2=hv005*(12676038/r(sum)) if country==9

sum hv005 if country==10
replace adj_wgt2=hv005*(11293258/r(sum)) if country==10

sum hv005 if country==11
replace adj_wgt2=hv005*(14132064/r(sum)) if country==11

sum hv005 if country==12
replace adj_wgt2=hv005*(8991735/r(sum)) if country==12

sum hv005 if country==13
replace adj_wgt2=hv005*(11251266/r(sum)) if country==13

sum hv005 if country==14
replace adj_wgt=hv005*((37149072-981754)/r(sum)) if country==14

sum hv005 if country==15
replace adj_wgt2=hv005*(10824125/r(sum)) if country==15
