
clear
set more off

cd "$file"

use data_files\output\AllCountries_Post2000_Main,clear

replace hiv05=hiv05/1000000 if hiv05!=.
replace hv005=hv005/1000000 if hv005!=.

*Birth Year
replace hv105=. if hv105>97

replace hv007=hv007+8 if country==4
gen year=hv007

gen by=year-hv105

*Sex
replace hv104=. if hv104==9

*Age 
rename hv105 age
gen age2=age*age
gen age3=age*age*age

*Schooling
gen yrschl=hv108 if hv108<30
gen anyschool=yrschl>=1 if yrschl!=.
gen primary=hv109>=2 if hv109<=5

*Grades Behind
gen ybehind=.
replace ybehind=age-6-yrschl
replace ybehind=0 if ybehind==(-1)
replace ybehind=. if ybehind<(-1)

*Define Survey Wave
replace hv007=2011 if country==3 & hv007==2012
replace hv007=2008 if country==7 & hv007==2009
replace hv007=2004 if country==8 & hv007==2005
replace hv007=2009 if country==8 & hv007==2010
replace hv007=2004 if country==9 & hv007==2005
replace hv007=2015 if country==9 & hv007==2016
replace hv007=2012 if country==10 & hv007==2013
replace hv007=2010 if country==12 & hv007==2011
replace hv007=2014 if country==12 & hv007==2015
replace hv007=2010 if country==13 & hv007==2011
replace hv007=2003 if country==14 & hv007==2004
replace hv007=2007 if country==14 & hv007==2008
replace hv007=2011 if country==14 & hv007==2012
replace hv007=2001 if country==15 & hv007==2002
replace hv007=2013 if country==15 & hv007==2014
replace hv007=2015 if country==16 & hv007==2016
replace hv007=2010 if country==17 & hv007==2011
replace hv007=2016 if country==17 & hv007==2017
replace hv007=2014 if country==18 & hv007==2015
replace hv007=2013 if country==20 & hv007==2014
replace hv007=2007 if country==23 & hv007==2006
replace hv007=2013 if country==28 & hv007==2014
replace hv007=2005 if country==30 & hv007==2006
replace hv007=2010 if country==30 & hv007==2011

*Define Time Consistent Regions
gen region=country*100+hv024

gen temp_region=103 if region==101 & hv007==2003
replace temp_region=101 if region==102 & hv007==2003
replace temp_region=103 if region==103 & hv007==2003
replace temp_region=107 if region==104 & hv007==2003
replace temp_region=111 if region==105 & hv007==2003
replace temp_region=104 if region==106 & hv007==2003
replace temp_region=105 if region==107 & hv007==2003
replace temp_region=106 if region==108 & hv007==2003
replace temp_region=108 if region==109 & hv007==2003
replace temp_region=110 if region==110 & hv007==2003
replace temp_region=102 if region==111 & hv007==2003
replace temp_region=109 if region==112 & hv007==2003
replace temp_region=112 if region==113 & hv007==2003
replace temp_region=113 if region==114 & hv007==2003
replace region=temp_region if country==1 & hv007==2003
drop temp_region

gen temp_region=301 if region==301 & country==3 & hv007==2005
replace temp_region=302 if region==302 & country==3 & hv007==2005
replace temp_region=303 if region==303 & country==3 & hv007==2005
replace temp_region=304 if region==304 & country==3 & hv007==2005
replace temp_region=305 if region==305 & country==3 & hv007==2005
replace temp_region=306 if region==306 & country==3 & hv007==2005
replace temp_region=307 if region==307 & country==3 & hv007==2005
replace temp_region=308 if region==308 & country==3 & hv007==2005
replace temp_region=309 if region==309 & country==3 & hv007==2005
replace temp_region=310 if region==310 & country==3 & hv007==2005
replace temp_region=309 if region==311 & country==3 & hv007==2005
replace region=temp_region if country==3 & hv007==2005
drop temp_region

gen temp_region=301 if region==301 & country==3 & hv007==2011
replace temp_region=302 if region==302 & country==3 & hv007==2011
replace temp_region=303 if region==303 & country==3 & hv007==2011
replace temp_region=304 if region==304 & country==3 & hv007==2011
replace temp_region=305 if region==305 & country==3 & hv007==2011
replace temp_region=306 if region==306 & country==3 & hv007==2011
replace temp_region=307 if region==307 & country==3 & hv007==2011
replace temp_region=308 if region==308 & country==3 & hv007==2011
replace temp_region=309 if region==309 & country==3 & hv007==2011
replace temp_region=310 if region==310 & country==3 & hv007==2011
replace temp_region=309 if region==311 & country==3 & hv007==2011
replace region=temp_region if country==3 & hv007==2011
drop temp_region

gen temp_region=401 if region==401 & country==4 & hv007==2005 
replace temp_region=402 if region==402 & country==4 & hv007==2005
replace temp_region=403 if region==403 & country==4 & hv007==2005
replace temp_region=404 if region==404 & country==4 & hv007==2005
replace temp_region=405 if region==405 & country==4 & hv007==2005
replace temp_region=406 if region==406 & country==4 & hv007==2005
replace temp_region=407 if region==407 & country==4 & hv007==2005
replace temp_region=408 if region==412 & country==4 & hv007==2005
replace temp_region=409 if region==413 & country==4 & hv007==2005
replace temp_region=410 if region==414 & country==4 & hv007==2005
replace temp_region=411 if region==415 & country==4 & hv007==2005 
replace region=temp_region if country==4 & hv007==2005
drop temp_region

gen temp_region=401 if region==401 & country==4 & hv007==2011
replace temp_region=402 if region==402 & country==4 & hv007==2011
replace temp_region=403 if region==403 & country==4 & hv007==2011
replace temp_region=404 if region==404 & country==4 & hv007==2011
replace temp_region=405 if region==405 & country==4 & hv007==2011
replace temp_region=406 if region==406 & country==4 & hv007==2011
replace temp_region=407 if region==407 & country==4 & hv007==2011
replace temp_region=408 if region==412 & country==4 & hv007==2011
replace temp_region=409 if region==413 & country==4 & hv007==2011
replace temp_region=410 if region==414 & country==4 & hv007==2011
replace temp_region=411 if region==415 & country==4 & hv007==2011
replace region=temp_region if country==4 & hv007==2011
drop temp_region

gen temp_region=501 if region==501 & hv007==2003
replace temp_region=502 if region==502 & hv007==2003
replace temp_region=503 if region==503 & hv007==2003
replace temp_region=504 if region==504 & hv007==2003
replace temp_region=505 if region==505 & hv007==2003
replace temp_region=506 if region==506 & hv007==2003
replace temp_region=507 if region==507 & hv007==2003
replace temp_region=508 if region==508 & hv007==2003
replace temp_region=510 if region==509 & hv007==2003
replace temp_region=509 if region==510 & hv007==2003
replace region=temp_region if country==5 & hv007==2003
drop temp_region

gen temp_region=708 if region==701 & hv007==2003
replace temp_region=704 if region==702 & hv007==2003
replace temp_region=701 if region==703 & hv007==2003
replace temp_region=703 if region==704 & hv007==2003 
replace temp_region=707 if region==705 & hv007==2003
replace temp_region=705 if region==706 & hv007==2003 
replace temp_region=706 if region==707 & hv007==2003
replace temp_region=702 if region==708 & hv007==2003
replace region=temp_region if country==7 & hv007==2003
drop temp_region

gen temp_region=708 if region==701 & hv007==2008
replace temp_region=704 if region==702 & hv007==2008
replace temp_region=701 if region==703 & hv007==2008
replace temp_region=703 if region==704 & hv007==2008
replace temp_region=707 if region==705 & hv007==2008
replace temp_region=705 if region==706 & hv007==2008
replace temp_region=706 if region==707 & hv007==2008
replace temp_region=702 if region==708 & hv007==2008
replace region=temp_region if country==7 & hv007==2008
drop temp_region

gen temp_region=1301 if region==1301 & hv007==2005
replace temp_region=1302 if region==1302 & hv007==2005
replace temp_region=1302 if region==1303 & hv007==2005
replace temp_region=1302 if region==1304 & hv007==2005
replace temp_region=1304 if region==1305 & hv007==2005
replace temp_region=1302 if region==1306 & hv007==2005
replace temp_region=1303 if region==1307 & hv007==2005
replace temp_region=1303 if region==1308 & hv007==2005
replace temp_region=1303 if region==1309 & hv007==2005
replace temp_region=1301 if region==1310 & hv007==2005
replace temp_region=1304 if region==1311 & hv007==2005
replace region=temp_region if country==13  & hv007==2005
drop temp_region

gen temp_region=1301 if region==1301 & hv007==2010
replace temp_region=1304 if region==1302 & hv007==2010
replace temp_region=1302 if region==1303 & hv007==2010
replace temp_region=1303 if region==1304 & hv007==2010
replace temp_region=1303 if region==1305 & hv007==2010
replace temp_region=1302 if region==1306 & hv007==2010
replace temp_region=1301 if region==1307 & hv007==2010
replace temp_region=1302 if region==1308 & hv007==2010
replace temp_region=1302 if region==1309 & hv007==2010
replace temp_region=1304 if region==1310 & hv007==2010
replace temp_region=1303 if region==1311 & hv007==2010
replace temp_region=1302 if region==1312 & hv007==2010
replace temp_region=1303 if region==1313 & hv007==2010
replace temp_region=1304 if region==1314 & hv007==2010
replace region=temp_region if country==13  & hv007==2010
drop temp_region

gen temp_region=1301 if region==1301 & hv007==2017
replace temp_region=1304 if region==1302 & hv007==2017
replace temp_region=1302 if region==1303 & hv007==2017
replace temp_region=1303 if region==1304 & hv007==2017
replace temp_region=1303 if region==1305 & hv007==2017
replace temp_region=1302 if region==1306 & hv007==2017
replace temp_region=1301 if region==1307 & hv007==2017
replace temp_region=1302 if region==1308 & hv007==2017
replace temp_region=1302 if region==1309 & hv007==2017
replace temp_region=1304 if region==1310 & hv007==2017
replace temp_region=1303 if region==1311 & hv007==2017
replace temp_region=1302 if region==1312 & hv007==2017
replace temp_region=1303 if region==1313 & hv007==2017
replace temp_region=1304 if region==1314 & hv007==2017
replace region=temp_region if country==13  & hv007==2017
drop temp_region

gen temp_region=1401 if region==1401 & hv007==2003
replace temp_region=1402 if region==1402 & hv007==2003
replace temp_region=1403 if region==1403 & hv007==2003
replace temp_region=1404 if region==1404 & hv007==2003
replace temp_region=1405 if region==1405 & hv007==2003
replace temp_region=1406 if region==1406 & hv007==2003 
replace temp_region=1407 if region==1407 & hv007==2003 
replace temp_region=1408 if region==1408 & hv007==2003
replace temp_region=1409 if region==1409 & hv007==2003 
replace temp_region=1410 if region==1410 & hv007==2003
replace temp_region=1411 if region==1411 & hv007==2003
replace temp_region=1412 if region==1412 & hv007==2003 
replace temp_region=1413 if region==1413 & hv007==2003
replace temp_region=1414 if region==1414 & hv007==2003
replace temp_region=1415 if region==1415 & hv007==2003 
replace temp_region=1416 if region==1416 & hv007==2003 
replace temp_region=1419 if region==1417 & hv007==2003
replace temp_region=1419 if region==1418 & hv007==2003
replace temp_region=1419 if region==1419 & hv007==2003 
replace temp_region=1420 if region==1420 & hv007==2003 
replace temp_region=1421 if region==1421 & hv007==2003
replace region=temp_region if country==14  & hv007==2003
drop temp_region

gen temp_region=1401 if region==1401 & hv007==2007
replace temp_region=1402 if region==1402 & hv007==2007
replace temp_region=1403 if region==1403 & hv007==2007
replace temp_region=1404 if region==1404 & hv007==2007
replace temp_region=1405 if region==1405 & hv007==2007
replace temp_region=1406 if region==1406 & hv007==2007
replace temp_region=1407 if region==1407 & hv007==2007
replace temp_region=1408 if region==1408 & hv007==2007
replace temp_region=1409 if region==1409 & hv007==2007
replace temp_region=1410 if region==1410 & hv007==2007
replace temp_region=1411 if region==1411 & hv007==2007
replace temp_region=1412 if region==1412 & hv007==2007
replace temp_region=1413 if region==1413 & hv007==2007
replace temp_region=1414 if region==1414 & hv007==2007
replace temp_region=1415 if region==1415 & hv007==2007
replace temp_region=1416 if region==1416 & hv007==2007
replace temp_region=1419 if region==1417 & hv007==2007
replace temp_region=1419 if region==1418 & hv007==2007 
replace temp_region=1419 if region==1419 & hv007==2007 
replace temp_region=1420 if region==1420 & hv007==2007
replace temp_region=1421 if region==1421 & hv007==2007
replace temp_region=1450 if region==1451 & hv007==2007
replace temp_region=1450 if region==1452 & hv007==2007 
replace temp_region=1450 if region==1453 & hv007==2007
replace temp_region=1450 if region==1454 & hv007==2007 
replace temp_region=1450 if region==1455 & hv007==2007
replace region=temp_region if country==14 & hv007==2007
drop temp_region

gen temp_region=1401 if region==1401 & hv007==2011
replace temp_region=1402 if region==1402 & hv007==2011
replace temp_region=1403 if region==1403 & hv007==2011
replace temp_region=1404 if region==1404 & hv007==2011
replace temp_region=1405 if region==1405 & hv007==2011
replace temp_region=1406 if region==1406 & hv007==2011
replace temp_region=1407 if region==1407 & hv007==2011
replace temp_region=1408 if region==1408 & hv007==2011
replace temp_region=1409 if region==1409 & hv007==2011
replace temp_region=1410 if region==1410 & hv007==2011
replace temp_region=1411 if region==1411 & hv007==2011
replace temp_region=1412 if region==1412 & hv007==2011
replace temp_region=1413 if region==1413 & hv007==2011
replace temp_region=1414 if region==1414 & hv007==2011
replace temp_region=1415 if region==1415 & hv007==2011
replace temp_region=1416 if region==1416 & hv007==2011
replace temp_region=1419 if region==1417 & hv007==2011
replace temp_region=1419 if region==1418 & hv007==2011
replace temp_region=1419 if region==1419 & hv007==2011
replace temp_region=1420 if region==1420 & hv007==2011
replace temp_region=1421 if region==1421 & hv007==2011
replace temp_region=1411 if region==1422 & hv007==2011
replace temp_region=1415 if region==1423 & hv007==2011
replace temp_region=1419 if region==1424 & hv007==2011
replace temp_region=1419 if region==1425 & hv007==2011
replace temp_region=1450 if region==1451 & hv007==2011
replace temp_region=1450 if region==1452 & hv007==2011
replace temp_region=1450 if region==1453 & hv007==2011
replace temp_region=1450 if region==1454 & hv007==2011
replace temp_region=1450 if region==1455 & hv007==2011
replace region=temp_region if country==14 & hv007==2011
drop temp_region

gen temp_region=1501 if region==1501 & hv007==2001 
replace temp_region=1502 if region==1502 & hv007==2001
replace temp_region=1503 if region==1503 & hv007==2001
replace temp_region=1504 if region==1504 & hv007==2001
replace temp_region=1505 if region==1505 & hv007==2001
replace temp_region=1507 if region==1506 & hv007==2001
replace temp_region=1508 if region==1507 & hv007==2001
replace temp_region=1509 if region==1508 & hv007==2001
replace temp_region=1510 if region==1509 & hv007==2001
replace region=temp_region if country==15 & hv007==2001 
drop temp_region

gen temp_region=1501 if region==1501 & hv007==2007
replace temp_region=1502 if region==1502 & hv007==2007
replace temp_region=1503 if region==1503 & hv007==2007
replace temp_region=1504 if region==1504 & hv007==2007
replace temp_region=1505 if region==1505 & hv007==2007
replace temp_region=1507 if region==1506 & hv007==2007
replace temp_region=1508 if region==1507 & hv007==2007
replace temp_region=1509 if region==1508 & hv007==2007
replace temp_region=1510 if region==1509 & hv007==2007
replace region=temp_region if country==15 & hv007==2007
drop temp_region

gen temp_region=1501 if region==1501 & hv007==2013
replace temp_region=1502 if region==1502 & hv007==2013
replace temp_region=1503 if region==1503 & hv007==2013
replace temp_region=1504 if region==1504 & hv007==2013
replace temp_region=1505 if region==1505 & hv007==2013
replace temp_region=1503 if region==1506 & hv007==2013
replace temp_region=1507 if region==1507 & hv007==2013
replace temp_region=1508 if region==1508 & hv007==2013
replace temp_region=1509 if region==1509 & hv007==2013
replace temp_region=1510 if region==1510 & hv007==2013
replace region=temp_region if country==15 & hv007==2013
drop temp_region

gen temp_reg=1701 if country==17 & hv007==2010 & region==1701 
replace temp_reg=1702 if country==17 & hv007==2010 & region==1702 
replace temp_reg=1703 if country==17 & hv007==2010 & region==1703 
replace temp_reg=1704 if country==17 & hv007==2010 & region==1704
replace temp_reg=1704 if country==17 & hv007==2010 & region==1705
replace region=temp_reg if country==17 & hv007==2010
drop temp_reg

gen temp_reg=1704 if country==17 & hv007==2016 & region==1701 
replace temp_reg=1704 if country==17 & hv007==2016 & region==1702 
replace temp_reg=1704 if country==17 & hv007==2016 & region==1703 
replace temp_reg=1703 if country==17 & hv007==2016 & region==1704 
replace temp_reg=1704 if country==17 & hv007==2016 & region==1705 
replace temp_reg=1703 if country==17 & hv007==2016 & region==1706 
replace temp_reg=1703 if country==17 & hv007==2016 & region==1707 
replace temp_reg=1702 if country==17 & hv007==2016 & region==1708 
replace temp_reg=1702 if country==17 & hv007==2016 & region==1709 
replace temp_reg=1704 if country==17 & hv007==2016 & region==1710 
replace temp_reg=1703 if country==17 & hv007==2016 & region==1711 
replace temp_reg=1702 if country==17 & hv007==2016 & region==1712 
replace temp_reg=1704 if country==17 & hv007==2016 & region==1713 
replace temp_reg=1702 if country==17 & hv007==2016 & region==1714 
replace temp_reg=1704 if country==17 & hv007==2016 & region==1715 
replace temp_reg=1703 if country==17 & hv007==2016 & region==1716 
replace temp_reg=1701 if country==17 & hv007==2016 & region==1717 
replace temp_reg=1704 if country==17 & hv007==2016 & region==1718 
replace region=temp_reg if country==17 & hv007==2016
drop temp_reg

gen temp_reg=2001 if country==20 & hv007==2007 & region==2010
replace temp_reg=2003 if country==20 & hv007==2007 & region==2020
replace temp_reg=2002 if country==20 & hv007==2007 & region==2030
replace temp_reg=2004 if country==20 & hv007==2007 & region==2040
replace temp_reg=2010 if country==20 & hv007==2007 & region==2050
replace temp_reg=2009 if country==20 & hv007==2007 & region==2061
replace temp_reg=2008 if country==20 & hv007==2007 & region==2062
replace temp_reg=2011 if country==20 & hv007==2007 & region==2063
replace temp_reg=2007 if country==20 & hv007==2007 & region==2070
replace temp_reg=2006 if country==20 & hv007==2007 & region==2080
replace temp_reg=2005 if country==20 & hv007==2007 & region==2090
replace region=temp_reg if country==20 & hv007==2007
drop temp_reg

gen temp_reg=2302 if country==23 & hv007==2007 & region==2301
replace temp_reg=2301 if country==23 & hv007==2007 & region==2302
replace temp_reg=2302 if country==23 & hv007==2007 & region==2303
replace temp_reg=2303 if country==23 & hv007==2007 & region==2304
replace temp_reg=2304 if country==23 & hv007==2007 & region==2305
replace temp_reg=2305 if country==23 & hv007==2007 & region==2306
replace region=temp_reg if country==23 & hv007==2007
drop temp_reg


***Create Regional Measures
gen hiv_prime=hiv03 if age>=15 & age<=49
egen hiv_region=wtmean(hiv_prime), weight(hiv05) by(hv007 region)
*Scale Variable to be Measured in Percentage Points
gen hiv_scaled=hiv_region*100


*Weight Adjustment with WDI population estimates
sum hv005 if country==1 & hv007==2003
gen double adj_wgt=hv005*(12654621/r(sum)) if country==1 & hv007==2003
sum hv005 if country==1 & hv007==2010
replace adj_wgt=hv005*(15605217/r(sum)) if country==1 & hv007==2010

sum hv005 if country==2 & hv007==2004
replace adj_wgt=hv005*(16959081/r(sum)) if country==2 & hv007==2004
sum hv005 if country==2 & hv007==2011
replace adj_wgt=hv005*(20520447/r(sum)) if country==2 & hv007==2011

sum hv005 if country==3 & hv007==2005
replace adj_wgt=hv005*(18336303/r(sum)) if country==3 & hv007==2005
sum hv005 if country==3 & hv007==2011
replace adj_wgt=hv005*(20895311/r(sum)) if country==3 & hv007==2011

sum hv005 if country==4 & hv007==2005
replace adj_wgt=hv005*(76727083/r(sum)) if country==4 & hv007==2005
sum hv005 if country==4 & hv007==2011
replace adj_wgt=hv005*(90046756/r(sum)) if country==4 & hv007==2011
sum hv005 if country==4 & hv007==2016
replace adj_wgt=hv005*(102403196/r(sum)) if country==4 & hv007==2016

sum hv005 if country==5 & hv007==2003
replace adj_wgt=hv005*(20446782/r(sum)) if country==5 & hv007==2003
sum hv005 if country==5 & hv007==2014
replace adj_wgt=hv005*(26962563/r(sum)) if country==5 & hv007==2014

sum hv005 if country==6 & hv007==2005
replace adj_wgt=hv005*(9679745/r(sum)) if country==6 & hv007==2005
sum hv005 if country==6 & hv007==2012
replace adj_wgt=hv005*(11281469/r(sum)) if country==6 & hv007==2012

sum hv005 if country==7 & hv007==2003
replace adj_wgt=hv005*(34130852/r(sum)) if country==7 & hv007==2003
sum hv005 if country==7 & hv007==2008
replace adj_wgt=hv005*(39148416/r(sum)) if country==7 & hv007==2008

sum hv005 if country==8 & hv007==2004
replace adj_wgt=hv005*(1933728/r(sum)) if country==8 & hv007==2004
sum hv005 if country==8 & hv007==2009
replace adj_wgt=hv005*(2019209/r(sum)) if country==8 & hv007==2009
sum hv005 if country==8 & hv007==2014
replace adj_wgt=hv005*(2145785/r(sum)) if country==8 & hv007==2014

sum hv005 if country==9 & hv007==2004
replace adj_wgt=hv005*(12676038/r(sum)) if country==9 & hv007==2004
sum hv005 if country==9 & hv007==2010
replace adj_wgt=hv005*(15167095/r(sum)) if country==9 & hv007==2010
sum hv005 if country==9 & hv007==2015
replace adj_wgt=hv005*(15167095/r(sum)) if country==9 & hv007==2015

sum hv005 if country==10 & hv007==2001
replace adj_wgt=hv005*(11293258/r(sum)) if country==10 & hv007==2001
sum hv005 if country==10 & hv007==2006
replace adj_wgt=hv005*(13227064/r(sum)) if country==10 & hv007==2006
sum hv005 if country==10 & hv007==2012
replace adj_wgt=hv005*((16006670-1600667)/r(sum)) if country==10 & hv007==2012

sum hv005 if country==11 & hv007==2006
replace adj_wgt=hv005*(14132064/r(sum)) if country==11 & hv007==2006
sum hv005 if country==11 & hv007==2012
replace adj_wgt=hv005*(17731634/r(sum)) if country==11 & hv007==2012

sum hv005 if country==12 & hv007==2005
replace adj_wgt=hv005*(8991735/r(sum)) if country==12 & hv007==2005
sum hv005 if country==12 & hv007==2010
replace adj_wgt=hv005*(10246842/r(sum)) if country==12 & hv007==2010
sum hv005 if country==12 & hv007==2014
replace adj_wgt=hv005*(11345357/r(sum)) if country==12 & hv007==2014

sum hv005 if country==13 & hv007==2005
replace adj_wgt=hv005*(11251266/r(sum)) if country==13 & hv007==2005
sum hv005 if country==13 & hv007==2010
replace adj_wgt=hv005*(12916229/r(sum)) if country==13 & hv007==2010
sum hv005 if country==13 & hv007==2017
replace adj_wgt=hv005*(15850567/r(sum)) if country==13 & hv007==2017

sum hv005 if country==14 & hv007==2003
replace adj_wgt=hv005*((37149072-690957)/r(sum)) if country==14 & hv007==2003
sum hv005 if country==14 & hv007==2007
replace adj_wgt=hv005*((41923715)/r(sum)) if country==14 & hv007==2007
sum hv005 if country==14 & hv007==2011
replace adj_wgt=hv005*((47570902)/r(sum)) if country==14 & hv007==2011

sum hv005 if country==15 & hv007==2001
replace adj_wgt=hv005*(10824125/r(sum)) if country==15 & hv007==2001
sum hv005 if country==15 & hv007==2007
replace adj_wgt=hv005*(12725974/r(sum)) if country==15 & hv007==2007
sum hv005 if country==15 & hv007==2013
replace adj_wgt=hv005*(15153210/r(sum)) if country==15 & hv007==2013

sum hv005 if country==16 & hv007==2015
replace adj_wgt=hv005*(27859305/r(sum)) if country==16 & hv007==2015

sum hv005 if country==17 & hv007==2010
replace adj_wgt=hv005*(8766930/r(sum)) if country==17 & hv007==2010
sum hv005 if country==17 & hv007==2016
replace adj_wgt=hv005*(10524117/r(sum)) if country==17 & hv007==2016

sum hv005 if country==18 & hv007==2014
replace adj_wgt=hv005*(13569438/r(sum)) if country==18 & hv007==2014

sum hv005 if country==19 & hv007==2009
replace adj_wgt=hv005*(4253712/r(sum)) if country==19 & hv007==2009

sum hv005 if country==20 & hv007==2007
replace adj_wgt=hv005*(58417562/r(sum)) if country==20 & hv007==2007
sum hv005 if country==20 & hv007==2013
replace adj_wgt=hv005*(71316033/r(sum)) if country==20 & hv007==2013

sum hv005 if country==21 & hv007==2012
replace adj_wgt=hv005*(1756817/r(sum)) if country==21 & hv007==2012

sum hv005 if country==22 & hv007==2013
replace adj_wgt=hv005*(1859324/r(sum)) if country==22 & hv007==2013

sum hv005 if country==23 & hv007==2007
replace adj_wgt=hv005*(3512932/r(sum)) if country==23 & hv007==2007
sum hv005 if country==23 & hv007==2013
replace adj_wgt=hv005*(4286291/r(sum)) if country==23 & hv007==2013

sum hv005 if country==24 & hv007==2009
replace adj_wgt=hv005*(23524063/r(sum)) if country==24 & hv007==2009
sum hv005 if country==24 & hv007==2015
replace adj_wgt=hv005*(28010691/r(sum)) if country==24 & hv007==2015

sum hv005 if country==25 & hv007==2013
replace adj_wgt=hv005*(2316520/r(sum)) if country==25 & hv007==2013

sum hv005 if country==26 & hv007==2008
replace adj_wgt=hv005*(6165372/r(sum)) if country==26 & hv007==2008
sum hv005 if country==26 & hv007==2013
replace adj_wgt=hv005*(6922079/r(sum)) if country==26 & hv007==2013

sum hv005 if country==27 & hv007==2016
replace adj_wgt=hv005*(56015473/r(sum)) if country==27 & hv007==2016

sum hv005 if country==28 & hv007==2013
replace adj_wgt=hv005*(7042948/r(sum)) if country==28 & hv007==2013

sum hv005 if country==29 & hv007==2011
replace adj_wgt=hv005*(35093648/r(sum)) if country==29 & hv007==2011

sum hv005 if country==30 & hv007==2005
replace adj_wgt=hv005*(12940032/r(sum)) if country==30 & hv007==2005
sum hv005 if country==30 & hv007==2010
replace adj_wgt=hv005*(14086317/r(sum)) if country==30 & hv007==2010
sum hv005 if country==30 & hv007==2015
replace adj_wgt=hv005*(15777451/r(sum)) if country==30 & hv007==2015
/*
********************************************************************************
*Geodist
*geodist latnum longnum -6.31 23.59, gen(distance) sphere 

gen latDRC=-6.31
gen longDRC=23.59
geodist latnum longnum latDRC longDRC, gen(distance) sphere

*Chin and Wilson
***Create Cluster Measures
egen hiv_cluster=wtmean(hiv_prime), weight(hiv05) by(country hv007 dhs_clust)
*Scale Variable to be Measured in Percentage Points
gen hiv_scaled2=hiv_cluster*100

gen ln_hiv=ln(hiv_cluster)
egen mean_age=wtmean(age), weight(hiv05) by(country hv007 dhs_clust)
egen mean_urban=wtmean(hv025), weight(hiv05) by(country hv007 dhs_clust)

reg ln_hiv distance mean_age i.mean_urban [aw=adj_wgt] if age>=15 & age<=49,cluster(dhs_clust)
ivreg2 yrschl (ln_hiv=distance) mean_age i.mean_urban [aw=adj_wgt] if age>=15 & age<=49,cluster(dhs_clust)

gen ln_distance=ln(distance)
reg hiv_cluster ln_distance mean_age i.mean_urban [aw=adj_wgt] if age>=15 & age<=49,cluster(dhs_clust)
ivreg2 yrschl (hiv_cluster=ln_distance) mean_age i.mean_urban [aw=adj_wgt] if age>=15 & age<=49,cluster(dhs_clust)
*/
********************************************************************************
*Table 1
/*
*preserve

bysort region hv007 : gen mark=_n
egen reg_wgt=sum(adj_wgt),by(region hv007)

*keep if mark==1
 

univar hiv_scaled [aw=reg_wgt] if country==1 & mark==1 & hv007==2003
univar hiv_scaled [aw=reg_wgt] if country==1 & mark==1 & hv007==2010
univar hiv_scaled [aw=reg_wgt] if country==2 & mark==1 & hv007==2004
univar hiv_scaled [aw=reg_wgt] if country==2 & mark==1 & hv007==2011
univar hiv_scaled [aw=reg_wgt] if country==3 & mark==1 & hv007==2011
univar hiv_scaled [aw=reg_wgt] if country==3 & mark==1 & hv007==2005
univar hiv_scaled [aw=reg_wgt] if country==4 & mark==1 & hv007==2005
univar hiv_scaled [aw=reg_wgt] if country==4 & mark==1 & hv007==2011
univar hiv_scaled [aw=reg_wgt] if country==4 & mark==1 & hv007==2016
univar hiv_scaled [aw=reg_wgt] if country==5 & mark==1 & hv007==2003
univar hiv_scaled [aw=reg_wgt] if country==5 & mark==1 & hv007==2014
univar hiv_scaled [aw=reg_wgt] if country==6 & mark==1 & hv007==2005
univar hiv_scaled [aw=reg_wgt] if country==6 & mark==1 & hv007==2012
univar hiv_scaled [aw=reg_wgt] if country==7 & mark==1 & hv007==2003
univar hiv_scaled [aw=reg_wgt] if country==7 & mark==1 & hv007==2008
univar hiv_scaled [aw=reg_wgt] if country==8 & mark==1 & hv007==2004
univar hiv_scaled [aw=reg_wgt] if country==8 & mark==1 & hv007==2009
univar hiv_scaled [aw=reg_wgt] if country==8 & mark==1 & hv007==2014
univar hiv_scaled [aw=reg_wgt] if country==9 & mark==1 & hv007==2004
univar hiv_scaled [aw=reg_wgt] if country==9 & mark==1 & hv007==2010
univar hiv_scaled [aw=reg_wgt] if country==9 & mark==1 & hv007==2015
univar hiv_scaled [aw=reg_wgt] if country==10 & mark==1 & hv007==2001
univar hiv_scaled [aw=reg_wgt] if country==10 & mark==1 & hv007==2006
univar hiv_scaled [aw=reg_wgt] if country==10 & mark==1 & hv007==2012
univar hiv_scaled [aw=reg_wgt] if country==11 & mark==1 & hv007==2006
univar hiv_scaled [aw=reg_wgt] if country==11 & mark==1 & hv007==2012
univar hiv_scaled [aw=reg_wgt] if country==12 & mark==1 & hv007==2005
univar hiv_scaled [aw=reg_wgt] if country==12 & mark==1 & hv007==2010
univar hiv_scaled [aw=reg_wgt] if country==12 & mark==1 & hv007==2014
univar hiv_scaled [aw=reg_wgt] if country==13 & mark==1 & hv007==2005
univar hiv_scaled [aw=reg_wgt] if country==13 & mark==1 & hv007==2010
univar hiv_scaled [aw=reg_wgt] if country==13 & mark==1 & hv007==2017
univar hiv_scaled [aw=reg_wgt] if country==14 & mark==1 & hv007==2003
univar hiv_scaled [aw=reg_wgt] if country==14 & mark==1 & hv007==2007
univar hiv_scaled [aw=reg_wgt] if country==14 & mark==1 & hv007==2011
univar hiv_scaled [aw=reg_wgt] if country==15 & mark==1 & hv007==2001
univar hiv_scaled [aw=reg_wgt] if country==15 & mark==1 & hv007==2007
univar hiv_scaled [aw=reg_wgt] if country==15 & mark==1 & hv007==2013
univar hiv_scaled [aw=reg_wgt] if country==16 & mark==1 & hv007==2015
univar hiv_scaled [aw=reg_wgt] if country==17 & mark==1 & hv007==2010
univar hiv_scaled [aw=reg_wgt] if country==17 & mark==1 & hv007==2016
univar hiv_scaled [aw=reg_wgt] if country==18 & mark==1 & hv007==2014
univar hiv_scaled [aw=reg_wgt] if country==18 & mark==1 & hv007==2014
univar hiv_scaled [aw=reg_wgt] if country==19 & mark==1 & hv007==2009
univar hiv_scaled [aw=reg_wgt] if country==20 & mark==1 & hv007==2007
univar hiv_scaled [aw=reg_wgt] if country==20 & mark==1 & hv007==2013
univar hiv_scaled [aw=reg_wgt] if country==21 & mark==1 & hv007==2012
univar hiv_scaled [aw=reg_wgt] if country==22 & mark==1 & hv007==2013
univar hiv_scaled [aw=reg_wgt] if country==23 & mark==1 & hv007==2007
univar hiv_scaled [aw=reg_wgt] if country==23 & mark==1 & hv007==2013
univar hiv_scaled [aw=reg_wgt] if country==24 & mark==1 & hv007==2009
univar hiv_scaled [aw=reg_wgt] if country==24 & mark==1 & hv007==2015
univar hiv_scaled [aw=reg_wgt] if country==25 & mark==1 & hv007==2013
univar hiv_scaled [aw=reg_wgt] if country==26 & mark==1 & hv007==2008
univar hiv_scaled [aw=reg_wgt] if country==26 & mark==1 & hv007==2013
univar hiv_scaled [aw=reg_wgt] if country==27 & mark==1 & hv007==2016
univar hiv_scaled [aw=reg_wgt] if country==28 & mark==1 & hv007==2013
univar hiv_scaled [aw=reg_wgt] if country==29 & mark==1 & hv007==2011
univar hiv_scaled [aw=reg_wgt] if country==30 & mark==1 & hv007==2005
univar hiv_scaled [aw=reg_wgt] if country==30 & mark==1 & hv007==2010
univar hiv_scaled [aw=reg_wgt] if country==30 & mark==1 & hv007==2015


*Table 2: Sample Children Characteristics
sum hiv_scaled [aw=adj_wgt] if age>=7 & age<=14
sum ybehind [aw=adj_wgt] if age>=7 & age<=14
sum by [aw=adj_wgt] if age>=7 & age<=14
sum hv104 [aw=adj_wgt] if age>=7 & age<=14
sum hv025 [aw=adj_wgt] if age>=7 & age<=14

gen bf=1 if country==1 & country!=.
replace bf=0 if country!=1 & country!=.
gen cm=1 if country==2 & country!=.
replace cm=0 if country!=2 & country!=.
gen ci=1 if country==3 & country!=.
replace ci=0 if country!=3 & country!=.
gen et=1 if country==4 & country!=.
replace et=0 if country!=4 & country!=.
gen gh=1 if country==5 & country!=.
replace gh=0 if country!=5 & country!=.
gen gn=1 if country==6 & country!=.
replace gn=0 if country!=6 & country!=.
gen ke=1 if country==7 & country!=.
replace ke=0 if country!=7 & country!=.
gen ls=1 if country==8 & country!=.
replace ls=0 if country!=8 & country!=.
gen mw=1 if country==9 & country!=.
replace mw=0 if country!=9 & country!=.
gen ml=1 if country==10 & country!=.
replace ml=0 if country!=10 & country!=.
gen ni=1 if country==11 & country!=.
replace ni=0 if country!=11 & country!=.
gen rw=1 if country==12 & country!=.
replace rw=0 if country!=12 & country!=.
gen sn=1 if country==13 & country!=.
replace sn=0 if country!=13 & country!=.
gen tz=1 if country==14 & country!=.
replace tz=0 if country!=14 & country!=.
gen zm=1 if country==15 & country!=.
replace zm=0 if country!=15 & country!=.


sum bf [aw=adj_wgt] if age>=7 & age<=14
sum cm [aw=adj_wgt] if age>=7 & age<=14
sum ci [aw=adj_wgt] if age>=7 & age<=14
sum et [aw=adj_wgt] if age>=7 & age<=14
sum gh [aw=adj_wgt] if age>=7 & age<=14
sum gn [aw=adj_wgt] if age>=7 & age<=14
sum ke [aw=adj_wgt] if age>=7 & age<=14
sum ls [aw=adj_wgt] if age>=7 & age<=14
sum mw [aw=adj_wgt] if age>=7 & age<=14
sum ml [aw=adj_wgt] if age>=7 & age<=14
sum ni [aw=adj_wgt] if age>=7 & age<=14
sum rw [aw=adj_wgt] if age>=7 & age<=14
sum sn [aw=adj_wgt] if age>=7 & age<=14
sum tz [aw=adj_wgt] if age>=7 & age<=14
sum zm [aw=adj_wgt] if age>=7 & age<=14

*Table 3

sum hiv_scaled [aw=adj_wgt] if age>=15 & age<=49
sum yrschl [aw=adj_wgt] if age>=15 & age<=49
sum anyschool [aw=adj_wgt] if age>=15 & age<=49
sum primary [aw=adj_wgt] if age>=15 & age<=49
sum by [aw=adj_wgt] if age>=15 & age<=49
sum hv104 [aw=adj_wgt] if age>=15 & age<=49
sum hv025 [aw=adj_wgt] if age>=15 & age<=49
sum bf [aw=adj_wgt] if age>=15 & age<=49
sum cm [aw=adj_wgt] if age>=15 & age<=49
sum ci [aw=adj_wgt] if age>=15 & age<=49
sum et [aw=adj_wgt] if age>=15 & age<=49
sum gh [aw=adj_wgt] if age>=15 & age<=49
sum gn [aw=adj_wgt] if age>=15 & age<=49
sum ke [aw=adj_wgt] if age>=15 & age<=49
sum ls [aw=adj_wgt] if age>=15 & age<=49
sum mw [aw=adj_wgt] if age>=15 & age<=49
sum ml [aw=adj_wgt] if age>=15 & age<=49
sum ni [aw=adj_wgt] if age>=15 & age<=49
sum rw [aw=adj_wgt] if age>=15 & age<=49
sum sn [aw=adj_wgt] if age>=15 & age<=49
sum tz [aw=adj_wgt] if age>=15 & age<=49
sum zm [aw=adj_wgt] if age>=15 & age<=49

*Table 4

*Gen Key DiD and Young
gen young=by>=1980 if by!=.
gen key=hiv_region*young

***Estimate Model
*Years of Schooling
reg yrschl key age* i.hv104 i.hv025 i.region i.by i.hv007 [aw=adj_wgt] if age>=15 & age<=49,cluster(region)
*Any Schooling
reg anyschool key age* i.hv104 i.hv025 i.region i.by i.hv007 [aw=adj_wgt] if age>=15 & age<=49,cluster(region)
*Complete Primary
reg primary key age* i.hv104 i.hv025 i.region i.by i.hv007 [aw=adj_wgt] if age>=15 & age<=49,cluster(region)

********************************************************************************
*Table 6

***Placebo
gen early=by>=1970 if by!=.
gen key_early=hiv_region*early

*Years of Schooling
reg yrschl key_early age* i.hv104 i.hv025 i.region i.by i.hv007 [aw=adj_wgt] if age>=15 & age<=49 & by<1980,cluster(region)
*Any Schooling
reg anyschool key_early age* i.hv104 i.hv025 i.region i.by i.hv007 [aw=adj_wgt] if age>=15 & age<=49 & by<1980,cluster(region)
*Complete Primary
reg primary key_early age* i.hv104 i.hv025 i.region i.by i.hv007 [aw=adj_wgt] if age>=15 & age<=49 & by<1980,cluster(region)

********************************************************************************
*Table 7
*use key for 15-25 men and women 

*Years of Schooling
reg yrschl key age* i.hv104 i.hv025 i.region i.by i.hv007 [aw=adj_wgt] if age>=15 & age<=25,cluster(region)
*Any Schooling
reg anyschool key age* i.hv104 i.hv025 i.region i.by i.hv007 [aw=adj_wgt] if age>=15 & age<=25,cluster(region)
*Complete Primary
reg primary key age* i.hv104 i.hv025 i.region i.by i.hv007 [aw=adj_wgt] if age>=15 & age<=25,cluster(region)

********************************************************************************
*Table 8

replace hv111=. if hv111==8
replace hv111=. if hv111==9

replace hv113=. if hv113==8
replace hv113=. if hv113==9

gen late=by>=1992 if by!=.
gen key_late=hiv_region*late

*Col(1)
reg ybehind key_late age* i.hv104 i.hv025 i.region i.by i.hv007 [aw=adj_wgt] if age>=7 & age<=14,cluster(region)

*Col(2)
egen varmin=rowmin(hv111 hv113)
reg ybehind key_late age* i.hv104 i.hv025 i.region i.by i.hv007 [aw=adj_wgt] if age>=7 & age<=14 & varmin==1,cluster(region)

*Col(3)

**Col (2) restriction + ...
*Build Variable to define if any HH member was tested; cannot match to HH in Mali (10) and Zambia (15)
egen hivhh=max(hiv03),by(country dhs_clust dhs_struct dhs_hh)
replace hivhh=. if country==10 & hv007==2001 | country==15 & hv007==2001

reg ybehind key_late age* i.hv104 i.hv025 i.region i.by i.hv007 [aw=adj_wgt] if age>=7 & age<=14 & varmin==1 & hivhh!=.,cluster(region)

*Col(4)

reg ybehind key_late age* i.hv104 i.hv025 i.region i.by i.hv007 [aw=adj_wgt] if age>=7 & age<=14 & varmin==1 & hivhh==0,cluster(region)


*Table 9

*Gen Key DiD and Young
gen male=hv104==1 if hv104!=.
gen key_male=hiv_region*young*male

***Estimate Model
*Years of Schooling
reg yrschl key_male key age* i.hv104 i.hv025 i.region i.by i.hv007 [aw=adj_wgt] if age>=15 & age<=49,cluster(region)
*Any Schooling
reg anyschool key_male key age* i.hv104 i.hv025 i.region i.by i.hv007 [aw=adj_wgt] if age>=15 & age<=49,cluster(region)
*Complete Primary
reg primary key_male key age* i.hv104 i.hv025 i.region i.by i.hv007 [aw=adj_wgt] if age>=15 & age<=49,cluster(region)

*Table 4 with Dummies

*Five Year Birth Cohorts 

gen cohort_56=by>=1956 & by<=1960 if by!=.
gen cohort_61=by>=1961 & by<=1965 if by!=.
gen cohort_66=by>=1966 & by<=1970 if by!=.
gen cohort_71=by>=1971 & by<=1975 if by!=.
gen cohort_76=by>=1976 & by<=1980 if by!=.
gen cohort_81=by>=1981 & by<=1985 if by!=.
gen cohort_86=by>=1986 & by<=1990 if by!=.
gen cohort_91=by>=1991 & by<=1995 if by!=.
gen cohort_96=by>=1996 & by<=2002 if by!=.

*Interaction with hiv prevalence 

gen cohort56_key= cohort_56*hiv_region
gen cohort61_key= cohort_61*hiv_region
gen cohort66_key= cohort_66*hiv_region
gen cohort71_key= cohort_71*hiv_region
gen cohort76_key= cohort_76*hiv_region
gen cohort81_key= cohort_81*hiv_region
gen cohort86_key= cohort_86*hiv_region
gen cohort91_key= cohort_91*hiv_region
gen cohort96_key= cohort_96*hiv_region

***Estimate Model with Five Year Birth Cohorts 
*Years of Schooling
reg yrschl cohort56_key cohort61_key cohort66_key cohort71_key cohort76_key cohort81_key cohort86_key cohort91_key cohort96_key hiv_region age* i.hv104 i.hv025 i.region i.by i.hv007 [aw=adj_wgt] if age>=15 & age<=49,cluster(region)
*Any Schooling
reg anyschool cohort56_key cohort61_key cohort66_key cohort71_key cohort76_key cohort81_key cohort86_key cohort91_key cohort96_key hiv_region age* i.hv104 i.hv025 i.region i.by i.hv007 [aw=adj_wgt] if age>=15 & age<=49,cluster(region)
*Complete Primary
reg primary cohort56_key cohort61_key cohort66_key cohort71_key cohort76_key cohort81_key cohort86_key cohort91_key cohort96_key age* hiv_region i.hv104 i.hv025 i.region i.by i.hv007 [aw=adj_wgt] if age>=15 & age<=49,cluster(region)

**Estimate Model with post-1980 Birth Cohorts
*Years of Schooling
reg yrschl cohort81_key cohort86_key cohort91_key cohort96_key hiv_region age* i.hv104 i.hv025 i.region i.by i.hv007 [aw=adj_wgt] if age>=15 & age<=49,cluster(region)
*Any Schooling
reg anyschool cohort81_key cohort86_key cohort91_key cohort96_key hiv_region age* i.hv104 i.hv025 i.region i.by i.hv007 [aw=adj_wgt] if age>=15 & age<=49,cluster(region)
*Complete Primary
reg primary cohort81_key cohort86_key cohort91_key cohort96_key hiv_region age* i.hv104 i.hv025 i.region i.by i.hv007 [aw=adj_wgt] if age>=15 & age<=49,cluster(region)
*/
