
*-----------------------------------
*
* Table 2
*
*-----------------------------------

clear 
eststo clear

global file /*Add Replication Folder Location Here/replication_cls*/

cd "$file"

*-----------------------------------
* Table 2 - Column (1)
* Data: Original_Replication
* SetUp: Original_Replication_ContempSetUp 
*-----------------------------------

***Original - With Contemporary Population Weights
run analysis_files/setup_code/Original_Replication_ContempSetUp 

*Prep
gen young=by>=1980 if by!=.
gen key_scaled=hiv_scaled*young

*Output
foreach yvar of varlist yrschl anysch primary {
	eststo: qui reghdfe `yvar' key_scaled [aw=adj_wgt] ///
		if by>=1965 & hv105>=15 & hv105<=49,cluster(region) a(region hv104 hv025 by)
	estadd scalar Clusters=e(N_clust)
	}
	
esttab * using analysis_files\output\table_2\t2_c1.csv, stats(Clusters N) ///
	b(3) se(3) star(* 0.10 ** 0.05 *** 0.01) k(key_scaled) replace
eststo clear

********************************************************************************

*-----------------------------------
* Table 2 - Column (2)
* Data: Original_AllYears
* SetUp: Original_AllYears_SetUp
*-----------------------------------
	
***Original Countries Expanded Sample
run analysis_files/setup_code/Original_AllYears_SetUp 

*Prep
gen young=by>=1980 if by!=.
gen key_scaled=hiv_scaled*young

*Output
foreach yvar of varlist yrschl anysch primary {
	eststo: qui reghdfe `yvar' key_scaled hiv_scaled age* [aw=adj_wgt] ///
		if by>=1965 & age>=15 & age<=49,cluster(region) a(region hv104 hv025 by)
	estadd scalar Clusters=e(N_clust)
	}
esttab * using analysis_files\output\table_2\t2_c2.csv, stats(Clusters N) ///
	b(3) se(3) star(* 0.10 ** 0.05 *** 0.01) k(key_scaled hiv_scaled) replace
eststo clear

********************************************************************************

*-----------------------------------
* Table 2 - Columns (3); (4); (5)
* Data: AllCountries_Post2000_Main
* SetUp: AllCountries_Post2000_SetUp
*-----------------------------------

***All Countries - Post-2000
run analysis_files/setup_code/AllCountries_Post2000_SetUp 

*Prep
gen young=by>=1980 if by!=.
gen key_scaled=hiv_scaled*young

egen hiv_max=max(hiv_scaled),by(region)
gen key_max=hiv_max*young

egen regfe=group(region hv007)

*Output
foreach yvar of varlist yrschl anysch primary {
	eststo: qui reghdfe `yvar' key_scaled hiv_scaled age* [aw=adj_wgt] ///
		if by>=1965 & age>=15 & age<=49,cluster(region) a(region hv104 hv025 by)
	estadd scalar Clusters=e(N_clust)
	
	eststo: qui reghdfe `yvar' key_scaled age* [aw=adj_wgt] ///
		if by>=1965 & age>=15 & age<=49,cluster(region) a(regfe hv104 hv025 by)
	estadd scalar Clusters=e(N_clust)
	
	eststo: qui reghdfe `yvar' key_max age* [aw=adj_wgt] ///
		if by>=1965 & age>=15 & age<=49,cluster(region) a(regfe hv104 hv025 by)
	estadd scalar Clusters=e(N_clust)
	}
esttab * using analysis_files\output\table_2\t2_c3_4_5.csv, stats(Clusters N) ///
	b(3) se(3) star(* 0.10 ** 0.05 *** 0.01) k(key_scaled hiv_scaled key_max) replace
eststo clear

********************************************************************************

*-----------------------------------
* Table 2 - Columns (3); (4); (5)
* Data: AllCountries_AllYears
* SetUp: AllCountries_AllYears_SetUp
*-----------------------------------

***Annual HIV Prev. Estiamtes
run analysis_files/setup_code/AllCountries_AllYears_SetUp 
replace hiv_gdb=hiv_gdb*100

*Prep
egen regfe=group(region hv007)

*Output
foreach yvar of varlist yrschl anysch primary {
	eststo: qui reghdfe `yvar' hiv_gdb age* [aw=adj_wgt] ///
		if by>=1965 & age>=15 & age<=49,cluster(region) a(regfe hv104 hv025 by)
	estadd scalar Clusters=e(N_clust)
	}

esttab * using analysis_files\output\table_2\t2_c6.csv, stats(Clusters N) ///
	b(3) se(3) star(* 0.10 ** 0.05 *** 0.01) k(hiv_gdb) replace
eststo clear
