
*-----------------------------------
*
* Table A.8
*
*-----------------------------------

clear 
eststo clear

global file /*Add Replication Folder Location Here/replication_cls*/

cd "$file"

********************************************************************************

*-----------------------------------
* Table A.8 - Panel A
* Data: Original_Replication
* SetUp: Original_Replication_ContempSetUp 
*-----------------------------------

***Original - With Contemporary Population Weights
run analysis_files/setup_code/Original_Replication_ContempSetUp 

*Prep
gen young=by>=1980 if by!=.
gen key_scaled=hiv_scaled*young

foreach yvar of varlist yrschl anysch primary {
	eststo: qui reghdfe `yvar' key_scaled i.hv104 i.hv025 [aw=adj_wgt] ///
		if by>=1965 & hv105>=15 & hv105<=25,cluster(region) a(region by)
	estadd scalar Clusters=e(N_clust)
	}

********************************************************************************
*-----------------------------------
* Table A.8 - Panel B
* Data: AllCountries_Post2000_Main
* SetUp: AllCountries_Post2000_SetUp
*-----------------------------------

***All Countries - Post-2000
run analysis_files/setup_code/AllCountries_Post2000_SetUp 

*Prep
gen young=by>=1980 if by!=.
gen key_scaled=hiv_scaled*young

egen regfe=group(region hv007)

foreach yvar of varlist yrschl anysch primary {
	eststo: qui reghdfe `yvar' key_scaled age* i.hv104 i.hv025 [aw=adj_wgt] ///
		if by>=1965 & age>=15 & age<=25,cluster(region) a(regfe by)
	estadd scalar Clusters=e(N_clust)
	}

********************************************************************************

esttab * using analysis_files\output\table_a8.csv, ///
	stats(Clusters N) b(3) se(3) star(* 0.10 ** 0.05 *** 0.01) ///
	k(key_scaled) replace
eststo clear

