*-----------------------------------
*
* Table A.7
*
*-----------------------------------

clear 
eststo clear

global file /*Add Replication Folder Location Here/replication_cls*/

cd "$file"

********************************************************************************

*-----------------------------------
* Table A.7
* Data: AllCountries_Post2000_Main
* SetUp: AllCountries_Post2000_SetUp
*-----------------------------------

***All Countries - Post-2000
run analysis_files/setup_code/AllCountries_Post2000_SetUp 

egen regfe=group(region hv007)

*Prep
gen late=by>=1992 if by!=.
gen key_late=hiv_scaled*late

*Parents Alive
replace hv111=. if hv111==8
replace hv111=. if hv111==9

replace hv113=. if hv113==8
replace hv113=. if hv113==9
egen varmin=rowmin(hv111 hv113)

*No HIV Positive
egen hivhh=max(hiv03),by(country dhs_clust dhs_struct dhs_hh)
replace hivhh=. if country==10 & hv007==2001 | country==15 & hv007==2001

***(1) Full Sample
eststo: qui reghdfe ybehind key_late age* i.hv104 i.hv025 [aw=adj_wgt] ///
	if by>=1965 & age>=7 & age<=14,cluster(region) a(regfe by)
estadd scalar Clusters=e(N_clust)
***(2) Parents Alive
eststo: qui reghdfe ybehind key_late age* i.hv104 i.hv025 [aw=adj_wgt] ///
	if age>=7 & age<=14 & varmin==1,cluster(region) a(regfe by)
estadd scalar Clusters=e(N_clust)
***(3) : (2) + HIV Testing Sample
eststo: qui reghdfe ybehind key_late age* i.hv104 i.hv025 [aw=adj_wgt] ///
	if age>=7 & age<=14 & varmin==1 & hivhh!=.,cluster(region) a(regfe by)
estadd scalar Clusters=e(N_clust)
***(4) : (2) + No HIV+
eststo: qui reghdfe ybehind key_late age* i.hv104 i.hv025 [aw=adj_wgt] ///
	if age>=7 & age<=14 & varmin==1 & hivhh==0,cluster(region) a(regfe by)
estadd scalar Clusters=e(N_clust)

********************************************************************************

esttab * using analysis_files\output\table_a7.csv, ///
	stats(Clusters N) b(3) se(3) star(* 0.10 ** 0.05 *** 0.01) ///
	k(key_late) replace
eststo clear
