*-----------------------------------
*
* Table A.6
*
*-----------------------------------

clear 
eststo clear

global file /*Add Replication Folder Location Here/replication_cls*/

cd "$file"

********************************************************************************

*-----------------------------------
* Table A.6
* Data: Original_Replication
* SetUp: Original_Replication_07SetUp 
*-----------------------------------

***Original - With Original Population Weights
run analysis_files/setup_code/Original_Replication_07SetUp 

*Prep
gen late=by>=1992 if by!=.
gen key_late=hiv_scaled*late

*Parents Alive
replace hv111=. if hv111==8
replace hv111=. if hv111==9

replace hv113=. if hv113==8
replace hv113=. if hv113==9
egen varmin=rowmin(hv111 hv113)

*No HIV Positive
egen hivhh=max(hiv03),by(country dhs_clust dhs_struct dhs_hh)
replace hivhh=. if country==10 & hv007==2001 | country==15 & hv007==2001

***(1) Full Sample
eststo: qui reghdfe ybehind key_late [aw=adj_wgt] ///
	if by>=1965 & hv105>=7 & hv105<=14,cluster(region) a(region hv104 hv025 hv105 by)
estadd scalar Clusters=e(N_clust)
***(2) Parents Alive
eststo: qui reghdfe ybehind key_late [aw=adj_wgt] ///
	if hv105>=7 & hv105<=14 & varmin==1,cluster(region) a(region hv104 hv025 hv105 by)
estadd scalar Clusters=e(N_clust)
***(3) : (2) + HIV Testing Sample
eststo: qui reghdfe ybehind key_late [aw=adj_wgt] ///
	if hv105>=7 & hv105<=14 & varmin==1 & hivhh!=.,cluster(region) a(region hv104 hv025 hv105 by)
estadd scalar Clusters=e(N_clust)
***(4) : (2) + No HIV+
eststo: qui reghdfe ybehind key_late [aw=adj_wgt] ///
	if hv105>=7 & hv105<=14 & varmin==1 & hivhh==0,cluster(region) a(region hv104 hv025 hv105 by)
estadd scalar Clusters=e(N_clust)

********************************************************************************

esttab * using analysis_files\output\table_a6.csv, ///
	stats(Clusters N) b(3) se(3) star(* 0.10 ** 0.05 *** 0.01) ///
	k(key_late) replace
eststo clear
