
*-----------------------------------
*
* Table A.4
*
*-----------------------------------

clear 
eststo clear

global file /*Add Replication Folder Location Here/replication_cls*/

cd "$file"


********************************************************************************
********************************************************************************

*-----------------------------------
* Table A.4 - Panels A and B
* Data: AllCountries_Post2000_Main
* SetUp: AllCountries_Post2000_SetUp
*-----------------------------------

***All Countries - Post-2000
run analysis_files/setup_code/AllCountries_Post2000_SetUp 

*Prep
gen young=by>=1980 if by!=.
gen key_scaled=hiv_scaled*young

egen hiv_max=max(hiv_scaled),by(region)
gen key_max=hiv_max*young

egen regfe=group(region hv007)

forval y=1/5 {
	gen sch`y'=yrschl>=`y' if yrschl!=.
	}

*Full
forval y=1/5 {
	eststo: qui reghdfe sch`y' key_scaled age* [aw=adj_wgt] ///
		if by>=1965 & age>=15 & age<=49,cluster(region) a(regfe hv104 hv025 by)
	estadd scalar Clusters=e(N_clust)
	}
eststo: qui reghdfe primary key_scaled age* [aw=adj_wgt] ///
	if by>=1965 & age>=15 & age<=49,cluster(region) a(regfe hv104 hv025 by)
estadd scalar Clusters=e(N_clust)

********************************************************************************

*Full
forval y=1/5 {
	eststo: qui reghdfe sch`y' key_max age* [aw=adj_wgt] ///
		if by>=1965 & age>=15 & age<=49,cluster(region) a(regfe hv104 hv025 by)
	estadd scalar Clusters=e(N_clust)
	}
eststo: qui reghdfe primary key_max age* [aw=adj_wgt] ///
	if by>=1965 & age>=15 & age<=49,cluster(region) a(regfe hv104 hv025 by)
estadd scalar Clusters=e(N_clust)


********************************************************************************
********************************************************************************

*-----------------------------------
* Table A.4 - Panel C
* Data: AllCountries_AllYears
* SetUp: AllCountries_AllYears_SetUp
*-----------------------------------

***Annual HIV Prev. Estiamtes
run analysis_files/setup_code/AllCountries_AllYears_SetUp 
replace hiv_gdb=hiv_gdb*100

*Prep
egen regfe=group(region hv007)

forval y=1/5 {
	gen sch`y'=yrschl>=`y' if yrschl!=.
	}

*Full
forval y=1/5 {
	eststo: qui reghdfe sch`y' hiv_gdb age* [aw=adj_wgt] ///
		if by>=1965 & age>=15 & age<=49,cluster(region) a(regfe hv104 hv025 by)
	estadd scalar Clusters=e(N_clust)
	}
eststo: qui reghdfe primary hiv_gdb age* [aw=adj_wgt] ///
	if by>=1965 & age>=15 & age<=49,cluster(region) a(regfe hv104 hv025 by)
estadd scalar Clusters=e(N_clust)


********************************************************************************

esttab * using analysis_files\output\table_a4.csv, ///
	stats(Clusters N) b(3) se(3) star(* 0.10 ** 0.05 *** 0.01) ///
	k(key_scaled key_max hiv_gdb) replace
eststo clear
