
*-----------------------------------
*
* Table A.2
*
*-----------------------------------

clear 
eststo clear

global file /*Add Replication Folder Location Here/replication_cls*/

cd "$file"

********************************************************************************

*-----------------------------------
* Table A.2 - Odd Columns
* Data: Original_Replication
* SetUp: Original_Replication_07SetUp
*-----------------------------------

* Original Population Weights
run analysis_files\setup_code\Original_Replication_07SetUp

*Gen Key DiD and Young
gen young=by>=1980 if by!=.
gen key_scaled=hiv_scaled*young

gen rural=hv025==2 if hv025!=.
gen female=hv104==2 if hv104!=.


foreach yvar of varlist yrschl anysch primary {
	***Original Weights - Panel A
	eststo: qui reghdfe `yvar' key_scaled rural female [aw=adj_wgt] if hv105>=15 & hv105<=49 ///
		,cluster(region) a(region by)
	estadd scalar Clusters=e(N_clust)
	
	***Original Weights - Panel B
	eststo: qui reghdfe `yvar' key_scaled rural female [aw=adj_wgt] if hv105>=15 & hv105<=49 ///
		& by>=1965,cluster(region) a(region by)
	estadd scalar Clusters=e(N_clust)
	}
	
	
********************************************************************************

*-----------------------------------
* Table A.2 - Even Columns
* Data: Original_Replication
* SetUp: Original_Replication_ContempSetUp
*-----------------------------------

*Survey Year Population Weights	
run analysis_files\setup_code\Original_Replication_ContempSetUp

*Prep
gen young=by>=1980 if by!=.
gen key_scaled=hiv_scaled*young

gen rural=hv025==2 if hv025!=.
gen female=hv104==2 if hv104!=.

foreach yvar of varlist yrschl anysch primary {
	***Survey Year Population Weights - Panel A
	eststo: qui reghdfe `yvar' key_scaled rural female [aw=adj_wgt] if hv105>=15 & hv105<=49 ///
		,cluster(region) a(region by)
	estadd scalar Clusters=e(N_clust)
	
	***Survey Year Population Weights - Panel B
	eststo: qui reghdfe `yvar' key_scaled rural female [aw=adj_wgt] if hv105>=15 & hv105<=49 ///
		& by>=1965,cluster(region) a(region by)
	estadd scalar Clusters=e(N_clust)
	}

********************************************************************************
	
esttab * using analysis_files\output\table_a2.csv, stats(Clusters N) ///
	b(3) se(3) star(* 0.10 ** 0.05 *** 0.01) k(key_scaled rural female) replace
eststo clear
