
*-----------------------------------
*
* Table A.10
*
*-----------------------------------

clear 
eststo clear

global file /*Add Replication Folder Location Here/replication_cls*/

cd "$file"

********************************************************************************

*-----------------------------------
* Table A.10 - Columns (1) to (2)
* Data: Original_Replication
* SetUp: Original_Replication_ContempSetUp 
*-----------------------------------

***Original - With Contemporary Population Weights
run analysis_files/setup_code/Original_Replication_ContempSetUp 

*Prep
gen young=by>=1980 if by!=.
gen key_scaled=hiv_scaled*young

*Male Interaction Control Variables
gen male=hv104==1 if hv104!=.
gen mkey_scaled=male*key_scaled

*Missing Interaction for Triple Diff
gen mhiv=male*hiv_scaled
gen myoung=male*young

*Vary FE by Sex
gen mby=by*10+male
gen mregfe=region*10+male

********************************************************************************
********************************************************************************
*Output for Appendix Table MF
foreach yvar of varlist yrschl anysch primary {
	eststo: qui reghdfe `yvar' mkey_scaled key_scaled [aw=adj_wgt] ///
		if by>=1965 & hv105>=15 & hv105<=49,cluster(region) a(region hv104 hv025 by)
	estadd scalar Clusters=e(N_clust)
		
	eststo: qui reghdfe `yvar' mkey_scaled key_scaled mhiv myoung [aw=adj_wgt] ///
		if by>=1965 & hv105>=15 & hv105<=49,cluster(region) a(region hv104 hv025 by)
	estadd scalar Clusters=e(N_clust)
	}
	
********************************************************************************

*-----------------------------------
* Table A.10 - Columns (3) to (5)
* Data: AllCountries_Post2000_Main
* SetUp: AllCountries_Post2000_SetUp
*-----------------------------------

***All Countries - Post-2000
run analysis_files/setup_code/AllCountries_Post2000_SetUp 

*Prep
gen young=by>=1980 if by!=.
gen key_scaled=hiv_scaled*young

egen hiv_max=max(hiv_scaled),by(region)
gen key_max=hiv_max*young

egen regfe=group(region hv007)

*Male Interaction Control Variables
gen male=hv104==1 if hv104!=.
gen mkey_scaled=male*key_scaled
gen mkey_max=male*key_max

*Missing Interaction for Triple Diff
gen mhiv=male*hiv_scaled
gen myoung=male*young

*Vary FE by Sex
gen mby=by*10+male
gen mregfe=regfe*10+male

foreach yvar of varlist yrschl anysch primary {		
	eststo: qui reghdfe `yvar' mkey_scaled key_scaled mhiv myoung age* i.hv104 i.hv025 [aw=adj_wgt] ///
		if country<=15 & by>=1965 & age>=15 & age<=49,cluster(region) a(regfe by)
	estadd scalar Clusters=e(N_clust)

	eststo: qui reghdfe `yvar' mkey_scaled key_scaled mhiv myoung age* i.hv104 i.hv025 [aw=adj_wgt] ///
		if by>=1965 & age>=15 & age<=49,cluster(region) a(regfe by)
	estadd scalar Clusters=e(N_clust)

	eststo: qui reghdfe `yvar' mkey_scaled key_scaled mhiv myoung age* i.hv104 i.hv025 [aw=adj_wgt] ///
		if by>=1965 & age>=15 & age<=49,cluster(region) a(mregfe mby)
	estadd scalar Clusters=e(N_clust)
	}

********************************************************************************

esttab * using analysis_files\output\table_a10.csv, stats(Clusters N) ///
	b(3) se(3) star(* 0.10 ** 0.05 *** 0.01) k(mkey_scaled key_scaled) replace
eststo clear
