prog def multisort
	syntax varlist [, id(varname) over(string) preserve(varlist)]
	tempfile fh
	loc vars `varlist'

	// Preserve variables in current order
	if "`preserve'" != "" {
		preserve
		keep `preserve'
		gen key = _n
		save `fh'
		restore
	}

	// Reshape to wide if over is called
	if "`over'" != "" {
		if "`id'" == "" {
			di as error "option id required with option over"
			error
			}
		levelsof `over', local(varsuff)
		reshape wide `vars', i(`id') j(`over')
		// Include wide vars in varlist to be sorted
		foreach v in `vars' {
			foreach e in `varsuff' {
				loc vvars `vvars' `v'`e'
			}
		}
		loc vars `vvars'
	}
	
	// Sort on every var of varlist to generate new data set
	loc k : list sizeof vars
	loc v1 : word 1 of `vars'
	loc vk : word `k' of `vars'
	qui foreach v in `vars' {
		preserve
		keep `v'
		sort `v'
		gen key = _n
		cap merge 1:1 key using `fh', nogen
		if "`v'" != "`vk'" {
			save `fh', replace
			restore
		}
	}
	restore, not
	drop key 	

end
