clear
set more off
global path "" // add the files location here
cd "$path"
cap log close
log using logs/uk1994to2001.txt, replace
import delimited "$path/data/eudist_hinc.csv", clear
keep *UK*
qui foreach var of varlist * {
	replace `var' = 0 if `var' < 0
	}
	
loc i = 1 
keep if mod(_n,10) == 1
gen f = _n/(_N + 1)
gen yyear = 1993 + _n if 1993 + _n <= 2001
replace yyear = 1996 + _n if inrange(1993 + _n,2002,2007)

loc se u(.1(.1).9) m(`i') seed(22032013)
local N1994 = 6253
local N1995 = 5506
local N1996 = 5046
local N1997 = 2771
local N1998 = 2768
local N1999 = 2769
local N2000 = 2738
local N2001 = 2698
local N2005 = 6064
local N2006 = 5450
local N2007 = 5077
local N2008 = 4888
local N2009 = 4349
local N2010 = 4130


cap prog drop mydomlevel
prog def mydomlevel
	syntax anything(name=0) , [ Record se Quietly name(string) ]
	tokenize `0'
	loc t1 `1'
	loc t2 `2'
	if `t2' <= `t1' { 
		loc tt1 `t2'
		loc t2 `t1'
		loc t1 `tt1'
	}	

	if "`se'" != "" loc se se(u(.1(.1).9) m(1000) sims(1000) seed(22032013)) process
	qui dominance hincUK`t1' hincUK`t2', f1(f) f2(f) tol(100) n1(`N`t1'') n2(`N`t2'') `se'
	`quietly' di "`t1' vs `t2': up = `r(up)'; down = `r(down)'; pup=`r(p_up)', pdown=`r(p_down)', pup05=`r(p_up_05)'

	qui if "`record'" != "" {
		foreach r in down up {
			cap gen UKupdown`t2' = ""
			cap gen UK`name'`r'`t2' = ""
			if "`r(`r'dir)'" == "hincUK`t1'" loc dir >
			if "`r(`r'dir)'" == "hincUK`t2'" loc dir <
			if "`r(`r')'" != "" {
				replace UK`name'`r'`t2' = "`r(`r')'`dir'" if yyear == `t1'
				if "`r'"=="up" replace UK`name'updown`t2' = "`r(`r')'`dir'" if yyear == `t1'
				else replace UK`name'updown`t1' = "`r(`r')'`dir'" if yyear == `t2'
			}
			if "`r'"=="up" & r(up) <= 2 replace UK`name'down`t2' = "`r(up)'`dir'" if yyear == `t1'
			cap gen t`t2'`name'_2nd = ""
			cap gen t`t2'`name'_3rd_up = ""
			cap gen t`t2'`name'_3rd_down = ""
			if "`r'"=="up" & r(`r') <= 2 replace t`t2'`name'_2nd = "`dir'" if yyear == `t1'
			if r(`r') <= 3 | r(up) <= 2 replace t`t2'`name'_3rd_`r' = "`dir'" if yyear == `t1'
			cap gen p`t2'`name'_3rd_up = ""
			cap gen p`t2'`name'_3rd_down = ""
			if r(`r') <= 3 | r(up) <= 2 replace p`t2'`name'_3rd_`r' = "`r(p_`r')'" if yyear == `t1'
		}
		foreach r in updir downdir {
			cap gen UK`r'`name'`t2' = ""
			if "`r(`r')'" != "" replace UK`r'`name'`t2' = "`r(`r')'" if yyear == `t1'
		}
	}
end

// Dominance level with p-value below 0.05
cap prog drop mydomlevelpfix
prog def mydomlevelpfix
forval t1 = 1994/2010 {
	forval t2 = 1994/2010 {
			if `t2' >= `t1' cap gen UKupdown`t2' = ""
			if `t2' <= `t1' continue
			cap confirm var hincUK`t1' hincUK`t2'
			if _rc continue
			mydomlevelpfix `t1' `t2'
		}
	}

// Dominance level and p-value
forval t1 = 1994/2010 {
	forval t2 = 1994/2010 {
			if `t2' >= `t1' cap gen UKupdown`t2' = ""
			if `t2' <= `t1' continue
			cap confirm var hincUK`t1' hincUK`t2'
			if _rc continue
			mydomlevel `t1' `t2' , record se process
		}
	}
end

// Dominance level and p-value
qui forval t1= 1994/2010 {
	cap confirm var hincUK`t1'
	if _rc continue
	loc i = `i' + 1 	
	forval t2= 1994/2010 {
		cap confirm var hincUK`t2'
		if _rc continue
		cap gen UKupdown`t2' = ""
		if `t2' <= `t1' continue
		dominance hincUK`t1' hincUK`t2', f1(f) f2(f) tol(100) n1(`N`t1'') n2(`N`t2'') ///
			se(u(.1(.1).9) m(1000) sims(1000) seed(22032013)) process
		noi di "`t1' vs `t2': up = `r(up)'; down = `r(down)'; pup=`r(p_up)', pdown=`r(p_down)', pup05=`r(p_up_05)'
		foreach r in down up {
			cap gen UK`r'`t2' = ""
			if "`r(`r'dir)'" == "hincUK`t1'" loc dir >
			if "`r(`r'dir)'" == "hincUK`t2'" loc dir <
			if "`r(`r')'" != "" {
				replace UK`r'`t2' = "`r(`r')'`dir'" if yyear == `t1'
				if "`r'"=="up" replace UKupdown`t2' = "`r(`r')'`dir'" if yyear == `t1'
				else replace UKupdown`t1' = "`r(`r')'`dir'" if yyear == `t2'
			}
			if "`r'"=="up" & r(up) <= 2 replace UKdown`t2' = "`r(up)'`dir'" if yyear == `t1'
			if inlist("`r'","meandiff","mindiff","mean","gini","sd","p10","p20","p80","p90") replace UK`r'`t2' = "``r''" if yyear == `t1'
			cap gen t`t2'_2nd = ""
			cap gen t`t2'_3rd_up = ""
			cap gen t`t2'_3rd_down = ""
			if "`r'"=="up" & r(`r') <= 2 replace t`t2'_2nd = "`dir'" if yyear == `t1'
			if r(`r') <= 3 | r(up) <= 2 replace t`t2'_3rd_`r' = "`dir'" if yyear == `t1'
			cap gen p`t2'_3rd_up = ""
			cap gen p`t2'_3rd_down = ""
			if r(`r') <= 3 | r(up) <= 2 replace p`t2'_3rd_`r' = "`r(p_`r')'" if yyear == `t1'
		}
		foreach r in updir downdir {
			cap gen UK`r'`t2' = ""
			if "`r(`r')'" != "" replace UK`r'`t2' = "`r(`r')'" if yyear == `t1'
		}
	}
}
log close

preserve
	drop hincUK* f
	export delimited using logs/all_uk1994to2001.csv, replace
restore
