clear
set more off

global path "" // write your files location here here
cd "$path"
adopath + "$path\code"

cap log close
log using logs/jobsfirst.txt, replace
insheet using data/jobsfirst.csv, clear
	
loc i = 1 
drop if quantile == 0 | quantile > .95

multisort level_comp level_treat treat_flattax treat_proptax, preserve(quantile)
gen f = _n/100

cap prog drop myanalyse
prog def myanalyse
	args y1 y2
	dominance `y1' `y2', f1(f) f2(f) tol(100) n1(2407) n2(2396) ///
		se(u(.1(.1).9) m(1000) sims(1000) seed(22032013)) process
	noi di "pup=`r(p_up)', pdown=`r(p_down)', pup05=`r(p_up_05)'"

end

myanalyse level_comp level_treat
myanalyse level_comp treat_flattax
myanalyse level_comp treat_proptax

log close

