#include <oxstd.oxh>
#include <oxdraw.oxh>
#include <oxprob.oxh>
#include <oxstd.h>
#include <oxdraw.h>
#include <oxprob.h>
#include <oxfloat.h>
#import <modelbase>
#import <simulator>
#include <packages/ssfpack/ssfpack_ex.h>
#include <packages/ssfpack/ssfnong.ox>

static decl s_mY, s_mYmu, s_mYy, s_cT, GH, GH_h, GH_z, s_J, wgt_star, smoH, mHtj;
static decl Xset, s_iM, s_iSeed, s_iAnti;
static decl sigmay, sigmamu, vPar;
static decl mPhi, mOmega, mSigma, mJ_Omega, mStSmomu, mStSmoy, mStSmo;
static decl Phi, Omega, Sigma, J_Omega, EXPh;

// This file applies UCSV, for memory index and for forecasting

SetSsf(const vP)
{
	sigmay = exp(vP[0]);
	sigmamu = exp(vP[1]);
	mOmega = diagcat(diag(sigmamu^2 ~ sigmay^2), unit(2));
	mJ_Omega = constant(-1, mOmega);
	mJ_Omega[2][2] = 0;
	mJ_Omega[3][3] = 1;
	mSigma = <-1, 0; 0, -1> | zeros(1, 2);
	mPhi = unit(2) | unit(2);	// used for G
	
	Phi = 1 | 1; Omega = unit(2); Sigma = -1 | 0;
	J_Omega = <0, -1; -1, 1>; 	// used for P
}

KFStoX(const mX)
{	
	SsfMomentEstEx(ST_SMO, &mStSmo, mX[:1][] ./ mX[2:][], mPhi, mOmega, mSigma,
		<>, <>, mJ_Omega, <>, 1.0 ./ mX[2:][]);
	return mStSmo[:1][] | mStSmo[4:5][];
}

geth_tilt(const SmoH)	// get the GaussHermite transform of theta_tilt, J^2 by T
{
	decl H_mut, H_yt, nodes_mu, nodes_y;
	H_mut = reshape(SmoH[0][], s_J^2, s_cT);
	H_yt = reshape(SmoH[1][], s_J^2, s_cT);
	nodes_mu = vec(reshape(GH_z, s_J, s_J));  	// 111 222 333
	nodes_y = reshape(GH_z, s_J^2, 1);		// 123 123 123 notice difference, product grid
	
	return H_mut + nodes_mu * sqrt(SmoH[2][]) | 
				 H_yt + nodes_y * sqrt(SmoH[3][]);
}

log2Pgh(const htj)
{
	decl sj, var_mu, var_y, logP;
	sj = rows(htj) / 2;
	var_mu = exp(htj[:sj-1][1:]~htj[:sj-1][s_cT-1]);
	var_y = exp(htj[sj:][]);
	logP = zeros(sj, s_cT);

	parallel for (decl j=0; j<sj; j++)
	{
		decl mKF = KalmanFil(s_mY, Phi, Omega, Sigma, <>, <>, J_Omega, <>, var_mu[j][]|var_y[j][]);
		decl v = mKF[0][];
		decl F = mKF[rows(mKF)-1][];
		logP[j][] = -0.5 * (-log(F) + v .^2 .* F);
	}
				
	decl pruThresh, weight_mu, weight_y, pruIndex;
	pruThresh = GH_h[0] * GH_h[floor((s_J+1)/2)] / s_J;
	weight_mu = vec(reshape(GH_h, s_J, s_J));
	weight_y = reshape(GH_h, s_J^2, 1);
	pruIndex = vecindex((weight_mu .* weight_y) .> pruThresh);
	
	return {logP, pruIndex};
}

ParallelWLS(const lp, const H_til, const weight, const PruIndex)
{
	decl GHJ, n_mX, hmu_t, hy_t, beta, i;
	GHJ = rows(H_til) / 2;
	n_mX = zeros(4, s_cT);
	hmu_t = H_til[0:GHJ-1][];	// for hmu_t
	hy_t = H_til[GHJ:][];		// for hy_t
	beta = zeros(5, s_cT);
	
	parallel for (i=0; i<s_cT; i++)
	{
	decl Y = lp[PruIndex][i].* sqrt(weight[PruIndex][i]);
	decl X = (ones(PruIndex) ~ hmu_t[PruIndex][i] ~ hy_t[PruIndex][i] ~ -0.5 * hmu_t[PruIndex][i].^2 ~
			-0.5 * hy_t[PruIndex][i].^2) .* sqrt(weight[PruIndex][i] * ones(1, 5));	
	beta[][i] = invertgen(X' * X, 3) * X' * Y;
	}
	n_mX = beta[1:4][];
	n_mX[2:3][] = fabs(n_mX[2:3][]);
	
	return n_mX;
}

iterateX()
{
	decl logg, index, logp, wgt_star, tempEXP, tempmX, i, dconv1 = 0, H_final;
	
	wgt_star = vec(reshape(GH_h, s_J, s_J)) .* reshape(GH_h, s_J^2, 1) .*
			exp(0.5 * (vec(reshape(GH_z, s_J, s_J)).^2 + reshape(GH_z, s_J^2, 1).^2)) * ones(1, s_cT);
	for (i=0; i<100; i++)
	{
		tempmX = Xset;
		smoH = KFStoX(Xset);
		mHtj = geth_tilt(smoH);
		[logp, index] = log2Pgh(mHtj);
		Xset = ParallelWLS(logp, mHtj, wgt_star, index);
		Xset[][0] = tempmX[][0];
		dconv1 = max(fabs(tempmX - Xset));
		if (dconv1 < 0.001) break;
//		if (i==0) println("approximating starts......");
//		if (imod(i, 1) == 0) println(i," ",dconv1);
	}
	H_final = KFStoX(Xset)[0:1][];
	return {H_final[0][], H_final[1][]};			
}

logLikPgH(const hmu_f, const hy_f)
{
	decl dVar=1, Likp, hmuf, hyf;
 	hmuf = exp(hmu_f[][1:]~hmu_f[][s_cT-1]);
	hyf = exp(hy_f);
	SsfLikEx(&Likp, &dVar, s_mY, Phi, Omega, Sigma, <>, <>, J_Omega, <>, hmuf|hyf);
	
	return Likp;
}

NormalLogDensitySum(const vEpsmu, const vEpsy, const vTimeVar)
{
	return  -0.5 * sumr(log(vTimeVar[0][]) + log(vTimeVar[1][]) + (vEpsmu.^2 ./ vTimeVar[0][] +
		vEpsy.^2 ./ vTimeVar[1][]));
}

SsfMCLogLik(const vP)
{
	decl Hmu, Hy, logG, dVAR=1, vWgt, verrsim, vmusim, vysim, dmeanwgts, dvarwgts, s_mGamma, mkf, mwgt,
			vystar, vtimevar, vepsstar, dlhat, vepssim, umu, uy, errmu, erry, logwgt, lw_hat, lw_bar;

	SetSsf(vP);
	vystar = Xset[:1][] ./ Xset[2:][];
	vtimevar = 1.0 ./ Xset[2:][];
	vepsstar = SsfCondDensEx(DS_SMO, vystar, mPhi, mOmega, mSigma, <>, <>, mJ_Omega, <>, vtimevar)[2:][];
	print("*");
	
	SsfLikEx(&logG, &dVAR, vystar, mPhi, mOmega, mSigma, <>, <>, mJ_Omega, <>, vtimevar);
	dlhat = logLikPgH(vystar[0][] - vepsstar[0][], vystar[1][] - vepsstar[1][]) -
			NormalLogDensitySum(vepsstar[0][1:], vepsstar[1][1:], vtimevar[][1:]);
	if (s_iM == 0) return double(logG + dlhat);
	
	ranseed(s_iSeed);
	vWgt = zeros(1, s_iM);
	decl vstdevstate = sqrt(mOmega[:1][:1]);
	decl vstdevobs = sqrt(vtimevar / 10);
	for (decl i=0; i<s_iM; i++)
	{
		decl verrsim1 = (vstdevstate * rann(2, s_cT+1)) | ((0 ~ vstdevobs).*rann(2, s_cT+1));
		decl vysim = SsfSimObs(verrsim1, mPhi, mOmega, mSigma, <>, <>, mJ_Omega, <>, zeros(2, 1) ~ vtimevar);
		decl vepssim1 = SsfCondDensEx(DS_SMO, vystar-vysim, mPhi, mOmega, mSigma, <>, <>, mJ_Omega, <>, vtimevar)[2:][];
		vepssim1 += verrsim1[2:][1:];
		vWgt[][i] = exp(logLikPgH(vystar[0][] - vepssim1[0][], vystar[1][] - vepssim1[1][]) -
			NormalLogDensitySum(vepssim1[0][], vepssim1[1][], vtimevar) - dlhat);
	}
	dmeanwgts = meanr(vWgt); dvarwgts = varr(vWgt);
	
	return double(logG + dlhat + log(dmeanwgts) + (0.5 * dvarwgts / (s_iM * sqr(dmeanwgts))));
}

LogLikelihood(const vP, const adLogLik, const avSco, const amHes)
{
	adLogLik[0] = SsfMCLogLik(vP) / s_cT;
	return 1; 
}

StdErrPar(const vP)
{
    decl covar, invcov, result;
    result = Num2Derivative(LogLikelihood, vP, &covar);
    if (!result)
    {	print("Covar() failed in numerical second derivatives\n");
        return zeros(vP);
    }
    invcov = invertgen(-covar, 3);
    return sqrt(diagonal(invcov) / s_cT)';
}

MaxLik()
{
    decl ir, dloglikmn, std_vP, trPar, trStd, tStat;
	MaxControlEps(1e-5, 1e-5);
    MaxControl(2000, 1, 1);
    ir = MaxBFGS(LogLikelihood, &vPar, &dloglikmn, 0, 1);
	std_vP = StdErrPar(vPar);

	SetSsf(vPar);
	trPar = sigmay | sigmamu;
	trStd = exp(vPar) .* std_vP;
	tStat = 2.0 * minr(probt(trPar ./ trStd, s_cT - rows(vPar) - 1) ~
		tailt(trPar ./ trStd, s_cT - rows(vPar) - 1));
    println(MaxConvergenceMsg(ir), " using numerical derivatives");
	print("parameters with standard errors:",
		"%cf", {"%12.5g", "  (%7.5f)"}, vPar ~ std_vP);
	println("estimated pars. with standard errors:",
		"%cf", {"%12.5g", "  (%7.5f)", "  %7.5f"}, trPar ~ trStd ~ tStat);
	println("Average Log-likelihood value = ", "%f", dloglikmn);
	println("Log-likelihood value = ", "%f", dloglikmn * s_cT);	
}

DrawMean(const vP)
{
	decl Hmu, Hy, allMu, varMu, logG, Y_star, dVAR=1, vWgt, vstdevstate, vstdevobs, verrsim,
		vmusim, vysim, dmeanwgts, dvarwgts, vystar, vtimevar, vepsstar, dlhat, vepssim, q, ma, lst, prE, prE_dens, s_tmp, ddv=1;

	SetSsf(vP);
	vystar = Xset[:1][] ./ Xset[2:][];
	vtimevar = 1.0 ./ Xset[2:][];
	vepsstar = SsfCondDensEx(DS_SMO, vystar, mPhi, mOmega, mSigma, <>, <>, mJ_Omega, <>, vtimevar)[2:][];
	
	SsfLikEx(&logG, &dVAR, vystar, mPhi, mOmega, mSigma, <>, <>, mJ_Omega, <>, vtimevar);
	dlhat = logLikPgH(vystar[0][] - vepsstar[0][], vystar[1][] - vepsstar[1][]) -
			NormalLogDensitySum(vepsstar[0][1:], vepsstar[1][1:], vtimevar[][1:]);
	
	if (s_iM == 0) return double(logG + dlhat);
	ranseed(s_iSeed);
	s_iM = s_iM * 10; // smooth a bit more
	Hmu = Hy = q = ma = lst = zeros(s_iM, s_cT);
	allMu = prE = varMu = zeros(s_iM, s_cT);
	prE_dens = zeros(s_iM, 1);
	vWgt = zeros(s_iM, 1);
	vstdevstate = sqrt(mOmega[:1][:1]);
	vstdevobs = sqrt(vtimevar / 10);
	for (decl i=0; i<s_iM; i++)
	{
		verrsim = (vstdevstate*rann(2, s_cT+1)) | ((0 ~ vstdevobs).*rann(2, s_cT+1));
		vysim = SsfSimObs(verrsim, mPhi, mOmega, mSigma, <>, <>, mJ_Omega, <>, zeros(2,1) ~ vtimevar);
		vepssim = SsfCondDensEx(DS_SMO, vystar-vysim, mPhi, mOmega, mSigma, <>, <>, mJ_Omega, <>, vtimevar)[2:][];
		vepssim += verrsim[2:][1:];	
		vWgt[i] = exp(logLikPgH(vystar[0][] - vepssim[0][], vystar[1][] - vepssim[1][]) -
				NormalLogDensitySum(vepssim[0][1:], vepssim[1][1:], vtimevar[][1:]) - dlhat);
		Hmu[i][] = vystar[0][] - vepssim[0][]; Hy[i][] = vystar[1][] - vepssim[1][];
		q[i][] = exp(Hmu[i][] - Hy[i][]);
		ma[i][] = 0.5 * (sqrt(q[i][].^2 + 4.0 * q[i][]) - 2.0 - q[i][]);
		lst[i][] = log((log(0.05) - log(1 + ma[i][])) ./ log(-ma[i][]));
		prE[i][] = s_mY - SsfCondDensEx(ST_SMO, s_mY, 1|1, unit(2), -1|0, <>, <>, <0,-1;-1,1>, <>, exp(vystar[0][] - vepssim[0][]) | exp(vystar[1][] - vepssim[1][]));
		SsfLikEx(&s_tmp, &ddv, s_mY, 1|1, unit(2), -1|0, <>, <>, <0,-1;-1,1>, <>, exp(vystar[0][] - vepssim[0][]) | exp(vystar[1][] - vepssim[1][]));
		prE_dens[i] = s_tmp / s_cT;
		decl mPred;
		SsfMomentEstEx(ST_SMO, &mPred, s_mY, <1;1>, unit(2), <-1;0>, <>, <>, <0,-1;-1,1>,
			<>, exp(2*Hmu[i][]) | exp(Hy[i][]));
		allMu[i][] = mPred[0][];
		varMu[i][] = mPred[2][];
	}
	decl weights = (vWgt / sumc(vWgt)) * ones(1, s_cT);
	prE = sqrt(meanr(sumc(prE .* weights).^2)); println("in-sample RMSE is: ", prE);
	prE_dens = sumc((vWgt / sumc(vWgt)) .* prE_dens); println("in-sample MPLS is: ", prE_dens);
	decl meanHmu = sumc(Hmu .* weights), meanHy = sumc(Hy .* weights), meanq = sumc(q .* weights),
		meanma = sumc(ma .* weights), meanlst = sumc(lst .* weights);
	decl varHmu = sumc((Hmu - reshape(meanHmu, s_iM, s_cT)).^2 .* weights);
	decl varHy = sumc((Hy - reshape(meanHy, s_iM, s_cT)).^2 .* weights);
	decl varq = sumc((q - reshape(meanq, s_iM, s_cT)).^2 .* weights);
	decl varma = sumc((ma - reshape(meanma, s_iM, s_cT)).^2 .* weights);
	decl varlst = sumc((lst - reshape(meanlst, s_iM, s_cT)).^2 .* weights);

	decl mn_mu  = sqrt(exp(meanHmu));
	decl se1_mu = sqrt(exp(meanHmu - 1.98 * sqrt(varHmu)));
	decl se2_mu = sqrt(exp(meanHmu + 1.98 * sqrt(varHmu)));
	
	decl mn_y  = sqrt(exp(meanHy));
	decl se1_y = sqrt(exp(meanHy - 1.98 * sqrt(varHy)));
	decl se2_y = sqrt(exp(meanHy + 1.98 * sqrt(varHy)));

	decl mn_lst = meanlst;
	decl se1_lst = meanlst - 1.98 * sqrt(varlst);
	decl se2_lst = meanlst + 1.98 * sqrt(varlst);

	decl mn_ma = meanma;
	decl se1_ma = meanma - 1.98 * sqrt(varma);
	decl se2_ma = meanma + 1.98 * sqrt(varma);

	decl Mu_SV = sumc(allMu .* weights);
	decl var_mn_Mu = sumc(varMu .* weights);
	decl var_Mu = sumc((allMu - Mu_SV).^2 .* weights) + var_mn_Mu;
	decl se1_Mu_SV = Mu_SV - 1.98 * sqrt(var_Mu);
	decl se2_Mu_SV = Mu_SV + 1.98 * sqrt(var_Mu);
	
	SetDrawWindow("UCSV");
	DrawTitle(0, "(i)");
	DrawTMatrix(0, Mu_SV, "core inflation LLM-SV", 1960, 1, 4, 0, 3);
	DrawTMatrix(0, se1_Mu_SV, <>, 1960, 1, 4, 0, 6);
	DrawTMatrix(0, se2_Mu_SV, <>, 1960, 1, 4, 0, 6);
	DrawTMatrix(0, s_mY, "quaterly inflation", 1960, 1, 4, 1, 1);

	DrawTitle(3, "(iv)");
	DrawTMatrix(3, mn_y, "transitory volatility", 1960, 1, 4, 0, 3);
	DrawTMatrix(3, se1_y, <>, 1960, 1, 4, 0, 6);
	DrawTMatrix(3, se2_y, <>, 1960, 1, 4, 0, 6);
	
	DrawTitle(2, "(iii)");
	DrawTMatrix(2, mn_mu, "permanent volatility", 1960, 1, 4, 0, 3);
	DrawTMatrix(2, se1_mu, <>, 1960, 1, 4, 0, 6);
	DrawTMatrix(2, se2_mu, <>, 1960, 1, 4, 0, 6);

	DrawTitle(1, "(ii)");
	DrawTMatrix(1, mn_lst, "memory index", 1960, 1, 4, 0, 3);
	DrawTMatrix(1, se1_lst, <>, 1960, 1, 4, 0, 6);
	DrawTMatrix(1, se2_lst, <>, 1960, 1, 4, 0, 6);
}

Forecast(const vP, const sL, const sh)
{
	decl Hmu, Hy, allMu, varMu, logG, Y_star, dVAR=1, vWgt, vstdevstate, vstdevobs, verrsim,
		vmusim, vysim, vepssim, vystar, vtimevar, vepsstar, dlhat;

	SetSsf(vP);
	vystar = Xset[:1][] ./ Xset[2:][];
	vtimevar = 1.0 ./ Xset[2:][];
	vepsstar = SsfCondDensEx(DS_SMO, vystar, mPhi, mOmega, mSigma, <>, <>, mJ_Omega, <>, vtimevar)[2:][];
	
	dlhat = logLikPgH(vystar[0][] - vepsstar[0][], vystar[1][] - vepsstar[1][]) -
			NormalLogDensitySum(vepsstar[0][1:], vepsstar[1][1:], vtimevar[][1:]);
	
	ranseed(s_iSeed);
	s_iM = s_iM * 10; // smooth a bit more
	Hmu = Hy = zeros(s_iM, s_cT);
	allMu = varMu = zeros(s_iM, s_cT);
	vWgt = zeros(s_iM, 1);
	vstdevstate = sqrt(mOmega[:1][:1]);
	vstdevobs = sqrt(vtimevar / 10);
	for (decl i=0; i<s_iM; i++)
	{
		verrsim = (vstdevstate*rann(2, s_cT+1)) | ((0 ~ vstdevobs).*rann(2, s_cT+1));
		vysim = SsfSimObs(verrsim, mPhi, mOmega, mSigma, <>, <>, mJ_Omega, <>, zeros(2,1) ~ vtimevar);
		vepssim = SsfCondDensEx(DS_SMO, vystar-vysim, mPhi, mOmega, mSigma, <>, <>, mJ_Omega, <>, vtimevar)[2:][];
		vepssim += verrsim[2:][1:];	
		vWgt[i] = exp(logLikPgH(vystar[0][] - vepssim[0][], vystar[1][] - vepssim[1][]) -
				NormalLogDensitySum(vepssim[0][1:], vepssim[1][1:], vtimevar[][1:]) - dlhat);
		Hmu[i][] = vystar[0][] - vepssim[0][]; Hy[i][] = vystar[1][] - vepssim[1][];
	}
	decl weights, Mu_SV, var_mn_Mu, var_Mu, se1_Mu_SV, se2_Mu_SV;
	weights = (vWgt / sumc(vWgt)) * ones(1, s_cT);
	Hmu = sumc(Hmu .* weights);
	Hy = sumc(Hy .* weights);

	decl vMSE, vMLS, MSE, MLS, mFor, mFor_var, var_mu, var_y;
	MSE = zeros(1, sh);
	MLS = zeros(1, sh);
	var_mu = exp(2*Hmu);
	var_y = exp(Hy);
	mFor = mFor_var = M_NAN * ones(sh, s_cT - sL - 1);
	
	for (decl i=0; i<s_cT - sL - 1; i++)
	{
		decl mPred, tmp_vmu, tmp_vy;
		tmp_vmu = var_mu[][:sL+i] ~ var_mu[][sL+i] * ones(1, sh);
		tmp_vy = var_y[][:sL+i] ~ var_y[][sL+i] * ones(1, sh);
		SsfMomentEstEx(ST_SMO, &mPred, s_mY[][:sL+i] ~ M_NAN * ones(1, sh), Phi, Omega, Sigma, <>, <>,
			J_Omega, <>, tmp_vmu | tmp_vy);
			
		mFor[][i] = mPred[1][sL+i+1:]';
		mFor_var[][i] = mPred[3][sL+i+1:]';
	}
	
	for (decl i=0; i<sh; i++)
	{
		decl pred_err, tmp_var, likscore;
		pred_err = s_mY[][sL+i+1:] - mFor[i][:columns(s_mY[][sL+i+1:])-1];
		MSE[][i] = sqrt(meanr(pred_err.^2));

		tmp_var = mFor_var[i][:columns(s_mY[][sL+i+1:])-1];
		likscore = -0.5 * (log(M_2PI) + log(tmp_var) + pred_err.^2 ./ tmp_var);
		MLS[][i] = meanr(likscore);
	}

	return MSE | MLS;
}

main()
{
	// data import
	decl raw_data, cutoff;
	GH = loadmat("GH10.xlsx");
	GH_z = GH[][0];
	GH_h = GH[][1];	// change GaussHermite nodes #
	s_J = rows(GH_z);

	s_mY = loadmat("US_Data.csv")[][0]';	
	s_cT = columns(s_mY);


	// initialization
	sigmay = 0.4;
	sigmamu = 0.1;
	vPar = log(sigmay) | log(sigmamu);
	SetSsf(vPar);
	Xset = -ones(2, s_cT) | ones(2, s_cT);
	iterateX();

	// estimation
	// simulation admin
	s_iM = 200;
	s_iSeed = 100;
	s_iAnti = 4;	// number of antithetics

	// estimation
	MaxLik();
	DrawMean(vPar);
	ShowDrawWindow();

	// forecast
//	decl mPred, sTrain, sStep;
//	sTrain = 189;	// use expanding window
//	sStep = 4; 		// step-ahead forecast
//	mPred = Forecast(vPar, 189, 4);
//	println(mPred);
}
