function ml = mlikelihood(para_,Ystar,YY,XX,XY)
global lambdas k N T Tstar %YY XX XY %K0P_cP K1P_cP;
% global datamat W dt maturity;%

%para_ is teta_draw

[GYY,GXY,GXX,retcode] = Moments(para_); %compute moments

if retcode == 0; ml = -3e+10; return; end; % case of nonstationarity or other problems
Phi_stard = GXX\GXY;
Sig_stard = GYY -GXY'*Phi_stard;

if isinf(lambdas)
    
    
    ml = -0.5*N*T*log(2*pi)-0.5*T*log(det(Sig_stard)) ...
         -0.5*sum(diag(inv(Sig_stard)*(YY-2*Phi_stard'*XY+Phi_stard'*XX*Phi_stard))); %#ok<MINV>
     
elseif ~isinf(lambdas);
    
    %mixed moments
	MYY = YY + Tstar*GYY;
	MXY = XY + Tstar*GXY;
	MXX = XX + Tstar*GXX;
    Sig_tilde = (MYY -MXY'/MXX*MXY)/(T+Tstar);
    
    % check positive definiteness of inv(S)
    [~,p] = chol(inv(Sig_tilde*(T+Tstar)));
    if p > 0; ml = -3e+10; return; end;

    %ML (Eq. A5)
	lnkapt = -0.5*N*T*log(2*pi) + 0.5*N*T*log(2);
    for i = 1:N
    lnkapt = lnkapt+gammaln(0.5*(T+Tstar-k+1-i))-gammaln(0.5*(Tstar-k+1-i));  
    end
    %this seems to provide the best numerical behavior
    ml  = lnkapt  - 0.5*(T+Tstar-k)*log(det((T+Tstar)*Sig_tilde)) ...
                  + 0.5*(Tstar-k)*log(det(Tstar*Sig_stard)) ... 
                  - 0.5*N*log(det(MXX)) ...
                  + 0.5*N*log(det(Tstar*GXX));
          
% compare with standard matricvariate T formula              
% mvtLogpdf(Ystar,Xstar*B0,inv(eye(T-T0)+Xstar*Omega0*Xstar'), S_prior, v0)
% X=Ystar;
% MU=Xstar*B0;
% P=inv(eye(T-T0)+Xstar*Omega0*Xstar');
% Q=S_prior; 
% v=Tstar-k;
% [p q] = size(X);
% %p=p+3; %To adjust smaple size
% lnkapt = 0.5*q*(p+3)*log(pi) -0.5*q*log(det(P))-0.5*v*log(det(Q)); 
% %%Dickey version, Karlsson uses 0.5*p*log(det(Q))
% for i = 1:q
% lnkapt = lnkapt+gammaln(0.5*(v+1-i))-gammaln(0.5*(v+1-i+p));  
% end
% logp  = -lnkapt  - 0.5*(p+v)*log(det(Q+(X-MU)'*P*(X-MU)));



%   alternative 1
% 	ml  = lnkapt  - 0.5*(T+Tstar-k)*log(det((T+Tstar)*Sig_tilde)) + 0.5*(Tstar-k)*log(det(Tstar*Sig_stard)) ...
%     - 0.5*N*log(det(MXX)/det(Tstar*GXX));

%   alternative 2, Longer but more instructive way to compute it  
%   %% Compute OLS estimates for dummy observations    
%   lnkaptd = 0.5*N*(Tstar-k)*log(2);
%   i = 1;    while i <= N;
%      lnkaptd = lnkaptd + gammaln(0.5*(Tstar-k+1-i));
%   i =i+1;   end;      
%   pYtd  = lnkaptd  - 0.5*(Tstar-k)*log(det(Tstar*Sig_stard)) - 0.5*N*log(det(Tstar*GXX));
% 
%   %% Compute OLS estimates for actual and dummy observations 
%   lnkapt = -0.5*T*N*log(2*pi) + 0.5*N*(T+Tstar-k)*log(2);
%   i = 1;    while i <= N;
%      lnkapt = lnkapt + gammaln(0.5*(T+Tstar-k+1-i));
%   i = i+1;  end;          
%   pYt  = lnkapt  - 0.5*(T+Tstar-k)*log(det((T+Tstar)*Sig_tilde)) - 0.5*N*log(det(MXX));
% 
%   %% Put toghether
%   ml  = pYt - pYtd;
    
end

         

