% Forecasting economic variables
% Last checking: 05/23/2019

function prediction_Y=prediction(XDATA,ZDATA,YDATA,Y_T,r_f,k_f,h,method)
if method==0 % forecasting using the level I(1) data

[Tsample,N1sample]=size(XDATA);% Specifying the sample size for estimating common factors
% YDATA=(Tsample+h)-dimensional vector
YDATA_h=YDATA((Tsample+h)-(Tsample-k_f)+1:Tsample+h);% dependent variable in the forecasting equation
YDATA_0=YDATA(Tsample-(Tsample-k_f)+1:Tsample);% vector of Y_T
if k_f==0 && r_f==0
    REG=[ZDATA(k_f+1:end,:), YDATA_0];% regressors when r_f=0 and k_f=0
elseif r_f>0 && k_f==0
    Fhat=estimation_fac(XDATA,r_f,0);% estimated I(1) factors
    REG=[ZDATA(k_f+1:end,:), Fhat(k_f+1:end,:), YDATA_0];% regressors when r_f>0 and k_f=0
elseif r_f==0 && k_f>0
    Y_lags=zeros(Tsample-k_f,k_f);% bins for lagged Y
   for jj=1:k_f
    Y_lags(:,jj)=YDATA(k_f+1-jj:Tsample-jj);% lagged Y
   end
    REG=[ZDATA(k_f+1:end,:), YDATA_0, Y_lags];% regressors when r_f=0 and k_f>0
elseif r_f>0 && k_f>0
    Fhat=estimation_fac(XDATA,r_f,0);% estimated I(1) factors
    Y_lags=zeros(Tsample-k_f,k_f);% bins for lagged Y
   for jj=1:k_f
    Y_lags(:,jj)=YDATA(k_f+1-jj:Tsample-jj);% lagged Y
   end
    REG=[ZDATA(k_f+1:end,:), Fhat(k_f+1:end,:), YDATA_0, Y_lags];% regressors when r_f>0 and k_f>0
end

delta_L=(REG'*REG)\REG'*YDATA_h;% OLS estimate
fitted_Y_L=REG*delta_L;% pridicted value
prediction_Y=fitted_Y_L(end);% prediction output

elseif method==1 % forecasting using the differenced I(0) data

DXDATA=XDATA;yDATA=YDATA;zDATA=ZDATA;% Redefining the variables
[Tsample_1,Nsample]=size(DXDATA);% Specifying the sample size for estimating common factors
% yDATA=(Tsample_1+h)-dimensional vector
yDATA_h=yDATA((Tsample_1+h)-(Tsample_1-k_f)+1:Tsample_1+h);% dependent variable in the forecasting equation (conventional)
yDATA_0=yDATA(Tsample_1-(Tsample_1-k_f)+1:Tsample_1);% vector of y_T
if k_f==0 && r_f==0
    reg=[zDATA(k_f+1:end,:), yDATA_0];% regressors when r_f=0 and k_f=0
elseif r_f>0 && k_f==0
    fhat=estimation_fac(DXDATA,r_f,1);% estimated I(1) factors
    reg=[zDATA(k_f+1:end,:), fhat(k_f+1:end,:), yDATA_0];% regressors when r_f>0 and k_f=0
elseif r_f==0 && k_f>0
    y_lags=zeros(Tsample_1-k_f,k_f);% bins for lagged Y
   for jj=1:k_f
    y_lags(:,jj)=yDATA(k_f+1-jj:Tsample_1-jj);% lagged Y
   end
    reg=[zDATA(k_f+1:end,:), yDATA_0, y_lags];% regressors when r_f=0 and k_f>0
elseif r_f>0 && k_f>0
    fhat=estimation_fac(DXDATA,r_f,1);% estimated I(1) factors
    y_lags=zeros(Tsample_1-k_f,k_f);% bins for lagged Y
   for jj=1:k_f
    y_lags(:,jj)=yDATA(k_f+1-jj:Tsample_1-jj);% lagged Y
   end
    reg=[zDATA(k_f+1:end,:), fhat(k_f+1:end,:), yDATA_0, y_lags];% regressors when r_f>0 and k_f>0
end

delta_D=(reg'*reg)\reg'*yDATA_h;% OLS estimate
fitted_Y_D=reg*delta_D;% pridicted value
prediction_Y=Y_T+sum(fitted_Y_D(end-h+1:end));% prediction output

end
end