% Modified Diebold-Mariano test (Harvey, Leybourne, and Newbold, 1997): They suggest that improved small-sample properties can be obtained by (i) making a bias correction to the DM test statistic, and (ii) comparing the corrected statistic with a Student-t distribution with (T-1) degrees of freedom, rather than the standard normal
% method=1 : quadratic loss function
% method=2 : absolute value loss function

function [mdm, mpv]=mdbtest(e_1t,e_2t,h,method)

TF=length(e_1t); % length of forecasts

if method==1
   
 d_t=e_2t.^2 - e_1t.^2;% quadratic loss differential
 d=mean(d_t);% mean of loss differential
   
elseif method==2

 d_t=abs(e_2t)-abs(e_1t);% absolute loss differential
 d=mean(d_t);% mean of loss differential

end

[fd]=specden(d_t);% computed spectral density

dm=d/sqrt((2*pi*fd)/TF);% original DM test statistic
mdm=dm*sqrt((TF+1-2*h+(h*(h-1)/TF))/TF);% modified DM test statistic
mpv=2*(1-tcdf(abs(dm),TF-1));% p-value based on the t-distribution with TF-1 degrees of freedom

end