% Diebold-Mariano test (1995)
% method=1 : quadratic loss function
% method=2 : absolute value loss function


function [dm, pv]=dbtest(e_1t,e_2t,method)

TF=length(e_1t); % length of forecasts

if method==1
   
 d_t=e_2t.^2 - e_1t.^2;% quadratic loss differential
 d=mean(d_t);% mean of loss differential

    
elseif method==2

 d_t=abs(e_2t) - abs(e_1t);% absolute loss differential
 d=mean(d_t);% mean of loss differential

end

[fd]=specden(d_t);% spectral density of loss differential

dm=d/sqrt((2*pi*fd)/TF);% test statistic
pv=2*(1-normcdf(abs(dm)));% p value

end