% Determining the dimension of common factors
% This function is based on Bai's (2004) IPC_1 criterion
% Last checking: 05/20/2019

function opt_r=IPC_1(X,rmax)
% X=T by N matrix of a dataset
% rmax=prespecified the maximum factor dimensions
[T,N]=size(X);
[Fhatmax, Lhatmax, ehatmax, vkmax]=estimation_fac(X,rmax,0);
sigmasqhat=vkmax;
alpha_T=T/(4*log(log(T)));
g_NT=((N+T)/(N*T))*log((N*T)/(N+T));
IPC=zeros(rmax+1,1);
IPC(1)=(1/(N*T))*sum(sum(X.^2));% sum of squared residuals for the zero factor case (in this case, there is no penalty term)
for kk=2:length(IPC)
    [Fhat, Lhat, ehat, vk]=estimation_fac(X,kk-1,0);
    IPC(kk)=vk+(kk-1)*sigmasqhat*alpha_T*g_NT;
end
opt_r=find(IPC==min(IPC))-1;