
% Generate histogram (and save as .mat and .png) from (sims x Nlist) matrix 
function make_histogram(histinput,listN,ind_legend,legend_position,sims,...
                        filename_path,x_range,x_ticks,x_tick_labels,ind_location)

    figure;
    save([filename_path '.mat']);
    hist(histinput,x_range); 
    if length(x_tick_labels)==1; set(gca,'XTick',x_ticks,'FontSize',22);
    else;                        set(gca,'XTick',x_ticks,'XTickLabel',x_tick_labels,'FontSize',22);
    end
    ylim([0 sims]);
    xlim([min(x_range)-0.5 max(x_range)+0.5]);
    
    %if (max(x_range) == 11|max(x_range) == 20); xlim([0 max(x_range)]);
    %end
    
    % For histogram of breakpoint locations
    if ind_location == 1
        axis([0,max(x_range),0,sims]);
        set(gca,'XTick',x_ticks,'FontSize',19);
    end
    
    % Legend
    if ind_legend == 1 
        legend_list_byN = {};
        for Nindex = 1:1:length(listN); legend_list_byN = [legend_list_byN, ['N = ' num2str(listN(Nindex))]];
        end 
        legend(legend_list_byN,'FontSize',25,'Location',legend_position)
    elseif ind_legend == 2
        legend({'Change size = 0.01','Change size = 0.015','Change size = 0.02'},'FontSize',19,'Location',legend_position)
    end
    
    
    % Colour
    abc = findobj(gca,'Type','patch');
    set(abc(1),'Facecolor',[0 0 0.5],'FaceAlpha',1,'EdgeColor','k');
    set(abc(2),'Facecolor',[0 0 0.8],'FaceAlpha',0.4,'EdgeColor','k');
    set(abc(3),'Facecolor',[0 0 0.8],'FaceAlpha',0.1,'EdgeColor','k');
    
    saveas(gcf,[filename_path '.png'],'png')
    saveas(gcf,[filename_path '.eps'],'eps')

end