% est_numbbreaks_pls: returns the break point estimator from panel data with
% multiple breaks using pooled least squares. Estimates optimal number of breakpoints.
function [breakvecEst] = est_numbbreaks_pls(y,xMatrix,N,T,penaltytype)

% Compute matrix with all possible SSR from all possible segmentations
% of the time interval 1 : T
SSR_seg = ones(T,T)*(-100000);
for j = 1 : T
    for i = 1 : j
        SSR_seg(j,i) = compute_ssr(y(N*(i-1)+1:N*j),xMatrix(N*(i-1)+1:N*j,:));
    end
end

% Minimize over number of breakpoints
SSR_breaknumb = zeros(T,1);
Optbreakcomb_ind = zeros(T,1);
SSR_breaknumb(T,1) = SSR_seg(T,1); % Speacial case: no break point (put last in vector)
timewindow_breaks = 1 : T-1;
% For large T, for efficiency search only over 1 to 6 breaks
if (T > 20)
    breaknumb_search_list = 1 : 6; 
    IC_search_list = [breaknumb_search_list,T];
else
    breaknumb_search_list = 1 : T-1;
    IC_search_list = 1 : T;
end
for break_numb = breaknumb_search_list
    breakcomb_matrix = nchoosek(timewindow_breaks,break_numb);
    [breakcomb_numb,~] = size(breakcomb_matrix);
    SSR_matrix = zeros(breakcomb_numb,break_numb+1);
    for i = 1 : breakcomb_numb
        for j = 1 : break_numb + 1
            if j == 1; lower = 0;
            else;      lower = breakcomb_matrix(i,j-1);
            end
            if j == break_numb + 1; upper = T;
            else;                   upper = breakcomb_matrix(i,j);
            end
            SSR_matrix(i,j) = SSR_seg(upper,lower+1);
        end
    end
    SSR_sum = sum(SSR_matrix,2); % Sum over all segments
    % Minimize over all possible number of breaks
    [SSR_sum_min,min_ind] = min(SSR_sum);
    SSR_breaknumb(break_numb,1)    = SSR_sum_min;
    Optbreakcomb_ind(break_numb,1) = min_ind;
end
[~,p] = size(xMatrix);
count_breaks = zeros(T,1);
count_breaks(1:T-1,1) = 1:T-1;

% Information Criterion (IC) to be minimized (see Hall et al. WP 2013)
if     (penaltytype == 1); penaltyPart2 = log(N*T)/(N*T);      % BIC-type
elseif (penaltytype == 2); penaltyPart2 = log(log(N*T))/(N*T); % HQIC-type
end
penalty = ( p*(count_breaks+1) + 3*count_breaks ) * penaltyPart2;
IC = log(SSR_breaknumb) + penalty;

% Minimize IC and return the respective vector of breakpoints
[~,minSSR_ind] = min(IC(IC_search_list));
if (minSSR_ind==length(breaknumb_search_list)+1); est_breaknumb = 0;
else;                                             est_breaknumb = (minSSR_ind);
end
est_breakcomb_matrix = nchoosek(timewindow_breaks,est_breaknumb);
if (est_breaknumb == 0); breakvecEst = NaN;
else;                    breakvecEst = est_breakcomb_matrix(Optbreakcomb_ind(est_breaknumb),:);
    
end











