% est_beta_panelbreak: returns the SFE/FFE estimates of beta and 
% estimates for their variances, for given breakpoint vector: breakvecEst
function [betaSfeEstimator,betaFfeEstimator,varBetaSfeEstimator,...
          CovBetaSfeEstimator,varBetaFfeEstimator,CovBetaFfeEstimator]...
         = est_beta_panelmultibreak(y,xArray,X,breakvecEst,timevarReg_ind,se_type)
     
[N,T,p] = size(xArray);
if isnan(breakvecEst); break_numb = 0;
else;                  [break_numb,~] = size(breakvecEst);
end

% Drop columns in xMatrix of time-constant regressors
X_timevar = X(:,timevarReg_ind);
[p_timevar,~] = size(timevarReg_ind);

% If no breaks: Standard within transformation on full sample (fixed effects)
if break_numb == 0 
    indexRegime = 1:N*T;
    xDemeaned = within_transform(X_timevar(indexRegime,:),N);
    yDemeaned = within_transform(        y(indexRegime,:),N);
    betaSfeEstimator = regress( yDemeaned, xDemeaned );

    % Compute Standard Errors (no heteroscedasticity or serial correlation)
    [~,ptemp] = size(xDemeaned);
    stats = regstats(yDemeaned,xDemeaned,eye(ptemp),{'beta','covb'});
    CovBetaSfeEstimator = stats.covb;
    varBetaSfeEstimator = diag(CovBetaSfeEstimator);
    betaFfeEstimator    = [];
    varBetaFfeEstimator = [];
    CovBetaFfeEstimator = [];
else  
    %%%%% Compute SFE (time-constant regressors have to be dropped) %%%%%
    for regime = 1 : break_numb + 1
        % Demean X and y within group within each regime
        if regime == 1 
            indexRegime = 1:N*breakvecEst(regime,1);
            xSubSampleDemeaned = within_transform(X_timevar(indexRegime,:),N);
            ySubSampleDemeaned = within_transform(      y(indexRegime,:),N);
        elseif regime == break_numb + 1
            indexRegime = N*breakvecEst(regime-1,1)+1:N*T;
            xSubSampleDemeaned = [xSubSampleDemeaned; within_transform(X_timevar(indexRegime,:),N)];
            ySubSampleDemeaned = [ySubSampleDemeaned; within_transform(      y(indexRegime,:),N)];
        else
            indexRegime = N*breakvecEst(regime-1,1)+1:N*breakvecEst(regime,1);
            xSubSampleDemeaned = [xSubSampleDemeaned; within_transform(X_timevar(indexRegime,:),N)];
            ySubSampleDemeaned = [ySubSampleDemeaned; within_transform(      y(indexRegime,:),N)];
        end 
    end
    % Compute SFE estimator for beta
    xMatrix_par = diagonal_partition_multi(xSubSampleDemeaned,N,T,breakvecEst);
    betaSfeEstimator = regress( ySubSampleDemeaned, xMatrix_par );
    % Compute Standard Errors
    Omega_1 = [];
    residFE = [];
    %loop over regimes r
    for r = 1 : break_numb + 1
        Omega_rr = zeros(p_timevar,p_timevar);
        if (r == 1)            
            regime_start   = 1;
            regime_start_t = 1;
        else
            regime_start   = breakvecEst(r-1)*N+1;
            regime_start_t = breakvecEst(r-1)+1;
        end
        if (r == break_numb+1) 
            regime_end   = N*T;
            regime_end_t = T;
        else
            regime_end   = breakvecEst(r)*N;
            regime_end_t = breakvecEst(r);
        end
        for it = regime_start : regime_end
            Omega_rr = Omega_rr + xSubSampleDemeaned(it,:)' * xSubSampleDemeaned(it,:);
        end
        residFE = [ residFE ; ySubSampleDemeaned(regime_start:regime_end,1) - xSubSampleDemeaned(regime_start:regime_end,:)*betaSfeEstimator((r-1)*p_timevar+1:r*p_timevar,1) ];
        Omega_1 = blkdiag(Omega_1,Omega_rr);
    end            
    W_1 = zeros((break_numb+1)*p_timevar,(break_numb+1)*p_timevar);
    for i = 1 : N
        wi = [];
        wi_blockd = [];
        for r = 1 : break_numb + 1
            wi_r = zeros(p_timevar,1);
            if (r == 1)            regime_start_t = 1;
            else                   regime_start_t = breakvecEst(r-1)+1;
            end
            if (r == break_numb+1) regime_end_t = T;
            else                   regime_end_t = breakvecEst(r);
            end
            for t = regime_start_t : regime_end_t
                wi_r = [ wi_r + xSubSampleDemeaned((t-1)*N+i,:)' .* residFE((t-1)*N+i,1) ];
            end
            wi = [wi ; wi_r];
            wi_blockd = blkdiag(wi_blockd,wi_r*wi_r');
        end
        % Case A: autocorr.- and heterosk.-robust
        if     (se_type == 0.3); W_1 = W_1 + wi * wi';
        % Case B: no autocorr. and heterosk.-robust
        elseif (se_type == 0.2); W_1 = W_1 + wi_blockd;
        end 
    end            
    CovBetaSfeEstimator = Omega_1^(-1) * W_1 * Omega_1^(-1);
    % Case C: no autocorr.- and cond. homosked
    if (se_type == 0.1)
        sigma2_FE = 0;
        for it = 1:N*T
           sigma2_FE = sigma2_FE + residFE(it,1)^2;
        end
        sigma2_FE = sigma2_FE/(N*(T-1)-2*p_timevar);
        CovBetaSfeEstimator = sigma2_FE .* Omega_1^(-1);
    end  
    varBetaSfeEstimator = diag(CovBetaSfeEstimator);    

    %%%%% Compute FFE estimator %%%%% 
    lambda = zeros(break_numb,1);
    for seg = 1 : break_numb + 1
        if     seg == 1;             lambda(seg) = breakvecEst(seg) / T;
        elseif seg == break_numb +1; lambda(seg) = ( T - breakvecEst(break_numb) ) / T;
        else;                        lambda(seg) = ( breakvecEst(seg) - breakvecEst(seg-1) ) / T;
        end
    end
    xTilde_matrix = zeros(N*T,break_numb*p);
    for seg = 1 : break_numb + 1
        if     seg == 1;             xMatrix_seg = X( 1                         :breakvecEst(seg)*N,:);
        elseif seg == break_numb +1; xMatrix_seg = X(breakvecEst(break_numb)*N+1: T              *N,:);
        else;                        xMatrix_seg = X(breakvecEst(seg-1)*N+1     :breakvecEst(seg)*N,:);
        end
        xArray_seg = reshape(xMatrix_seg,N,[],p);
        meanXi = repmat(reshape(mean(xArray_seg,2),N,p),T,1);
        diagnoal_Xit = diagonal_partition_multi(X,N,T,breakvecEst);
        xTilde_matrix(:,p*(seg-1)+1 : p*seg) = diagnoal_Xit(:,p*(seg-1)+1 : p*seg) - lambda(seg)*meanXi;
    end
    [~,ptemp] = size(xTilde_matrix);
    yFullSampleDemeaned = within_transform(y,N);
    % Adjust xTilde_matrix; From first segment of xTilde_matrix: drop columns with time-constant regressor (also drop constant)
    xTilde_matrix_adj = xTilde_matrix(:,timevarReg_ind); 
    xTilde_matrix_adj = [xTilde_matrix_adj,xTilde_matrix(:,p+1:ptemp)];
    betaFfeEstimator = regress( yFullSampleDemeaned, xTilde_matrix_adj );
    % Compute Standard Errors
    if (se_type == 0.1 || se_type == 0.2 || se_type == 0.3)
        % Compute Standard Errors (assumes number of breaks = 1)
        [p_all_FFE,~] = size(betaFfeEstimator);
        residFFE = yFullSampleDemeaned - xTilde_matrix_adj * betaFfeEstimator ;
        Omega_3 = zeros(p_all_FFE,p_all_FFE);
        W_3 = zeros(p_all_FFE,p_all_FFE);
        sigma2_FFE = 0;
        sumi_xit_star = zeros(p_all_FFE,p_all_FFE);
        for i = 1 : N
            wi_3 = zeros(p_all_FFE,1);
            sumt_xit_star = zeros(p_all_FFE,1);
            for t = 1 : T
                wi_3 = wi_3 + xTilde_matrix_adj((t-1)*N+i,:)' .* residFFE((t-1)*N+i,1) ;
                sumt_xit_star = sumt_xit_star + xTilde_matrix_adj((t-1)*N+i,:)';
                Omega_3 = Omega_3 + xTilde_matrix_adj((t-1)*N+i,:)' * xTilde_matrix_adj((t-1)*N+i,:);
                % Case C: no autocorr.- and cond. homosked
                if (se_type == 0.1); sigma2_FFE = sigma2_FFE + residFFE((t-1)*N+i,1)^2;
                end
            end
            sumi_xit_star = sumi_xit_star + sumt_xit_star * sumt_xit_star';
            % Case A (or B): autocorr.- and heterosk.-robust (no autocorr. and heterosk.-robust)
            if     (se_type == 0.3||se_type == 0.2); W_3 = W_3 + wi_3*wi_3';
            end
        end
        sigma2_FFE = sigma2_FFE/(N*(T-1)-p_all_FFE);
        if (se_type == 0.1); W_3 = sigma2_FFE .* ( Omega_3 - 1/T .* sumi_xit_star );
        end
        CovBetaFfeEstimator = Omega_3^(-1) * W_3 * Omega_3^(-1);
        varBetaFfeEstimator = diag(CovBetaFfeEstimator);
    elseif (se_type == 0)
        % Compute Standard Errors (no heteroscedasticity or serial correlation)
        [~,p_all_FFE] = size(xTilde_matrix_adj);
        stats = regstats(yFullSampleDemeaned,xTilde_matrix_adj,eye(p_all_FFE),{'beta','covb'});
        CovBetaFfeEstimator = stats.covb;
        varBetaFfeEstimator = diag(CovBetaFfeEstimator);
    end
    % Included placeholder for non-identified intercept of the first segment
    betaFfeEstimator_temp = betaFfeEstimator;
    varBetaFfeEstimator_temp = varBetaFfeEstimator;
    betaFfeEstimator = [];
    varBetaFfeEstimator = [];
    q = 1;
    for j = 1 : p
        if ismember(j,timevarReg_ind) == 0 
            betaFfeEstimator    = [betaFfeEstimator; NaN];
            varBetaFfeEstimator = [varBetaFfeEstimator; NaN];
        else 
            betaFfeEstimator    = [betaFfeEstimator; betaFfeEstimator_temp(q)];
            varBetaFfeEstimator = [varBetaFfeEstimator; varBetaFfeEstimator_temp(q)];
            q = q + 1;
        end
    end
    [templength,~] = size(betaFfeEstimator_temp);
    betaFfeEstimator = [betaFfeEstimator; betaFfeEstimator_temp(q:templength,1)];        
    varBetaFfeEstimator = [varBetaFfeEstimator; varBetaFfeEstimator_temp(q:templength,1)];

end

end



