% array_to_latex_table: Generate latex table from array
function array_to_latex_table(string_array,ColLabels,RowLabels,Table_caption,DataFormat)
    input.data = string_array;
    % Set column labels (use empty string for no label):
    input.tableColLabels = ColLabels;
    %size(input.tableColLabels)
    % Set row labels (use empty string for no label):
    %input.tableRowLabels = {};
    input.tableRowLabels = RowLabels;
    % Switch transposing/pivoting your table:
    input.transposeTable = 0;
    % Determine whether input.dataFormat is applied column or row based:
    input.dataFormatMode = 'column'; % use 'column' or 'row'. if not set 'colum' is used
    input.dataFormat = DataFormat;
    % Define how NaN values in input.tableData should be printed in the LaTex table:
    input.dataNanString = '-';
    % Column alignment in Latex table ('l'=left-justified, 'c'=centered,'r'=right-justified):
    input.tableColumnAlignment = 'c';
    % Switch table borders on/off:
    input.tableBorders = 1;
    % LaTex table caption:
    tableCap = Table_caption;
    input.tableCaption = tableCap;
    % LaTex table label:
    input.tableLabel = 'MyTableLabel';
    % Switch to generate a complete LaTex document or just a table:
    input.makeCompleteLatexDocument = 0;
    % call latexTable:
    latexTable(input);
end