%% Initialize variables.
filename = 'hexp.csv';
delimiter = ';';
startRow = 2;

%% Format string for each line of text:
%   column1: double (%f)
%	column2: double (%f)
%   column3: double (%f)
%	column4: double (%f)
%   column5: double (%f)
%	column6: double (%f)
%   column7: double (%f)
%	column8: double (%f)
%   column9: double (%f)
%	column10: double (%f)
%   column11: double (%f)
%	column12: double (%f)
%   column13: double (%f)
%	column14: double (%f)
%   column15: double (%f)
%	column16: double (%f)
%   column17: double (%f)
%	column18: double (%f)
% For more information, see the TEXTSCAN documentation.
formatSpec = '%f%f%f%f%f%f%f%f%f%f%f%f%f%f%f%f%f%f%[^\n\r]';

%% Open the text file.
fileID = fopen(filename,'r');

%% Read columns of data according to format string.
% This call is based on the structure of the file used to generate this
% code. If an error occurs for a different file, try regenerating the code
% from the Import Tool.
dataArray = textscan(fileID, formatSpec, 'Delimiter', delimiter, 'EmptyValue' ,NaN,'HeaderLines' ,startRow-1, 'ReturnOnError', false);

%% Close the text file.
fclose(fileID);

%% Post processing for unimportable data.
% No unimportable data rules were applied during the import, so no post
% processing code is included. To generate code which works for
% unimportable data, select unimportable cells in a file and regenerate the
% script.

%% Allocate imported array to column variable names
id = dataArray{:, 1};
waveid = dataArray{:, 2};
he1y = dataArray{:, 3};
he5y = dataArray{:, 4};
urngq = dataArray{:, 5};
hg1_nsa = dataArray{:, 6};
lhv = dataArray{:, 7};
logfamilyincomePC = dataArray{:, 8};
householdsize = dataArray{:, 9};
age = dataArray{:, 10};
female = dataArray{:, 11};
schooling = dataArray{:, 12};
white1 = dataArray{:, 13};
married = dataArray{:, 14};
health = dataArray{:, 15};
ecoSent = dataArray{:, 16};
genSent = dataArray{:, 17};
sand = dataArray{:, 18};


%% Clear temporary variables
clearvars filename delimiter startRow formatSpec fileID dataArray ans;