#ifndef __FILE_SNP_STAT_MOD_H_SEEN__
#define __FILE_SNP_STAT_MOD_H_SEEN__

/*-----------------------------------------------------------------------------

Copyright (C) 2014

A. Ronald Gallant
Post Office Box 659
Chapel Hill NC 27514-0659
USA   

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License along
with this program; if not, write to the Free Software Foundation, Inc.,
51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.

-----------------------------------------------------------------------------*/

// This code is from gsm_develop/svfx.  
// Errors discovered here should be fixed there also.

#include "libsnp.h"
#include "snp.h"

namespace mle {
    
  class snp_stat_mod;

  class snp_stat_mod {
  private:
    scl::realmat Xlags;           // First few transformed and squashed
    scl::realmat Ylags;           // observations to get lags for gen_sim
    scl::realmat X;               // Transformed and squashed data or simulation
    scl::realmat Y;               // maintained by set_data_ptr for use by logl, 
    snp::parmfile pf;
    snp::trnfrm tr;
    snp::snpll ll;
    INTEGER lsim;
    INTEGER spin;
    INTEGER lrho;
    INTEGER lstats;
    bool snp_simulate(INT_32BIT& iseed, scl::realmat& sim);
  public:
    snp_stat_mod
      (const scl::realmat* dat_ptr, const std::vector<std::string>& pfvec,
       const std::vector<std::string>& alvec, std::ostream& detail);
    INTEGER len_parm() {return lrho;}
    INTEGER len_func() {return lstats;}
    INTEGER num_obs() {return Y.get_cols();}
    void    get_parm(scl::realmat& rho);
    void    set_parm(const scl::realmat& rho);
    void    set_data_ptr(const scl::realmat* dat_ptr);
    bool    support(const scl::realmat& rho);
    scl::den_val prior(const scl::realmat& rho, const scl::realmat& stats);
    bool    gen_sim(scl::realmat& sim, scl::realmat& stats);
    bool write_parmfile(const char* filename);
    scl::den_val loglikelihood();
    scl::den_val loglikelihood(scl::realmat& dlogl);
    scl::den_val loglikelihood(scl::realmat& dlogl,scl::realmat& infmat);
    scl::den_val loglikelihood
      (scl::realmat& dlogl,scl::realmat& infmat,scl::realmat& scores);
    REAL    penalty(scl::realmat& dpenalty);
  };
  
}
#endif
