/*-----------------------------------------------------------------------------

Copyright (C) 2016, 2018

A. Ronald Gallant
Post Office Box 659
Chapel Hill NC 27514-0659
USA   

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License along
with this program; if not, write to the Free Software Foundation, Inc.,
51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.

-----------------------------------------------------------------------------*/

#include "libscl.h"
#include "crra_mf.h"

using namespace std;
using namespace scl;

// data(1,t) = sr = stock returns as decimal
// data(2,t) = cg = consumption growth

// Constant Relative Risk Aversion

// beta = theta[1]
// gamma = theta[2]

// mrs = beta*cg^{-gamma}
// lmrs = log(beta) - gamma*lcg

namespace mle {


realmat crra_moment_function::operator()(INTEGER t)
{
  REAL e;

  REAL lsr = (*dat)(1,t);   //log gross stock return
  REAL lcg = (*dat)(2,t);   //log consumption growth

  REAL lsrlag = (*dat)(1,t-1);
  REAL lcglag = (*dat)(2,t-1);

  REAL beta  = mrs_parm[1];
  REAL gamma = mrs_parm[2];

  REAL lmrs = log(beta) - gamma*lcg;

  e = 1.0 - exp(lmrs + lsr);

  realmat m(n_moments,1);

  m[1]  = e;
  m[2]  = lsrlag*e;
  m[3]  = lcglag*e;

  return m;
}

}
