#ifndef __FILE_CRRA_MF_H_SEEN__
#define __FILE_CRRA_MF_H_SEEN__

/*-----------------------------------------------------------------------------

Copyright (C) 2016, 2018

A. Ronald Gallant
Post Office Box 659
Chapel Hill NC 27514-0659
USA   

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License along
with this program; if not, write to the Free Software Foundation, Inc.,
51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.

-----------------------------------------------------------------------------*/

const INTEGER n_moments = 2;

// data(1,t) = lsr = log stock gross returns
// data(2,t) = lcg = log consumption growth

// Constant Relative Risk Aversion

// beta = theta[1]
// gamma = theta[2]

// mrs = beta*cg^{-gamma}
// lmrs = log(beta) - gamma*lcg

namespace mle {

class crra_moment_function :  public scl::moment_function_base {
private:
  const scl::realmat* dat;
  INTEGER sample_size;
  INTEGER L;
  scl::realmat mrs_parm;
public:
  crra_moment_function() : dat(0),sample_size(0),L(0),mrs_parm(2,1) { }
  bool set_data(const scl::realmat* datptr) {dat=datptr; return true;}
  bool set_sample_size(INTEGER n) {sample_size = n; return true;}
  bool set_L(INTEGER lag) {L=lag; return true;}
  bool set_theta(const scl::realmat& parm) {mrs_parm = parm; return true;}
  INTEGER get_T0() {return 4;}
  INTEGER get_d() {return n_moments;}
  scl::realmat operator()(INTEGER t);
};

}
#endif
