#ifndef __FILE_MLE_H_SEEN__
#define __FILE_MLE_H_SEEN__

/*-----------------------------------------------------------------------------

Copyright (C) 2013.

A. Ronald Gallant
Post Office Box 659
Chapel Hill NC 27514-0659
USA   

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License along
with this program; if not, write to the Free Software Foundation, Inc.,
51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.

-----------------------------------------------------------------------------*/

#include "libmle.h"
#include "mle_base.h"
#include "mleusr.h"

namespace mle {
    
  class mleparms {
  private:
    std::vector<std::string> history;
    estblock est_blk;
    datblock dat_blk;
    modblock mod_blk;
    scl::realmat rho;
    scl::intvec rho_mask;
    scl::realmat rho_increment;
    scl::realmat prop_scale;
    libmle::prop_def prop_groups; 
    std::vector<std::string> usrparms;
    std::vector<std::string> mod_alvec;
    std::vector<std::string> obj_alvec;
    std::vector<std::string> grouptxt;
    std::vector<std::string> parmrhs;
    std::vector<std::string> scalerhs;
    std::vector<std::string> incrhs;
  public:
    mleparms() {}
    bool read_parms(const char* filename, std::ostream& detail);
    bool set_parms(const std::vector<std::string>& pf, std::ostream& detail);
    bool write_parms(std::string parmfile, std::string prefix, 
      INT_32BIT seed, const scl::realmat& rho_last, 
      const scl::realmat& rho_mode, const scl::realmat& sig) const;
    void set_estblock(const estblock& eb);
    void set_rho(const scl::realmat& r);
    const estblock& get_estblock() const {return est_blk;}
    const datblock& get_datblock() const {return dat_blk;}
    const modblock& get_modblock() const {return mod_blk;}
    const std::vector<std::string> get_mod_alvec() const {return mod_alvec;}
    const std::vector<std::string> get_obj_alvec() const {return obj_alvec;}
    const scl::realmat& get_rho() const {return rho;}
    const scl::intvec& get_rho_mask() const {return rho_mask;}
    const scl::realmat& get_rho_increment() const {return rho_increment;}
    const scl::realmat& get_prop_scale() const {return prop_scale;}
    const libmle::prop_def& get_prop_groups() const {return prop_groups;}
    const std::vector<std::string>& get_usrparms() const {return usrparms;}
  };
  
}

#endif
