library(MASS)

prefix <- "Z_0050"

ps.options(horizontal=FALSE,onefile=FALSE)
ps.options(pagecentre=TRUE)
ps.options(paper="letter")
ps.options(width=7.0,height=5.0)

filename <- paste(prefix,".dat",sep="");

z <- read.table(filename,sep="",header=FALSE)

z1 <- z[,1]
z2 <- z[,2]
z3 <- z[,3]

filename <- "00f0f0f0f1800000.sim"
s1 <- scan(filename);

print(mean(s1))

pvals <- seq(0.001,0.999,0.001)

filename <- paste(prefix,"_1_qq_snp.eps",sep="");
postscript(file=filename)

zval1 <- quantile(z1,probs=pvals)

sval1 <- quantile(s1,probs=pvals)

plot(sval1,zval1,type="n",ylab="",main=expression(Z[1]))
lines(sval1,zval1,lty="solid")

dev.off()



