#include "libscl.h"
#include "spline_interpolator.h"

using namespace std;
using namespace scl;

const bool debug = true;

int main(int argc, char** argp, char** envp)
{

  INTEGER n_knots = 25;

  realmat Phi(n_knots,2);

  for (INTEGER i=1; i<=n_knots; ++i) {
    REAL x = -4.0 + 8.0*REAL(i-1)/REAL(n_knots-1);
    Phi(i,1) = x;
    Phi(i,2) = pnorm(x);
  }

  string filename = "normal_knots.txt";

  writetable(filename.c_str(),Phi,25,16);

  return 0;
}

