********************* RATS program, from 
********************* Carriero, Clark, and Marcellino, "Assessing International Commonality in Macroeconomic Uncertainty 
********************* and Its Effects," Journal of Applied Econometrics
********************* computing historical decomposition for BVAR-GFSV model with quarterly data for the U.S., EA, and UK
********************* 

dis %dateandtime()
dis %ratsversion()

*********************
********************* BASIC SETUP & PARAMETER ENTRY
*********************
comp ndraws = 5000                     ;* # of draws used

comp styr = 1983
comp freq = 4
if freq==12
 cal(m) styr:1
else
 cal(q) styr:1
endif
comp stsmpl = styr:1	;*earliest period with data
comp endsmpl = 2013:3      ;* last data observation (will use same data sample as for other models)

comp nvar = 67	;* number of variables in the VAR
comp nus = 26   ;* number of U.S. variables in the model (variables 1 through nus in order)
comp nfact = 2  ;* number of common volatility factors in the model
comp nfactx = 1 ;* only the first factor is in the VAR's conditional mean
comp fixlags = 2	;* fixed lag order to use in VAR
comp flags = 2      ;* AR order of log factor process, corresponding to length of lags included in VAR's conditional mean

all endsmpl
smpl stsmpl endsmpl

env nowshowgraphs
gsave(format=pdf) "HDcalc_3economies_*.pdf"

*********************
********************* READING IN DATA and determining available sample
*********************
dec vec[ser] y(nvar) yraw(nvar)
dec vec[str] varlabel(nvar+nfact)
do i = 1,nfact
 comp varlabel(nvar+i) = "log uncertainty factor " + %string(i)
end do i

open data data/GCPdata.xlsx

data(format=xlsx,org=col,sheet="US") / REAL_GDP	REAL_CONSUMPTION REAL_GOVT_CONSUMPTION REAL_INVESTMENT REAL_EXPORTS REAL_IMPORTS $
  REAL_INVENTORIES_CHANGE_OVER_GDP ULC TOTAL_EMPLOYMENT	HOURS_WORKED UNEMPLOYMENT_RATE SHORT_TERM_RATE BOND_YIELD_2Y $
  BOND_YIELD_10Y M2 $
  OIL_PRICE COMMODITY_PRICES CONSUMER_PRICES CPIXFE $
  PPI	REAL_HOUSING_INVESTMENT	STOCK_MKT_INDEX	CAPACITY_UTILIZATION	CONSUMER_CONFIDENCE	$
  INDUSTRIAL_CONFIDENCE	PMI
comp n = 0
dofor i =  REAL_GDP	REAL_CONSUMPTION REAL_GOVT_CONSUMPTION REAL_INVESTMENT REAL_EXPORTS REAL_IMPORTS $
  REAL_INVENTORIES_CHANGE_OVER_GDP ULC TOTAL_EMPLOYMENT	HOURS_WORKED UNEMPLOYMENT_RATE SHORT_TERM_RATE BOND_YIELD_2Y $
  BOND_YIELD_10Y M2  $
  OIL_PRICE COMMODITY_PRICES CONSUMER_PRICES CPIXFE $
  PPI	REAL_HOUSING_INVESTMENT	STOCK_MKT_INDEX	CAPACITY_UTILIZATION	CONSUMER_CONFIDENCE	$
  INDUSTRIAL_CONFIDENCE	PMI
 comp n = n+1
 set yraw(n) = i{0}
 comp varlabel(n) = "US " + %l(i)
end do i

clear REAL_GDP	REAL_CONSUMPTION REAL_GOVT_CONSUMPTION REAL_INVESTMENT REAL_EXPORTS REAL_IMPORTS $
  REAL_INVENTORIES_CHANGE_OVER_GDP ULC TOTAL_EMPLOYMENT	HOURS_WORKED UNEMPLOYMENT_RATE SHORT_TERM_RATE BOND_YIELD_2Y $
  BOND_YIELD_10Y M2  $
  OIL_PRICE COMMODITY_PRICES CONSUMER_PRICES CPIXFE $
  PPI	REAL_HOUSING_INVESTMENT	STOCK_MKT_INDEX	CAPACITY_UTILIZATION	CONSUMER_CONFIDENCE	$
  INDUSTRIAL_CONFIDENCE	PMI

data(format=xlsx,org=col,sheet="EA") / REAL_GDP REAL_CONSUMPTION REAL_GOVT_CONSUMPTION REAL_INVESTMENT REAL_EXPORTS	REAL_IMPORTS $
  REAL_INVENTORIES_CHANGE_OVER_GDP	ULC	TOTAL_EMPLOYMENT	UNEMPLOYMENT_RATE	SHORT_TERM_RATE	BOND_YIELD_2Y $	
  BOND_YIELD_10Y	$
  M3		$
  GDP_DEFLATOR	CONSUMER_PRICES	CONSUMER_PRICES_EXCL_ENERGY_FOOD	PPI	REAL_HOUSING_INVESTMENT	$
  STOCK_MKT_INDEX	CAPACITY_UTILIZATION	CONSUMER_CONFIDENCE	INDUSTRIAL_CONFIDENCE	PMI	LABOR_SHORTAGES
dofor i = REAL_GDP REAL_CONSUMPTION REAL_GOVT_CONSUMPTION REAL_INVESTMENT REAL_EXPORTS	REAL_IMPORTS $
  REAL_INVENTORIES_CHANGE_OVER_GDP		ULC	TOTAL_EMPLOYMENT	UNEMPLOYMENT_RATE	SHORT_TERM_RATE	BOND_YIELD_2Y $	
  BOND_YIELD_10Y	$
  M3		$
  GDP_DEFLATOR	CONSUMER_PRICES	CONSUMER_PRICES_EXCL_ENERGY_FOOD	PPI	REAL_HOUSING_INVESTMENT	$
  STOCK_MKT_INDEX	CAPACITY_UTILIZATION	CONSUMER_CONFIDENCE	INDUSTRIAL_CONFIDENCE	PMI	LABOR_SHORTAGES	
 comp n = n+1
 set yraw(n) = i{0}
 comp varlabel(n) = "EA " + %l(i)
end do i
close

open data data/UK_Haver.xlsx

data(format=xlsx,org=col,sheet="quarterly") / gdp	consumption	gov	investment	export	import	ulc	industrial_confidence 
dofor i =  gdp	consumption	gov	investment	export	import	ulc	industrial_confidence 
 comp n = n+1
 set yraw(n) = i{0}
 comp varlabel(n) = "UK " + %l(i)
end do i

data(format=xlsx,org=col,sheet="monthly") / consumer_confidence employment	unemployment_rate ppi rpi policy_rate bondyield10y stockprice
dofor i = consumer_confidence employment	unemployment_rate ppi rpi policy_rate bondyield10y stockprice
 comp n = n+1
 set yraw(n) = i{0}
 comp varlabel(n) = "UK " + %l(i)
end do i
close

comp basestsmpl = stsmpl
do i = 1,nvar
 inquire(series=yraw(i)) stpt endpt
 comp nobs = endpt-stpt+1
 dis %l(i) @15 %datelabel(stpt) %datelabel(endpt)
 stats(noprint) yraw(i)
 if %nobs<>nobs
  dis 'missing obs = ' (nobs-%nobs)
 comp basestsmpl = %imax(basestsmpl,stpt)
 comp endsmpl = %imin(endsmpl,endpt)
end do i

dis %datelabel(basestsmpl) %datelabel(endsmpl)

*** data transformations
comp [vec[int]] transvec = ||5,5,5,5,5,5,1,5,5,5,1,1,1,1,5,5,5,5,5,5,5,5,1,1,1,1,5,5,5,5,5,5,1,5,5,1,1,1,1,5,5,5,5,5,5,5,1,1,1,1,1,5,5,5,5,5,5,5,1,1,5,1,5,5,1,1,5||
if %rows(transvec)<>nvar
 dis "mismatch of nvar and rows of transvec; nvar, rows = " nvar transvec
endif

*** set up data vector
smpl basestsmpl endsmpl
do i = 1,nvar
 if transvec(i)==1
  set y(i) = yraw(i){0}
 else if transvec(i)==2
  diff yraw(i) basestsmpl+1 endsmpl y(i)
 else if transvec(i)==3
  diff(diffs=2) yraw(i)  basestsmpl+2 endsmpl y(i)
 else if transvec(i)==4
  set y(i) = 100.*log(yraw(i){0})
 else if transvec(i)==5
  set y(i) basestsmpl+1 endsmpl = 100.*log(yraw(i){0}/yraw(i){1})
 else if transvec(i)==6
  {
   set tempser = 100.*log(yraw(i){0})
   diff(diffs=2) tempser  basestsmpl+2 endsmpl y(i)
  }
end do i

** now adjust basestsmpl to reflect differencing
comp basestsmpl = basestsmpl+1

******************************** define sample and standardize data
******************************** 
******************************** 
comp basestsmpl = basestsmpl+fixlags
smpl basestsmpl endsmpl
dis %datelabel(basestsmpl) %datelabel(endsmpl)

comp [vec] keepscales = %fill(nvar,1,1.0)
do i = 1,nvar
 stats(noprint) y(i)
 set(scratch) y(i) basestsmpl-fixlags endsmpl = (y(i){0}-%mean)/%variance^0.5
 comp keepscales(i) = %variance^0.5
end do i

********************************
******************************** stuff needed below
********************************
comp ncoef = fixlags*nvar+nfactx*(flags+1)    ;* # of coefs in VAR (each equation)
comp nfcoef = flags+nvar               ;* # of coefs in factor equations

** procedure for historical decomposition calculation
sou(noecho) procedures/histdecomp.GFSV_restricted.src

********************************
******************************** reading draws of params. and states from files
******************************** note: to reduce storage needs, rather than store draws of Sigma(t), we will reconstruct them from the draws of A and Lambda(t)
********************************
comp directory = "draws_3economies/"

**** dimensioning
dec vec[vec] PhiRes(ndraws) Psi0Res(ndraws) 
dec vec[rec] PiRes(ndraws) Ares(ndraws) fcoefres(ndraws) loadingRes(ndraws)
dec rec[ser] LambdaRes(ndraws,nvar) hres(ndraws,nvar) factorRes(ndraws,nfact) uncertshocks(ndraws,nfact)
dec rec[symm] SigmaRes(ndraws,endsmpl)  

*** Pi (draws of matrices of VAR coefs)
comp thisroot = 'Pi'
comp filename = directory+thisroot+'.prn'
open data &filename
do i = 1,ndraws
 dim PiRes(i)(ncoef,nvar)
 read PiRes(i)
end do i
close data

*** A (vec(draws) of matrix of A coefs)
comp thisroot = 'A'
comp filename = directory+thisroot+'.prn'
open data &filename
do i = 1,ndraws
 dim ARes(i)(nvar,nvar)
 read ARes(i)
end do i
close data

*** loadings on factor
comp thisroot = 'loading'
comp filename = directory+thisroot+'.prn'
open data &filename
do i = 1,ndraws
 dim loadingRes(i)(nvar,nfact)
 read loadingRes(i)
end do i
close data

*** Psi0 (intercepts of idiosyn vols)
comp thisroot = 'Psi0'
comp filename = directory+thisroot+'.prn'
open data &filename
do i = 1,ndraws
 dim Psi0Res(i)(nvar)
 read Psi0Res(i)
end do i
close data

*** factor process coefficients
comp thisroot = 'factorcoef'
comp filename = directory+thisroot+'.prn'
open data &filename
do i = 1,ndraws
 dim fcoefRes(i)(nfcoef,nfact)
 read fcoefRes(i)
end do i
close data

*** vol factors (rec array(draws, nvar) of time series)
comp ndatacol = nfact
do i = 1,ndraws
 do j = 1,ndatacol
  label factorRes(i,j)
  # "factor_"+i+"_"+j
 end do j
end do i
do i = 1,ndatacol
 comp thisroot = 'factor.n'+i
 comp filename = directory+thisroot+'.csv'
 open data &filename
 data(org=row,for=cdf) / factorRes(1,i) to factorRes(ndraws,i)
 close data
end do i

*** reduced form shocks to vol factors (rec array(draws, nvar) of time series)
comp ndatacol = nfact
do i = 1,ndraws
 do j = 1,ndatacol
  label uncertshocks(i,j)
  # "shock_"+i+"_"+j
 end do j
end do i
do i = 1,ndatacol
 comp thisroot = 'shock.n'+i
 comp filename = directory+thisroot+'.csv'
 open data &filename
 data(org=row,for=cdf) / uncertshocks(1,i) to uncertshocks(ndraws,i)
 close data
end do i

*** idiosyncratic vols (rec array(draws, nvar) of time series)
comp ndatacol = nvar
do i = 1,ndraws
 do j = 1,ndatacol
  label hRes(i,j)
  # "h_"+i+"_"+j
 end do j
end do i
do i = 1,ndatacol
 comp thisroot = 'idiosyn.n'+i
 comp filename = directory+thisroot+'.csv'
 open data &filename
 data(org=row,for=cdf) / hRes(1,i) to hRes(ndraws,i)
 close data
end do i

*** lambdas (rec array(draws, nvar) of time series)
comp ndatacol = nvar
do i = 1,ndraws
 do j = 1,ndatacol
  label lambdaRes(i,j)
  # "lambda_"+i+"_"+j
 end do j
end do i
do i = 1,ndatacol
 comp thisroot = 'lambda.n'+i
 comp filename = directory+thisroot+'.csv'
 open data &filename
 data(org=row,for=cdf) / lambdaRes(1,i) to lambdaRes(ndraws,i)
 close data
end do i

*** now rebuild Sigma(t) draws from A and Lambda
dec ser[symm] Sigma lambdamatdraw   
dec ser[vec] lambdadraw

do draws = 1,ndraws
 gset Lambdadraw = %zeros(nvar,1)
 do vtime = basestsmpl,endsmpl
  do i = 1,nvar
   comp lambdadraw(vtime)(i) = lambdaRes(draws,i)(vtime)
  end do i
 end do vtime
 gset Lambdamatdraw = %diag(lambdadraw(t))
 gset Sigma basestsmpl endsmpl = %mqform(Lambdamatdraw(t),tr(inv(ARes(draws)))) ;* Sigma = inv(A)*H*inv(A)' 
 do vtime = basestsmpl,endsmpl
  comp SigmaRes(draws,vtime) = Sigma(vtime)
 end do vtime
end do draws

********************************
******************************** construct median estimate of (log) uncertainty for use in charts
********************************
dec vec[ser] actuallogfactors(nfact)
clear(length=endsmpl) actuallogfactors

smpl 1 ndraws
do vtime = basestsmpl,endsmpl
  do i = 1,nfact
   set statser = log(factorRes(t,i)(vtime))
   comp [vec] frac = %fractiles(statser,||.5||)
   comp actuallogfactors(i)(vtime) = frac(1)
  end do i
end do vtime

********************************
******************************** compute historical decomposition for all draws
********************************

**** start and end point for historical decomposition
comp decstpt = 1998:1  
comp decendpt = endsmpl

comp starttime = %cputime()
@histdec y nfactx basestsmpl endsmpl decstpt decendpt fixlags flags ndraws PiRes Ares loadingres Psi0Res fcoefres $
 factorRes uncertshocks SigmaRes basepath udirectpath edirectpath 

dis 'historical decomp calculation run time in minutes = ' (%cputime()-starttime)/60.

********************************
******************************** tabulate medians and 70 percent sets
********************************
comp totvar = nvar+nfact
dec vec[ser] comp0_50(totvar) comp0_15(totvar) comp0_85(totvar) comp1_50(totvar) comp1_15(totvar) comp1_85(totvar) comp1m_50(totvar) comp1m_15(totvar) comp1m_85(totvar) $
 comp1f_50(totvar) comp1f_15(totvar) comp1f_85(totvar) comp2_50(totvar) comp2_15(totvar) comp2_85(totvar)  
clear(length=endsmpl) comp0_50 comp0_15 comp0_85 comp1_50 comp1_15 comp1_85 comp2_50 comp2_15 comp2_85 $
 comp1m_50 comp1m_15 comp1m_85 comp1f_50 comp1f_15 comp1f_85 

** construct median and credible set
smpl 1 ndraws
do vtime = decstpt,decendpt
  do i = 1,totvar
    ** base path
    set(scratch) statser = basepath(t,i)(vtime)
    comp [vec] frac = %fractiles(statser,||.5,.15,.85||)
    comp comp0_50(i)(vtime) = frac(1)
    comp comp0_15(i)(vtime) = frac(2)
    comp comp0_85(i)(vtime) = frac(3)
    
    ** contrib from all uncertainty shocks together
    set(scratch) statser = udirectpath(t,i)(vtime)   ;* +basepath(t,i)(vtime)
    comp [vec] frac = %fractiles(statser,||.5,.15,.85||)
    comp comp1_50(i)(vtime) = frac(1)
    comp comp1_15(i)(vtime) = frac(2)
    comp comp1_85(i)(vtime) = frac(3)

    ** contrib from VAR shocks
    set(scratch) statser = edirectpath(t,i)(vtime)   ;* +udirectpath(t,i)(vtime)+basepath(t,i)(vtime)
    comp [vec] frac = %fractiles(statser,||.5,.15,.85||)
    comp comp2_50(i)(vtime) = frac(1)
    comp comp2_15(i)(vtime) = frac(2)
    comp comp2_85(i)(vtime) = frac(3)
  end do i
end do vtime

********************************
******************************** create STACKED BAR charts, using medians of contribution estimates
********************************
comp perpage = 12
comp vf = 3
comp hf = 4
comp [vec[str]] keylab = ||"data","base path","m shocks","VAR shocks"||

comp nline = 4
dec vect[int] symbols(nline)
ewise symbols(i)=i   ;* %if(i==nline,1,i+1)

smpl decstpt decendpt

grparm(bold) header 34
grparm axislabeling 26
grparm keylabeling 10

do i = 1,totvar,perpage
 spgraph(vfields=vf,hfields=hf,klab=keylab,key=below,style=stackedbar,nopatterns) ;*
 do j = i,%imin(i+perpage-1,totvar)
  if j<=nvar
   set actualseries = y(j){0}
  else
   set actualseries = actuallogfactors(j-nvar){0}
  comp header1 = varlabel(j)
  *
  set series1 = comp0_50(j){0}
  set series2 = comp1_50(j){0}
  set series3 = comp2_50(j){0}   ;* -comp1_50(j){0}
  
  extremum(noprint) actualseries
  comp vmin = %minimum
  comp vmax = %maximum
  set checkser = series1+series2+series3
  extremum(noprint) checkser
  comp vmin = %min(%minimum,vmin)-0.25
  comp vmax = %max(%maximum,vmax)+0.25

  graph(dates,style=line,overlay=stackedbar,ovcount=(nline-1),ovsame,symbols=symbols,header=header1,max=vmax,min=vmin) nline
  # actualseries / 1
  # series1
  # series2
  # series3

 end do j
 spgraph(done)
end do i

********************************
******************************** write decomposition to file
********************************
smpl decstpt decendpt

comp filename = %unitfnroot("input")+".csv"
open copy &filename
copy(dates,org=col,for=cdf) / comp0_50 comp1_50 comp2_50 $
comp0_15 comp1_15 comp2_15 $
comp0_85 comp1_85 comp2_85 
close copy
