********************* RATS program, from 
********************* Carriero, Clark, and Marcellino, "Assessing International Commonality in Macroeconomic Uncertainty 
********************* and Its Effects," Journal of Applied Econometrics
********************* computing historical decomposition for BVAR-GFSV model with quarterly data on GDP growth in 19 countries
********************* 

dis %dateandtime()
dis %ratsversion()

*********************
********************* BASIC SETUP & PARAMETER ENTRY
*********************
comp ndraws = 5000       ;* # of draws used

comp styr = 1960
comp freq = 4
if freq==12
 cal(m) styr:1
else
 cal(q) styr:1
endif
comp stsmpl = styr:1	;*earliest period with data
comp endsmpl = 2016:4      ;* last data observation (will use same data sample as for other models)

comp nvar = 19	;* number of variables in the VAR
comp nfact = 1  ;* number of common volatility factors in the model
comp fixlags = 2	;* fixed lag order to use in VAR
comp flags = 2      ;* AR order of log factor process, corresponding to length of lags included in VAR's conditional mean

all endsmpl
smpl stsmpl endsmpl

env nowshowgraphs
gsave(format=pdf) "HDcalc_19countries_*.pdf"

*********************
********************* READING IN DATA and determining available sample
*********************
open data data/GDP_OECD.xls
data(format=xls,org=col) / US Australia Austria Belgium Canada Denmark Finland France Germany Italy Japan Luxembourg Netherlands Norway Portugal Spain Sweden Switzerland UK
close

comp basestsmpl = stsmpl
do i = 1,nvar
 inquire(series=i) stpt endpt
 comp nobs = endpt-stpt+1
 dis %l(i) @15 %datelabel(stpt) %datelabel(endpt)
 stats(noprint) i
 if %nobs<>nobs
  dis 'missing obs = ' (nobs-%nobs)
 comp basestsmpl = %imax(basestsmpl,stpt)
 comp endsmpl = %imin(endsmpl,endpt)
end do i

dis %datelabel(basestsmpl) %datelabel(endsmpl)

dec vec[ser] y(nvar)
dec vec[int] transvec(nvar)
dec vec[str] varlabel(nvar+nfact)
comp varlabel(nvar+1) = "log uncertainty factor 1"

*** set of data vector and convert simple percent changes to log growth rates, which is what we will use
smpl basestsmpl endsmpl
do i = 1,nvar
 comp transvec(i) = 5
 comp varlabel(i) = %l(i)
 set(first=1.) ylevel basestsmpl-1 endsmpl = ylevel{1}*(1.+.01*i{0})
 set y(i) = 100.*log(ylevel{0}/ylevel{1})
end do i

** outlier screening
do i = 1,nvar
 dis ""
 dis "**************************** " varlabel(i)
 stats(fractiles,noprint) y(i)
 comp iqr = %fract75-%fract25
 comp lower = %median - 6.*iqr
 comp upper = %median + 6.*iqr
 set outlier = (y(i)(t).gt.upper).or.(y(i)(t).lt.lower)
 do vtime = basestsmpl,endsmpl
  if outlier(vtime)>0
   {
    dis "outlier in " %datelabel(vtime)
    dis "old value = " y(i)(vtime)
    if y(i)(vtime).gt.upper
     comp y(i)(vtime) = upper
    else if y(i)(vtime).lt.lower
     comp y(i)(vtime) = lower
    dis "new value = " y(i)(vtime)
   }
 end do vtime
end do i

******************************** define sample and
******************************** set initial values needed
******************************** and then standardize data
comp basestsmpl = 1985:1   ;* basestsmpl+fixlags
smpl basestsmpl endsmpl
dis %datelabel(basestsmpl) %datelabel(endsmpl)

comp [vec] keepscales = %fill(nvar,1,1.0)
do i = 1,nvar
 stats(noprint) y(i)
 set(scratch) y(i) basestsmpl-fixlags endsmpl = (y(i){0}-%mean)/%variance^0.5
 comp keepscales(i) = %variance^0.5
end do i

********************************
******************************** stuff needed below
********************************
comp ncoef = fixlags*nvar+nfact*(flags+1)    ;* # of coefs in VAR (each equation)
comp nfcoef = flags+nvar               ;* # of coefs in factor equations

** procedure for historical decomposition calculation
sou(noecho) procedures/histdecomp.GFSV.src

********************************
******************************** reading draws of params. and states from files
******************************** note: to reduce storage needs, rather than store draws of Sigma(t), we will reconstruct them from the draws of A and Lambda(t)
********************************
comp directory = "draws_19countries/"

**** dimensioning
dec vec[vec] PhiRes(ndraws) Psi0Res(ndraws) Psi1Res(ndraws)
dec vec[rec] PiRes(ndraws) Ares(ndraws) fcoefres(ndraws) loadingRes(ndraws)
dec rec[ser] LambdaRes(ndraws,nvar) hres(ndraws,nvar) factorRes(ndraws,nfact) uncertshocks(ndraws,nfact)
dec rec[symm] SigmaRes(ndraws,endsmpl)  

*** Pi (draws of matrices of VAR coefs)
comp thisroot = 'Pi'
comp filename = directory+thisroot+'.prn'
open data &filename
do i = 1,ndraws
 dim PiRes(i)(ncoef,nvar)
 read PiRes(i)
end do i
close data

*** A (vec(draws) of matrix of A coefs)
comp thisroot = 'A'
comp filename = directory+thisroot+'.prn'
open data &filename
do i = 1,ndraws
 dim ARes(i)(nvar,nvar)
 read ARes(i)
end do i
close data

*** loadings on factor
comp thisroot = 'loading'
comp filename = directory+thisroot+'.prn'
open data &filename
do i = 1,ndraws
 dim loadingRes(i)(nvar,nfact)
 read loadingRes(i)
end do i
close data

*** Psi0 (intercepts of idiosyn vols)
comp thisroot = 'Psi0'
comp filename = directory+thisroot+'.prn'
open data &filename
do i = 1,ndraws
 dim Psi0Res(i)(nvar)
 read Psi0Res(i)
end do i
close data

*** Psi1 (AR(1) coefs of idiosyn vols)
comp thisroot = 'Psi1'
comp filename = directory+thisroot+'.prn'
open data &filename
do i = 1,ndraws
 dim Psi1Res(i)(nvar)
 read Psi1Res(i)
end do i
close data

*** factor process coefficients
comp thisroot = 'factorcoef'
comp filename = directory+thisroot+'.prn'
open data &filename
do i = 1,ndraws
 dim fcoefRes(i)(nfcoef,nfact)
 read fcoefRes(i)
end do i
close data

*** Phi (var-cov matrix of innovations to idiosyn. vol.)
comp thisroot = 'Phi'
comp filename = directory+thisroot+'.prn'
open data &filename
do i = 1,ndraws
 dim PhiRes(i)(nvar)
 read PhiRes(i)
end do i
close data

*** vol factors (rec array(draws, nvar) of time series)
comp ndatacol = nfact
do i = 1,ndraws
 do j = 1,ndatacol
  label factorRes(i,j)
  # "factor_"+i+"_"+j
 end do j
end do i
do i = 1,ndatacol
 comp thisroot = 'factor.n'+i
 comp filename = directory+thisroot+'.xls'
 open data &filename
 data(org=row,for=xls) / factorRes(1,i) to factorRes(ndraws,i)
 close data
end do i

*** reduced form shocks to vol factors (rec array(draws, nvar) of time series)
comp ndatacol = nfact
do i = 1,ndraws
 do j = 1,ndatacol
  label uncertshocks(i,j)
  # "shock_"+i+"_"+j
 end do j
end do i
do i = 1,ndatacol
 comp thisroot = 'shock.n'+i
 comp filename = directory+thisroot+'.xls'
 open data &filename
 data(org=row,for=xls) / uncertshocks(1,i) to uncertshocks(ndraws,i)
 close data
end do i

*** idiosyncratic vols (rec array(draws, nvar) of time series)
comp ndatacol = nvar
do i = 1,ndraws
 do j = 1,ndatacol
  label hRes(i,j)
  # "h_"+i+"_"+j
 end do j
end do i
do i = 1,ndatacol
 comp thisroot = 'idiosyn.n'+i
 comp filename = directory+thisroot+'.xls'
 open data &filename
 data(org=row,for=xls) / hRes(1,i) to hRes(ndraws,i)
 close data
end do i

*** lambdas (rec array(draws, nvar) of time series)
comp ndatacol = nvar
do i = 1,ndraws
 do j = 1,ndatacol
  label lambdaRes(i,j)
  # "lambda_"+i+"_"+j
 end do j
end do i
do i = 1,ndatacol
 comp thisroot = 'lambda.n'+i
 comp filename = directory+thisroot+'.xls'
 open data &filename
 data(org=row,for=xls) / lambdaRes(1,i) to lambdaRes(ndraws,i)
 close data
end do i

*** now rebuild Sigma(t) draws from A and Lambda
dec ser[symm] Sigma lambdamatdraw   
dec ser[vec] lambdadraw

do draws = 1,ndraws
 gset Lambdadraw = %zeros(nvar,1)
 do vtime = basestsmpl,endsmpl
  do i = 1,nvar
   comp lambdadraw(vtime)(i) = lambdaRes(draws,i)(vtime)
  end do i
 end do vtime
 gset Lambdamatdraw = %diag(lambdadraw(t))
 gset Sigma basestsmpl endsmpl = %mqform(Lambdamatdraw(t),tr(inv(ARes(draws)))) ;* Sigma = inv(A)*H*inv(A)' 
 do vtime = basestsmpl,endsmpl
  comp SigmaRes(draws,vtime) = Sigma(vtime)
 end do vtime
end do draws

********************************
******************************** construct median estimate of (log) uncertainty for use in charts
********************************
dec vec[ser] actuallogfactors(nfact)
clear(length=endsmpl) actuallogfactors

smpl 1 ndraws
do vtime = basestsmpl,endsmpl
  do i = 1,nfact
   set statser = log(factorRes(t,i)(vtime))
   comp [vec] frac = %fractiles(statser,||.5||)
   comp actuallogfactors(i)(vtime) = frac(1)
  end do i
end do vtime

********************************
******************************** compute historical decomposition for all draws
********************************

**** start and end point for historical decomposition
comp decstpt = 1987:1
comp decendpt = endsmpl

comp starttime = %cputime()
@histdec y basestsmpl endsmpl decstpt decendpt fixlags flags ndraws PiRes Ares loadingres Psi0Res Psi1Res fcoefres PhiRes hRes factorRes uncertshocks SigmaRes basepath udirectpath udirectpath_sep edirectpath 
dis 'historical decomp calculation run time in minutes = ' (%cputime()-starttime)/60.

********************************
******************************** tabulate medians and 70 percent sets
********************************
comp totvar = nvar+nfact
dec vec[ser] comp0_50(totvar) comp0_15(totvar) comp0_85(totvar) comp1_50(totvar) comp1_15(totvar) comp1_85(totvar) comp1m_50(totvar) comp1m_15(totvar) comp1m_85(totvar) $
 comp1f_50(totvar) comp1f_15(totvar) comp1f_85(totvar) comp2_50(totvar) comp2_15(totvar) comp2_85(totvar)  
clear(length=endsmpl) comp0_50 comp0_15 comp0_85 comp1_50 comp1_15 comp1_85 comp2_50 comp2_15 comp2_85 $
 comp1m_50 comp1m_15 comp1m_85 comp1f_50 comp1f_15 comp1f_85 

** construct median and credible set
smpl 1 ndraws
do vtime = decstpt,decendpt
  do i = 1,totvar
    ** base path
    set(scratch) statser = basepath(t,i)(vtime)
    comp [vec] frac = %fractiles(statser,||.5,.15,.85||)
    comp comp0_50(i)(vtime) = frac(1)
    comp comp0_15(i)(vtime) = frac(2)
    comp comp0_85(i)(vtime) = frac(3)
    
    ** contrib from all uncertainty shocks together
    set(scratch) statser = udirectpath(t,i)(vtime)   ;* +basepath(t,i)(vtime)
    comp [vec] frac = %fractiles(statser,||.5,.15,.85||)
    comp comp1_50(i)(vtime) = frac(1)
    comp comp1_15(i)(vtime) = frac(2)
    comp comp1_85(i)(vtime) = frac(3)

    ** contrib from VAR shocks
    set(scratch) statser = edirectpath(t,i)(vtime)   ;* +udirectpath(t,i)(vtime)+basepath(t,i)(vtime)
    comp [vec] frac = %fractiles(statser,||.5,.15,.85||)
    comp comp2_50(i)(vtime) = frac(1)
    comp comp2_15(i)(vtime) = frac(2)
    comp comp2_85(i)(vtime) = frac(3)
  end do i
end do vtime

********************************
******************************** create STACKED BAR charts, using medians of contribution estimates
********************************
comp perpage = 20
comp vf = 4
comp hf = 5
comp [vec[str]] keylab = ||"data","base path","m shocks","VAR shocks"||

comp nline = 4
dec vect[int] symbols(nline)
ewise symbols(i)=i   ;* %if(i==nline,1,i+1)

smpl decstpt decendpt

grparm(bold) header 34
grparm axislabeling 26
grparm keylabeling 10

do i = 1,totvar,perpage
 spgraph(vfields=vf,hfields=hf,klab=keylab,key=below,style=stackedbar,nopatterns) ;*
 do j = i,%imin(i+perpage-1,totvar)
  if j<=nvar
   set actualseries = y(j){0}
  else
   set actualseries = actuallogfactors(j-nvar){0}
  comp header1 = varlabel(j)
  *
  set series1 = comp0_50(j){0}
  set series2 = comp1_50(j){0}
  set series3 = comp2_50(j){0}   ;* -comp1_50(j){0}
  
  extremum(noprint) actualseries
  comp vmin = %minimum
  comp vmax = %maximum
  set checkser = series1+series2+series3
  extremum(noprint) checkser
  comp vmin = %min(%minimum,vmin)-0.25
  comp vmax = %max(%maximum,vmax)+0.25

  graph(dates,style=line,overlay=stackedbar,ovcount=(nline-1),ovsame,symbols=symbols,header=header1,max=vmax,min=vmin) nline
  # actualseries / 1
  # series1
  # series2
  # series3

 end do j
 spgraph(done)
end do i

********************************
******************************** write decomposition to file
********************************
smpl decstpt decendpt

comp filename = %unitfnroot("input")+".csv"
open copy &filename
copy(dates,org=col,for=cdf) / comp0_50 comp1_50 comp2_50 $
comp0_15 comp1_15 comp2_15 $
comp0_85 comp1_85 comp2_85 
close copy

