********************* RATS program, from 
********************* Carriero, Clark, and Marcellino, "Assessing International Commonality in Macroeconomic Uncertainty 
********************* and Its Effects," Journal of Applied Econometrics
********************* estimating BVAR-GFSV model with quarterly data for the U.S., EA, and UK
********************* 

dis %dateandtime()
dis %ratsversion()

*********************
********************* BASIC SETUP & PARAMETER ENTRY
*********************
comp ndraws = 5000                     ;* # of draws retained
comp burnindraws = 10000                ;* # of draws burned
comp skipint = 5                      ;* save only every 20th draw of MCMC (out of skipint*ndraws)
comp nparticle = 80

/*
comp ndraws = 100                     ;* # of draws retained
comp burnindraws = 25                ;* # of draws burned
comp skipint = 1                      ;* save only every 20th draw of MCMC (out of skipint*ndraws)
comp nparticle = 25
*/

comp styr = 1983
comp freq = 4
if freq==12
 cal(m) styr:1
else
 cal(q) styr:1
endif
comp stsmpl = styr:1	;*earliest period with data
comp endsmpl = 2013:3      ;* last data observation (will use same data sample as for other models)

comp nvar = 67	;* number of variables in the VAR
comp nus = 26   ;* number of U.S. variables in the model (variables 1 through nus in order)
comp nfact = 2  ;* number of common volatility factors in the model
comp nfactx = 1 ;* only the first factor is in the VAR's conditional mean
comp fixlags = 2	;* fixed lag order to use in VAR

all endsmpl
smpl stsmpl endsmpl

comp seedval = 3000
seed seedval
dis seedval

grparm(bold) header 14 subheader 12
grparm axislabeling 36
env nowshowgraphs
comp modeldesc = "BVAR-GFSV model, U.S., E.A., and U.K., N=67"
gsave(format=pdf) "GFSV_3economies_*.pdf"

*********************
********************* READING IN DATA and determining available sample
*********************
dec vec[ser] y(nvar) yraw(nvar)
dec vec[str] varlabel(nvar+nfact)
do i = 1,nfact
 comp varlabel(nvar+i) = "log uncertainty factor " + %string(i)
end do i

open data data/GCPdata.xlsx

data(format=xlsx,org=col,sheet="US") / REAL_GDP	REAL_CONSUMPTION REAL_GOVT_CONSUMPTION REAL_INVESTMENT REAL_EXPORTS REAL_IMPORTS $
  REAL_INVENTORIES_CHANGE_OVER_GDP ULC TOTAL_EMPLOYMENT	HOURS_WORKED UNEMPLOYMENT_RATE SHORT_TERM_RATE BOND_YIELD_2Y $
  BOND_YIELD_10Y M2 $
  OIL_PRICE COMMODITY_PRICES CONSUMER_PRICES CPIXFE $
  PPI	REAL_HOUSING_INVESTMENT	STOCK_MKT_INDEX	CAPACITY_UTILIZATION	CONSUMER_CONFIDENCE	$
  INDUSTRIAL_CONFIDENCE	PMI
comp n = 0
dofor i =  REAL_GDP	REAL_CONSUMPTION REAL_GOVT_CONSUMPTION REAL_INVESTMENT REAL_EXPORTS REAL_IMPORTS $
  REAL_INVENTORIES_CHANGE_OVER_GDP ULC TOTAL_EMPLOYMENT	HOURS_WORKED UNEMPLOYMENT_RATE SHORT_TERM_RATE BOND_YIELD_2Y $
  BOND_YIELD_10Y M2  $
  OIL_PRICE COMMODITY_PRICES CONSUMER_PRICES CPIXFE $
  PPI	REAL_HOUSING_INVESTMENT	STOCK_MKT_INDEX	CAPACITY_UTILIZATION	CONSUMER_CONFIDENCE	$
  INDUSTRIAL_CONFIDENCE	PMI
 comp n = n+1
 set yraw(n) = i{0}
 comp varlabel(n) = "US " + %l(i)
end do i

clear REAL_GDP	REAL_CONSUMPTION REAL_GOVT_CONSUMPTION REAL_INVESTMENT REAL_EXPORTS REAL_IMPORTS $
  REAL_INVENTORIES_CHANGE_OVER_GDP ULC TOTAL_EMPLOYMENT	HOURS_WORKED UNEMPLOYMENT_RATE SHORT_TERM_RATE BOND_YIELD_2Y $
  BOND_YIELD_10Y M2  $
  OIL_PRICE COMMODITY_PRICES CONSUMER_PRICES CPIXFE $
  PPI	REAL_HOUSING_INVESTMENT	STOCK_MKT_INDEX	CAPACITY_UTILIZATION	CONSUMER_CONFIDENCE	$
  INDUSTRIAL_CONFIDENCE	PMI

data(format=xlsx,org=col,sheet="EA") / REAL_GDP REAL_CONSUMPTION REAL_GOVT_CONSUMPTION REAL_INVESTMENT REAL_EXPORTS	REAL_IMPORTS $
  REAL_INVENTORIES_CHANGE_OVER_GDP	ULC	TOTAL_EMPLOYMENT	UNEMPLOYMENT_RATE	SHORT_TERM_RATE	BOND_YIELD_2Y $	
  BOND_YIELD_10Y	$
  M3		$
  GDP_DEFLATOR	CONSUMER_PRICES	CONSUMER_PRICES_EXCL_ENERGY_FOOD	PPI	REAL_HOUSING_INVESTMENT	$
  STOCK_MKT_INDEX	CAPACITY_UTILIZATION	CONSUMER_CONFIDENCE	INDUSTRIAL_CONFIDENCE	PMI	LABOR_SHORTAGES
dofor i = REAL_GDP REAL_CONSUMPTION REAL_GOVT_CONSUMPTION REAL_INVESTMENT REAL_EXPORTS	REAL_IMPORTS $
  REAL_INVENTORIES_CHANGE_OVER_GDP		ULC	TOTAL_EMPLOYMENT	UNEMPLOYMENT_RATE	SHORT_TERM_RATE	BOND_YIELD_2Y $	
  BOND_YIELD_10Y	$
  M3		$
  GDP_DEFLATOR	CONSUMER_PRICES	CONSUMER_PRICES_EXCL_ENERGY_FOOD	PPI	REAL_HOUSING_INVESTMENT	$
  STOCK_MKT_INDEX	CAPACITY_UTILIZATION	CONSUMER_CONFIDENCE	INDUSTRIAL_CONFIDENCE	PMI	LABOR_SHORTAGES	
 comp n = n+1
 set yraw(n) = i{0}
 comp varlabel(n) = "EA " + %l(i)
end do i
close

open data data/UK_Haver.xlsx

data(format=xlsx,org=col,sheet="quarterly") / gdp	consumption	gov	investment	export	import	ulc	industrial_confidence 
dofor i =  gdp	consumption	gov	investment	export	import	ulc	industrial_confidence 
 comp n = n+1
 set yraw(n) = i{0}
 comp varlabel(n) = "UK " + %l(i)
end do i

data(format=xlsx,org=col,sheet="monthly") / consumer_confidence employment	unemployment_rate ppi rpi policy_rate bondyield10y stockprice
dofor i = consumer_confidence employment	unemployment_rate ppi rpi policy_rate bondyield10y stockprice
 comp n = n+1
 set yraw(n) = i{0}
 comp varlabel(n) = "UK " + %l(i)
end do i
close

comp basestsmpl = stsmpl
do i = 1,nvar
 inquire(series=yraw(i)) stpt endpt
 comp nobs = endpt-stpt+1
 dis %l(i) @15 %datelabel(stpt) %datelabel(endpt)
 stats(noprint) yraw(i)
 if %nobs<>nobs
  dis 'missing obs = ' (nobs-%nobs)
 comp basestsmpl = %imax(basestsmpl,stpt)
 comp endsmpl = %imin(endsmpl,endpt)
end do i

dis %datelabel(basestsmpl) %datelabel(endsmpl)

*** data transformations
comp [vec[int]] transvec = ||5,5,5,5,5,5,1,5,5,5,1,1,1,1,5,5,5,5,5,5,5,5,1,1,1,1,5,5,5,5,5,5,1,5,5,1,1,1,1,5,5,5,5,5,5,5,1,1,1,1,1,5,5,5,5,5,5,5,1,1,5,1,5,5,1,1,5||
if %rows(transvec)<>nvar
 dis "mismatch of nvar and rows of transvec; nvar, rows = " nvar transvec
endif

*** set up data vector
smpl basestsmpl endsmpl
do i = 1,nvar
 if transvec(i)==1
  set y(i) = yraw(i){0}
 else if transvec(i)==2
  diff yraw(i) basestsmpl+1 endsmpl y(i)
 else if transvec(i)==3
  diff(diffs=2) yraw(i)  basestsmpl+2 endsmpl y(i)
 else if transvec(i)==4
  set y(i) = 100.*log(yraw(i){0})
 else if transvec(i)==5
  set y(i) basestsmpl+1 endsmpl = 100.*log(yraw(i){0}/yraw(i){1})
 else if transvec(i)==6
  {
   set tempser = 100.*log(yraw(i){0})
   diff(diffs=2) tempser  basestsmpl+2 endsmpl y(i)
  }
end do i

** now adjust basestsmpl to reflect differencing
comp basestsmpl = basestsmpl+1

********************************
******************************** stuff for estimation
********************************
sou(noecho) procedures/BVARGFSV.GFSV_restricted.src
sou(noecho) procedures/impresp.GFSV_restricted.src

******** prior means of first lag of dep variable in each equation (basic intention is to push VAR towards AR(1) models with coef of 0)
comp [vec] bvarprior = %fill(nvar,1,0.0)  ;* default prior mean is 0.0
comp [vec] shrinkage = ||.1,0.5,1.,1.0,1.0,0.05|| ;* overall tightness, relative weight on other lags, decay on lag
                                                  * elements 4 and 5 control coef on f(t) and f(t-1), respectively
                                                  * element 6 is prior variance on elements of A matrix

********* mean and variance of Phi, var-cov matrix of innovations to log stochastic volatility
comp flags = 2                         ;* AR order of log factor process, corresponding to length of lags included in VAR's conditional mean

comp [vec] fshockvar = ||0.03,0.03||   ;* vector of fixed variance of innovations to factor vols, with nfact rows

dec vec[vec] load_prmean(nvar) psiH_prmean(nvar)  psiF_prmean(nfact)
dec vec[symm]  load_prvar(nvar) psiH_prvar(nvar) psiF_prvar(nfact)

do i = 1,nvar
 ** prior mean and variance for factor loadings
 comp load_prmean(i) = %fill(nfact,1,1.0)
 comp load_prvar(i) = 0.5^2.*%identity(nfact)
 ** prior mean and variance for AR coefs of idiosyn. processes
 comp psiH_prmean(i) = ||0.0||
 comp psiH_prvar(i) = ||1.||
end do i

** lower the prior mean on the second factor's loadings, without changing the variance
if nfact==2
{
do i = 1,nvar
 ** prior mean and variance for factor loadings
 comp load_prmean(i)(2) = 0.5
 *comp load_prvar(i)(2,2) = 1.0
end do i
}
endif

comp nfcoef = flags+nvar
do i = 1,nfact
 comp psiF_prmean(i) = 0.9*%unitv(nfcoef,1)
 comp psiF_prvar(i) = 0.2^2.*%identity(nfcoef)   ;* prior variance for all coefs. of factor process (lagged y and lagged factor)
 dis ""
 do l = 1,flags
  comp psiF_prvar(i)(l,l) = 0.2^2.         ;* tighter (actually, same in this case) variance for lagged factor coefs of factor process
 end do l
end do i

dec rec[int] loadrestrictions(nvar,2)  ;* indicators of which variables are used to impose sign restrictions on factors.  1 or 0 in first col, factor number in second col
do i = 1,nvar
 comp loadrestrictions(i,1)=0, loadrestrictions(i,2)=0
end do i
comp loadrestrictions(1,1)=1, loadrestrictions(1,2)=1        ;* first factor

comp nsplit = nus
if nfact==2
 comp loadrestrictions(nsplit+1,1)=1, loadrestrictions(nsplit+1,2)=2        ;* second factor if applicable, here taken as GDP for EA if we have a 2nd factor
endif

******************************** define sample and standardize data
******************************** 
******************************** 
comp basestsmpl = basestsmpl+fixlags
smpl basestsmpl endsmpl
dis %datelabel(basestsmpl) %datelabel(endsmpl)

comp [vec] keepscales = %fill(nvar,1,1.0)
do i = 1,nvar
 stats(noprint) y(i)
 set(scratch) y(i) basestsmpl-fixlags endsmpl = (y(i){0}-%mean)/%variance^0.5
 comp keepscales(i) = %variance^0.5
end do i

********************************
******************************** setting up other initial stuff
********************************
smpl basestsmpl endsmpl

*** log lambda for idiosyn processes
comp [vec] lnlambdainp = %zeros(nvar,1)
dec vec[ser] Aresids(nvar)
do i = 1,nvar
  linreg(noprint) y(i) basestsmpl endsmpl Aresids(i)
  # constant y(i){1 to fixlags}
  sstats(mean) / Aresids(i){0}**2.>>lnlambdainp(i)
  comp lnlambdainp(i) = log(0.4*lnlambdainp(i))
  comp psiH_prmean(i)(1) = lnlambdainp(i)
end do i

*** initial factors
dec vec[ser] initialfactor(nfact)
do i = 1,nfact
 set initialfactor(i) stsmpl endsmpl = 1.0
end do i

* US
comp varno = 1
comp pos = 1
linreg(noprint) Aresids(varno)
# constant
garch(p=1,q=1,regressors,presample=||%seesq||,hser=garchvar) / Aresids(varno)
# constant
log garchvar / logvar
diff(center) logvar / loginitialfactor
set initialfactor(pos) = exp(loginitialfactor{0})
stats initialfactor(pos)

* 2nd factor
if nfact==2
{
comp varno = nsplit+1
comp pos = 2
linreg(noprint) Aresids(varno)
# constant
garch(p=1,q=1,regressors,presample=||%seesq||,hser=garchvar) / Aresids(varno)
# constant
log garchvar / logvar
diff(center) logvar / loginitialfactor
set initialfactor(pos) = exp(loginitialfactor{0})
stats initialfactor(pos)
}
endif

do i = 1,nvar
  dis i @5 varlabel(i) @25 psiH_prmean(i)(1) lnlambdainp(i)
end do i

********************************
******************************** model estimation
********************************
comp starttime = %cputime()
@modelestimation(prmean,noinclconst,npart=nparticle,drawtrack) y nfact nfactx basestsmpl endsmpl 0 fixlags flags ndraws burnindraws skipint bvarprior shrinkage $
 fshockvar load_prmean load_prvar loadrestrictions psiH_prmean psiH_prvar psiF_prmean psiF_prvar initialfactor PiRes ARes loadingRes Psi0Res fcoefres factorRes uncertshocks SigmaRes hres LambdaRes stdevRes
dis 'run time in minutes = ' (%cputime()-starttime)/60.

********************************
******************************** write draws of params. and states to files
******************************** set of stuff:  PiRes ARes  loadingRes loading2Res Psi0Res Psi1Res fcoefres PhiRes PhiFRes  factorRes shockres orthoshockres hres LambdaRes
******************************** note: to reduce storage needs, rather than store draws of Sigma(t), we will reconstruct them from the draws of A and Lambda(t)
comp directory = "draws_3economies/"

*** Pi (draws of matrices of VAR coefs)
comp thisroot = 'Pi'
comp filename = directory+thisroot+'.prn'
open copy &filename
write(unit=copy,for='(40F40.20)') PiRes
close copy

*** A (vec(draws) of matrix of A coefs)
comp thisroot = 'A'
comp filename = directory+thisroot+'.prn'
open copy &filename
write(unit=copy,for='(40F30.20)') ARes
close copy

*** loading matrices
comp thisroot = 'loading'
comp filename = directory+thisroot+'.prn'
open copy &filename
write(unit=copy,for='(40F40.20)')  loadingRes
close copy

*** Psi0 (intercepts of idiosyn vols)
comp thisroot = 'Psi0'
comp filename = directory+thisroot+'.prn'
open copy &filename
write(unit=copy,for='(40F40.20)') Psi0Res
close copy

*** factor process coefficients
comp thisroot = 'factorcoef'
comp filename = directory+thisroot+'.prn'
open copy &filename
write(unit=copy,for='(40F40.20)') fcoefres
close copy

*** vol factors (rec array(draws, nvar) of time series)
comp ndatacol = nfact
do i = 1,ndraws
 do j = 1,ndatacol
  label factorRes(i,j)
  # "factor_"+i+"_"+j
 end do j
end do i
do i = 1,ndatacol
 comp thisroot = 'factor.n'+i
 comp filename = directory+thisroot+'.csv'
 open copy &filename
 copy(org=row,for=cdf) / factorRes(1,i) to factorRes(ndraws,i)
 close copy
end do i

*** reduced form shocks to vol factors (rec array(draws, nvar) of time series)
comp ndatacol = nfact
do i = 1,ndraws
 do j = 1,ndatacol
  label uncertshocks(i,j)
  # "shock_"+i+"_"+j
 end do j
end do i
do i = 1,ndatacol
 comp thisroot = 'shock.n'+i
 comp filename = directory+thisroot+'.csv'
 open copy &filename
 copy(org=row,for=cdf) / uncertshocks(1,i) to uncertshocks(ndraws,i)
 close copy
end do i

*** idiosyncratic vols (rec array(draws, nvar) of time series)
comp ndatacol = nvar
do i = 1,ndraws
 do j = 1,ndatacol
  label hRes(i,j)
  # "h_"+i+"_"+j
 end do j
end do i
do i = 1,ndatacol
 comp thisroot = 'idiosyn.n'+i
 comp filename = directory+thisroot+'.csv'
 open copy &filename
 copy(org=row,for=cdf) / hRes(1,i) to hRes(ndraws,i)
 close copy
end do i

*** lambdas (rec array(draws, nvar) of time series)
comp ndatacol = nvar
do i = 1,ndraws
 do j = 1,ndatacol
  label lambdaRes(i,j)
  # "lambda_"+i+"_"+j
 end do j
end do i
do i = 1,ndatacol
 comp thisroot = 'lambda.n'+i
 comp filename = directory+thisroot+'.csv'
 open copy &filename
 copy(org=row,for=cdf) / lambdaRes(1,i) to lambdaRes(ndraws,i)
 close copy
end do i

********************************
******************************** GFSV and idiosyncratic volatility, calculating posterior stats
********************************
dec vec[ser] idiovolmedian(nvar) idiovol15(nvar) idiovol85(nvar) rfvolmedian(nvar) rfvol15(nvar) rfvol85(nvar)
clear(length=endsmpl) idiovolmedian idiovol15 idiovol85 rfvolmedian rfvol15 rfvol85 gfsvmedian gfsv15 gfsv85 gfsv2median gfsv215 gfsv285

smpl 1 ndraws
do vtime = basestsmpl,endsmpl
  do i = 1,nvar
    set(scratch) statser = hRes(t,i)(vtime)^0.5
    comp [vec] frac = %fractiles(statser,||.15,.5,.85||)
    comp idiovolmedian(i)(vtime) = frac(2)
    comp idiovol15(i)(vtime) = frac(1)
    comp idiovol85(i)(vtime) = frac(3)

    set(scratch) statser = stdevRes(t,i)(vtime)
    comp [vec] frac = %fractiles(statser,||.15,.5,.85||)
    comp rfvolmedian(i)(vtime) = frac(2)
    comp rfvol15(i)(vtime) = frac(1)
    comp rfvol85(i)(vtime) = frac(3)
  end do i

  set statser = factorRes(t,1)(vtime)^0.5
  comp [vec] frac = %fractiles(statser,||.15,.5,.85||)
  comp gfsvmedian(vtime) = frac(2)
  comp gfsv15(vtime) = frac(1)
  comp gfsv85(vtime) = frac(3)

  set statser = factorRes(t,2)(vtime)^0.5
  comp [vec] frac = %fractiles(statser,||.15,.5,.85||)
  comp gfsv2median(vtime) = frac(2)
  comp gfsv215(vtime) = frac(1)
  comp gfsv285(vtime) = frac(3)
end do vtime

**** now write to Excel files:  GFSV estimates and reduced form vols
comp filename = %unitfnroot("input")+".csv"
open copy &filename
copy(dates,org=col,for=cdf) basestsmpl endsmpl gfsvmedian gfsv15 gfsv85 rfvolmedian rfvol15 rfvol85 gfsv2median gfsv215 gfsv285 
close copy

********************************
******************************** charts of vols
********************************

comp perpage = 20
comp IRperpage = 20
comp vf = 4
comp hf = 5

comp [vec[string]] mykey_full = ||'median','15%ile','85%ile'||
smpl basestsmpl endsmpl

******************************** reduced-form volatilities
comp header1 = 'Innovation volatility estimate: ' + modeldesc
comp subheader = '(standard deviation)'
do i = 1,nvar,perpage
 grparm(bold) header 14
 spgraph(vfields=vf,hfields=hf,header=header1,subheader=subheader)
 grparm(bold) header 22
 do j = i,%imin(i+perpage-1,nvar)
  comp header = varlabel(j)
  graph(header=header,dates,key=below,klab=mykey_full) 3
  # rfvolmedian(j) / 1
  # rfvol15(j) / 2
  # rfvol85(j) / 2
 end do j
 spgraph(done)
end do i

******************************** uncertainty estimates

*** because this is a 1 by 1 chart, reset some chart fonts to defaults
grparm(bold) header 14
grparm axislabeling 18
comp nlines = 3

comp header = "Uncertainty estimates, factor 1"
graph(header=header,dates,key=below,klab=||'unc. factor 1^0.5 (left)','15%ile','85%ile'||) nlines
# gfsvmedian / 1
# gfsv15 / 2
# gfsv85 / 2

comp header = "Uncertainty estimates, factor 2"
graph(header=header,dates,key=below,klab=||'unc. factor 2^0.5 (left)','15%ile','85%ile'||) nlines
# gfsv2median / 1
# gfsv215 / 2
# gfsv285 / 2

cmom(corr,print)
# gfsvmedian gfsv2median
dis(store=string1) "correlation = " #.### %cmom(2,1)

comp nlines = 2
comp header = "Uncertainty estimates, factor 1 and 2 together"
spgraph(vfields=1,hfields=1,header=header)
graph(dates,key=below,klab=||'factor 1 (left)', 'factor 2 (right)'||,overlay=line,ovcount=1) nlines
# gfsvmedian / 1
# gfsv2median / 2
grtext(position=upleft,bold,size=16) string1
spgraph(done)

********************************
******************************** simple impulse responses, uncertainty shocks
********************************
comp starttime = %cputime()
comp nsteps = 4*freq
dec vec[ser] uncertmedian(nfact)
set uncertmedian(1) basestsmpl endsmpl = log(gfsvmedian{0}^2.)
set uncertmedian(2) basestsmpl endsmpl = log(gfsv2median{0}^2.)

@impresp(noinclconst,undiff=transvec) y uncertmedian nfactx basestsmpl endsmpl fixlags flags ndraws nsteps PiRes fcoefres fshockvar SigmaRes simpleIRs
dis 'var decomp calculation run time in minutes = ' (%cputime()-starttime)/60.

dec rec[ser] simIRmedian(nvar+nfact,nfactx) simIR15(nvar+nfact,nfactx) simIR85(nvar+nfact,nfactx)
clear(length=nsteps) simIRmedian simIR15 simIR85

** construct median and credible set:  response to US uncert
smpl 1 ndraws
do vtime = 1,nsteps
 do nn = 1,nfactx
  do i = 1,nvar+nfact
    if i<=nvar
     set(scratch) statser = keepscales(i)*simpleIRs(t,(nn-1)*(nvar+nfact)+i)(vtime)
    else
     set(scratch) statser = simpleIRs(t,(nn-1)*(nvar+nfact)+i)(vtime)
    comp [vec] frac = %fractiles(statser,||.15,.5,.85||)
    comp simIRmedian(i,nn)(vtime) = frac(2)
    comp simIR15(i,nn)(vtime) = frac(1)
    comp simIR85(i,nn)(vtime) = frac(3)
  end do i
 end do nn
end do vtime

** make charts
smpl 1 nsteps

grparm axislabeling 36

do nn = 1,nfactx
 comp header = 'Simple impulse responses to uncertainty shock: factor ' + %string(nn)
 do i = 1,nvar+nfact,IRperpage
  grparm(bold) header 14
  spgraph(vfields=vf,hfields=hf,header=header)
  grparm(bold) header 22
  do j = i,%imin(i+IRperpage-1,nvar+nfact)
   comp header1 = varlabel(j)
   graph(ticks,number=0,ovcount=2,overlay=fan,ovsame,header=header1) 3
   # simirmedian(j,nn) / 1
   # simir15(j,nn) / 2
   # simir85(j,nn) / 2
  end do j
  spgraph(done)
 end do i
end do nn

** write to Excel
smpl 1 nsteps
comp filename = %unitfnroot("input")+".impresp.csv"
open copy &filename
copy(dates,org=col,for=cdf) / simIRmedian simIR15 simIR85
close copy
