********************* RATS program, from
********************* Carriero, Clark, and Marcellino, "Assessing International Commonality in Macroeconomic Uncertainty
********************* and Its Effects," Journal of Applied Econometrics
********************* Creating Figure 6 after reading in estimates created by other estimation program

*********************
********************* BASIC SETUP & PARAMETER ENTRY
*********************
comp ndraws = 5000       ;* # of draws used

comp styr = 1960
comp freq = 4
if freq==12
 cal(m) styr:1
else
 cal(q) styr:1
endif
comp stsmpl = styr:1	;*earliest period with data
comp endsmpl = 2016:4      ;* last data observation (will use same data sample as for other models)

comp nvar = 19	;* number of variables in the VAR
comp nfact = 1  ;* number of common volatility factors in the model

comp fixlags = 2	;* fixed lag order to use in VAR
comp flags = 2      ;* AR order of log factor process, corresponding to length of lags included in VAR's conditional mean

all endsmpl
smpl stsmpl endsmpl

*env noshowgraphs
*gsave(format=pdf) "Figure6.pdf"

*********************
********************* READING IN DATA and determining available sample
*********************
open data data/GDP_OECD.xls  ;*
data(format=xls,org=col) / US Australia Austria Belgium Canada Denmark Finland France Germany Italy Japan Luxembourg Netherlands Norway Portugal Spain Sweden Switzerland UK
close

comp basestsmpl = stsmpl
do i = 1,nvar
 inquire(series=i) stpt endpt
 comp nobs = endpt-stpt+1
 dis %l(i) @15 %datelabel(stpt) %datelabel(endpt)
 stats(noprint) i
 if %nobs<>nobs
  dis 'missing obs = ' (nobs-%nobs)
 comp basestsmpl = %imax(basestsmpl,stpt)
 comp endsmpl = %imin(endsmpl,endpt)
end do i

dis %datelabel(basestsmpl) %datelabel(endsmpl)

dec vec[ser] y(nvar)
dec vec[int] transvec(nvar)
dec vec[str] varlabel(nvar+nfact)
comp varlabel(nvar+1) = "log uncertainty factor 1"

*** set of data vector and convert simple percent changes to log growth rates, which is what we will use
smpl basestsmpl endsmpl
do i = 1,nvar
 comp transvec(i) = 5
 comp varlabel(i) = %l(i)
 set(first=1.) ylevel basestsmpl-1 endsmpl = ylevel{1}*(1.+.01*i{0})
 set y(i) = 100.*log(ylevel{0}/ylevel{1})
end do i

** outlier screening
do i = 1,nvar
 dis ""
 dis "**************************** " varlabel(i)
 stats(fractiles,noprint) y(i)
 comp iqr = %fract75-%fract25
 comp lower = %median - 6.*iqr
 comp upper = %median + 6.*iqr
 set outlier = (y(i)(t).gt.upper).or.(y(i)(t).lt.lower)
 do vtime = basestsmpl,endsmpl
  if outlier(vtime)>0
   {
    dis "outlier in " %datelabel(vtime)
    dis "old value = " y(i)(vtime)
    if y(i)(vtime).gt.upper
     comp y(i)(vtime) = upper
    else if y(i)(vtime).lt.lower
     comp y(i)(vtime) = lower
    dis "new value = " y(i)(vtime)
   }
 end do vtime
end do i

******************************** define sample and
******************************** set initial values needed
******************************** and then standardize data
comp basestsmpl = 1985:1   ;* basestsmpl+fixlags
smpl basestsmpl endsmpl
dis %datelabel(basestsmpl) %datelabel(endsmpl)

comp [vec] keepscales = %fill(nvar,1,1.0)
do i = 1,nvar
 stats(noprint) y(i)
 set(scratch) y(i) basestsmpl-fixlags endsmpl = (y(i){0}-%mean)/%variance^0.5
 comp keepscales(i) = %variance^0.5
end do i

comp [vec[str]] varlabel = ||"U.S.",$
"Australia",$
"Austria",$
"Belgium",$
"Canada",$
"Denmark",$
"Finland",$
"France",$
"Germany",$
"Italy",$
"Japan",$
"Luxembourg",$
"Netherlands",$
"Norway",$
"Portugal",$
"Spain",$
"Sweden",$
"Switzerland",$
"U.K.",$
"international uncertainty factor"||

********************* now set period of decomposition
comp decstpt = 1987:1 ;* 2003:1
comp decendpt = endsmpl

********************************
******************************** reading in contribution estimates (these are medians)
********************************
comp totvar = nvar+nfact

** comp0: baseline forecast
** comp1: direct contrib of uncertainty shock
** comp2: direct contrib of VAR's shocks

dec vec[ser] comp0_50(totvar) comp1_50(totvar) comp2_50(totvar)

do i = 1,totvar
 label comp0_50(i)
 # "comp0_"+i
 label comp1_50(i)
 # "comp1_"+i
 label comp2_50(i)
 # "comp2_"+i
end do i

comp filename = "estimatesforfigures/estimatesforFigure6.xlsx"
open data &filename
data(for=xlsx,org=col) / comp0_50(1) to comp0_50(totvar) comp1_50(1) to comp1_50(totvar) comp2_50(1) to comp2_50(totvar)
close data

inquire(series=comp0_50(1)) decstpt2 decendpt2
dis %datelabel(decstpt2) %datelabel(decendpt2)

smpl decstpt decendpt

********************************
******************************** reading draws of params. and states from files
******************************** note: to reduce storage needs, rather than store draws of Sigma(t), we will reconstruct them from the draws of A and Lambda(t)
********************************
comp directory = "draws_19countries/"

**** dimensioning
dec rec[ser] factorRes(ndraws,nfact)

**** vol factors (rec array(draws, nvar) of time series)
comp ndatacol = nfact
do i = 1,ndraws
 do j = 1,ndatacol
  label factorRes(i,j)
  # "factor_"+i+"_"+j
 end do j
end do i
do i = 1,ndatacol
 comp thisroot = directory+'factor.n'+i
 comp filename = thisroot+'.xls'
 open data &filename
 data(org=row,for=xls) basestsmpl endsmpl factorRes(1,i) to factorRes(ndraws,i)
 close data
end do i

**** construct median estimate of (log) uncertainty for use in charts
dec vec[ser] actuallogfactors(nfact)
clear(length=endsmpl) actuallogfactors

smpl 1 ndraws
do vtime = basestsmpl,endsmpl
  do i = 1,nfact
   set statser = log(factorRes(t,i)(vtime))
   comp [vec] frac = %fractiles(statser,||.5||)
   comp actuallogfactors(i)(vtime) = frac(1)
  end do i
end do vtime

******************************** charts with SUBSET OF VARIABLES
******************************** create STACKED BAR charts, using medians of contribution estimates
********************************

*** variable numbers for variables to be included in charts
comp [vec[int]] incldummy = ||1,2,5,7,8,9,11,14,16,17,19,20||
comp nvarx = %rows(incldummy)
dis nvarx

************ chart settings
comp perpage = 12
comp vf = 3
comp hf = 4

comp [vec[str]] keylab = ||"data","VAR shocks","m shocks"||

comp nline = 3
dec vect[int] symbols(nline)
comp symbols = ||1,4,5||

smpl decstpt decendpt

grparm(bold) header 44
grparm axislabeling 46
grparm keylabeling 12

do i = 1,nvarx,perpage
 spgraph(vfields=vf,hfields=hf,klab=keylab,key=below,style=stackedbar,nopatterns,symbols=symbols) ;*
 do j = 1,perpage
  comp jj = incldummy((i-1)+j)
  if jj<=nvar
   set actualseries = y(jj){0}
  else
   set actualseries = actuallogfactors(jj-nvar){0}
  comp header1 = varlabel(jj)
  *
  set series1 = comp1_50(jj){0}
  set series2 = comp2_50(jj){0}   ;* -comp1_50(jj){0}

  extremum(noprint) actualseries
  comp vmin = %minimum
  comp vmax = %maximum
  set checkser = series1+series2
  extremum(noprint) checkser
  comp vmin = %min(%minimum,vmin)-0.25
  comp vmax = %max(%maximum,vmax)+0.25

  graph(dates,style=line,overlay=stackedbar,ovcount=(nline-1),ovsame,symbols=symbols,header=header1) nline  ;* ,max=vmax,min=vmin
  # actualseries / 1
  # series2
  # series1

 end do j
 spgraph(done)
end do i

