********************* RATS program, from 
********************* Carriero, Clark, and Marcellino, "Assessing International Commonality in Macroeconomic Uncertainty 
********************* and Its Effects," Journal of Applied Econometrics
********************* Creating Figure 5 after reading in estimates created by other estimation program

comp nvar = 67	;* number of variables in the VAR
comp nfact = 2  ;* # of factors
comp nfactx = 1 ;* only the first factor is in the VAR's conditional mean
comp totvar = nvar+nfact
comp totvarx = nvar+nfactx

comp freq = 4
comp nsteps = 4*freq

all nsteps
smpl 1 nsteps

grparm(bold) header 36
grparm axislabeling 36 footer 14 KEYLABELING 12

env noshowgraphs
gsave(format=pdf) "Figure5.pdf"

*********************
********************* READING IN IRs
*********************
dec rec[ser] IR(totvar,3)

comp filename1 = "estimatesforfigures/estimatesforFigure5.xlsx"

open data &filename1
data(format=xlsx,org=col) /
close
do i = 1,totvar
 set IR(i,1) = %s("SIMIRMEDIAN"+%string(i)){0}
 set IR(i,2) = %s("SIMIR15"+%string(i)){0}
 set IR(i,3) = %s("SIMIR85"+%string(i)){0}
end do i
comp basesize = %s("SIMIRMEDIAN"+%string(totvar-1))(1)
dis  basesize

comp [vec[str]] varlabel = ||"U.S. real GDP",$
"U.S. real consumption",$
"U.S. real government consumption",$
"U.S. real investment",$
"U.S. real exports",$
"U.S. real imports",$
"U.S. real inventories",$
"U.S. unit labor costs",$
"U.S. employment",$
"U.S. hours worked",$
"U.S. unemployment rate",$
"U.S. federal funds rate",$
"U.S. 2-year bond yield",$
"U.S. 10-year bond yield",$
"U.S. M2",$
"oil price",$
"commodity prices",$
"U.S. consumer prices",$
"U.S. core consumer prices",$
"U.S. producer prices",$
"U.S. real housing investment",$
"U.S. stock price index",$
"U.S. capacity utilization",$
"U.S. consumer confidence",$
"U.S. industrial confidence",$
"U.S. purchasing managers' index",$
"E.A. real GDP",$
"E.A. real consumption",$
"E.A. real government consumption",$
"E.A. real investment",$
"E.A. real exports",$
"E.A. real imports",$
"E.A. real inventories",$
"E.A. unit labor costs",$
"E.A. employment",$
"E.A. unemployment rate",$
"E.A. Eonia rate",$
"E.A. 2-year bond yield",$
"E.A. 10-year bond yield",$
"E.A. M3",$
"E.A. GDP deflator",$
"E.A. consumer prices",$
"E.A. core consumer prices",$
"E.A. producer prices",$
"E.A. real housing investment",$
"E.A. stock price index",$
"E.A. capacity utilization",$
"E.A. consumer confidence",$
"E.A. industrial confidence",$
"E.A. purchasing managers' index",$
"E.A. labor shortages",$
"U.K. real GDP",$
"U.K. real consumption",$
"U.K. real government consumption",$
"U.K. real investment",$
"U.K. real exports",$
"U.K. real imports",$
"U.K. unit labor costs",$
"U.K. industrial confidence",$
"U.K. consumer confidence",$
"U.K. employment",$
"U.K. unemployment rate",$
"U.K. producer prices",$
"U.K. retail price index",$
"U.K. official bank rate",$
"U.K. 10-year bond yield",$
"U.K. stock price index",$
"international uncertainty factor 1",$
"international uncertainty factor 2"||

*********************
********************* for pulling out combinations of IRs to put all countries on the same page, for the 16 variables included for all economies
*********************
comp [rec[int]] variablecomb = ||1,27,52|$
2,28,53|$
4,30,55|$
5,31,56|$
6,32,57|$
8,34,58|$
9,35,61|$
11,36,62|$
25,49,59|$
18,42,64|$
20,44,63|$
12,37,65|$
14,39,66|$
22,46,67|$
68,68,68|$
69,69,69||


comp [vec[str]] chartlabel = ||"Real GDP","Real consumption","Real investment","Real exports","Real imports","Unit labor costs",$
"Employment","Unemployment rate", "Industrial confidence", "Consumer prices","Producer prices","Policy rate","10-year bond yield",$
"Stock price index","International uncertainty factor 1","International uncertainty factor 2"||
comp ncombo = %rows(chartlabel)

********************************
******************************** charts
********************************
comp vf = 4
comp hf = 4

comp footer = "Lines are posterior medians.  Shaded regions are 70% credible sets for U.S. responses."

grparm(define="LINE_COLOR_01=0,000000,2.0")
grparm(define="LINE_COLOR_02=0,0000FF,4.0")
grparm(define="LINE_COLOR_03=0,FF0000,4.0")

comp [vec[string]] mykey_full = ||"U.S.","E.A.","U.K."||  ;* ,'U.S. 15%ile','U.S. 85%ile'
spgraph(vfields=vf,hfields=hf,key=below,klab=mykey_full)  ;*   ,footer=footer
do i = 1,ncombo
 comp header = chartlabel(i)
 if i>(ncombo-2)
  {
 graph(ticks,number=0,ovcount=2,overlay=fan,ovsame,header=header) 3
 # IR(variablecomb(i,1),1) / 1
 # IR(variablecomb(i,1),2) / 8
 # IR(variablecomb(i,1),3) / 8
  }
 else
 {
 dis '******************** panel ' i @40 header
 do j = 1,3
  dis varlabel(variablecomb(i,j))
 end do j
 graph(ticks,number=0,ovcount=2,overlay=fan,ovsame,header=header) 5
 # IR(variablecomb(i,1),1) / 1
 # IR(variablecomb(i,2),1) / 2
 # IR(variablecomb(i,3),1) / 3
 # IR(variablecomb(i,1),2) / 8
 # IR(variablecomb(i,1),3) / 8
 }
end do i
spgraph(done)

