********************* RATS program, from 
********************* Carriero, Clark, and Marcellino, "Assessing International Commonality in Macroeconomic Uncertainty 
********************* and Its Effects," Journal of Applied Econometrics
********************* Creating Figure 3 after reading in estimates created by other estimation program

comp styr = 1980
cal(q) styr:1
comp stsmpl = styr:1	;*earliest period with data
comp endsmpl = 2016:4   ;* for 19 economy

all endsmpl
smpl stsmpl endsmpl

grparm(bold) header 42 ;* 36
grparm axislabeling 38 ;* 32
grparm keylabeling 30 ;* 12

env noshowgraphs
gsave(format=pdf) "Figure3.pdf"

******************************************************* set up Bloom date indicators

*** Bloom 2009 dates, converted to quarterly (only monthly)
clear(zeros,length=endsmpl) bloom crisisperiod
set crisisperiod 2007:3 2008:4 = 1.0
set bloom 1987:4 1987:4 = 1.0
set bloom 1990:3 1990:3 = 1.0
set bloom 2002:3 2002:3 = 1.0
dofor i = 1997:4 1998:3 2001:3 2003:1
 comp bloom(i) = 1.0
end do i

comp [vec[int]] bloomdatevec = ||1987:4,1990:3,1997:4,1998:3,2001:3,2002:3,2003:1,2008:2||
comp [vec[str]] bloomlabels = ||"Black Monday","Gulf War I","Asian Crisis","Russian Crisis","9/11","Enron","Gulf War II","Crisis"||

do i = 1,%rows(bloomdatevec)
 dis %datelabel(bloomdatevec(i)) @10 bloomlabels(i)
end do i

*******************************************************
******************************************************* read in our estimates and others from the literature
*******************************************************

comp [vec[str]] serlabels = ||"3-economy", "19-country GDP","CCM macro","CCM financial","JLN macro","JLN financial", "Global EPU", "MT common", "BGK common"||

smpl stsmpl endsmpl

open data estimatesforfigures/factorcomparison.xlsx
data(format=xlsx,org=col,sheet="19country") / GFSVmedian
set ours19country = GFSVmedian
clear GFSVmedian
data(format=xlsx,org=col,sheet="larger2factor") / GFSVmedian
set ours3larger = GFSVmedian
close data

open data estimatesforfigures/otheruncertaintyestimatesfromliterature.xlsx
data(format=xlsx,org=col,sheet="quarterly") / MTworld	Berger
data(format=xlsx,org=col,sheet="monthly") / CCMmacro CCMfinancial JLNmacro JLNfinancial GlobalEPU
close data

*******************************************************
******************************************************* compute correlations and construct chart
*******************************************************

dec vec[str] usekey(2)
comp usekey(1) = serlabels(1) + " (left)"

comp count = 1
spgraph(vfields=3,hfields=3)
dofor j = ours19country CCMmacro CCMfinancial JLNmacro JLNfinancial GlobalEPU MTworld Berger
 comp count = count+1
 dis ""
 dis "***************************** " "ours3larger and " %l(j)
 comp basestsmpl = stsmpl
 comp baseendsmpl = endsmpl
 dofor i = ours3larger j
  inquire(series=i) stpt endpt
  comp basestsmpl = %imax(basestsmpl,stpt)
  comp baseendsmpl = %imin(baseendsmpl,endpt)
 end do i
 dis %datelabel(basestsmpl) %datelabel(baseendsmpl)
 smpl basestsmpl baseendsmpl

 stats(noprint) ours3larger
 comp basemean=%mean, basesd=%variance^0.5
 diff(standardize) j / normseries
 set normseries = basesd*normseries{0} + basemean
 
 cmom(corr,noprint)
 # ours3larger normseries
 dis(store=string1) "correlation = " #.### %cmom(2,1)

 comp header = serlabels(count)
 comp usekey(2) = serlabels(count) + " (right)"
 graph(header=header,dates,key=none) 2   ;* ,key=below,klab=||||,ovcount=1,overlay=line  below,klab=usekey
 # ours3larger
 # normseries
 grtext(position=upleft,bold,size=44) string1
end do j
spgraph(done)

