********************* RATS program, from 
********************* Carriero, Clark, and Marcellino, "Assessing International Commonality in Macroeconomic Uncertainty 
********************* and Its Effects," Journal of Applied Econometrics
********************* Creating Figure 1 after reading in estimates created by other estimation program

comp totvar = 67
comp nus = 26
comp nuk = 16

comp styr = 1980
cal(q) styr:1
comp stsmpl = styr:1	;*earliest period with data
comp endsmpl = 2013:3

all endsmpl
smpl stsmpl endsmpl

grparm(bold) header 38
grparm axislabeling 40
grparm keylabeling 12

env noshowgraphs
gsave(format=pdf) "Figure1.pdf"

*********************
********************* READING IN ALL vol estimates and determining available sample
*********************

dec vec[ser] volest(totvar) stvolest(totvar)

comp filename = "estimatesforfigures/estimatesforFigure1.xlsx"
open data &filename
data(format=xlsx,org=col) /
close data
do j = 1,totvar
  set volest(j) = %s("volmedian"+%string(j)){0}
end do j

comp basestsmpl = stsmpl
dofor i = 1 nus+1 totvar
 inquire(series=volest(i)) stpt *
 comp basestsmpl = %imax(basestsmpl,stpt)
end do i
dis %datelabel(basestsmpl) %datelabel(endsmpl)
smpl basestsmpl endsmpl

comp [vec[str]] allvarlist = ||"1      US REAL_GDP",$
"2      US REAL_CONSUMPTION",$
"3      US REAL_GOVT_CONSUM",$
"4      US REAL_INVESTMENT",$
"5      US REAL_EXPORTS",$
"6      US REAL_IMPORTS",$
"7      US REAL_INVENTORIES",$
"8      US ULC",$
"9      US TOTAL_EMPLOYMENT",$
"10     US HOURS_WORKED",$
"11     US UNEMPLOYMENT_RAT",$
"12     US SHORT_TERM_RATE",$
"13     US BOND_YIELD_2Y",$
"14     US BOND_YIELD_10Y",$
"15     US M2",$
"16     US OIL_PRICE",$
"17     US COMMODITY_PRICES",$
"18     US CONSUMER_PRICES",$
"19     US CPIXFE",$
"20     US PPI",$
"21     US REAL_HOUSING_INV",$
"22     US STOCK_MKT_INDEX",$
"23     US CAPACITY_UTILIZA",$
"24     US CONSUMER_CONFIDE",$
"25     US INDUSTRIAL_CONFI",$
"26     US PMI",$
"27     EA REAL_GDP",$
"28     EA REAL_CONSUMPTION",$
"29     EA REAL_GOVT_CONSUM",$
"30     EA REAL_INVESTMENT",$
"31     EA REAL_EXPORTS",$
"32     EA REAL_IMPORTS",$
"33     EA REAL_INVENTORIES",$
"34     EA ULC",$
"35     EA TOTAL_EMPLOYMENT",$
"36     EA UNEMPLOYMENT_RAT",$
"37     EA SHORT_TERM_RATE",$
"38     EA BOND_YIELD_2Y",$
"39     EA BOND_YIELD_10Y",$
"40     EA M3",$
"41     EA GDP_DEFLATOR",$
"42     EA CONSUMER_PRICES",$
"43     EA CONSUMER_PRICES_",$
"44     EA PPI",$
"45     EA REAL_HOUSING_INV",$
"46     EA STOCK_MKT_INDEX",$
"47     EA CAPACITY_UTILIZA",$
"48     EA CONSUMER_CONFIDE",$
"49     EA INDUSTRIAL_CONFI",$
"50     EA PMI",$
"51     EA LABOR_SHORTAGES",$
"52     UK GDP",$
"53     UK CONSUMPTION",$
"54     UK GOV",$
"55     UK INVESTMENT",$
"56     UK EXPORT",$
"57     UK IMPORT",$
"58     UK ULC",$
"59     UK INDUSTRIAL_CONFI",$
"60     UK CONSUMER_CONFIDE",$
"61     UK EMPLOYMENT",$
"62     UK UNEMPLOYMENT_RAT",$
"63     UK PPI",$
"64     UK RPI",$
"65     UK POLICY_RATE",$
"66     UK BONDYIELD10Y",$
"67     UK STOCKPRICE"||

*********************
********************* for purposes of creating labels with minimal work relative to estimation code: READING IN DATA
*********************
comp [rec[int]] variablecomb = ||1,27,52|$
2,28,53|$
3,29,54|$
4,30,55|$
5,31,56|$
6,32,57|$
8,34,58|$
9,35,61|$
11,36,62|$
18,42,64|$
24,48,60|$
25,49,59|$
20,44,63|$
12,37,65|$
14,39,66|$
22,46,67||

comp [vec[str]] chartlabel = ||"Real GDP","Real consumption","Real government cons.","Real investment","Real exports","Real imports","Unit labor costs",$
"Employment","Unemployment rate","Consumer confidence", "Industrial confidence", "Consumer prices","Producer prices","Policy rate","10-year bond yield","Stock price index"||
comp ncombo = %rows(chartlabel)

********************************
******************************** charts
********************************
comp vf = 4
comp hf = 4

/*
grparm(define="LINE_BW_1=0,0.0,1.0")
grparm(define="LINE_BW_2=1,0.0,3.0")
grparm(define="LINE_BW_3=2,0.0,4.0")
*/

grparm(define="LINE_BW_1=0,0.0,1.0")
grparm(define="LINE_BW_2=1,0.0,4.0")
grparm(define="LINE_BW_3=2,0.5,5.0")

comp [vec[string]] mykey_full = ||"U.S.","E.A.","U.K."||
spgraph(vfields=vf,hfields=hf,key=below,klab=mykey_full)
do i = 1,ncombo
 dis '******************** panel ' i
 do j = 1,3
  dis allvarlist(variablecomb(i,j))
 end do j
 comp header = chartlabel(i)
 graph(header=header,dates) 3
 # volest(variablecomb(i,1))
 # volest(variablecomb(i,2))
 # volest(variablecomb(i,3))
end do i
spgraph(done)
