********************* RATS program, from 
********************* Carriero, Clark, and Marcellino, "Assessing International Commonality in Macroeconomic Uncertainty 
********************* and Its Effects," Journal of Applied Econometrics
********************* estimating BVAR-SV model with quarterly data on GDP growth in 19 countries
********************* 

dis %dateandtime()
dis %ratsversion()

*********************
********************* BASIC SETUP & PARAMETER ENTRY
*********************
comp skipint = 5                      ;* save only every kth draw of MCMC (out of skipint*ndraws)
comp ndraws = 5000                    ;* # of draws retained
comp burnindraws = 5000               ;* # of draws burned

/*
comp ndraws = 200                     ;* # of draws retained
comp burnindraws = 50                ;* # of draws burned
comp skipint = 1                      ;* save only every 20th draw of MCMC (out of skipint*ndraws)
*/

comp styr = 1960
comp freq = 4
if freq==12
 cal(m) styr:1
else
 cal(q) styr:1
endif
comp stsmpl = styr:1	;*earliest period with data
comp endsmpl = 2016:4      ;* last data observation (will use same data sample as for other models)

comp nvar = 19	;* number of variables in the VAR
comp fixlags = 2	;* fixed lag order to use in VAR

all endsmpl
smpl stsmpl endsmpl

comp seedval = 3000
seed seedval
dis seedval

grparm(bold) header 14 subheader 12
grparm axislabeling 24
env nowshowgraphs
comp modeldesc = "BVAR-SV model, OECD GDP growth data for 19 countries"
gsave(format=pdf) "BVARSV_19countries_*.pdf"

*********************
********************* READING IN DATA and determining available sample
*********************
open data data/GDP_OECD.xls
data(format=xls,org=col) / US Australia Austria Belgium Canada Denmark Finland France Germany Italy Japan Luxembourg Netherlands Norway Portugal Spain Sweden Switzerland UK
close

comp basestsmpl = stsmpl
do i = 1,nvar
 inquire(series=i) stpt endpt
 comp nobs = endpt-stpt+1
 dis %l(i) @15 %datelabel(stpt) %datelabel(endpt)
 stats(noprint) i
 if %nobs<>nobs
  dis 'missing obs = ' (nobs-%nobs)
 comp basestsmpl = %imax(basestsmpl,stpt)
 comp endsmpl = %imin(endsmpl,endpt)
end do i

dis %datelabel(basestsmpl) %datelabel(endsmpl)

dec vec[str] varlabel(nvar)
dec vec[ser] y(nvar)

*** set of data vector and convert simple percent changes to log growth rates, which is what we will use
smpl basestsmpl endsmpl
do i = 1,nvar
 comp varlabel(i) = %l(i)
 set(first=1.) ylevel basestsmpl-1 endsmpl = ylevel{1}*(1.+.01*i{0})
 set y(i) = 100.*log(ylevel{0}/ylevel{1})
end do i

** outlier screening
do i = 1,nvar
 dis ""
 dis "**************************** " varlabel(i)
 stats(fractiles,noprint) y(i)
 comp iqr = %fract75-%fract25
 comp lower = %median - 6.*iqr
 comp upper = %median + 6.*iqr
 set outlier = (y(i)(t).gt.upper).or.(y(i)(t).lt.lower)
 do vtime = basestsmpl,endsmpl
  if outlier(vtime)>0
   {
    dis "outlier in " %datelabel(vtime)
    dis "old value = " y(i)(vtime)
    if y(i)(vtime).gt.upper
     comp y(i)(vtime) = upper
    else if y(i)(vtime).lt.lower
     comp y(i)(vtime) = lower
    dis "new value = " y(i)(vtime)
   }
 end do vtime
end do i

********************************
******************************** stuff for estimation
********************************
sou(noecho) procedures/BVARBE.SV.src

******** prior means of first lag of dep variable in each equation (basic intention is to push VAR towards AR(1) models with coef of 0)
comp [vec] bvarprior = %fill(nvar,1,0.0)  ;* default prior mean is 0.0
comp [vec] shrinkage = ||.1,0.5,1.,1000.|| ;* overall tightness, relative weight on other lags, decay on lag, intercept hyperparm.

dec vec dpriormean(nvar)
dec vec[symm] dpriorvar(nvar)
do i = 1,nvar
 comp dpriormean(i) = 0.95   ;* prior mean on slope of st vol process; prior mean set within procedure based on this slope and period 0 mean
 comp dpriorvar(i) = ||2.| 0.0, 0.3^2.||
end do i

********* mean and variance of Phi, var-cov matrix of innovations to log stochastic volatility
dec symm muPhi(nvar,nvar)
comp muPhi = %mscalar(.03)
dec symm Omegalambda0(nvar,nvar)
comp Omegalambda0 = %mscalar(2.)
comp priordfPhi = nvar+2 

** now adjust muPhi to get the intended prior mean 
comp adjustment = (priordfPhi-nvar-1.)/priordfPhi
comp muphi = adjustment*muphi 

******************************** define sample and
******************************** set initial values needed
comp basestsmpl = 1985:1   ;* basestsmpl+fixlags
smpl basestsmpl endsmpl
dis %datelabel(basestsmpl) %datelabel(endsmpl)

do i = 1,nvar
 stats(noprint) y(i)
 set(scratch) y(i) basestsmpl-fixlags endsmpl = (y(i){0}-%mean)/%variance^0.5
end do i

comp [vec] lnlambdainp = %zeros(nvar,1)
dec vec[ser] Aresids(nvar)
do i = 1,nvar
  linreg(noprint) y(i) / Aresids(i)
  # constant y(i){1 to fixlags}
  sstats(mean) / Aresids(i){0}**2.>>lnlambdainp(i)
  comp lnlambdainp(i) = log(lnlambdainp(i))
end do i

********************************
******************************** model estimation
********************************

smpl basestsmpl endsmpl
dis %datelabel(basestsmpl) %datelabel(endsmpl)

comp starttime = %cputime()
@BVARBESV(prmean,lnlambdainp=lnlambdainp,noinclconst) y basestsmpl endsmpl 0 fixlags ndraws burnindraws skipint bvarprior shrinkage Omegalambda0 muPhi $
 priordfPhi dpriormean dpriorvar 0 PiRes ARes PhiRes SigmaRes LambdaRes stdevRes svcoefRes ForecastRes volinnovations meanresids normresids

dis 'run time in minutes = ' (%cputime()-starttime)/60.

********************************
******************************** volatility, calculating posterior stats
********************************
dec vec[ser] rfvolmedian(nvar) rfvol15(nvar) rfvol85(nvar) loglambda(nvar)
clear(length=endsmpl) rfvolmedian rfvol15 rfvol85 loglambda

smpl 1 ndraws
do vtime = basestsmpl,endsmpl
  do i = 1,nvar
    set(scratch) statser = stdevRes(t,i)(vtime)
    stats(noprint,fractiles) statser
    comp [vec] frac = %fractiles(statser,||.15,.5,.85||)
    comp rfvolmedian(i)(vtime) = %median
    comp rfvol15(i)(vtime) = frac(1)
    comp rfvol85(i)(vtime) = frac(3)
    *
    set(scratch) statser = log(lambdaRes(t,i)(vtime))
    stats(noprint,fractiles) statser
    comp loglambda(i)(vtime) = %median
  end do i
end do vtime

**** now write to Excel files
comp filename = %unitfnroot("input")+".xls"
open copy &filename
copy(dates,org=col,for=xls) basestsmpl endsmpl rfvolmedian loglambda rfvol15 rfvol85
close copy

********************************
******************************** charts
********************************
comp perpage = 20
comp vf = 4
comp hf = 5

comp [vec[string]] mykey_full = ||'median','15%ile','85%ile'||
smpl basestsmpl endsmpl

******************************** reduced-form volatilities
comp header1 = 'Innovation volatility estimate: ' + modeldesc
comp subheader = '(standard deviation)'
do i = 1,nvar,perpage
 grparm(bold) header 14 
 spgraph(vfields=vf,hfields=hf,header=header1,subheader=subheader)
 grparm(bold) header 22
 do j = i,%imin(i+perpage-1,nvar)
  comp header = varlabel(j)
  graph(header=header,dates,key=below,klab=mykey_full) 3
  # rfvolmedian(j) / 1
  # rfvol15(j) / 2
  # rfvol85(j) / 2
 end do j
 spgraph(done)
end do i

********************************
******************************** checking principal components:  log lambda (using posterior medians)
********************************
comp npc = 5
dec vec[ser] factors(npc)
smpl basestsmpl endsmpl

*** standardization
do i = 1,nvar
 diff(standardize) loglambda(i) / loglambda(i)
end do i

*** form data matrix
make datamat
# loglambda
dis %rows(datamat) %cols(datamat)

*** compute eigen values and factors
if %rows(datamat)<%cols(datamat)
 {
  comp xx = %outerxx(datamat)
  eigen xx eigvals eigenvec
  comp eigenvec = eigenvec*(sqrt(float(%rows(xx))))
  do i = 1,npc
   set factors(i) = eigenvec(t-basestsmpl+1,i)
  end do i
 }
else
 {
  comp xx = %innerxx(datamat)
  eigen xx eigvals eigenvec
  do i = 1,npc
   comp [vec] princoef=%xcol(eigenvec,i)*(1./sqrt(float(%rows(xx))))
   comp [vec] factorvec = datamat*princoef
   set factors(i) = factorvec(t-basestsmpl+1)
  end do i
 }
endif

*** check and flip signs as need be to make correlations with first variable positive
do i = 1,npc
 set gapseries = abs(factors(i){0}-loglambda(1))
 set gapseries2 = abs(-1.*factors(i){0}-loglambda(1))
 if %sum(gapseries2)<%sum(gapseries)
  set factors(i) = -1.*factors(i){0}
end do i

*** compute and show incremental R2's and Ahn-Horenstein eigen value ratio
do i = 1,npc
 if i==1
  dis ""
 dis "share of PC and A-H measure " i @35 "= " #####.### eigvals(i)/%sum(eigvals) eigvals(i)/eigvals(i+1)
end do i 

*** run regressions to get R'2s for each variable, and loading coefficients
dec rec coefs(nvar,npc) rsquares(nvar,npc)
do i = 1,nvar
 do j = 1,npc
  linreg(noprint) loglambda(i)
  # factors(j)
  comp coefs(i,j) = %beta(1)
  comp rsquares(i,j) = %rsquared
 end do j
end do i 

*** dis loadings on 1st factor
do i = 1,nvar
 if i==1
  dis ""
 dis "1st three factor loadings for var " i @40 "= " ###.### coefs(i,1) 
end do i 

*** tabulate percentiles of R-square distributions
do j = 1,npc
 set statser 1 nvar = rsquares(t,j)
 stats(fractiles,noprint) statser 1 nvar
 dis "PC " j @14 "mean, median, 25%, 75% =   " ####.### %mean %median %fract25 %fract75
end do j

*** copy factor to Excel file
comp filename = %unitfnroot("input")+"_pcfactor.xls"
open copy &filename
copy(dates,org=col,for=xls) basestsmpl endsmpl factors(1)
close copy
