'------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
'This programs replicates and extends Table 5 from: Cicarelli, M and B Mojon (2010) `Global Inflation', Review of Economics and Statistics 92(3), pp. 524-535
'Extension: update to 2016
'Authors: Christian Gillitzer and Martin McCarthy, February 2017
'Modified: May 2018
'------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

'Setup quarterly workfile
workfile q 1960:1 2019:2
smpl @all

mode quiet

cd "C:\Users\cgil3035\Dropbox\Global Inflation\JAE.R1\Code"

scalar maxh=8	'Maximum forecast horizon
scalar T = 230+maxh		'Number of observations in dataset + forecast horizon
scalar T0 = @dtoo("1960:1")-1	'First data in estimation window
scalar length = @dtoo("1985:1")-maxh-T0	'Initial estimation window length (quarters)

'Load Headline CPI index levels
smpl @first @last
read(b2,s=CM_Extended_sa) "..\Data\Data.xls" 23

'Load Industrial Production data
smpl @first @last
read(b10,s=IP_CM_Extended) "..\Data\Data.xls" 23

'Load M3 data
smpl @first @last
read(b10,s=M3_CM_Extended) "..\Data\Data.xls" 23

'Load commodity price data
smpl @first @last
read(b10,s=COMPRICE_CM_Extended) "..\Data\Data.xls" 1

'----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
' Transform variables
'----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

'Calculate annualised inflation rates: annualised
for %country cpi_aut cpi_bel cpi_fin cpi_fra cpi_ger cpi_ita cpi_ned cpi_por cpi_esp cpi_irl cpi_den cpi_gre cpi_swe cpi_uk cpi_nor cpi_sui cpi_can cpi_jpn cpi_usa cpi_aus cpi_nzl cpi_lux cpi_u2

	series l{%country} = @log({%country})

	for !h=1 to 8 'h-period average inflation
		
		series d{!h}l{%country} = (400/{!h})*(l{%country} - l{%country}(-{!h}))

	next

next

'Group inflation rates
group d4lcpi_global d4lcpi_aut d4lcpi_bel d4lcpi_fin d4lcpi_fra d4lcpi_ger d4lcpi_ita d4lcpi_ned d4lcpi_por d4lcpi_esp d4lcpi_irl d4lcpi_den d4lcpi_gre d4lcpi_swe d4lcpi_uk d4lcpi_nor d4lcpi_sui d4lcpi_can d4lcpi_jpn d4lcpi_usa d4lcpi_aus d4lcpi_nzl d4lcpi_lux d4lcpi_u2
group d1lcpi_global d1lcpi_aut d1lcpi_bel d1lcpi_fin d1lcpi_fra d1lcpi_ger d1lcpi_ita d1lcpi_ned d1lcpi_por d1lcpi_esp d1lcpi_irl d1lcpi_den d1lcpi_gre d1lcpi_swe d1lcpi_uk d1lcpi_nor d1lcpi_sui d1lcpi_can d1lcpi_jpn d1lcpi_usa d1lcpi_aus d1lcpi_nzl d1lcpi_lux d1lcpi_u2

'Commodity price inflation
series lcomprice = @log(comprice)
series d1lcomprice = 400*(lcomprice - lcomprice(-1))

'Annualised growth in M3 and IP
for %country aut bel fin fra ger ita ned por esp irl den gre swe uk nor sui can jpn usa aus nzl lux u2

	series lm3_{%country} = @log(m3_{%country})
	series d1lm3_{%country} = 400*(lm3_{%country} - lm3_{%country}(-1))
	
	series lip_{%country} = @log(ip_{%country})
	series d1lip_{%country} = 400*(lip_{%country} - lip_{%country}(-1))

next

'----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
' Principal components forecast
'----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

'Estimate principal components
for !t = 0 to (T-T0-length-maxh)

			smpl @first+T0+2 @first+T0+(length-1)+!t	'Note: the +2 is for consistency with Ciccarelli and Mojon (2010). This removes 1 quarter of data unnecessarily.

			'Standardise series
			for %country cpi_aut cpi_bel cpi_fin cpi_fra cpi_ger cpi_ita cpi_ned cpi_por cpi_esp cpi_irl cpi_den cpi_gre cpi_swe cpi_uk cpi_nor cpi_sui cpi_can cpi_jpn cpi_usa cpi_aus cpi_nzl cpi_lux cpi_u2

				series d1l{%country}_{!t} = (d1l{%country}-@mean(d1l{%country}))/@stdev(d1l{%country})
				series d4l{%country}_{!t} = (d4l{%country}-@mean(d4l{%country}))/@stdev(d4l{%country})

			next

			group d1lcpi_global_{!t} d1lcpi_aut_{!t} d1lcpi_bel_{!t} d1lcpi_fin_{!t} d1lcpi_fra_{!t} d1lcpi_ger_{!t} d1lcpi_ita_{!t} d1lcpi_ned_{!t} d1lcpi_por_{!t} d1lcpi_esp_{!t} d1lcpi_irl_{!t} d1lcpi_den_{!t} d1lcpi_gre_{!t} d1lcpi_swe_{!t} d1lcpi_uk_{!t} d1lcpi_nor_{!t} d1lcpi_sui_{!t} d1lcpi_can_{!t} d1lcpi_jpn_{!t} d1lcpi_usa_{!t} d1lcpi_aus_{!t} d1lcpi_nzl_{!t} d1lcpi_lux_{!t} d1lcpi_u2_{!t}
			d1lcpi_global_{!t}.pcomp(method=cov, out=table) f1q_{!t}
			close d1lcpi_global_{!t} 	

			group d4lcpi_global_{!t} d4lcpi_aut_{!t} d4lcpi_bel_{!t} d4lcpi_fin_{!t} d4lcpi_fra_{!t} d4lcpi_ger_{!t} d4lcpi_ita_{!t} d4lcpi_ned_{!t} d4lcpi_por_{!t} d4lcpi_esp_{!t} d4lcpi_irl_{!t} d4lcpi_den_{!t} d4lcpi_gre_{!t} d4lcpi_swe_{!t} d4lcpi_uk_{!t} d4lcpi_nor_{!t} d4lcpi_sui_{!t} d4lcpi_can_{!t} d4lcpi_jpn_{!t} d4lcpi_usa_{!t} d4lcpi_aus_{!t} d4lcpi_nzl_{!t} d4lcpi_lux_{!t} d4lcpi_u2_{!t}
			d4lcpi_global_{!t}.pcomp(method=cov, out=table) f1ye_{!t}	
			close d4lcpi_global_{!t}

next

'Table to store results
table(24,9) rmse_pc
rmse_pc(1,2) = "1q"
rmse_pc(1,3) = "2q"
rmse_pc(1,4) = "3q"
rmse_pc(1,5) = "4q"
rmse_pc(1,6) = "5q"
rmse_pc(1,7) = "6q"
rmse_pc(1,8) = "7q"
rmse_pc(1,9) = "8q"

'Estimate forecasting regressions
scalar counter = 1 'Country number for loop
for %country cpi_aut cpi_bel cpi_fin cpi_fra cpi_ger cpi_ita cpi_ned cpi_por cpi_esp cpi_irl cpi_den cpi_gre cpi_swe cpi_uk cpi_nor cpi_sui cpi_can cpi_jpn cpi_usa cpi_aus cpi_nzl cpi_lux cpi_u2
	
	scalar counter = counter + 1
	rmse_pc(counter,1) = %country
	
	for !h=1 to maxh	'Loop over forecast horizons

		!lags_pc = !h+3 'Number of lags of principal components
		series fcst_pc_{%country}_h{!h} = na	 'Series to store forecasts
		series sq_error_pc_{%country}_h{!h} = na 'Series to store squared forecast errors

		for !t = 0 to (T-T0-length-maxh)	'Loop over time periods

			!schwarz = 99999
			!bestlag = 0

			smpl @first+T0 @first+T0+(length-1)+!t
		
			for !p=0 to 1	'Choose lag length based on SIC
				
				!pi = !h + !p
				equation reg_pc_{%country}_t{!t}_h{!h}.ls(cov=hac) d{!h}l{%country} c d1l{%country}(-{!h} to -!pi) f1q_{!t}(-{!h} to -!lags_pc) 	'In-sample forecasting regression

				if reg_pc_{%country}_t{!t}_h{!h}.@schwarz<!schwarz then
					!bestlag = !p
					!schwarz = reg_pc_{%country}_t{!t}_h{!h}.@schwarz
				endif
			
			next

			!pstar = !h + !bestlag
			equation reg_pc_{%country}_t{!t}_h{!h}.ls(cov=hac) d{!h}l{%country} c d1l{%country}(-{!h} to -!pstar) f1q_{!t}(-{!h} to -!lags_pc) 	'In-sample forecasting regression
	
			smpl @first+T0+(length-1)+!t+!h @first+T0+(length-1)+!t+!h
			forecast(f=na) fcst
			fcst_pc_{%country}_h{!h} = fcst	'Store forecasts
			scalar actual = @elem(d{!h}l{%country},@otod(1+T0+(length-1)+{!t}+{!h})) 'Actual outcome
			sq_error_pc_{%country}_h{!h} = (actual - fcst)^2	 'Squared forecast error														

		next		

		smpl 1995:4+{!h} 2016:4
		rmse_pc(counter,{!h}+1) = @sqrt(@mean(sq_error_pc_{%country}_h{!h}))

	next

next

'----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
' Autoregressive forecast
'----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

'Table to store results
table(24,9) rmse_ar
rmse_ar(1,2) = "1q"
rmse_ar(1,3) = "2q"
rmse_ar(1,4) = "3q"
rmse_ar(1,5) = "4q"
rmse_ar(1,6) = "5q"
rmse_ar(1,7) = "6q"
rmse_ar(1,8) = "7q"
rmse_ar(1,9) = "8q"

'Estimate forecasting regressions
scalar counter = 1 'Country number for loop
for %country cpi_aut cpi_bel cpi_fin cpi_fra cpi_ger cpi_ita cpi_ned cpi_por cpi_esp cpi_irl cpi_den cpi_gre cpi_swe cpi_uk cpi_nor cpi_sui cpi_can cpi_jpn cpi_usa cpi_aus cpi_nzl cpi_lux cpi_u2
	
	scalar counter = counter + 1
	rmse_ar(counter,1) = %country
	
	for !h=1 to maxh	'Loop over forecast horizons

		series fcst_ar_{%country}_h{!h} = na	 'Series to store forecasts
		series sq_error_ar_{%country}_h{!h} = na 'Series to store squared forecast errors

		for !t = 0 to (T-T0-length-maxh)	'Loop over time periods

			!schwarz = 99999
			!bestlag = 0

			smpl @first+T0 @first+T0+(length-1)+!t
		
			for !p=0 to 1 'Choose lag length based on SIC
				
				!pi = !h + !p
				equation reg_ar_{%country}_t{!t}_h{!h}.ls(cov=hac) d{!h}l{%country} c d1l{%country}(-{!h} to -!pi) 	'In-sample forecasting regression

				if reg_ar_{%country}_t{!t}_h{!h}.@schwarz<!schwarz then
					!bestlag = !p
					!schwarz = reg_ar_{%country}_t{!t}_h{!h}.@schwarz
				endif
			
			next

			!pstar = !h + !bestlag
			equation reg_ar_{%country}_t{!t}_h{!h}.ls(cov=hac) d{!h}l{%country} c d1l{%country}(-{!h} to -!pstar) 	'In-sample forecasting regression
	
			smpl @first+T0+(length-1)+!t+!h @first+T0+(length-1)+!t+!h
			forecast(f=na) fcst
			fcst_ar_{%country}_h{!h} = fcst	'Store forecasts
			scalar actual = @elem(d{!h}l{%country},@otod(1+T0+(length-1)+{!t}+{!h})) 'Actual outcome
			sq_error_ar_{%country}_h{!h} = (actual - fcst)^2	 'Squared forecast error														

		next		

		smpl 1995:4+{!h} 2016:4
		rmse_ar(counter,{!h}+1) = @sqrt(@mean(sq_error_ar_{%country}_h{!h}))

	next
 
next

'----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
' Ratio of RMSEs: PC-forecast to AR-forecast
'----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

'Table to store results: ratio of RMSEs
table(24,17) rmse_ratio_ar
rmse_ratio_ar(1,2) = "1q"
rmse_ratio_ar(1,4) = "2q"
rmse_ratio_ar(1,6) = "3q"
rmse_ratio_ar(1,8) = "4q"
rmse_ratio_ar(1,10) = "5q"
rmse_ratio_ar(1,12) = "6q"
rmse_ratio_ar(1,14) = "7q"
rmse_ratio_ar(1,16) = "8q"

scalar counter = 1  'Country number for loop
for %country cpi_aut cpi_bel cpi_fin cpi_fra cpi_ger cpi_ita cpi_ned cpi_por cpi_esp cpi_irl cpi_den cpi_gre cpi_swe cpi_uk cpi_nor cpi_sui cpi_can cpi_jpn cpi_usa cpi_aus cpi_nzl cpi_lux cpi_u2

	scalar counter = counter + 1
	rmse_ratio_ar(counter,1) = %country

	for !h=1 to maxh

		scalar index = !h+1
		scalar column = {!h}*2		
		rmse_ratio_ar(counter,column)  = @val(rmse_pc(counter,index))/@val(rmse_ar(counter,index)) 'Ratio of RMSEs

		'Statistical significance (10 percent level)
		smpl 1995:4+{!h} 2016:4
		scalar lag={!h}
		equation dm_ar_{%country}_h{!h}.ls(cov=hac,nodf,covbw=lag) (sq_error_pc_{%country}_h{!h} - sq_error_ar_{%country}_h{!h}) c
		scalar tstat = dm_ar_{%country}_h{!h}.@tstats(1)
		if tstat<-1.282 then
			rmse_ratio_ar(counter,column+1) = 1
		else 
			rmse_ratio_ar(counter,column+1) = 0
		endif		
		
	next

next

'Export results
rmse_ratio_ar.save(t=csv) "rmse_ratio_ar_2016.csv"

'----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
' Random walk forecast (RW1)
'----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

'Table to store results
table(24,9) rmse_rw
rmse_rw(1,2) = "1q"
rmse_rw(1,3) = "2q"
rmse_rw(1,4) = "3q"
rmse_rw(1,5) = "4q"
rmse_rw(1,6) = "5q"
rmse_rw(1,7) = "6q"
rmse_rw(1,8) = "7q"
rmse_rw(1,9) = "8q"

'Estimate forecasting regressions
scalar counter = 1 'Country number for loop
for %country cpi_aut cpi_bel cpi_fin cpi_fra cpi_ger cpi_ita cpi_ned cpi_por cpi_esp cpi_irl cpi_den cpi_gre cpi_swe cpi_uk cpi_nor cpi_sui cpi_can cpi_jpn cpi_usa cpi_aus cpi_nzl cpi_lux cpi_u2
	
	scalar counter = counter + 1
	rmse_rw(counter,1) = %country
	
	for !h=1 to maxh	'Loop over forecast horizons

		series fcst_rw_{%country}_h{!h} = na	 'Series to store forecasts
		series sq_error_rw_{%country}_h{!h} = na 'Series to store squared forecast errors

		for !t = 0 to (T-T0-length-maxh)	'Loop over time periods

			smpl @first+T0+(length-1)+!t+!h @first+T0+(length-1)+!t+!h
			!h_minus = -!h
			fcst_rw_{%country}_h{!h} = d1l{%country}(!h_minus)	'Store forecasts
			scalar actual = @elem(d{!h}l{%country},@otod(1+T0+(length-1)+{!t}+{!h})) 'Actual outcome													
			sq_error_rw_{%country}_h{!h} = (actual - d1l{%country}(!h_minus))^2	 'Squared forecast error																										

		next		

		smpl 1995:4+{!h} 2016:4
		rmse_rw(counter,{!h}+1) = @sqrt(@mean(sq_error_rw_{%country}_h{!h}))

	next
 
next

'----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
' Ratio of RMSEs: PC-forecast to RW-forecast
'----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

'Table to store results: ratio of RMSEs
table(24,17) rmse_ratio_rw
rmse_ratio_rw(1,2) = "1q"
rmse_ratio_rw(1,4) = "2q"
rmse_ratio_rw(1,6) = "3q"
rmse_ratio_rw(1,8) = "4q"
rmse_ratio_rw(1,10) = "5q"
rmse_ratio_rw(1,12) = "6q"
rmse_ratio_rw(1,14) = "7q"
rmse_ratio_rw(1,16) = "8q"

scalar counter = 1  'Country number for loop
for %country cpi_aut cpi_bel cpi_fin cpi_fra cpi_ger cpi_ita cpi_ned cpi_por cpi_esp cpi_irl cpi_den cpi_gre cpi_swe cpi_uk cpi_nor cpi_sui cpi_can cpi_jpn cpi_usa cpi_aus cpi_nzl cpi_lux cpi_u2

	scalar counter = counter + 1
	rmse_ratio_rw(counter,1) = %country

	for !h=1 to maxh

		scalar index = !h+1
		scalar column = {!h}*2		
		rmse_ratio_rw(counter,column)  = @val(rmse_pc(counter,index))/@val(rmse_rw(counter,index)) 'Ratio of RMSEs

		'Statistical significance (10 percent level)
		smpl 1995:4+{!h} 2016:4
		scalar lag={!h}
		equation dm_rw_{%country}_h{!h}.ls(cov=hac,nodf,covbw=lag) (sq_error_pc_{%country}_h{!h} - sq_error_rw_{%country}_h{!h}) c
		scalar tstat = dm_rw_{%country}_h{!h}.@tstats(1)
		if tstat<-1.282 then
			rmse_ratio_rw(counter,column+1) = 1
		else 
			rmse_ratio_rw(counter,column+1) = 0
		endif		
		
	next

next

'Export results
rmse_ratio_rw.save(t=csv) "rmse_ratio_rw_2016.csv"

'----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
' Phillips curve forecast
'----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

'Table to store results
table(24,9) rmse_phil
rmse_phil(1,2) = "1q"
rmse_phil(1,3) = "2q"
rmse_phil(1,4) = "3q"
rmse_phil(1,5) = "4q"
rmse_phil(1,6) = "5q"
rmse_phil(1,7) = "6q"
rmse_phil(1,8) = "7q"
rmse_phil(1,9) = "8q"

'Estimate forecasting regressions
scalar counter = 1 'Country number for loop
for %country aut bel fin fra ger ita ned por esp irl den gre swe uk nor sui can jpn usa aus nzl lux u2
	
	scalar counter = counter + 1
	rmse_phil(counter,1) = %country
	
	for !h=1 to maxh	'Loop over forecast horizons

		series fcst_phil_cpi_{%country}_h{!h} = na	 'Series to store forecasts
		series sq_error_phil_cpi_{%country}_h{!h} = na 'Series to store squared forecast errors

		for !t = 0 to (T-T0-length-maxh)-5		'Loop over time periods (note 5q shorter period due to data availability for M3 and IP)

			!schwarz = 99999
			!bestlag = 0

			smpl @first+T0 @first+T0+(length-1)+!t
		
			for !p=0 to 1 'Choose lag length based on SIC
				
				!pi = !h + !p
				equation reg_phil_cpi_{%country}_t{!t}_h{!h}.ls(cov=hac) d{!h}lcpi_{%country} c d1lcpi_{%country}(-{!h} to -!pi) d1lip_{%country}(-{!h} to -!pi) d1lm3_{%country}(-{!h} to -!pi) d1lcomprice(-{!h} to -!pi) 	'In-sample forecasting regression

				if reg_phil_cpi_{%country}_t{!t}_h{!h}.@schwarz<!schwarz then
					!bestlag = !p
					!schwarz = reg_phil_cpi_{%country}_t{!t}_h{!h}.@schwarz
				endif
			
			next

			!pstar = !h + !bestlag
			equation reg_phil_cpi_{%country}_t{!t}_h{!h}.ls(cov=hac) d{!h}lcpi_{%country} c d1lcpi_{%country}(-{!h} to -!pstar) d1lip_{%country}(-{!h} to -!pstar) d1lm3_{%country}(-{!h} to -!pstar) d1lcomprice(-{!h} to -!pstar)	'In-sample forecasting regression
	
			smpl @first+T0+(length-1)+!t+!h @first+T0+(length-1)+!t+!h
			forecast(f=na) fcst
			fcst_phil_cpi_{%country}_h{!h} = fcst	'Store forecasts
			scalar actual = @elem(d{!h}lcpi_{%country},@otod(1+T0+(length-1)+{!t}+{!h})) 'Actual outcome
			sq_error_phil_cpi_{%country}_h{!h} = (actual - fcst)^2	 'Squared forecast error														

		next		

		smpl 1995:4+{!h} 2016:4
		rmse_phil(counter,{!h}+1) = @sqrt(@mean(sq_error_phil_cpi_{%country}_h{!h}))

	next

next

'----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
' Ratio of RMSEs: PC-forecast to Phillips curve forecast
'----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

'Table to store results: ratio of RMSEs
table(24,17) rmse_ratio_phil
rmse_ratio_phil(1,2) = "1q"
rmse_ratio_phil(1,4) = "2q"
rmse_ratio_phil(1,6) = "3q"
rmse_ratio_phil(1,8) = "4q"
rmse_ratio_phil(1,10) = "5q"
rmse_ratio_phil(1,12) = "6q"
rmse_ratio_phil(1,14) = "7q"
rmse_ratio_phil(1,16) = "8q"

scalar counter = 1  'Country number for loop
for %country cpi_aut cpi_bel cpi_fin cpi_fra cpi_ger cpi_ita cpi_ned cpi_por cpi_esp cpi_irl cpi_den cpi_gre cpi_swe cpi_uk cpi_nor cpi_sui cpi_can cpi_jpn cpi_usa cpi_aus cpi_nzl cpi_lux cpi_u2

	scalar counter = counter + 1
	rmse_ratio_phil(counter,1) = %country

	for !h=1 to maxh

		scalar index = !h+1
		scalar column = {!h}*2		

		smpl 1995:4+{!h} 2016:4
		scalar rmse_pc_temp = @sqrt(@mean(sq_error_pc_{%country}_h{!h}))
		rmse_ratio_phil(counter,column)  = rmse_pc_temp/@val(rmse_phil(counter,index))	'Ratio of RMSEs

		'Statistical significance (10 percent level)
		scalar lag={!h}
		equation dm_phil_{%country}_h{!h}.ls(cov=hac,nodf,covbw=lag) (sq_error_pc_{%country}_h{!h} - sq_error_phil_{%country}_h{!h}) c
		scalar tstat = dm_phil_{%country}_h{!h}.@tstats(1)
		if tstat<-1.282 then
			rmse_ratio_phil(counter,column+1) = 1
		else 
			rmse_ratio_phil(counter,column+1) = 0
		endif		
		
	next

next

'Export results
rmse_ratio_phil.save(t=csv) "rmse_ratio_phil_2016.csv"

'----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
' Commodity price model forecast
'----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

'Estimate forecasting regressions
for %country aut bel fin fra ger ita ned por esp irl den gre swe uk nor sui can jpn usa aus nzl lux u2
	
	for !h=1 to maxh	'Loop over forecast horizons

		series fcst_comp_cpi_{%country}_h{!h} = na	 'Series to store forecasts
		series sq_error_comp_cpi_{%country}_h{!h} = na 'Series to store squared forecast errors

		for !t = 0 to (T-T0-length-maxh)		'Loop over time periods

			!schwarz = 99999
			!bestlag = 0

			smpl @first+T0 @first+T0+(length-1)+!t
		
			for !p=0 to 1 'Choose lag length based on SIC
				
				!pi = !h + !p
				equation reg_comp_cpi_{%country}_t{!t}_h{!h}.ls(cov=hac) d{!h}lcpi_{%country} c d1lcpi_{%country}(-{!h} to -!pi) d1lcomprice(-{!h} to -!pi) 	'In-sample forecasting regression

				if reg_comp_cpi_{%country}_t{!t}_h{!h}.@schwarz<!schwarz then
					!bestlag = !p
					!schwarz = reg_comp_cpi_{%country}_t{!t}_h{!h}.@schwarz
				endif
			
			next

			!pstar = !h + !bestlag
			equation reg_comp_cpi_{%country}_t{!t}_h{!h}.ls(cov=hac) d{!h}lcpi_{%country} c d1lcpi_{%country}(-{!h} to -!pstar) d1lcomprice(-{!h} to -!pstar)	'In-sample forecasting regression
	
			smpl @first+T0+(length-1)+!t+!h @first+T0+(length-1)+!t+!h
			forecast(f=na) fcst
			fcst_comp_cpi_{%country}_h{!h} = fcst	'Store forecasts
			scalar actual = @elem(d{!h}lcpi_{%country},@otod(1+T0+(length-1)+{!t}+{!h})) 'Actual outcome
			sq_error_comp_cpi_{%country}_h{!h} = (actual - fcst)^2	 'Squared forecast error														

		next		

	next
 
next

'----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
' Random walk forecast (RW4)
'----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

'Table to store results
table(24,9) rmse_rw4
rmse_rw4(1,2) = "1q"
rmse_rw4(1,3) = "2q"
rmse_rw4(1,4) = "3q"
rmse_rw4(1,5) = "4q"
rmse_rw4(1,6) = "5q"
rmse_rw4(1,7) = "6q"
rmse_rw4(1,8) = "7q"
rmse_rw4(1,9) = "8q"

'Estimate forecasting regressions
scalar counter = 1 'Country number for loop
for %country cpi_aut cpi_bel cpi_fin cpi_fra cpi_ger cpi_ita cpi_ned cpi_por cpi_esp cpi_irl cpi_den cpi_gre cpi_swe cpi_uk cpi_nor cpi_sui cpi_can cpi_jpn cpi_usa cpi_aus cpi_nzl cpi_lux cpi_u2
	
	scalar counter = counter + 1
	rmse_rw4(counter,1) = %country
	
	for !h=1 to maxh	'Loop over forecast horizons

		series fcst_rw4_{%country}_h{!h} = na	 'Series to store forecasts
		series sq_error_rw4_{%country}_h{!h} = na 'Series to store squared forecast errors

		for !t = 0 to (T-T0-length-maxh)	'Loop over time periods

			smpl @first+T0+(length-1)+!t+!h @first+T0+(length-1)+!t+!h
			!h_minus = -!h
			fcst_rw4_{%country}_h{!h} = d4l{%country}(!h_minus)	'Store forecasts
			scalar actual = @elem(d{!h}l{%country},@otod(1+T0+(length-1)+{!t}+{!h})) 'Actual outcome													
			sq_error_rw4_{%country}_h{!h} = (actual - d4l{%country}(!h_minus))^2	 'Squared forecast error																										

		next		

		smpl 1995:4+{!h} 2016:4
		rmse_rw4(counter,{!h}+1) = @sqrt(@mean(sq_error_rw4_{%country}_h{!h}))

	next
 
next

'----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
' Ratio of RMSEs: PC-forecast to rw4-forecast
'----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

'Table to store results: ratio of RMSEs
table(24,17) rmse_ratio_rw4
rmse_ratio_rw4(1,2) = "1q"
rmse_ratio_rw4(1,4) = "2q"
rmse_ratio_rw4(1,6) = "3q"
rmse_ratio_rw4(1,8) = "4q"
rmse_ratio_rw4(1,10) = "5q"
rmse_ratio_rw4(1,12) = "6q"
rmse_ratio_rw4(1,14) = "7q"
rmse_ratio_rw4(1,16) = "8q"

scalar counter = 1  'Country number for loop
for %country cpi_aut cpi_bel cpi_fin cpi_fra cpi_ger cpi_ita cpi_ned cpi_por cpi_esp cpi_irl cpi_den cpi_gre cpi_swe cpi_uk cpi_nor cpi_sui cpi_can cpi_jpn cpi_usa cpi_aus cpi_nzl cpi_lux cpi_u2

	scalar counter = counter + 1
	rmse_ratio_rw4(counter,1) = %country

	for !h=1 to maxh

		scalar index = !h+1
		scalar column = {!h}*2		
		rmse_ratio_rw4(counter,column)  = @val(rmse_pc(counter,index))/@val(rmse_rw4(counter,index)) 'Ratio of RMSEs

		'Statistical significance (10 percent level)
		smpl 1995:4+{!h} 2016:4
		scalar lag={!h}
		equation dm_rw4_{%country}_h{!h}.ls(cov=hac,nodf,covbw=lag) (sq_error_pc_{%country}_h{!h} - sq_error_rw4_{%country}_h{!h}) c
		scalar tstat = dm_rw4_{%country}_h{!h}.@tstats(1)
		if tstat<-1.282 then
			rmse_ratio_rw4(counter,column+1) = 1
		else 
			rmse_ratio_rw4(counter,column+1) = 0
		endif		
		
	next

next

'Export results
rmse_ratio_rw4.save(t=csv) "rmse_ratio_rw4_2016.csv"

'----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
' Figure 4
'----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

!n = 23 'Number of countries

for !h=1 to 8 'Loop over forecast horizons
	
	smpl @all

	series rmse_rw_h{!h}_avg = na
	series rmse_pc_h{!h}_avg = na
	series rmse_ar_h{!h}_avg = na
	series rmse_comp_h{!h}_avg = na
	series rmse_rw4_h{!h}_avg = na

	for !t = 0 to T-@dtoo("1995:1")-maxh	'Loop over time periods
	
		smpl 1994:4+{!t}+{!h}-36 1994:4+{!t}+{!h} 'Note: CM use 37-quarter rather than 40-quarter window
		
		scalar rmse_rw_h{!h}_avg_t = 0	
		scalar rmse_pc_h{!h}_avg_t = 0	
		scalar rmse_ar_h{!h}_avg_t = 0
		scalar rmse_comp_h{!h}_avg_t = 0
		scalar rmse_rw4_h{!h}_avg_t = 0	
	
			for %country cpi_aut cpi_bel cpi_fin cpi_fra cpi_ger cpi_ita cpi_ned cpi_por cpi_esp cpi_irl cpi_den cpi_gre cpi_swe cpi_uk cpi_nor cpi_sui cpi_can cpi_jpn cpi_usa cpi_aus cpi_nzl cpi_lux cpi_u2
			
				'Average across forecasts for each model
				scalar rmse_rw_h{!h}_avg_t = rmse_rw_h{!h}_avg_t + @sqrt(@mean(sq_error_rw_{%country}_h{!h}))
				scalar rmse_pc_h{!h}_avg_t = rmse_pc_h{!h}_avg_t + @sqrt(@mean(sq_error_pc_{%country}_h{!h}))
				scalar rmse_ar_h{!h}_avg_t = rmse_ar_h{!h}_avg_t + @sqrt(@mean(sq_error_ar_{%country}_h{!h}))
				scalar rmse_comp_h{!h}_avg_t = rmse_comp_h{!h}_avg_t + @sqrt(@mean(sq_error_comp_{%country}_h{!h}))
				scalar rmse_rw4_h{!h}_avg_t = rmse_rw4_h{!h}_avg_t + @sqrt(@mean(sq_error_rw4_{%country}_h{!h}))

				'Average across forecasts for each model (CM version: use current quarterly inflation rate as truth rather than h-period average inflation as in Eqs. 2-5)
				'series sq_error_rw_{%country}_h{!h}_t = (d1l{%country}-fcst_rw_{%country}_h{!h})^2
				'scalar rmse_rw_h{!h}_avg_t = rmse_rw_h{!h}_avg_t + @sqrt(@mean(sq_error_rw_{%country}_h{!h}_t))
				'series sq_error_pc_{%country}_h{!h}_t = (d1l{%country}-fcst_pc_{%country}_h{!h})^2
				'scalar rmse_pc_h{!h}_avg_t = rmse_pc_h{!h}_avg_t + @sqrt(@mean(sq_error_pc_{%country}_h{!h}_t))
				'series sq_error_ar_{%country}_h{!h}_t = (d1l{%country}-fcst_ar_{%country}_h{!h})^2
				'scalar rmse_ar_h{!h}_avg_t = rmse_ar_h{!h}_avg_t + @sqrt(@mean(sq_error_ar_{%country}_h{!h}_t))
				'series sq_error_cp_{%country}_h{!h}_t = (d1l{%country}-fcst_comp_{%country}_h{!h})^2
				'scalar rmse_comp_h{!h}_avg_t = rmse_comp_h{!h}_avg_t + @sqrt(@mean(sq_error_cp_{%country}_h{!h}_t))
				'series sq_error_rw4_{%country}_h{!h}_t = (d1l{%country}-fcst_rw4_{%country}_h{!h})^2
				'scalar rmse_rw4_h{!h}_avg_t = rmse_rw4_h{!h}_avg_t + @sqrt(@mean(sq_error_rw4_{%country}_h{!h}_t))
				
			next
		
			smpl 1994:4+{!t}+{!h} 1994:4+{!t}+{!h}

			series rmse_rw_h{!h}_avg = rmse_rw_h{!h}_avg_t/{!n}
			series rmse_pc_h{!h}_avg = rmse_pc_h{!h}_avg_t/{!n}
			series rmse_ar_h{!h}_avg = rmse_ar_h{!h}_avg_t/{!n}
			series rmse_comp_h{!h}_avg = rmse_comp_h{!h}_avg_t/{!n}
			series rmse_rw4_h{!h}_avg = rmse_rw4_h{!h}_avg_t/{!n}
	
	next

next

'Export series
smpl @all
write(t=xls,na=.,d=c,dates) "rmse_2016" rmse_pc_h1_avg rmse_rw_h1_avg rmse_ar_h1_avg rmse_comp_h1_avg rmse_rw4_h1_avg rmse_pc_h4_avg rmse_rw_h4_avg rmse_ar_h4_avg rmse_comp_h4_avg rmse_rw4_h4_avg rmse_pc_h8_avg rmse_rw_h8_avg rmse_ar_h8_avg rmse_comp_h8_avg rmse_rw4_h8_avg

'----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
' Save workfile
'----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

wfsave "cm_2016"


