function [Log_ML,aT,AT,cT,CT] = Bayesian_regr(w,z,a0,A0,c0,C0,Sigma)
[T,k]=size(w);

if Sigma==0
    % Posterior parameters
    AT = inv(z'*z + inv(A0));
    aT = AT*(z'*w + inv(A0)*a0);
    cT = c0 + T/2;
    CT = C0 + 0.5*(w'*w+a0'*inv(A0)*a0-aT'*inv(AT)*aT);

    % Marginal likelihood of the regression model
    Log_ML = 0.5*log(det(AT))-0.5*log(det(A0)) + gammaln(cT) + c0*log(C0) - gammaln(c0) - cT*log(CT);

else
    % Posterior parameters
    Sigma = diag(Sigma); % make diagonal matrix of vector
    Sigma_inv = inv(Sigma);
    AT = inv(z'*Sigma_inv*z + inv(A0));
    aT = AT*(z'*Sigma_inv*w + inv(A0)*a0);
    cT = []; CT = [];
   
    % Marginal likelihood of the regression model
    Log_ML =   0.5*log(det(AT)) -0.5*log(det(A0)) -0.5*(w'*Sigma_inv*w + a0'*inv(A0)*a0 - aT'*inv(AT)*aT);
    % -0.5*log(det(Sigma)) term is excluded because
        %(i)  it is constant over restricted and unrestricted model
        %(ii) it is INF if det(Sigma)=0, causing NaN's in the remainder of the code
end

end
