function [p_bin] = p_bin_calc(y,x,bin_indic,a0,A0,c0,C0,p0,Sigma,nx,s)
log_ml=zeros(1,2); log_post=zeros(1,2);

%% "Unrestricted" regression (bin_s = 1)
% Restricting matrices according to the "Unrestricted" model specification in Model_bin
bin_indic(s,1) = 1;
I0 = find(bin_indic==0);                                                   % construct index indicating which binary indicators are zero
a0r=a0; a0r(nx+I0,:)=[];                                                   % imposing restrictions implied by binary indicators
A0r=A0; A0r(:,nx+I0)=[]; A0r(nx+I0,:)=[];
xr=x; xr(:,nx+I0)=[];

% calculate marginal likelihood and posterior model log probability
[log_ml(1,2),aT0,AT0,cT0,CT0] = Bayesian_regr(y,xr,a0r,A0r,c0,C0,Sigma);
log_post(1,2) = log_ml(1,2) + log(p0);


%% Restricted regression (bin_s = 0)
% Restricting matrices according to the specification in Model_bin
bin_indic(s,1) = 0;
I0 = find(bin_indic==0);                                                   % construct index indicating which binary indicators are zero
a0r=a0; a0r(nx+I0,:)=[];                                                   % imposing restrictions implied by binary indicators
A0r=A0; A0r(:,nx+I0)=[]; A0r(nx+I0,:)=[];
xr=x; xr(:,nx+I0)=[];

% calculate marginal likelihood and posterior model log probability
[log_ml(1,1),aT0,AT0,cT0,CT0] = Bayesian_regr(y,xr,a0r,A0r,c0,C0,Sigma);
log_post(1,1) = log_ml(1,1) + log(1-p0); 

%% Calculate probability bin_s=1
max_ml = max(log_post);
e = exp(log_post-max_ml);
p_bin = e(1,2)/sum(e);

end

